/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ui.form.fields.CompositeFieldUtility;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;

public abstract class AbstractValidateContentDescriptor
implements IValidateContentDescriptor {
    private Consumer<IValidateContentDescriptor> m_problemLocationActivator = desc -> this.activateProblemLocationDefault();
    private String m_displayText;

    protected AbstractValidateContentDescriptor() {
    }

    @Override
    public Consumer<IValidateContentDescriptor> getProblemLocationActivator() {
        return this.m_problemLocationActivator;
    }

    @Override
    public AbstractValidateContentDescriptor setProblemLocationActivator(Consumer<IValidateContentDescriptor> locationActivator) {
        this.m_problemLocationActivator = locationActivator;
        return this;
    }

    @Override
    public AbstractValidateContentDescriptor problemLocationActivatorButBefore(Consumer<IValidateContentDescriptor> before) {
        if (before == null) {
            return this;
        }
        Consumer<IValidateContentDescriptor> current = this.getProblemLocationActivator();
        if (current == null) {
            this.setProblemLocationActivator((Consumer)before);
        } else {
            this.setProblemLocationActivator((Consumer)before.andThen(current));
        }
        return this;
    }

    @Override
    public AbstractValidateContentDescriptor problemLocationActivatorAndThen(Consumer<? super IValidateContentDescriptor> after) {
        if (after == null) {
            return this;
        }
        Consumer<IValidateContentDescriptor> current = this.getProblemLocationActivator();
        if (current == null) {
            this.setProblemLocationActivator(after::accept);
        } else {
            this.setProblemLocationActivator(current.andThen(after));
        }
        return this;
    }

    @Override
    public String getDisplayText() {
        return this.m_displayText;
    }

    @Override
    public AbstractValidateContentDescriptor setDisplayText(String displayText) {
        this.m_displayText = displayText;
        return this;
    }

    protected void selectAllParentTabsOf(IFormField formField) {
        CompositeFieldUtility.selectAllParentTabsOf(formField);
    }

    protected abstract void activateProblemLocationDefault();

    @Override
    public void activateProblemLocation() {
        Consumer<IValidateContentDescriptor> locationActivator = this.getProblemLocationActivator();
        if (locationActivator != null) {
            locationActivator.accept(this);
        }
    }
}

