/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IStatusMenuMapping;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;

public abstract class AbstractStatusMenuMapping
extends AbstractPropertyObserver
implements IStatusMenuMapping {
    private Class<? extends IMenu> m_menuClass;
    private IFormField m_parentField;

    public AbstractStatusMenuMapping() {
        this(true);
    }

    public AbstractStatusMenuMapping(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        this.initConfig();
    }

    protected void initConfig() {
        this.m_menuClass = this.getConfiguredMenu();
        this.setCodes(this.getConfiguredCodes());
        this.setSeverities(this.getConfiguredSeverities());
    }

    @Override
    public void setParentFieldInternal(IFormField parentField) {
        this.m_parentField = parentField;
    }

    @Override
    public void init() {
        if (this.m_menuClass != null) {
            this.setMenu(this.m_parentField.getMenuByClass(this.m_menuClass));
        }
    }

    @Override
    public IMenu getMenu() {
        return (IMenu)this.propertySupport.getProperty("menu");
    }

    @Override
    public void setMenu(IMenu menu) {
        this.propertySupport.setProperty("menu", (Object)menu);
    }

    @Order(value=10.0)
    protected Class<? extends IMenu> getConfiguredMenu() {
        return null;
    }

    @Override
    public List<Integer> getCodes() {
        return (List)this.propertySupport.getProperty("codes");
    }

    @Override
    public void setCodes(List<Integer> codes) {
        this.propertySupport.setProperty("codes", new ArrayList<Integer>(codes));
    }

    @Order(value=20.0)
    protected List<Integer> getConfiguredCodes() {
        return new ArrayList<Integer>();
    }

    @Override
    public List<Integer> getSeverities() {
        return (List)this.propertySupport.getProperty("severities");
    }

    @Override
    public void setSeverities(List<Integer> severities) {
        this.propertySupport.setProperty("severities", new ArrayList<Integer>(severities));
    }

    @Order(value=30.0)
    protected List<Integer> getConfiguredSeverities() {
        return new ArrayList<Integer>();
    }
}

