/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.services.common.icon.IconLocator;
import org.eclipse.scout.rt.client.services.common.icon.IconSpec;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCloseButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.htmlfield.AbstractHtmlField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.html.IHtmlTable;
import org.eclipse.scout.rt.platform.html.IHtmlTableCell;
import org.eclipse.scout.rt.platform.html.IHtmlTableRow;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ClassId(value="dee01442-979d-4231-a3f9-bd2a163e752a")
public class ScoutInfoForm
extends AbstractForm {
    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"Info");
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.GroupBox.HtmlField getHtmlField() {
        return this.getFieldByClass(MainBox.GroupBox.HtmlField.class);
    }

    public MainBox.CloseButton getCloseButton() {
        return this.getFieldByClass(MainBox.CloseButton.class);
    }

    public void startModify() {
        this.startInternal(new ModifyHandler());
    }

    protected void contributeHtmlAttachments(Collection<BinaryResource> collection) {
    }

    protected String createHtmlBody() {
        IHtmlElement html = HTML.div((CharSequence[])new CharSequence[]{this.createLogoHtml(), HTML.div((CharSequence[])new CharSequence[]{this.createTitleHtml(), this.createHtmlTable(this.getProperties())}).cssClass((CharSequence)"scout-info-form-text-container")}).cssClass((CharSequence)"scout-info-form-container");
        return html.toHtml();
    }

    protected IHtmlElement createLogoHtml() {
        IconSpec logo = IconLocator.instance().getIconSpec(this.getProductLogoId());
        if (logo != null) {
            return HTML.div((CharSequence[])new CharSequence[]{HTML.imgByIconId((CharSequence)this.getProductLogoId()).cssClass((CharSequence)"scout-info-form-logo")}).cssClass((CharSequence)"scout-info-form-logo-container");
        }
        return null;
    }

    protected IHtmlElement createTitleHtml() {
        String title = StringUtility.join((String)" ", (Object[])new Object[]{this.getProductName(), this.getProductVersion()});
        if (StringUtility.hasText((CharSequence)title)) {
            this.setTitle(title);
        }
        return null;
    }

    protected String getProductName() {
        return (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationNameProperty.class);
    }

    protected String getProductVersion() {
        return (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationVersionProperty.class);
    }

    protected String getProductLogoId() {
        return this.getDesktop().getLogoId();
    }

    protected Map<String, Object> getProperties() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        String userId = ClientSessionProvider.currentSession().getUserId();
        if (!StringUtility.hasText((CharSequence)userId)) {
            try {
                Subject subject = Subject.current();
                Principal firstPrincipal = (Principal)CollectionUtility.firstElement(subject.getPrincipals());
                userId = firstPrincipal.getName();
            }
            catch (Exception e) {
                userId = "-";
            }
        }
        props.put(TEXTS.get((String)"Username"), userId);
        Locale locale = NlsLocale.get();
        props.put(TEXTS.get((String)"Language"), locale.getDisplayLanguage(locale));
        props.put(TEXTS.get((String)"FormattingLocale"), locale);
        props.put(TEXTS.get((String)"ScoutVersion"), CONFIG.getPropertyValue(PlatformConfigProperties.PlatformVersionProperty.class));
        return props;
    }

    protected IHtmlTable createHtmlTable(Map<String, ?> properties) {
        ArrayList<IHtmlTableRow> rows = new ArrayList<IHtmlTableRow>();
        for (Map.Entry<String, ?> p : properties.entrySet()) {
            rows.add(this.createHtmlRow(p.getKey(), p.getValue()));
        }
        return HTML.table(rows).cssClass((CharSequence)"scout-info-form-table");
    }

    protected IHtmlTableRow createHtmlRow(String property, Object value) {
        return HTML.tr((IHtmlTableCell[])new IHtmlTableCell[]{HTML.td((CharSequence[])new CharSequence[]{StringUtility.emptyIfNull((Object)StringUtility.box((String)"", (String)property, (String)":"))}).cssClass((CharSequence)"scout-info-form-table-cell-description"), HTML.td((CharSequence[])new CharSequence[]{StringUtility.emptyIfNull((Object)value)}).cssClass((CharSequence)"scout-info-form-table-cell-value")});
    }

    @Order(value=10.0)
    @ClassId(value="794bf4a4-727b-44f3-a2eb-2d2187110036")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredWidthInPixel() {
            return 450;
        }

        @Order(value=20.0)
        @ClassId(value="8c451981-7963-49aa-80ca-ed13469267d8")
        public class CloseButton
        extends AbstractCloseButton {
        }

        @Order(value=10.0)
        @ClassId(value="e5b5d699-9e8a-49c7-84ea-128289f1e616")
        public class GroupBox
        extends AbstractGroupBox {

            @Order(value=20.0)
            @ClassId(value="cd526428-76ca-4e8f-8b8e-4a4f0964c518")
            public class HtmlField
            extends AbstractHtmlField {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected boolean getConfiguredScrollBarEnabled() {
                    return false;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected boolean getConfiguredGridUseUiHeight() {
                    return true;
                }

                @Override
                protected boolean getConfiguredStatusVisible() {
                    return false;
                }
            }
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() {
            ArrayList<BinaryResource> attachments = new ArrayList<BinaryResource>();
            ScoutInfoForm.this.contributeHtmlAttachments(attachments);
            if (!attachments.isEmpty()) {
                ScoutInfoForm.this.getHtmlField().setAttachments(attachments);
            }
            ScoutInfoForm.this.getHtmlField().setValue(ScoutInfoForm.this.createHtmlBody());
        }
    }
}

