/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.IFormFieldInjection;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;

public final class FormFieldInjectionThreadLocal {
    private static final ThreadLocal<FormFieldInjectionThreadLocal> THREAD_LOCAL = ThreadLocal.withInitial(FormFieldInjectionThreadLocal::new);
    private final List<IFormFieldInjection> m_stack = new ArrayList<IFormFieldInjection>();
    private final List<ICompositeField> m_containerFields = new ArrayList<ICompositeField>();

    public static void push(IFormFieldInjection injection) {
        THREAD_LOCAL.get().pushInternal(injection);
    }

    public static void pop(IFormFieldInjection injection) {
        THREAD_LOCAL.get().popInternal(injection);
        if (THREAD_LOCAL.get().isEmpty()) {
            THREAD_LOCAL.remove();
        }
    }

    public static void pushContainerField(ICompositeField container) {
        THREAD_LOCAL.get().pushContainerFieldInternal(container);
    }

    public static void popContainerField(ICompositeField container) {
        THREAD_LOCAL.get().popContainerFieldInternal(container);
        if (THREAD_LOCAL.get().isEmpty()) {
            THREAD_LOCAL.remove();
        }
    }

    public static List<ICompositeField> getContainerFields() {
        return THREAD_LOCAL.get().getContainerFieldsInternal();
    }

    public static void filterFields(IFormField container, List<Class<? extends IFormField>> fieldList) {
        THREAD_LOCAL.get().filterFieldsInternal(container, fieldList);
    }

    public static void injectFields(IFormField container, OrderedCollection<IFormField> fields) {
        THREAD_LOCAL.get().injectFieldsInternal(container, fields);
    }

    private FormFieldInjectionThreadLocal() {
    }

    private void pushInternal(IFormFieldInjection injection) {
        if (injection == null) {
            throw new IllegalArgumentException("injection is null");
        }
        this.m_stack.add(injection);
    }

    private void popInternal(IFormFieldInjection injection) {
        if (injection == null) {
            throw new IllegalArgumentException("injection is null");
        }
        if (this.m_stack.isEmpty()) {
            throw new IllegalArgumentException("push/pop asymmetry; expected nothing but got " + String.valueOf(injection.getClass()));
        }
        if (this.m_stack.isEmpty() || this.m_stack.get(this.m_stack.size() - 1) != injection) {
            throw new IllegalArgumentException("push/pop asymmetry; expected " + String.valueOf(this.m_stack.get(this.m_stack.size() - 1).getClass()) + " but got " + String.valueOf(injection.getClass()));
        }
        this.m_stack.remove(this.m_stack.size() - 1);
    }

    private void injectFieldsInternal(IFormField container, OrderedCollection<IFormField> fields) {
        if (this.m_stack.isEmpty()) {
            return;
        }
        for (IFormFieldInjection i : this.m_stack) {
            i.injectFields(container, fields);
        }
    }

    private void filterFieldsInternal(IFormField container, List<Class<? extends IFormField>> fieldList) {
        if (this.m_stack.isEmpty()) {
            return;
        }
        for (IFormFieldInjection i : this.m_stack) {
            i.filterFields(container, fieldList);
        }
    }

    private void pushContainerFieldInternal(ICompositeField container) {
        if (container == null) {
            throw new IllegalArgumentException("container is null");
        }
        this.m_containerFields.add(container);
    }

    private void popContainerFieldInternal(ICompositeField container) {
        if (container == null) {
            throw new IllegalArgumentException("container is null");
        }
        if (this.m_containerFields.isEmpty()) {
            throw new IllegalArgumentException("push/pop asymmetry; expected nothing but got " + String.valueOf(container.getClass()));
        }
        if (this.m_containerFields.isEmpty() || this.m_containerFields.get(this.m_containerFields.size() - 1) != container) {
            throw new IllegalArgumentException("push/pop asymmetry; expected " + String.valueOf(this.m_containerFields.get(this.m_containerFields.size() - 1).getClass()) + " but got " + String.valueOf(container.getClass()));
        }
        this.m_containerFields.remove(this.m_containerFields.size() - 1);
    }

    private List<ICompositeField> getContainerFieldsInternal() {
        return Collections.unmodifiableList(this.m_containerFields);
    }

    private boolean isEmpty() {
        return this.m_stack.isEmpty() && this.m_containerFields.isEmpty();
    }
}

