/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="2c6592c7-bae5-4cec-a475-e5b8f2e7fed7")
public class AutoLeafPageWithNodes
extends AbstractPageWithNodes {
    private final ITableRow m_tableRow;

    public AutoLeafPageWithNodes(ITableRow row) {
        if (row == null) {
            throw new IllegalArgumentException("Row must not be null");
        }
        this.m_tableRow = row;
    }

    public ITableRow getTableRow() {
        return this.m_tableRow;
    }

    @Override
    protected void execInitPage() {
        Cell cell = this.getCellForUpdate();
        if (cell.getText() == null) {
            cell.setText(this.findAppropriateTitle());
        }
        if (cell.getIconId() == null) {
            cell.setIconId(this.m_tableRow.getIconId());
        }
    }

    protected String findAppropriateTitle() {
        for (IColumn<?> column : this.m_tableRow.getTable().getColumns()) {
            if (!column.isVisible()) continue;
            return this.m_tableRow.getTable().getCell(this.m_tableRow, column).getText();
        }
        return null;
    }

    @Override
    protected boolean getConfiguredTableVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredDetailFormVisible() {
        return false;
    }

    @Override
    protected boolean getConfiguredLeaf() {
        return true;
    }
}

