/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline.pages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeNodeExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.IPageExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.pages.PageChains;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeListener;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.MenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.ITileOverviewForm;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="ef0d789e-dfbf-4715-9ab7-eedaefc936f3")
public abstract class AbstractPage<T extends ITable>
extends AbstractTreeNode
implements IPage<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPage.class);
    private static final String TABLE_VISIBLE = "TABLE_VISIBLE";
    private static final String DETAIL_FORM_VISIBLE = "DETAIL_FORM_VISIBLE";
    private static final String SHOW_TILE_OVERVIEW = "SHOW_TILE_OVERVIEW";
    private static final String NAVIGATE_BUTTONS_VISIBLE = "NAVIGATE_BUTTONS_VISIBLE";
    private static final String COMPACT_ROOT = "COMPACT_ROOT";
    private static final String PAGE_MENUS_ADDED = "PAGE_MENUS_ADDED";
    private static final String PAGE_ACTIVE = "PAGE_ACTIVE";
    private static final String PAGE_ACTIVATED = "PAGE_ACTIVATED";
    static final String SEARCH_REQUIRED = "SEARCH_REQUIRED";
    static final String SEARCH_ACTIVE = "SEARCH_ACTIVE";
    static final String LIMITED_RESULT = "LIMITED_RESULT";
    static final String ALWAYS_CREATE_CHILD_PAGE = "ALWAYS_CREATE_CHILD_PAGE";
    static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"TABLE_VISIBLE", "DETAIL_FORM_VISIBLE", "PAGE_MENUS_ADDED", "LIMITED_RESULT", "ALWAYS_CREATE_CHILD_PAGE", "SEARCH_ACTIVE", "SEARCH_REQUIRED", "PAGE_ACTIVE"});
    static final NamedBitMaskHelper FLAGS2_BIT_HELPER = new NamedBitMaskHelper(new String[]{"PAGE_ACTIVATED", "SHOW_TILE_OVERVIEW", "NAVIGATE_BUTTONS_VISIBLE"});
    private static final OutlineMenuWrapper.IMenuTypeMapper TREE_MENU_TYPE_MAPPER = menuType -> {
        if (menuType == TreeMenuType.SingleSelection) {
            return TableMenuType.EmptySpace;
        }
        return menuType;
    };
    private T m_table;
    private IForm m_detailForm;
    private String m_overviewIconId;
    private IDataChangeListener m_internalDataChangeListener;
    private final TreeListener m_localTreeListener;
    private final String m_userPreferenceContext;
    private final Map<ITableRow, IPage> m_tableRowToPageMap = new HashMap<ITableRow, IPage>();
    private final Map<IPage, ITableRow> m_pageToTableRowMap = new HashMap<IPage, ITableRow>();
    byte m_flags;
    byte m_flags2;

    @Override
    protected List<IMenu> lazyCreateAndInitializeMenus() {
        if (this.isInitializing()) {
            LOG.warn("Menus in page {} are now created during page init. This is not recommended. The menus should be created lazily when the page is activated. Use e.g. the execInitTable() callback to access the table after it has been created.", this.getClass(), (Object)new Exception("origin"));
        }
        AtomicReference ref = new AtomicReference();
        this.createDisplayParentRunContext().run(() -> this.runInExtensionContext(() -> ref.set(super.lazyCreateAndInitializeMenus())));
        return (List)ref.get();
    }

    @Override
    public T getTable() {
        return this.getTable(true);
    }

    @Override
    public T getTable(boolean create) {
        if (create && this.m_table == null) {
            if (this.isInitializing()) {
                LOG.warn("Table in page {} is created during page init. This is not recommended. The table should be created lazily when the page is activated. Use e.g. the execInitTable() callback to access the table after it has been created.", this.getClass(), (Object)new Exception("origin"));
            }
            if (this.isDisposing()) {
                LOG.warn("Table in page {} is created during page disposal. This is not recommended. Consider using getTable(false) during the disposal phase.", this.getClass(), (Object)new Exception("origin"));
            }
            this.createDisplayParentRunContext().run(() -> this.runInExtensionContext(() -> {
                this.m_table = this.createTable();
                if (this.m_table != null) {
                    this.m_table.init();
                    this.firePageChanged();
                    this.addDefaultTableControls();
                    this.interceptInitTable();
                    this.fireAfterTableInit();
                }
            }));
        }
        return this.m_table;
    }

    protected ClientRunContext createDisplayParentRunContext() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            return outline.createDisplayParentRunContext();
        }
        return ClientRunContexts.copyCurrent();
    }

    protected void linkTableRowWithPage(ITableRow tableRow, IPage<?> page) {
        this.m_tableRowToPageMap.put(tableRow, page);
        this.m_pageToTableRowMap.put(page, tableRow);
    }

    protected void unlinkAllTableRowWithPage() {
        this.m_tableRowToPageMap.clear();
        this.m_pageToTableRowMap.clear();
    }

    @Override
    public ITreeNode getTreeNodeFor(ITableRow tableRow) {
        if (tableRow == null) {
            return null;
        }
        return this.m_tableRowToPageMap.get(tableRow);
    }

    @Override
    public IPage<?> getPageFor(ITableRow tableRow) {
        return (IPage)this.getTreeNodeFor(tableRow);
    }

    @Override
    public ITableRow getTableRowFor(ITreeNode childPage) {
        return this.m_pageToTableRowMap.get(childPage);
    }

    @Override
    public List<ITableRow> getTableRowsFor(Collection<? extends ITreeNode> childPageNodes) {
        ArrayList<ITableRow> result = new ArrayList<ITableRow>();
        for (ITreeNode iTreeNode : childPageNodes) {
            ITableRow row = this.getTableRowFor(iTreeNode);
            if (row == null) continue;
            result.add(row);
        }
        return result;
    }

    protected void unlinkTableRowWithPage(ITableRow tableRow) {
        IPage page = this.m_tableRowToPageMap.remove(tableRow);
        if (page != null) {
            this.m_pageToTableRowMap.remove(page);
        }
    }

    public static String createUserPreferenceContext(Object ... vargs) {
        StringBuilder buf = new StringBuilder();
        if (vargs != null) {
            Object[] objectArray = vargs;
            int n = vargs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (buf.length() > 0) {
                    buf.append(",");
                }
                if (o == null) {
                    buf.append("null");
                } else if (o instanceof Object[]) {
                    buf.append(Arrays.toString((Object[])o));
                } else {
                    buf.append(o);
                }
                ++n2;
            }
        }
        return buf.toString();
    }

    public AbstractPage() {
        this(true);
    }

    public AbstractPage(String userPreferenceContext) {
        this(true, userPreferenceContext);
    }

    public AbstractPage(boolean callInitializer) {
        this(callInitializer, null);
    }

    public AbstractPage(boolean callInitializer, String userPreferenceContext) {
        super(false);
        this.m_userPreferenceContext = userPreferenceContext;
        this.m_localTreeListener = this.createLocalTreeListener();
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=35.0)
    protected boolean getConfiguredTableVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=91.0)
    protected boolean getConfiguredDetailFormVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=37.0)
    protected boolean getConfiguredShowTileOverview() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=38.0)
    protected boolean getConfiguredNavigateButtonsVisible() {
        return true;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=40.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=50.0)
    protected String getConfiguredIconId() {
        return null;
    }

    protected String getConfiguredOverviewIconId() {
        return null;
    }

    @ConfigProperty(value="FORM")
    @Order(value=90.0)
    protected Class<? extends IForm> getConfiguredDetailForm() {
        return null;
    }

    @ConfigOperation
    @Order(value=100.0)
    protected boolean execCalculateVisible() {
        return true;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execInitPage() {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDisposePage() {
    }

    @ConfigOperation
    @Order(value=55.0)
    protected void execDataChanged(Object ... dataTypes) {
        boolean isRootNode;
        if (this.getTree() == null) {
            return;
        }
        HashSet<ITreeNode> pathsToSelections = new HashSet<ITreeNode>();
        Iterator<ITreeNode> iterator = this.getTree().getSelectedNodes().iterator();
        while (iterator.hasNext()) {
            ITreeNode node;
            ITreeNode tmp = node = iterator.next();
            while (tmp != null) {
                pathsToSelections.add(tmp);
                tmp = tmp.getParentNode();
            }
        }
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        boolean isActiveOutline = desktop != null && desktop.getOutline() == this.getOutline();
        boolean bl = isRootNode = pathsToSelections.isEmpty() && this.getTree() != null && this.getTree().getRootNode() == this;
        if (isActiveOutline && (pathsToSelections.contains(this) || isRootNode)) {
            try {
                if (isRootNode) {
                    this.reloadPage("dataChangedTrigger");
                } else if (desktop != null) {
                    desktop.reloadPageFromRoot(this);
                }
            }
            catch (RuntimeException | PlatformError e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            }
        } else {
            this.setChildrenDirty(true);
            if (this.isExpanded()) {
                this.setExpanded(false);
            }
            try {
                if (this.isChildrenLoaded()) {
                    this.getTree().unloadNode(this);
                }
            }
            catch (RuntimeException | PlatformError e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            }
        }
    }

    @ConfigOperation
    @Order(value=58.0)
    protected void execReloadPage(String reloadReason) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        try {
            tree.setTreeChanging(true);
            if (this.isExpandedLazy()) {
                tree.setNodeExpanded(this, false);
            }
            this.loadChildren();
        }
        finally {
            tree.setTreeChanging(false);
        }
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execPageDataLoaded() {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execPageActivated() {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execPageDeactivated() {
    }

    @ConfigOperation
    @Order(value=120.0)
    protected void execInitDetailForm() {
    }

    @Order(value=130.0)
    @ConfigOperation
    protected void execInitTable() {
    }

    @Order(value=140.0)
    @ConfigOperation
    protected void execDetailFormActivated() {
        IForm detailForm = this.getDetailForm();
        if (detailForm != null) {
            detailForm.getUIFacade().fireFormActivatedFromUI();
        }
    }

    @Order(value=150.0)
    @ConfigOperation
    protected List<IMenu> execComputeParentTablePageMenus(IPageWithTable<?> parentTablePage) {
        ITableRow row = parentTablePage.getTableRowFor(this);
        if (row == null) {
            return CollectionUtility.emptyArrayList();
        }
        Object table = parentTablePage.getTable();
        table.getUIFacade().setSelectedRowsFromUI(CollectionUtility.arrayList((Object)row));
        return MenuUtility.filterMenusRec(table.getContextMenu().getChildActions(), MenuUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)TableMenuType.SingleSelection), false));
    }

    protected abstract T createTable();

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setTableVisible(this.getConfiguredTableVisible());
        this.setDetailFormVisible(this.getConfiguredDetailFormVisible());
        this.setShowTileOverview(this.getConfiguredShowTileOverview());
        this.setOverviewIconId(this.getConfiguredOverviewIconId());
        this.setNavigateButtonsVisible(this.getConfiguredNavigateButtonsVisible());
    }

    @Override
    public void initPage() {
        this.setInitializing(true);
        try {
            Cell cell = this.getCellForUpdate();
            if (cell.getText() == null && this.getConfiguredTitle() != null) {
                cell.setText(this.getConfiguredTitle());
            }
            if (cell.getIconId() == null && this.getConfiguredIconId() != null) {
                cell.setIconId(this.getConfiguredIconId());
            }
            this.interceptInitPage();
            if (!this.doCalculateVisibleLate()) {
                this.calculateVisibleInternal();
            }
            this.fireAfterPageInit();
        }
        finally {
            this.setInitializing(false);
        }
    }

    protected boolean isCalculateVisibleLate() {
        return false;
    }

    protected boolean doCalculateVisibleLate() {
        IPage<?> parentPage = this.getParentPage();
        if (parentPage instanceof AbstractPage) {
            return ((AbstractPage)parentPage).isCalculateVisibleLate();
        }
        return false;
    }

    protected void calculateVisibleInternal() {
        this.setVisibleGranted(this.isVisible() && this.interceptCalculateVisible());
    }

    protected void addDefaultTableControls() {
    }

    @Override
    public IStatus getTableStatus() {
        T table = this.getTable();
        if (table != null) {
            return table.getTableStatus();
        }
        return null;
    }

    @Override
    public void setTableStatus(IStatus tableStatus) {
        T table = this.getTable();
        if (table != null) {
            table.setTableStatus(tableStatus);
        }
    }

    @Override
    public boolean isTableStatusVisible() {
        T table = this.getTable();
        if (table != null) {
            return table.isTableStatusVisible();
        }
        return false;
    }

    @Override
    public void setTableStatusVisible(boolean tableStatusVisible) {
        T table = this.getTable();
        if (table != null) {
            table.setTableStatusVisible(tableStatusVisible);
        }
    }

    @Override
    public final String getUserPreferenceContext() {
        return this.m_userPreferenceContext;
    }

    @Override
    public IOutline getOutline() {
        return (IOutline)this.getTree();
    }

    @Override
    public IPage<?> getParentPage() {
        return (IPage)this.getParentNode();
    }

    @Override
    public void setTreeInternal(ITree tree, boolean includeSubtree) {
        ITree oldTree = this.getTree();
        if (oldTree != null) {
            oldTree.removeTreeListener(this.m_localTreeListener, new Integer[0]);
        }
        super.setTreeInternal(tree, includeSubtree);
        if (tree == null) {
            return;
        }
        tree.addTreeListener(this.m_localTreeListener, 20);
    }

    @Override
    public IPage<?> getChildPage(int childIndex) {
        return (IPage)this.getChildNode(childIndex);
    }

    @Override
    public List<IPage<?>> getChildPages() {
        ArrayList childPages = new ArrayList();
        for (ITreeNode childNode : this.getChildNodes()) {
            childPages.add((IPage)childNode);
        }
        return childPages;
    }

    @Override
    public void nodeAddedNotify() {
        try {
            this.setInitializing(true);
            try {
                this.initPage();
            }
            finally {
                this.setInitializing(false);
            }
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    @Override
    public void disposeInternal() {
        super.disposeInternal();
        try {
            this.interceptDisposePage();
            this.disposeDetailForm();
            this.disposeTable();
            this.fireAfterPageDispose();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
        }
        ITree tree = this.getTree();
        if (tree != null) {
            tree.removeTreeListener(this.m_localTreeListener, new Integer[0]);
        }
        this.unregisterDataChangeListener(new Object[0]);
    }

    @Override
    public void pageActivatedNotify() {
        try {
            this.ensureDetailFormCreated();
            this.ensureDetailFormStarted();
            this.interceptDetailFormActivated();
            this.enhanceTableWithPageMenus();
            this.interceptPageActivated();
            this.setPageActive(true);
            this.firePageActivated();
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    @Override
    public void pageDeactivatedNotify() {
        try {
            this.interceptPageDeactivated();
            this.setPageActive(false);
        }
        catch (Exception e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    @Override
    public boolean isPageActive() {
        return FLAGS_BIT_HELPER.isBitSet(PAGE_ACTIVE, this.m_flags);
    }

    protected void setPageActive(boolean active) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(PAGE_ACTIVE, active, this.m_flags);
        if (active) {
            this.m_flags2 = FLAGS2_BIT_HELPER.setBit(PAGE_ACTIVATED, this.m_flags2);
        }
    }

    @Override
    public boolean hasBeenActivated() {
        return FLAGS2_BIT_HELPER.isBitSet(PAGE_ACTIVATED, this.m_flags2);
    }

    private boolean isPageMenusAdded() {
        return FLAGS_BIT_HELPER.isBitSet(PAGE_MENUS_ADDED, this.m_flags);
    }

    private void setPageMenusAdded() {
        this.m_flags = FLAGS_BIT_HELPER.setBit(PAGE_MENUS_ADDED, this.m_flags);
    }

    protected void enhanceTableWithPageMenus() {
        if (this.isPageMenusAdded()) {
            return;
        }
        this.setPageMenusAdded();
        T table = this.getTable();
        if (table != null) {
            ITableContextMenu contextMenu = table.getContextMenu();
            List menus = contextMenu.getChildActions();
            for (IMenu menu : this.getOutline().getContextMenu().getChildActions()) {
                if (MenuWrapper.containsWrappedMenu(table.getMenus(), menu)) continue;
                menus.add(MenuWrapper.wrapMenu(menu, TREE_MENU_TYPE_MAPPER));
            }
            if (!CollectionUtility.equalsCollection(menus, contextMenu.getChildActions())) {
                contextMenu.setChildActions(menus);
            }
        }
    }

    protected IForm createDetailForm() {
        if (this.getConfiguredDetailForm() == null) {
            return null;
        }
        return (IForm)this.createDisplayParentRunContext().call(() -> this.getConfiguredDetailForm().getConstructor(new Class[0]).newInstance(new Object[0]));
    }

    protected ITileOverviewForm createTileOverviewForm() {
        return new P_TileOverviewForm();
    }

    protected void startDetailForm() {
        this.getDetailForm().start();
    }

    protected void ensureDetailFormCreated() {
        if (this.getDetailForm() != null) {
            return;
        }
        IForm form = this.isShowTileOverview() ? this.createTileOverviewForm() : this.createDetailForm();
        if (form != null) {
            this.setDetailForm(form);
            this.interceptInitDetailForm();
        }
    }

    protected void ensureDetailFormStarted() {
        if (this.getDetailForm() == null || !this.getDetailForm().isFormStartable()) {
            return;
        }
        this.startDetailForm();
    }

    protected void disposeDetailForm() {
        if (this.getDetailForm() != null) {
            this.getDetailForm().doClose();
            this.setDetailForm(null);
        }
    }

    protected void disposeTable() {
        T table = this.getTable(false);
        if (table != null) {
            table.dispose();
            this.setTableStatus(null);
        }
    }

    @Override
    public IForm getDetailForm() {
        return this.m_detailForm;
    }

    @Override
    public void setDetailForm(IForm form) {
        this.m_detailForm = form;
        if (this.m_detailForm != null) {
            this.decorateDetailForm();
        }
        this.firePageChanged();
        if (this.isSelectedNode()) {
            this.getOutline().setDetailForm(this.m_detailForm);
        }
    }

    protected void decorateDetailForm() {
        IForm form = this.getDetailForm();
        if (form.getDisplayHint() != 20) {
            form.setDisplayHint(20);
        }
        if (form.getDisplayViewId() == null) {
            form.setDisplayViewId("PAGE_DETAIL");
        }
        form.setModal(false);
        form.setShowOnStart(false);
    }

    @Override
    public void registerDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener == null) {
            this.m_internalDataChangeListener = event -> this.dataChanged(event.getDataType());
        }
        IDesktop.CURRENT.get().dataChangeDesktopInForegroundListeners().add(this.m_internalDataChangeListener, true, dataTypes);
    }

    @Override
    public void dataChanged(Object ... dataTypes) {
        this.createDisplayParentRunContext().run(() -> {
            try {
                this.interceptDataChanged(dataTypes);
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        });
    }

    @Override
    public void unregisterDataChangeListener(Object ... dataTypes) {
        if (this.m_internalDataChangeListener != null) {
            IDesktop.CURRENT.get().removeDataChangeListener(this.m_internalDataChangeListener, dataTypes);
        }
    }

    @Override
    public final void reloadPage(String reloadReason) {
        this.interceptReloadPage(reloadReason);
    }

    @Override
    public void loadChildren() {
        if (this.doCalculateVisibleLate()) {
            this.calculateVisibleInternal();
        }
        if (!this.isVisible()) {
            throw new VetoException(TEXTS.get((String)"ErrorTitleSecurity"), new Object[0]);
        }
        super.loadChildren();
        this.loadChildrenImpl();
        this.interceptPageDataLoaded();
    }

    protected void loadChildrenImpl() {
    }

    @Override
    public List<IMenu> computeParentTablePageMenus(IPageWithTable<?> parentTablePage) {
        return this.interceptComputeParentTablePageMenus(parentTablePage);
    }

    @Override
    public boolean isTableVisible() {
        return FLAGS_BIT_HELPER.isBitSet(TABLE_VISIBLE, this.m_flags);
    }

    @Override
    public void setTableVisible(boolean tableVisible) {
        if (this.isTableVisible() == tableVisible) {
            return;
        }
        this.m_flags = FLAGS_BIT_HELPER.changeBit(TABLE_VISIBLE, tableVisible, this.m_flags);
        this.firePageChanged();
    }

    @Override
    public boolean isDetailFormVisible() {
        return FLAGS_BIT_HELPER.isBitSet(DETAIL_FORM_VISIBLE, this.m_flags);
    }

    @Override
    public void setDetailFormVisible(boolean detailFormVisible) {
        if (this.isDetailFormVisible() == detailFormVisible) {
            return;
        }
        this.m_flags = FLAGS_BIT_HELPER.changeBit(DETAIL_FORM_VISIBLE, detailFormVisible, this.m_flags);
        this.firePageChanged();
    }

    @Override
    public boolean isCompactRoot() {
        return FLAGS2_BIT_HELPER.isBitSet(COMPACT_ROOT, this.m_flags2);
    }

    @Override
    public void setCompactRoot(boolean compactRoot) {
        this.m_flags2 = FLAGS2_BIT_HELPER.changeBit(COMPACT_ROOT, compactRoot, this.m_flags2);
    }

    @Override
    public boolean isShowTileOverview() {
        return FLAGS2_BIT_HELPER.isBitSet(SHOW_TILE_OVERVIEW, this.m_flags2);
    }

    @Override
    public void setShowTileOverview(boolean showTileOverview) {
        Assertions.assertNull((Object)this.getDetailForm(), (String)"Property 'showTileOverview' cannot be changed because DetailForm has already been created", (Object[])new Object[0]);
        if (this.isShowTileOverview() == showTileOverview) {
            return;
        }
        this.m_flags2 = FLAGS2_BIT_HELPER.changeBit(SHOW_TILE_OVERVIEW, showTileOverview, this.m_flags2);
        this.firePageChanged();
    }

    @Override
    public boolean isNavigateButtonsVisible() {
        return FLAGS2_BIT_HELPER.isBitSet(NAVIGATE_BUTTONS_VISIBLE, this.m_flags2);
    }

    @Override
    public void setNavigateButtonsVisible(boolean navigateButtonsVisible) {
        if (this.isNavigateButtonsVisible() == navigateButtonsVisible) {
            return;
        }
        this.m_flags2 = FLAGS2_BIT_HELPER.changeBit(NAVIGATE_BUTTONS_VISIBLE, navigateButtonsVisible, this.m_flags2);
        this.firePageChanged();
    }

    @Override
    public void setOverviewIconId(String overviewIconId) {
        if (ObjectUtility.equals((Object)this.getOverviewIconId(), (Object)overviewIconId)) {
            return;
        }
        this.m_overviewIconId = overviewIconId;
        this.firePageChanged();
    }

    @Override
    public String getOverviewIconId() {
        return this.m_overviewIconId;
    }

    protected void firePageChanged() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.firePageChanged(this);
        }
    }

    protected void fireBeforeDataLoaded() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.fireBeforeDataLoaded(this);
        }
    }

    protected void fireAfterDataLoaded() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.fireAfterDataLoaded(this);
        }
    }

    protected void fireAfterTableInit() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.fireAfterTableInit(this);
        }
    }

    protected void fireAfterPageInit() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.fireAfterPageInit(this);
        }
    }

    protected void fireAfterPageDispose() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.fireAfterPageDispose(this);
        }
    }

    protected void firePageActivated() {
        IOutline outline = this.getOutline();
        if (outline != null) {
            outline.firePageActivated(this);
        }
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }

    @Override
    public <A> A getAdapter(Class<A> clazz) {
        return null;
    }

    @Override
    public void unload() {
        super.unload();
        T table = this.getTable(false);
        if (table != null) {
            table.deleteAllRows();
        }
    }

    private void interceptReloadPage(String reloadReason) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageReloadPageChain chain = new PageChains.PageReloadPageChain(extensions);
        chain.execReloadPage(reloadReason);
    }

    protected final void interceptPageDataLoaded() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PagePageDataLoadedChain chain = new PageChains.PagePageDataLoadedChain(extensions);
        chain.execPageDataLoaded();
    }

    protected final void interceptPageActivated() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PagePageActivatedChain chain = new PageChains.PagePageActivatedChain(extensions);
        chain.execPageActivated();
    }

    protected final void interceptDataChanged(Object ... dataTypes) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageDataChangedChain chain = new PageChains.PageDataChangedChain(extensions);
        chain.execDataChanged(dataTypes);
    }

    protected final void interceptInitPage() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageInitPageChain chain = new PageChains.PageInitPageChain(extensions);
        chain.execInitPage();
    }

    protected final void interceptPageDeactivated() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PagePageDeactivatedChain chain = new PageChains.PagePageDeactivatedChain(extensions);
        chain.execPageDeactivated();
    }

    protected final void interceptDisposePage() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageDisposePageChain chain = new PageChains.PageDisposePageChain(extensions);
        chain.execDisposePage();
    }

    protected final void interceptInitDetailForm() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageInitDetailFormChain chain = new PageChains.PageInitDetailFormChain(extensions);
        chain.execInitDetailForm();
    }

    protected final void interceptInitTable() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageInitTableChain chain = new PageChains.PageInitTableChain(extensions);
        chain.execInitTable();
    }

    protected final void interceptDetailFormActivated() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageDetailFormActivatedChain chain = new PageChains.PageDetailFormActivatedChain(extensions);
        chain.execDetailFormActivated();
    }

    protected final boolean interceptCalculateVisible() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.PageCalculateVisibleChain chain = new PageChains.PageCalculateVisibleChain(extensions);
        return chain.execCalculateVisible();
    }

    protected final List<IMenu> interceptComputeParentTablePageMenus(IPageWithTable<?> parentTablePage) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        PageChains.ComputeParentTablePageMenusChain chain = new PageChains.ComputeParentTablePageMenusChain(extensions);
        return chain.execComputeParentTablePageMenus(parentTablePage);
    }

    protected TreeListener createLocalTreeListener() {
        return e -> {
            AbstractPage page = this;
            if (20 == e.getType() && e.getChildNodes().contains(page)) {
                this.firePageChanged();
            }
        };
    }

    protected IPageExtension<? extends AbstractPage> createLocalExtension() {
        return new LocalPageExtension<AbstractPage>(this);
    }

    protected static class LocalPageExtension<OWNER extends AbstractPage>
    extends AbstractTreeNode.LocalTreeNodeExtension<OWNER>
    implements IPageExtension<OWNER> {
        public LocalPageExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execReloadPage(PageChains.PageReloadPageChain chain, String reloadReason) {
            ((AbstractPage)this.getOwner()).execReloadPage(reloadReason);
        }

        @Override
        public void execPageDataLoaded(PageChains.PagePageDataLoadedChain chain) {
            ((AbstractPage)this.getOwner()).execPageDataLoaded();
        }

        @Override
        public void execPageActivated(PageChains.PagePageActivatedChain chain) {
            ((AbstractPage)this.getOwner()).execPageActivated();
        }

        @Override
        public void execDataChanged(PageChains.PageDataChangedChain chain, Object ... dataTypes) {
            ((AbstractPage)this.getOwner()).execDataChanged(dataTypes);
        }

        @Override
        public void execInitPage(PageChains.PageInitPageChain chain) {
            ((AbstractPage)this.getOwner()).execInitPage();
        }

        @Override
        public void execPageDeactivated(PageChains.PagePageDeactivatedChain chain) {
            ((AbstractPage)this.getOwner()).execPageDeactivated();
        }

        @Override
        public void execDisposePage(PageChains.PageDisposePageChain chain) {
            ((AbstractPage)this.getOwner()).execDisposePage();
        }

        @Override
        public void execInitDetailForm(PageChains.PageInitDetailFormChain chain) {
            ((AbstractPage)this.getOwner()).execInitDetailForm();
        }

        @Override
        public void execInitTable(PageChains.PageInitTableChain chain) {
            ((AbstractPage)this.getOwner()).execInitTable();
        }

        @Override
        public void execDetailFormActivated(PageChains.PageDetailFormActivatedChain chain) {
            ((AbstractPage)this.getOwner()).execDetailFormActivated();
        }

        @Override
        public boolean execCalculateVisible(PageChains.PageCalculateVisibleChain chain) {
            return ((AbstractPage)this.getOwner()).execCalculateVisible();
        }

        @Override
        public List<IMenu> execComputeParentTablePageMenus(PageChains.ComputeParentTablePageMenusChain chain, IPageWithTable<?> parentTablePage) {
            return ((AbstractPage)this.getOwner()).execComputeParentTablePageMenus(parentTablePage);
        }
    }

    @ClassId(value="d9e0f79c-5270-4a6e-8fad-220dc81659ac")
    protected class P_TileOverviewForm
    extends AbstractForm
    implements ITileOverviewForm {
        protected P_TileOverviewForm() {
        }

        @Override
        protected String getConfiguredTitle() {
            return AbstractPage.this.getConfiguredTitle();
        }

        @Order(value=10.0)
        @ClassId(value="e3e6ee1e-df3d-4b13-b5da-23306fbc2686")
        public class MainBox
        extends AbstractGroupBox {
            @Override
            protected boolean execCalculateVisible() {
                return true;
            }

            @Order(value=2000.0)
            @ClassId(value="2eb22815-f33d-41e6-aabc-46b9935f12a2")
            public class F5KeyStroke
            extends AbstractKeyStroke {
                @Override
                protected String getConfiguredKeyStroke() {
                    return "f5";
                }

                @Override
                protected void execAction() {
                    AbstractPage.this.reloadPage();
                }
            }
        }
    }
}

