/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.util.Collection;
import java.util.function.Predicate;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IReadOnlyMenu;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineFormMenuWrapper;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMenuWrapper;
import org.eclipse.scout.rt.client.ui.form.IFormMenu;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;

@ApplicationScoped
public class MenuWrapper {
    public static IMenu wrapMenuIfNotWrapped(IMenu menu) {
        return ((MenuWrapper)BEANS.get(MenuWrapper.class)).doWrapMenuIfNotWrapped(menu, OutlineMenuWrapper.AUTO_MENU_TYPE_MAPPER, OutlineMenuWrapper.ACCEPT_ALL_FILTER);
    }

    public static IMenu wrapMenu(IMenu menu, OutlineMenuWrapper.IMenuTypeMapper menuTypeMapper) {
        return MenuWrapper.wrapMenu(menu, menuTypeMapper, OutlineMenuWrapper.ACCEPT_ALL_FILTER);
    }

    public static IMenu wrapMenu(IMenu menu, OutlineMenuWrapper.IMenuTypeMapper menuTypeMapper, Predicate<IMenu> menuFilter) {
        return ((MenuWrapper)BEANS.get(MenuWrapper.class)).doWrapMenu(menu, menuTypeMapper, menuFilter);
    }

    protected IReadOnlyMenu doWrapMenuIfNotWrapped(IMenu menu, OutlineMenuWrapper.IMenuTypeMapper menuTypeMapper, Predicate<IMenu> menuFilter) {
        if (menu instanceof IReadOnlyMenu) {
            return (IReadOnlyMenu)menu;
        }
        return this.doWrapMenu(menu, menuTypeMapper, menuFilter);
    }

    protected IReadOnlyMenu doWrapMenu(IMenu menu, OutlineMenuWrapper.IMenuTypeMapper menuTypeMapper, Predicate<IMenu> menuFilter) {
        if (menu instanceof IFormMenu) {
            return new OutlineFormMenuWrapper((IFormMenu)menu, menuTypeMapper, menuFilter);
        }
        return new OutlineMenuWrapper(menu, menuTypeMapper, menuFilter);
    }

    public static IMenu unwrapMenu(IMenu menu) {
        if (menu instanceof IReadOnlyMenu) {
            return MenuWrapper.unwrapMenu(((IReadOnlyMenu)menu).getWrappedMenu());
        }
        return menu;
    }

    public static boolean containsWrappedMenu(Collection<IMenu> menus, IMenu menu) {
        if (menu instanceof IReadOnlyMenu) {
            IReadOnlyMenu wrapper = (IReadOnlyMenu)menu;
            return menus.contains(wrapper.getWrappedMenu()) || MenuWrapper.containsWrappedMenu(menus, wrapper.getWrappedMenu());
        }
        return false;
    }
}

