/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.ISearchOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.ISearchOutlineUiFacade;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;

@ClassId(value="57c90097-ba28-414c-8ce6-0ae32bfef803")
public abstract class AbstractSearchOutline
extends AbstractOutline
implements ISearchOutline {
    private int m_minSearchTokenLength;

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"Search");
    }

    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMaxSearchQueryLength() {
        return 60;
    }

    @ConfigProperty(value="INTEGER")
    protected int getConfiguredMinSearchTokenLength() {
        return 2;
    }

    @Override
    protected String getConfiguredIconId() {
        return "font:\ue02a";
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMaxSearchQueryLength(this.getConfiguredMaxSearchQueryLength());
        this.setMinSearchTokenLength(this.getConfiguredMinSearchTokenLength());
    }

    @Override
    public void setMinSearchTokenLength(int len) {
        if (len > 0) {
            this.m_minSearchTokenLength = len;
        }
    }

    @Override
    public int getMinSearchTokenLength() {
        if (this.m_minSearchTokenLength <= 0) {
            return 2;
        }
        return this.m_minSearchTokenLength;
    }

    @Override
    public void setMaxSearchQueryLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxSearchFieldLength", len);
        }
    }

    @Override
    public int getMaxSearchQueryLength() {
        int len = this.propertySupport.getPropertyInt("maxSearchFieldLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    public void search() {
        this.execSearch(this.getSearchQuery());
    }

    protected void execSearch(String query) {
    }

    @Override
    public void setSearchQuery(String searchQuery) {
        this.propertySupport.setPropertyString("searchQuery", searchQuery);
    }

    @Override
    public String getSearchQuery() {
        return this.propertySupport.getPropertyString("searchQuery");
    }

    @Override
    public void setSearchStatus(String searchStatus) {
        this.propertySupport.setPropertyString("searchStatus", searchStatus);
    }

    @Override
    public String getSearchStatus() {
        return this.propertySupport.getPropertyString("searchStatus");
    }

    @Override
    public void requestFocusQueryField() {
        this.propertySupport.setPropertyAlwaysFire("requestFocusQueryField", null);
    }

    @Override
    protected ITreeUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    @Override
    public ISearchOutlineUiFacade getUIFacade() {
        return (ISearchOutlineUiFacade)super.getUIFacade();
    }

    protected class P_UIFacade
    extends AbstractTree.P_UIFacade
    implements ISearchOutlineUiFacade {
        protected P_UIFacade() {
        }

        @Override
        public void search(String query) {
            try {
                this.pushUIProcessor();
                AbstractSearchOutline.this.setProperty("searchQuery", query);
                AbstractSearchOutline.this.search();
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

