/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import org.eclipse.scout.rt.client.extension.ui.desktop.outline.IOutlineViewButtonExtension;
import org.eclipse.scout.rt.client.ui.action.view.AbstractViewButton;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineViewButton;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.util.Assertions;

@ClassId(value="401907e2-6767-435b-8452-9c819f3af82f")
public abstract class AbstractOutlineViewButton
extends AbstractViewButton
implements IOutlineViewButton {
    private final IDesktop m_desktop;
    private final IOutline m_outline;

    public AbstractOutlineViewButton(IDesktop desktop, Class<? extends IOutline> outlineType) {
        this(desktop, AbstractOutlineViewButton.getOutlineOfType(desktop, outlineType));
    }

    protected static IOutline getOutlineOfType(IDesktop desktop, Class<? extends IOutline> outlineType) {
        if (desktop == null) {
            return null;
        }
        for (IOutline o : desktop.getAvailableOutlines()) {
            if (o.getClass() != outlineType) continue;
            return o;
        }
        throw new Assertions.AssertionException("the outline type {} is not registered in the desktop.", new Object[]{outlineType});
    }

    public AbstractOutlineViewButton(IDesktop desktop, IOutline outline) {
        super(false);
        this.m_desktop = (IDesktop)Assertions.assertNotNull((Object)desktop, (String)"Desktop must not be null", (Object[])new Object[0]);
        this.m_outline = (IOutline)Assertions.assertNotNull((Object)outline, (String)"Outline must not be null", (Object[])new Object[0]);
        this.callInitializer();
    }

    @Override
    protected void execInitAction() {
        this.setVisibleGranted(this.m_outline.isVisibleGranted());
        this.setVisible(this.m_outline.isVisible());
        this.setEnabled(this.m_outline.isEnabled());
        this.setText(this.m_outline.getTitle());
        this.setIconId(this.m_outline.getIconId());
        this.setSelected(this.m_desktop.getOutline() == this.m_outline);
        this.m_desktop.addDesktopListener(e -> {
            switch (e.getType()) {
                case 200: {
                    this.setSelected(e.getOutline() == this.m_outline);
                }
            }
        }, new Integer[0]);
        this.m_outline.addPropertyChangeListener(e -> {
            String n = e.getPropertyName();
            Object v = e.getNewValue();
            if (n.equals("visible")) {
                this.setVisible((Boolean)v);
            } else if (n.equals("title")) {
                this.setText((String)v);
            } else if (n.equals("iconId")) {
                this.setIconId((String)v);
            }
        });
    }

    @Override
    protected void execAction() {
        if (this.isSelected() && this.m_desktop.getOutline() != this.m_outline) {
            this.m_desktop.activateOutline(this.m_outline);
        }
    }

    @Override
    protected final boolean getConfiguredEnabled() {
        return super.getConfiguredEnabled();
    }

    @Override
    protected final String getConfiguredText() {
        return super.getConfiguredText();
    }

    @Override
    protected final boolean getConfiguredVisible() {
        return super.getConfiguredVisible();
    }

    @Override
    public IOutline getOutline() {
        return this.m_outline;
    }

    @Override
    protected IOutlineViewButtonExtension<? extends AbstractOutlineViewButton> createLocalExtension() {
        return new LocalOutlineViewButtonExtension<AbstractOutlineViewButton>(this);
    }

    protected static class LocalOutlineViewButtonExtension<OWNER extends AbstractOutlineViewButton>
    extends AbstractViewButton.LocalViewButtonExtension<OWNER>
    implements IOutlineViewButtonExtension<OWNER> {
        public LocalOutlineViewButtonExtension(OWNER owner) {
            super(owner);
        }
    }
}

