/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;

@ClassId(value="b235fb65-6b50-4870-895a-f8a26ee41c96")
public abstract class AbstractOutlineButton
extends AbstractButton {
    private IOutline m_outline;

    public AbstractOutlineButton() {
        this(true);
    }

    public AbstractOutlineButton(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected int getConfiguredDisplayStyle() {
        return 1;
    }

    @Override
    protected boolean getConfiguredProcessButton() {
        return false;
    }

    @ConfigProperty(value="OUTLINE")
    protected Class<? extends IOutline> getConfiguredOutline() {
        return null;
    }

    @Override
    protected void execInitField() {
        IDesktop desktop = ClientSessionProvider.currentSession().getDesktop();
        for (IOutline o : desktop.getAvailableOutlines()) {
            if (o.getClass() != this.getConfiguredOutline()) continue;
            this.m_outline = o;
            break;
        }
        if (this.m_outline != null) {
            this.setVisible(this.m_outline.isVisible());
            this.setEnabled(this.m_outline.isEnabled(), true);
            this.setLabel(this.m_outline.getTitle());
            this.setTooltipText(this.m_outline.getTitle());
            this.setSelected(desktop.getOutline() == this.m_outline);
            desktop.addDesktopListener(e -> {
                switch (e.getType()) {
                    case 200: {
                        this.setSelected(e.getOutline() == this.m_outline);
                    }
                }
            }, new Integer[0]);
            this.m_outline.addPropertyChangeListener(e -> {
                String n = e.getPropertyName();
                Object v = e.getNewValue();
                switch (n) {
                    case "visible": {
                        this.setVisible((Boolean)v);
                        break;
                    }
                    case "title": {
                        this.setLabel((String)v);
                        break;
                    }
                    case "defaultIconId": {
                        this.setIconId((String)v);
                    }
                }
            });
        }
    }

    @Override
    protected final void execSelectionChanged(boolean selection) {
        IDesktop desktop;
        if (selection && (desktop = ClientSessionProvider.currentSession().getDesktop()) != null) {
            desktop.activateOutline(this.m_outline);
        }
    }
}

