/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.notification;

import java.util.function.Consumer;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotificationUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.notification.NativeNotificationDefaults;
import org.eclipse.scout.rt.client.ui.notification.Notification;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.status.IStatus;
import org.eclipse.scout.rt.platform.status.Status;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

@ClassId(value="cd82392d-609d-44c2-ac41-87fca7a78646")
public class DesktopNotification
extends Notification
implements IDesktopNotification {
    private long m_duration;
    private final IDesktopNotificationUIFacade m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());

    public DesktopNotification(String text) {
        this((IStatus)new Status(text, 256));
    }

    public DesktopNotification(IStatus status) {
        this(status, DEFAULT_DURATION, true);
    }

    public DesktopNotification(IStatus status, long duration, boolean closable) {
        this(status, duration, closable, false);
    }

    public DesktopNotification(IStatus status, long duration, boolean closable, boolean htmlEnabled) {
        this(status, duration, closable, htmlEnabled, null);
    }

    public DesktopNotification(IStatus status, long duration, boolean closable, boolean htmlEnabled, Consumer<String> appLinkConsumer) {
        super(status, closable, htmlEnabled, appLinkConsumer);
        this.m_duration = duration;
        NativeNotificationDefaults nativeNotificationDefaults = IDesktop.CURRENT.get().getNativeNotificationDefaults();
        if (nativeNotificationDefaults != null) {
            this.withNativeNotificationTitle(nativeNotificationDefaults.getTitle());
            if (status == null) {
                this.withNativeNotificationStatus((IStatus)new Status(null, 256, 0, nativeNotificationDefaults.getIconId()));
            } else {
                this.withNativeNotificationStatus((IStatus)new Status(status.getMessage(), status.getSeverity(), status.getCode(), nativeNotificationDefaults.getIconId()));
            }
            this.withNativeNotificationVisibility((String)ObjectUtility.nvl((Object)nativeNotificationDefaults.getVisibility(), (Object)"none"));
        }
    }

    @Override
    public DesktopNotification withDuration(long duration) {
        this.m_duration = duration;
        return this;
    }

    @Override
    public long getDuration() {
        return this.m_duration;
    }

    @Override
    public DesktopNotification withNativeOnly(boolean nativeOnly) {
        this.propertySupport.setPropertyBool("nativeOnly", nativeOnly);
        return this;
    }

    @Override
    public boolean isNativeOnly() {
        return this.propertySupport.getPropertyBool("nativeOnly");
    }

    @Override
    public DesktopNotification withNativeNotificationVisibility(String nativeNotificationVisibility) {
        this.propertySupport.setPropertyString("nativeNotificationVisibility", nativeNotificationVisibility);
        return this;
    }

    @Override
    public String getNativeNotificationVisibility() {
        return this.propertySupport.getPropertyString("nativeNotificationVisibility");
    }

    @Override
    public DesktopNotification withNativeNotificationTitle(String nativeNotificationTitle) {
        this.propertySupport.setPropertyString("nativeNotificationTitle", nativeNotificationTitle);
        return this;
    }

    @Override
    public String getNativeNotificationTitle() {
        return this.propertySupport.getPropertyString("nativeNotificationTitle");
    }

    @Override
    public DesktopNotification withNativeNotificationStatus(IStatus nativeNotificationStatus) {
        this.propertySupport.setProperty("nativeNotificationStatus", (Object)nativeNotificationStatus);
        return this;
    }

    @Override
    public IStatus getNativeNotificationStatus() {
        return (IStatus)this.propertySupport.getProperty("nativeNotificationStatus", IStatus.class);
    }

    private void setNativeNotificationShown(boolean shown) {
        this.propertySupport.setPropertyBool("nativeNotificationShown", shown);
    }

    @Override
    public boolean isNativeNotificationShown() {
        return this.propertySupport.getPropertyBool("nativeNotificationShown");
    }

    @Override
    public DesktopNotification withAppLinkConsumer(Consumer<String> appLinkConsumer) {
        return (DesktopNotification)super.withAppLinkConsumer(appLinkConsumer);
    }

    @Override
    public DesktopNotification withClosable(boolean closable) {
        return (DesktopNotification)super.withClosable(closable);
    }

    @Override
    public DesktopNotification withHtmlEnabled(boolean htmlEnabled) {
        return (DesktopNotification)super.withHtmlEnabled(htmlEnabled);
    }

    @Override
    public DesktopNotification withStatus(IStatus status) {
        return (DesktopNotification)super.withStatus(status);
    }

    @Override
    public IDesktopNotificationUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected class P_UIFacade
    implements IDesktopNotificationUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireClosedFromUI() {
            IDesktop.CURRENT.get().getUIFacade().removedNotificationFromUI(DesktopNotification.this);
        }

        @Override
        public void setNativeNotificationShownFromUI(boolean shown) {
            DesktopNotification.this.setNativeNotificationShown(shown);
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            if (DesktopNotification.this.getAppLinkConsumer() != null) {
                DesktopNotification.this.getAppLinkConsumer().accept(ref);
            }
        }
    }
}

