/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.internal;

import java.beans.PropertyChangeListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.Coordinates;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.ScrollOptions;
import org.eclipse.scout.rt.client.ui.WidgetListeners;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.BrowserHistoryEntry;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListeners;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.bench.layout.BenchLayoutData;
import org.eclipse.scout.rt.client.ui.desktop.datachange.DataChangeEvent;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeManager;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.desktop.notification.NativeNotificationDefaults;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.context.PropertyMap;
import org.eclipse.scout.rt.platform.reflect.BasicPropertySupport;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.visitor.IBreadthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;

@ClassId(value="3184965f-010b-4d1b-9c08-d5cd35eedf2b")
public class VirtualDesktop
implements IDesktop {
    private DesktopListeners m_listeners = new DesktopListeners();
    private BasicPropertySupport m_propertyChangeListeners = new BasicPropertySupport((Object)this);
    private IDataChangeManager m_dataChangeListeners = (IDataChangeManager)BEANS.get(IDataChangeManager.class);
    private IDataChangeManager m_dataChangeDesktopInForegroundListeners = (IDataChangeManager)BEANS.get(IDataChangeManager.class);
    private WidgetListeners m_widgetListeners = new WidgetListeners();
    private IDesktop m_realDesktop;
    private List<Pair<Object, Boolean>> m_bufferedDataChangeEvents = new ArrayList<Pair<Object, Boolean>>();

    public void setRealDesktop(IDesktop realDesktop) {
        if (realDesktop == null) {
            throw new IllegalArgumentException("Real desktop must not be null");
        }
        if (realDesktop instanceof VirtualDesktop) {
            throw new IllegalArgumentException("Real desktop must not be virtual");
        }
        if (this.m_realDesktop == realDesktop) {
            return;
        }
        if (this.m_realDesktop != null) {
            throw new IllegalStateException("real desktop has already been set");
        }
        ModelJobs.assertModelThread();
        realDesktop.desktopListeners().addAll(this.desktopListeners());
        this.m_listeners = null;
        this.m_propertyChangeListeners.getPropertyChangeListeners().forEach(l -> realDesktop.addPropertyChangeListener((PropertyChangeListener)l));
        this.m_propertyChangeListeners.getSpecificPropertyChangeListeners().forEach((propName, listeners) -> listeners.forEach(listener -> realDesktop.addPropertyChangeListener((String)propName, (PropertyChangeListener)listener)));
        this.m_propertyChangeListeners = null;
        realDesktop.dataChangeListeners().addAll(this.dataChangeListeners());
        this.m_dataChangeListeners = null;
        realDesktop.dataChangeDesktopInForegroundListeners().addAll(this.dataChangeDesktopInForegroundListeners());
        this.m_dataChangeDesktopInForegroundListeners = null;
        realDesktop.widgetListeners().addAll(this.widgetListeners());
        this.m_widgetListeners = null;
        this.m_realDesktop = realDesktop;
        for (Pair<Object, Boolean> pair : this.m_bufferedDataChangeEvents) {
            boolean isFromFireDataChangeEvent = (Boolean)pair.getRight();
            Object event = pair.getLeft();
            if (isFromFireDataChangeEvent) {
                this.m_realDesktop.fireDataChangeEvent((DataChangeEvent)event);
                continue;
            }
            this.m_realDesktop.dataChanged(event);
        }
        this.m_bufferedDataChangeEvents = null;
    }

    public Optional<IDesktop> getRealDesktop() {
        return Optional.ofNullable(this.m_realDesktop);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.forwardToRealDesktopOrElse(d -> d.addPropertyChangeListener(listener), () -> this.m_propertyChangeListeners.addPropertyChangeListener(listener));
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.forwardToRealDesktopOrElse(d -> d.addPropertyChangeListener(propertyName, listener), () -> this.m_propertyChangeListeners.addPropertyChangeListener(propertyName, listener));
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.forwardToRealDesktopOrElse(d -> d.removePropertyChangeListener(listener), () -> this.m_propertyChangeListeners.removePropertyChangeListener(listener));
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.forwardToRealDesktopOrElse(d -> d.removePropertyChangeListener(propertyName, listener), () -> this.m_propertyChangeListeners.removePropertyChangeListener(propertyName, listener));
    }

    public List<PropertyChangeListener> getPropertyChangeListeners() {
        return this.getFromRealDesktopOrElseGet(d -> d.getPropertyChangeListeners(), () -> this.m_propertyChangeListeners.getPropertyChangeListeners());
    }

    public Map<String, List<PropertyChangeListener>> getSpecificPropertyChangeListeners() {
        return this.getFromRealDesktopOrElseGet(d -> d.getSpecificPropertyChangeListeners(), () -> this.m_propertyChangeListeners.getSpecificPropertyChangeListeners());
    }

    @Override
    public DesktopListeners desktopListeners() {
        return this.getFromRealDesktopOrElse(d -> d.desktopListeners(), this.m_listeners);
    }

    @Override
    public IDataChangeManager dataChangeListeners() {
        return this.getFromRealDesktopOrElse(d -> d.dataChangeListeners(), this.m_dataChangeListeners);
    }

    @Override
    public IDataChangeManager dataChangeDesktopInForegroundListeners() {
        return this.getFromRealDesktopOrElse(d -> d.dataChangeDesktopInForegroundListeners(), this.m_dataChangeDesktopInForegroundListeners);
    }

    @Override
    public WidgetListeners widgetListeners() {
        return this.getFromRealDesktopOrElse(d -> d.widgetListeners(), this.m_widgetListeners);
    }

    public void forwardToRealDesktopOrThrow(Consumer<IDesktop> realDesktopTask) {
        this.getFromRealDesktopOrThrow(d -> {
            realDesktopTask.accept((IDesktop)d);
            return Boolean.TRUE;
        });
    }

    public <T> T getFromRealDesktopOrThrow(Function<IDesktop, T> realDesktopTask) {
        IDesktop realDesktop = this.getRealDesktop().orElseThrow(() -> new UnsupportedOperationException("The desktop is currently loading. This method must be called after the desktop has loaded and is set onto the session"));
        return realDesktopTask.apply(realDesktop);
    }

    public void forwardToRealDesktopIfAvailable(Consumer<IDesktop> realDesktopTask) {
        this.getFromRealDesktopOrElse(d -> {
            realDesktopTask.accept((IDesktop)d);
            return Boolean.TRUE;
        }, null);
    }

    public <T> T getFromRealDesktopOrElse(Function<IDesktop, T> realDesktopTask, T orElse) {
        return (T)this.getFromRealDesktopOrElseGet(realDesktopTask, () -> orElse);
    }

    public void forwardToRealDesktopOrElse(Consumer<IDesktop> realDesktopTask, Runnable virtualDesktopTask) {
        this.getFromRealDesktopOrElseGet(d -> {
            realDesktopTask.accept((IDesktop)d);
            return Boolean.TRUE;
        }, () -> {
            virtualDesktopTask.run();
            return Boolean.TRUE;
        });
    }

    public <T> T getFromRealDesktopOrElseGet(Function<IDesktop, T> realDesktopTask, Supplier<? extends T> orElse) {
        return this.getRealDesktop().map(realDesktopTask).orElseGet(orElse);
    }

    @Override
    public boolean isAutoPrefixWildcardForTextSearch() {
        return this.getFromRealDesktopOrThrow(d -> d.isAutoPrefixWildcardForTextSearch());
    }

    @Override
    public void setAutoPrefixWildcardForTextSearch(boolean b) {
        this.forwardToRealDesktopOrThrow(d -> d.setAutoPrefixWildcardForTextSearch(b));
    }

    @Override
    public boolean isSelectViewTabsKeyStrokesEnabled() {
        return this.getFromRealDesktopOrThrow(IDesktop::isSelectViewTabsKeyStrokesEnabled);
    }

    @Override
    public void setSelectViewTabsKeyStrokesEnabled(boolean selectViewTabsKeyStrokesEnabled) {
        this.forwardToRealDesktopOrThrow(d -> d.setSelectViewTabsKeyStrokesEnabled(selectViewTabsKeyStrokesEnabled));
    }

    @Override
    public String getSelectViewTabsKeyStrokeModifier() {
        return this.getFromRealDesktopOrThrow(d -> d.getSelectViewTabsKeyStrokeModifier());
    }

    @Override
    public void setSelectViewTabsKeyStrokeModifier(String selectViewTabsKeyStrokeModifier) {
        this.forwardToRealDesktopOrThrow(d -> d.setSelectViewTabsKeyStrokeModifier(selectViewTabsKeyStrokeModifier));
    }

    @Override
    public void doLogoAction() {
        this.forwardToRealDesktopOrThrow(d -> d.doLogoAction());
    }

    @Override
    public void activateBookmark(Bookmark bm) {
        this.forwardToRealDesktopOrThrow(d -> d.activateBookmark(bm));
    }

    @Override
    public void activateBookmark(Bookmark bm, boolean activateOutline) {
        this.forwardToRealDesktopOrThrow(d -> d.activateBookmark(bm, activateOutline));
    }

    @Override
    public boolean isShowing(IFileChooser fileChooser) {
        return this.getFromRealDesktopOrThrow(d -> d.isShowing(fileChooser));
    }

    @Override
    public List<IFileChooser> getFileChoosers() {
        return this.getFromRealDesktopOrThrow(d -> d.getFileChoosers());
    }

    @Override
    public List<IFileChooser> getFileChoosers(IDisplayParent displayParent) {
        return this.getFromRealDesktopOrThrow(d -> d.getFileChoosers(displayParent));
    }

    @Override
    public void showFileChooser(IFileChooser fileChooser) {
        this.forwardToRealDesktopOrThrow(d -> d.showFileChooser(fileChooser));
    }

    @Override
    public void hideFileChooser(IFileChooser fileChooser) {
        this.forwardToRealDesktopOrThrow(d -> d.hideFileChooser(fileChooser));
    }

    @Override
    public void openUri(String url, IOpenUriAction openUriAction) {
        this.forwardToRealDesktopOrThrow(d -> d.openUri(url, openUriAction));
    }

    @Override
    public void openUri(BinaryResource binaryResource) {
        this.forwardToRealDesktopOrThrow(d -> d.openUri(binaryResource));
    }

    @Override
    public void openUri(BinaryResource binaryResource, IOpenUriAction openUriAction) {
        this.forwardToRealDesktopOrThrow(d -> d.openUri(binaryResource, openUriAction));
    }

    @Override
    public void showForm(IForm form) {
        this.forwardToRealDesktopOrThrow(d -> d.showForm(form));
    }

    @Override
    public void hideForm(IForm form) {
        this.forwardToRealDesktopOrThrow(d -> d.hideForm(form));
    }

    @Override
    public void addKeyStrokes(IKeyStroke ... keyStrokes) {
        this.forwardToRealDesktopOrThrow(d -> d.addKeyStrokes(keyStrokes));
    }

    @Override
    public void showMessageBox(IMessageBox messageBox) {
        this.forwardToRealDesktopOrThrow(d -> d.showMessageBox(messageBox));
    }

    @Override
    public void hideMessageBox(IMessageBox messageBox) {
        this.forwardToRealDesktopOrThrow(d -> d.hideMessageBox(messageBox));
    }

    @Override
    public void closeInternal() {
        this.forwardToRealDesktopOrThrow(d -> d.closeInternal());
    }

    @Override
    public Bookmark createBookmark() {
        return this.getFromRealDesktopOrThrow(d -> d.createBookmark());
    }

    @Override
    public Bookmark createBookmark(IPage<?> page) {
        return this.getFromRealDesktopOrThrow(d -> d.createBookmark(page));
    }

    @Override
    public void dataChanged(Object ... dataTypes) {
        if (dataTypes == null || dataTypes.length < 1) {
            return;
        }
        this.forwardToRealDesktopOrElse(d -> d.dataChanged(dataTypes), () -> Arrays.stream(dataTypes).map(dataType -> new ImmutablePair(dataType, (Object)false)).forEach(this.m_bufferedDataChangeEvents::add));
    }

    @Override
    public void fireDataChangeEvent(DataChangeEvent event) {
        if (event == null) {
            return;
        }
        this.forwardToRealDesktopOrElse(d -> d.fireDataChangeEvent(event), () -> {
            boolean bl = this.m_bufferedDataChangeEvents.add((Pair<Object, Boolean>)new ImmutablePair((Object)event, (Object)true));
        });
    }

    @Override
    public void setDataChanging(boolean b) {
    }

    @Override
    public boolean isDataChanging() {
        return false;
    }

    @Override
    public void ensureViewStackVisible() {
        this.forwardToRealDesktopOrThrow(d -> d.ensureViewStackVisible());
    }

    @Override
    public void activateForm(IForm form) {
        this.forwardToRealDesktopOrThrow(d -> d.activateForm(form));
    }

    @Override
    public void activateOutline(IOutline outline) {
        this.forwardToRealDesktopOrThrow(d -> d.activateOutline(outline));
    }

    @Override
    public void activateFirstPage() {
        this.forwardToRealDesktopOrThrow(d -> d.activateFirstPage());
    }

    @Override
    public <T extends IForm> T findForm(Class<T> formType) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.findForm(formType));
    }

    @Override
    public <T extends IForm> List<T> findForms(Class<T> formType) {
        return this.getFromRealDesktopOrThrow(d -> d.findForms(formType));
    }

    @Override
    public <T extends IOutline> T findOutline(Class<T> outlineType) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.findOutline(outlineType));
    }

    @Override
    public <T extends IAction> T findAction(Class<T> actionType) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.findAction(actionType));
    }

    @Override
    public <T extends IViewButton> T findViewButton(Class<T> viewButtonType) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.findViewButton(viewButtonType));
    }

    @Override
    public List<IOutline> getAvailableOutlines() {
        return this.getFromRealDesktopOrThrow(d -> d.getAvailableOutlines());
    }

    @Override
    public void setAvailableOutlines(List<? extends IOutline> availableOutlines) {
        this.forwardToRealDesktopOrThrow(d -> d.setAvailableOutlines(availableOutlines));
    }

    @Override
    public List<IForm> getDialogs() {
        return this.getFromRealDesktopOrThrow(d -> d.getDialogs());
    }

    @Override
    public List<IForm> getDialogs(IDisplayParent displayParent, boolean includeChildDialogs) {
        return this.getFromRealDesktopOrThrow(d -> d.getDialogs(displayParent, includeChildDialogs));
    }

    @Override
    public Set<IKeyStroke> getKeyStrokes() {
        return this.getFromRealDesktopOrThrow(d -> d.getKeyStrokes());
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getFromRealDesktopOrThrow(d -> d.getMenus());
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.getMenuByClass(menuType));
    }

    @Override
    public IContextMenu getContextMenu() {
        return this.getFromRealDesktopOrThrow(d -> d.getContextMenu());
    }

    @Override
    public boolean isShowing(IMessageBox messageBox) {
        return this.getFromRealDesktopOrThrow(d -> d.isShowing(messageBox));
    }

    @Override
    public List<IMessageBox> getMessageBoxes() {
        return this.getFromRealDesktopOrThrow(d -> d.getMessageBoxes());
    }

    @Override
    public List<IDesktopNotification> getNotifications() {
        return this.getFromRealDesktopOrThrow(d -> d.getNotifications());
    }

    @Override
    public List<IMessageBox> getMessageBoxes(IDisplayParent displayParent) {
        return this.getFromRealDesktopOrThrow(d -> d.getMessageBoxes(displayParent));
    }

    @Override
    public IOutline getOutline() {
        return this.getFromRealDesktopOrThrow(d -> d.getOutline());
    }

    @Override
    public IForm getPageSearchForm() {
        return this.getFromRealDesktopOrThrow(d -> d.getPageSearchForm());
    }

    @Override
    public void setPageSearchForm(IForm f) {
        this.forwardToRealDesktopOrThrow(d -> d.setPageSearchForm(f));
    }

    @Override
    public IForm getPageDetailForm() {
        return this.getFromRealDesktopOrThrow(d -> d.getPageDetailForm());
    }

    @Override
    public void setPageDetailForm(IForm f) {
        this.forwardToRealDesktopOrThrow(d -> d.setPageDetailForm(f));
    }

    @Override
    public ITable getPageDetailTable() {
        return this.getFromRealDesktopOrThrow(d -> d.getPageDetailTable());
    }

    @Override
    public void setPageDetailTable(ITable t) {
        this.forwardToRealDesktopOrThrow(d -> d.setPageDetailTable(t));
    }

    @Override
    public List<IForm> getSimilarForms(IForm form) {
        return this.getFromRealDesktopOrThrow(d -> d.getSimilarForms(form));
    }

    @Override
    public String getTitle() {
        return this.getFromRealDesktopOrThrow(d -> d.getTitle());
    }

    @Override
    public List<IAction> getActions() {
        return this.getFromRealDesktopOrThrow(d -> d.getActions());
    }

    @Override
    public <T extends IViewButton> T getViewButton(Class<? extends T> searchType) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.getViewButton(searchType));
    }

    @Override
    public List<IViewButton> getViewButtons() {
        return this.getFromRealDesktopOrThrow(d -> d.getViewButtons());
    }

    @Override
    public IDesktopUIFacade getUIFacade() {
        return this.getFromRealDesktopOrThrow(d -> d.getUIFacade());
    }

    @Override
    public boolean isShowing(IForm form) {
        return this.getFromRealDesktopOrThrow(d -> d.isShowing(form));
    }

    @Override
    public List<IForm> getForms(IDisplayParent displayParent) {
        return this.getFromRealDesktopOrThrow(d -> d.getForms(displayParent));
    }

    @Override
    public List<IForm> getViews() {
        return this.getFromRealDesktopOrThrow(d -> d.getViews());
    }

    @Override
    public Collection<IForm> getSelectedViews(IDisplayParent displayParent) {
        return this.getFromRealDesktopOrThrow(d -> d.getSelectedViews(displayParent));
    }

    @Override
    public <F extends IForm, H extends IFormHandler> List<F> findAllOpenViews(Class<? extends F> formClass, Class<? extends H> handlerClass, Object exclusiveKey) {
        return this.getFromRealDesktopOrThrow(d -> d.findAllOpenViews(formClass, handlerClass, exclusiveKey));
    }

    @Override
    public <F extends IForm, H extends IFormHandler> F findOpenView(Class<? extends F> formClass, Class<? extends H> handlerClass, Object exclusiveKey) {
        return (F)this.getFromRealDesktopOrThrow(d -> d.findOpenView(formClass, handlerClass, exclusiveKey));
    }

    @Override
    public List<IForm> getViews(IDisplayParent displayParent) {
        return this.getFromRealDesktopOrThrow(d -> d.getViews(displayParent));
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return this.getFromRealDesktopOrThrow(d -> d.getChildren());
    }

    @Override
    public void visit(Consumer<IWidget> visitor) {
        this.forwardToRealDesktopOrThrow(d -> d.visit(visitor));
    }

    @Override
    public <T extends IWidget> void visit(Consumer<T> visitor, Class<T> type) {
        this.forwardToRealDesktopOrThrow(d -> d.visit(visitor, type));
    }

    @Override
    public TreeVisitResult visit(Function<IWidget, TreeVisitResult> visitor) {
        return this.getFromRealDesktopOrThrow(d -> d.visit(visitor));
    }

    @Override
    public <T extends IWidget> TreeVisitResult visit(Function<T, TreeVisitResult> visitor, Class<T> type) {
        return this.getFromRealDesktopOrThrow(d -> d.visit(visitor, type));
    }

    @Override
    public TreeVisitResult visit(IDepthFirstTreeVisitor<IWidget> visitor) {
        return this.getFromRealDesktopOrThrow(d -> d.visit(visitor));
    }

    @Override
    public <T extends IWidget> TreeVisitResult visit(IDepthFirstTreeVisitor<T> visitor, Class<T> type) {
        return this.getFromRealDesktopOrThrow(d -> d.visit(visitor, type));
    }

    @Override
    public <T extends IWidget> TreeVisitResult visit(IBreadthFirstTreeVisitor<T> visitor, Class<T> type) {
        return this.getFromRealDesktopOrThrow(d -> d.visit(visitor, type));
    }

    @Override
    public TreeVisitResult visit(IBreadthFirstTreeVisitor<IWidget> visitor) {
        return this.getFromRealDesktopOrThrow(d -> d.visit(visitor));
    }

    @Override
    public void init() {
        this.forwardToRealDesktopOrThrow(d -> d.init());
    }

    @Override
    public void reinit() {
        this.forwardToRealDesktopOrThrow(d -> d.reinit());
    }

    @Override
    public boolean isInitConfigDone() {
        return this.getFromRealDesktopOrThrow(d -> d.isInitConfigDone());
    }

    @Override
    public boolean isInitDone() {
        return this.getFromRealDesktopOrThrow(d -> d.isInitDone());
    }

    @Override
    public boolean isDisposeDone() {
        return this.getFromRealDesktopOrThrow(d -> d.isDisposeDone());
    }

    @Override
    public void dispose() {
        this.forwardToRealDesktopOrThrow(d -> d.dispose());
    }

    @Override
    public boolean isOpened() {
        return this.getFromRealDesktopOrThrow(d -> d.isOpened());
    }

    @Override
    public boolean isReady() {
        return this.getFromRealDesktopOrThrow(d -> d.isReady());
    }

    @Override
    public boolean isGuiAvailable() {
        return this.getFromRealDesktopOrThrow(d -> d.isGuiAvailable());
    }

    @Override
    public void refreshPages(List<Class<? extends IPage<?>>> pages) {
        this.forwardToRealDesktopOrThrow(d -> d.refreshPages(pages));
    }

    public void refreshPages(Class ... pageTypes) {
        this.forwardToRealDesktopOrThrow(d -> d.refreshPages(pageTypes));
    }

    @Override
    public void releaseUnusedPages() {
        this.forwardToRealDesktopOrThrow(d -> d.releaseUnusedPages());
    }

    @Override
    public void afterTablePageLoaded(IPageWithTable<?> page) {
        this.forwardToRealDesktopOrThrow(d -> d.afterTablePageLoaded(page));
    }

    @Override
    public void removeKeyStrokes(IKeyStroke ... keyStrokes) {
        this.forwardToRealDesktopOrThrow(d -> d.removeKeyStrokes(keyStrokes));
    }

    @Override
    public void setKeyStrokes(Collection<? extends IKeyStroke> ks) {
        this.forwardToRealDesktopOrThrow(d -> d.setKeyStrokes(ks));
    }

    @Override
    public void setOutline(Class<? extends IOutline> outlineType) {
        this.forwardToRealDesktopOrThrow(d -> d.setOutline(outlineType));
    }

    @Override
    public void addNotification(IDesktopNotification notification) {
        this.forwardToRealDesktopIfAvailable(d -> d.addNotification(notification));
    }

    @Override
    public void removeNotification(IDesktopNotification notification) {
        this.forwardToRealDesktopIfAvailable(d -> d.removeNotification(notification));
    }

    @Override
    public void reloadGui() {
        this.forwardToRealDesktopOrThrow(d -> d.reloadGui());
    }

    @Override
    public void setTitle(String s) {
        this.forwardToRealDesktopOrThrow(d -> d.setTitle(s));
    }

    @Override
    public String getCssClass() {
        return this.getFromRealDesktopOrThrow(d -> d.getCssClass());
    }

    @Override
    public void setCssClass(String cssClass) {
        this.forwardToRealDesktopOrThrow(d -> d.setCssClass(cssClass));
    }

    @Override
    public boolean has(IWidget child) {
        return this.getFromRealDesktopOrThrow(d -> d.has(child));
    }

    @Override
    public boolean doBeforeClosingInternal() {
        return this.getFromRealDesktopOrThrow(d -> d.doBeforeClosingInternal());
    }

    @Override
    public List<IForm> getUnsavedForms() {
        return this.getFromRealDesktopOrThrow(d -> d.getUnsavedForms());
    }

    @Override
    public IForm getActiveForm() {
        return this.getFromRealDesktopOrThrow(d -> d.getActiveForm());
    }

    @Override
    public IWidget getFocusedElement() {
        return this.getFromRealDesktopOrThrow(d -> d.getFocusedElement());
    }

    @Override
    public void setTrackFocus(boolean trackFocus) {
        this.forwardToRealDesktopIfAvailable(d -> d.setTrackFocus(trackFocus));
    }

    @Override
    public boolean isTrackFocus() {
        return this.getFromRealDesktopOrElse(d -> d.isTrackFocus(), false);
    }

    @Override
    public void addAddOn(Object addOn) {
        this.forwardToRealDesktopOrThrow(d -> d.addAddOn(addOn));
    }

    @Override
    public void removeAddOn(Object addOn) {
        this.forwardToRealDesktopOrThrow(d -> d.removeAddOn(addOn));
    }

    @Override
    public Collection<Object> getAddOns() {
        return this.getFromRealDesktopOrThrow(d -> d.getAddOns());
    }

    @Override
    public <T> T getAddOn(Class<T> addOnClass) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.getAddOn(addOnClass));
    }

    @Override
    public boolean isOutlineChanging() {
        return this.getFromRealDesktopOrThrow(d -> d.isOutlineChanging());
    }

    @Override
    public String getDisplayStyle() {
        return this.getFromRealDesktopOrElse(d -> d.getDisplayStyle(), "default");
    }

    @Override
    public void setDisplayStyle(String displayStyle) {
        this.forwardToRealDesktopIfAvailable(d -> d.setDisplayStyle(displayStyle));
    }

    @Override
    public String getLogoId() {
        return this.getFromRealDesktopOrElse(d -> d.getLogoId(), null);
    }

    @Override
    public void setLogoId(String id) {
        this.forwardToRealDesktopIfAvailable(d -> d.setLogoId(id));
    }

    @Override
    public boolean isCacheSplitterPosition() {
        return this.getFromRealDesktopOrElse(d -> d.isCacheSplitterPosition(), false);
    }

    @Override
    public void setCacheSplitterPosition(boolean b) {
        this.forwardToRealDesktopIfAvailable(d -> d.setCacheSplitterPosition(b));
    }

    @Override
    public String getTheme() {
        return this.getFromRealDesktopOrElse(d -> d.getTheme(), null);
    }

    @Override
    public void setTheme(String theme) {
        this.forwardToRealDesktopIfAvailable(d -> d.setTheme(theme));
    }

    @Override
    public NativeNotificationDefaults getNativeNotificationDefaults() {
        return this.getFromRealDesktopOrElse(d -> d.getNativeNotificationDefaults(), null);
    }

    @Override
    public void reloadPageFromRoot(IPage<?> page) {
        this.forwardToRealDesktopIfAvailable(d -> d.reloadPageFromRoot(page));
    }

    @Override
    public void setNativeNotificationDefaults(NativeNotificationDefaults nativeNotificationDefaults) {
        this.forwardToRealDesktopIfAvailable(d -> d.setNativeNotificationDefaults(nativeNotificationDefaults));
    }

    @Override
    public BrowserHistoryEntry getBrowserHistoryEntry() {
        return this.getFromRealDesktopOrElse(d -> d.getBrowserHistoryEntry(), null);
    }

    @Override
    public void setBrowserHistoryEntry(BrowserHistoryEntry browserHistory) {
        this.forwardToRealDesktopIfAvailable(d -> d.setBrowserHistoryEntry(browserHistory));
    }

    @Override
    public void setNavigationVisible(boolean visible) {
        this.forwardToRealDesktopIfAvailable(d -> d.setNavigationVisible(visible));
    }

    @Override
    public boolean isNavigationVisible() {
        return this.getFromRealDesktopOrElse(d -> d.isNavigationVisible(), false);
    }

    @Override
    public void setBenchVisible(boolean visible) {
        this.forwardToRealDesktopIfAvailable(d -> d.setBenchVisible(visible));
    }

    @Override
    public boolean isBenchVisible() {
        return this.getFromRealDesktopOrElse(d -> d.isBenchVisible(), false);
    }

    @Override
    public BenchLayoutData getBenchLayoutData() {
        return this.getFromRealDesktopOrElse(d -> d.getBenchLayoutData(), null);
    }

    @Override
    public void setBenchLayoutData(BenchLayoutData layoutData) {
        this.forwardToRealDesktopIfAvailable(d -> d.setBenchLayoutData(layoutData));
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        this.forwardToRealDesktopIfAvailable(d -> d.setHeaderVisible(visible));
    }

    @Override
    public boolean isHeaderVisible() {
        return this.getFromRealDesktopOrElse(d -> d.isHeaderVisible(), false);
    }

    @Override
    public void setNavigationHandleVisible(boolean visible) {
        this.forwardToRealDesktopIfAvailable(d -> d.setNavigationHandleVisible(visible));
    }

    @Override
    public boolean isNavigationHandleVisible() {
        return this.getFromRealDesktopOrElse(d -> d.isNavigationHandleVisible(), false);
    }

    @Override
    public boolean isInBackground() {
        return this.getFromRealDesktopOrElse(d -> d.isInBackground(), false);
    }

    @Override
    public IEventHistory<DesktopEvent> getEventHistory() {
        return this.getFromRealDesktopOrElse(d -> d.getEventHistory(), null);
    }

    @Override
    public boolean isGeolocationServiceAvailable() {
        return this.getFromRealDesktopOrElse(d -> d.isGeolocationServiceAvailable(), false);
    }

    @Override
    public void setGeolocationServiceAvailable(boolean available) {
        this.forwardToRealDesktopIfAvailable(d -> d.setGeolocationServiceAvailable(available));
    }

    @Override
    public PropertyMap getStartupRequestParams() {
        return this.getFromRealDesktopOrElse(d -> d.getStartupRequestParams(), null);
    }

    @Override
    public String getStartupUrl() {
        return this.getFromRealDesktopOrElse(d -> d.getStartupUrl(), null);
    }

    @Override
    public <VALUE> VALUE getStartupRequestParam(String propertyName) {
        return this.getFromRealDesktopOrElse(d -> d.getStartupRequestParam(propertyName), null);
    }

    @Override
    public Future<Coordinates> requestGeolocation() {
        return this.getFromRealDesktopOrThrow(d -> d.requestGeolocation());
    }

    @Override
    public void setLogoActionEnabled(boolean logoActionEnabled) {
        this.forwardToRealDesktopIfAvailable(d -> d.setLogoActionEnabled(logoActionEnabled));
    }

    @Override
    public boolean isLogoActionEnabled() {
        return this.getFromRealDesktopOrElse(d -> d.isLogoActionEnabled(), false);
    }

    @Override
    public boolean cancelForms(Set<IForm> formSet) {
        return this.getFromRealDesktopOrThrow(d -> d.cancelForms(formSet));
    }

    @Override
    public boolean cancelForms(Set<IForm> formSet, boolean alwaysShowUnsavedChangesForm) {
        return this.getFromRealDesktopOrThrow(d -> d.cancelForms(formSet, alwaysShowUnsavedChangesForm));
    }

    @Override
    public void closeForms(Set<IForm> formSet) {
        this.forwardToRealDesktopIfAvailable(d -> d.closeForms(formSet));
    }

    @Override
    public Object getProperty(String name) {
        return this.getFromRealDesktopOrElse(d -> d.getProperty(name), null);
    }

    @Override
    public boolean setProperty(String name, Object value) {
        return this.getFromRealDesktopOrElse(d -> d.setProperty(name, value), false);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.getFromRealDesktopOrElse(d -> d.hasProperty(name), false);
    }

    @Override
    public <T extends IWidget> T getWidgetByClass(Class<T> widgetClassToFind) {
        return (T)this.getFromRealDesktopOrThrow(d -> d.getWidgetByClass(widgetClassToFind));
    }

    @Override
    public void setDense(boolean dense) {
        this.forwardToRealDesktopIfAvailable(d -> d.setDense(dense));
    }

    @Override
    public boolean isDense() {
        return this.getFromRealDesktopOrElse(d -> d.isDense(), false);
    }

    @Override
    public boolean isLoading() {
        return this.getFromRealDesktopOrElse(d -> d.isLoading(), false);
    }

    @Override
    public void setLoading(boolean loading) {
        this.forwardToRealDesktopIfAvailable(d -> d.setLoading(loading));
    }

    @Override
    public boolean isEnabled() {
        return this.getFromRealDesktopOrElse(d -> d.isEnabled(), false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabled(enabled));
    }

    @Override
    public void setEnabledPermission(Permission permission) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabledPermission(permission));
    }

    @Override
    public boolean isEnabledGranted() {
        return this.getFromRealDesktopOrElse(d -> d.isEnabledGranted(), false);
    }

    @Override
    public void setEnabledGranted(boolean enabledGranted) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabledGranted(enabledGranted));
    }

    public void setEnabled(boolean enabled, String dimension) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabled(enabled, dimension));
    }

    public boolean isEnabled(String dimension) {
        return this.getFromRealDesktopOrElse(d -> d.isEnabled(dimension), false);
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabled(enabled, updateParents));
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents, boolean updateChildren) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabled(enabled, updateParents, updateChildren));
    }

    @Override
    public void setEnabledGranted(boolean enabled, boolean updateParents) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabledGranted(enabled, updateParents));
    }

    @Override
    public void setEnabledGranted(boolean enabled, boolean updateParents, boolean updateChildren) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabledGranted(enabled, updateParents, updateChildren));
    }

    @Override
    public boolean isEnabled(Predicate<String> filter) {
        return this.getFromRealDesktopOrElse(d -> d.isEnabled(filter), false);
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents, String dimension) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabled(enabled, updateParents, dimension));
    }

    @Override
    public void setEnabled(boolean enabled, boolean updateParents, boolean updateChildren, String dimension) {
        this.forwardToRealDesktopIfAvailable(d -> d.setEnabled(enabled, updateParents, updateChildren, dimension));
    }

    @Override
    public IWidget getParent() {
        return this.getFromRealDesktopOrElse(d -> d.getParent(), null);
    }

    @Override
    public boolean setParentInternal(IWidget w) {
        return this.getFromRealDesktopOrElse(d -> d.setParentInternal(w), false);
    }

    @Override
    public boolean isEnabledIncludingParents() {
        return this.getFromRealDesktopOrElse(d -> d.isEnabledIncludingParents(), false);
    }

    @Override
    public boolean visitParents(Consumer<IWidget> visitor) {
        return this.getFromRealDesktopOrElse(d -> d.visitParents(visitor), false);
    }

    @Override
    public <T extends IWidget> boolean visitParents(Consumer<T> visitor, Class<T> typeFilter) {
        return this.getFromRealDesktopOrElse(d -> d.visitParents(visitor, typeFilter), false);
    }

    @Override
    public boolean visitParents(Predicate<IWidget> visitor) {
        return this.getFromRealDesktopOrElse(d -> d.visitParents(visitor), false);
    }

    @Override
    public <T extends IWidget> boolean visitParents(Predicate<T> visitor, Class<T> typeFilter) {
        return this.getFromRealDesktopOrElse(d -> d.visitParents(visitor, typeFilter), false);
    }

    @Override
    public <T extends IWidget> T getParentOfType(Class<T> type) {
        return (T)((IWidget)this.getFromRealDesktopOrElse(d -> d.getParentOfType(type), null));
    }

    public String classId() {
        return this.getFromRealDesktopOrElse(d -> d.classId(), null);
    }

    @Override
    public boolean isInheritAccessibility() {
        return this.getFromRealDesktopOrElse(d -> d.isInheritAccessibility(), false);
    }

    @Override
    public void setInheritAccessibility(boolean inheritAccessibility) {
        this.forwardToRealDesktopIfAvailable(d -> d.setInheritAccessibility(inheritAccessibility));
    }

    @Override
    public void scrollToTop() {
        this.forwardToRealDesktopIfAvailable(d -> d.scrollToTop());
    }

    @Override
    public void scrollToTop(ScrollOptions options) {
        this.forwardToRealDesktopIfAvailable(d -> d.scrollToTop(options));
    }

    @Override
    public void reveal() {
        this.forwardToRealDesktopIfAvailable(d -> d.reveal());
    }

    @Override
    public void reveal(ScrollOptions options) {
        this.forwardToRealDesktopIfAvailable(d -> d.reveal(options));
    }
}

