/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.client.ClientConfigProperties;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElements;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.IUiCallbackHandler;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.IUiCallbacksUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.UiCallback;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.UiCallbackAwaitInput;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.UiCallbackEvent;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.UiCallbackInput;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.IgnoreBean;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.event.EventSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class UiCallbacks
extends AbstractPropertyObserver {
    private static final Logger LOG = LoggerFactory.getLogger(UiCallbacks.class);
    protected final Map<String, Collection<P_UiCallback<?>>> m_pendingUiCallbacks = new HashMap();
    protected final EventSupport<UiCallbackEvent> m_eventSupport = new EventSupport();
    protected final IUiCallbacksUIFacade m_uiFacade = this.createUIFacade();
    protected final Map<String, UiCallbackEvent> m_eventBuffer = new HashMap<String, UiCallbackEvent>();

    protected UiCallbacks() {
        IDesktop desktop = IDesktop.CURRENT.get();
        desktop.addPropertyChangeListener("ready", e -> this.onDesktopReadyChanged((Boolean)e.getOldValue(), (Boolean)e.getNewValue()));
        desktop.addDesktopListener(e -> this.onDesktopClosed(), 100);
    }

    public static UiCallbacks get() {
        IDesktop desktop = IDesktop.CURRENT.get();
        if (desktop == null) {
            return null;
        }
        return desktop.getAddOn(UiCallbacks.class);
    }

    public static <RESULT> RESULT await(Future<RESULT> future, UiCallbackAwaitInput input) {
        return UiCallbacks.get().waitFor(future, input);
    }

    public static UiCallbackInput newInput() {
        return (UiCallbackInput)BEANS.get(UiCallbackInput.class);
    }

    public static UiCallbackAwaitInput newAwaitInput() {
        return (UiCallbackAwaitInput)BEANS.get(UiCallbackAwaitInput.class);
    }

    public <RESULT> Future<RESULT> send(IWidget owner, String jsHandlerObjectType) {
        return this.send(owner, jsHandlerObjectType, null);
    }

    public <RESULT> Future<RESULT> send(IWidget owner, String jsHandlerObjectType, UiCallbackInput input) {
        return this.send(owner, new DefaultUiCallbackHandler(jsHandlerObjectType), input);
    }

    public <RESULT> Future<RESULT> send(IWidget owner, IUiCallbackHandler<?, RESULT> handler) {
        return this.send(owner, handler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <RESULT> Future<RESULT> send(IWidget owner, IUiCallbackHandler<?, RESULT> handler, UiCallbackInput input) {
        P_UiCallback<RESULT> callback;
        boolean isNewId;
        ModelJobs.assertModelThread();
        Assertions.assertNotNull((Object)owner);
        Assertions.assertNotNull(handler);
        input = (UiCallbackInput)ObjectUtility.nvlOpt((Object)input, UiCallbacks::newInput);
        String callbackId = input.getCallbackId();
        if (StringUtility.isNullOrEmpty((CharSequence)callbackId)) {
            callbackId = UUID.randomUUID().toString();
        }
        Map<String, Collection<P_UiCallback<?>>> map = this.m_pendingUiCallbacks;
        synchronized (map) {
            isNewId = !this.m_pendingUiCallbacks.containsKey(callbackId);
            callback = this.registerCallback(owner, handler, callbackId);
        }
        if (isNewId) {
            this.fireUiCallbackEvent(callback, owner, input.getData(), input.getContextElements());
        }
        return callback;
    }

    protected <T> P_UiCallback<T> registerCallback(IWidget owner, IUiCallbackHandler<?, T> handler, String callbackId) {
        P_UiCallback<T> uiCallback = new P_UiCallback<T>(owner, handler, callbackId);
        this.m_pendingUiCallbacks.computeIfAbsent(callbackId, id -> new ArrayList()).add(uiCallback);
        return uiCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<P_UiCallback<?>> getCallbacksInternal(Predicate<P_UiCallback<?>> filter) {
        Map<String, Collection<P_UiCallback<?>>> map = this.m_pendingUiCallbacks;
        synchronized (map) {
            Stream<Object> callbackStream = this.m_pendingUiCallbacks.values().stream().flatMap(Collection::stream);
            if (filter != null) {
                callbackStream = callbackStream.filter(filter);
            }
            return callbackStream.collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<P_UiCallback<?>> getCallbacksInternal(String callbackId) {
        Map<String, Collection<P_UiCallback<?>>> map = this.m_pendingUiCallbacks;
        synchronized (map) {
            Collection<P_UiCallback<?>> callbacks = this.m_pendingUiCallbacks.get(callbackId);
            if (CollectionUtility.isEmpty(callbacks)) {
                return Collections.emptyList();
            }
            return new ArrayList(callbacks);
        }
    }

    public List<Future<?>> getCallbacks(String callbackId) {
        return Collections.unmodifiableList(this.getCallbacksInternal(callbackId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCallback(P_UiCallback<?> callback) {
        Map<String, Collection<P_UiCallback<?>>> map = this.m_pendingUiCallbacks;
        synchronized (map) {
            String callbackId = callback.m_id;
            Collection<P_UiCallback<?>> callbacks = this.m_pendingUiCallbacks.get(callbackId);
            if (callbacks == null) {
                return;
            }
            callbacks.removeIf(o -> o.equals(callback));
            if (callbacks.isEmpty()) {
                this.m_pendingUiCallbacks.remove(callbackId);
                this.m_eventBuffer.remove(callbackId);
            }
        }
    }

    public EventSupport<UiCallbackEvent> getEventSupport() {
        return this.m_eventSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <R> void fireUiCallbackEvent(P_UiCallback<R> callback, IWidget owner, IDoEntity data, HybridActionContextElements contextElements) {
        UiCallbackEvent event = new UiCallbackEvent((Object)this, callback.m_id, callback.m_handler.uiCallbackHandlerObjectType(), owner, data, contextElements);
        if (IDesktop.CURRENT.get().isReady()) {
            this.sendUiCallbackEvent(event);
        } else {
            Map<String, Collection<P_UiCallback<?>>> map = this.m_pendingUiCallbacks;
            synchronized (map) {
                this.m_eventBuffer.put(callback.m_id, event);
            }
        }
    }

    protected void sendUiCallbackEvent(UiCallbackEvent event) {
        this.getEventSupport().fireEvent((EventObject)event);
    }

    protected void onDesktopClosed() {
        this.cancelAllUiCallbacks(true);
    }

    protected void onDesktopReadyChanged(boolean wasReady, boolean isNowReady) {
        if (!wasReady && isNowReady) {
            this.consumeEventBuffer().forEach(this::sendUiCallbackEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<UiCallbackEvent> consumeEventBuffer() {
        Map<String, Collection<P_UiCallback<?>>> map = this.m_pendingUiCallbacks;
        synchronized (map) {
            if (this.m_eventBuffer.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<UiCallbackEvent> events = new ArrayList<UiCallbackEvent>(this.m_eventBuffer.values());
            this.m_eventBuffer.clear();
            return events;
        }
    }

    protected void fireCallbackDone(String callbackId, Object data, HybridActionContextElements contextElements) {
        this.getCallbacksInternal(callbackId).forEach(callback -> this.fireCallbackDone((P_UiCallback)callback, (Object)data, contextElements));
    }

    protected <DATA, RESULT> void fireCallbackDone(P_UiCallback<RESULT> callback, DATA data, HybridActionContextElements contextElements) {
        Pair result;
        try {
            IUiCallbackHandler handler = callback.m_handler;
            result = handler.onCallbackDone(data, contextElements);
        }
        catch (Exception e) {
            result = ImmutablePair.of(null, (Object)e);
        }
        this.finishCallback(callback, result.getLeft(), (Throwable)result.getRight());
    }

    protected void fireCallbackFailed(String callbackId, String message, String code) {
        ProcessingException t = new ProcessingException(StringUtility.hasText((CharSequence)message) ? message : "Error in UiCallback handler.", new Object[0]);
        if (StringUtility.hasText((CharSequence)code)) {
            t.withContextInfo("code", (Object)code, new Object[0]);
        }
        this.getCallbacksInternal(callbackId).forEach(callback -> this.fireCallbackFailed((P_UiCallback)callback, t, message, code));
    }

    protected <RESULT> void fireCallbackFailed(P_UiCallback<RESULT> callback, ProcessingException exception, String message, String code) {
        Pair result;
        try {
            IUiCallbackHandler handler = callback.m_handler;
            result = handler.onCallbackFailed(exception, message, code);
        }
        catch (Exception e) {
            result = ImmutablePair.of(null, (Object)e);
        }
        this.finishCallback(callback, result.getLeft(), (Throwable)result.getRight());
    }

    protected <RESULT> void finishCallback(UiCallback<RESULT> callback, RESULT result, Throwable exception) {
        if (exception != null) {
            callback.failed(exception);
        } else {
            callback.done(result);
        }
    }

    protected <RESULT> RESULT waitFor(Future<RESULT> future, UiCallbackAwaitInput input) {
        ModelJobs.assertModelThread();
        Assertions.assertNotNull(future);
        input = (UiCallbackAwaitInput)ObjectUtility.nvlOpt((Object)input, UiCallbacks::newAwaitInput);
        ClientConfigProperties.DefaultUiCallbackTimeoutMillisProperty timeoutProperty = (ClientConfigProperties.DefaultUiCallbackTimeoutMillisProperty)((Object)BEANS.get(ClientConfigProperties.DefaultUiCallbackTimeoutMillisProperty.class));
        long timeoutInMillis = NumberUtility.nvl((Long)((Long)ObjectUtility.nvlOpt((Object)input.getTimeoutInMillis(), () -> (Long)timeoutProperty.getValue())), (long)0L);
        try {
            return timeoutInMillis <= 0L ? future.get() : future.get(timeoutInMillis, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (e instanceof TimeoutException) {
                if (input.getTimeoutInMillis() == null) {
                    LOG.warn("UI callback{} timed out after {} ms. The timeout can be increased by adjusting the config property '{}'.", new Object[]{StringUtility.box((String)" '", (String)input.getName(), (String)"'"), timeoutInMillis, timeoutProperty.getKey(), e});
                } else {
                    LOG.warn("UI callback{} timed out after {} ms.", new Object[]{StringUtility.box((String)" '", (String)input.getName(), (String)"'"), timeoutInMillis, e});
                }
            } else {
                LOG.warn("Unexpected error while waiting for UI callback{}.", (Object)StringUtility.box((String)" '", (String)input.getName(), (String)"'"), (Object)e);
            }
            throw input.getExceptionTranslator() != null ? (RuntimeException)input.getExceptionTranslator().translate((Throwable)e) : ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    public void cancelUiCallbacks(String callbackId, boolean mayInterruptIfRunning) {
        this.getCallbacksInternal(callbackId).forEach(callback -> {
            boolean bl2 = callback.cancel(mayInterruptIfRunning);
        });
    }

    public void cancelAllUiCallbacks(boolean mayInterruptIfRunning) {
        this.getCallbacksInternal((Predicate<P_UiCallback<?>>)null).forEach(callback -> this.cancelCallback((UiCallback<?>)callback, mayInterruptIfRunning));
    }

    protected void cancelCallback(UiCallback<?> callback, boolean mayInterruptIfRunning) {
        try {
            callback.cancel(mayInterruptIfRunning);
        }
        catch (RuntimeException | PlatformError e) {
            LOG.error("Exception while closing UI callback.", e);
        }
    }

    protected IUiCallbacksUIFacade createUIFacade() {
        return ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent());
    }

    public IUiCallbacksUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @IgnoreBean
    public static class DefaultUiCallbackHandler<T>
    implements IUiCallbackHandler<T, T> {
        private final String m_uiCallbackHandlerObjectType;

        public DefaultUiCallbackHandler(String uiCallbackHandlerObjectType) {
            this.m_uiCallbackHandlerObjectType = uiCallbackHandlerObjectType;
        }

        @Override
        public String uiCallbackHandlerObjectType() {
            return this.m_uiCallbackHandlerObjectType;
        }

        @Override
        public Pair<T, ? extends Throwable> onCallbackDone(T data, HybridActionContextElements contextElements) {
            return ImmutablePair.of(data, null);
        }
    }

    protected static class P_OwnerDisposeListener
    implements PropertyChangeListener {
        private final P_UiCallback<?> m_callback;

        public P_OwnerDisposeListener(P_UiCallback<?> callback) {
            this.m_callback = callback;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean isDisposed = (Boolean)evt.getNewValue();
            boolean wasDisposed = (Boolean)evt.getOldValue();
            if (isDisposed && !wasDisposed) {
                this.m_callback.cancel(true);
            }
        }
    }

    protected class P_UIFacade
    implements IUiCallbacksUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void fireCallbackDoneFromUI(String callbackId, Object data, HybridActionContextElements contextElements) {
            UiCallbacks.this.fireCallbackDone(callbackId, data, contextElements);
        }

        @Override
        public void fireCallbackFailedFromUI(String callbackId, String message, String code) {
            UiCallbacks.this.fireCallbackFailed(callbackId, message, code);
        }
    }

    protected class P_UiCallback<T>
    extends UiCallback<T> {
        private final String m_id;
        private final IUiCallbackHandler<?, T> m_handler;
        private final IWidget m_owner;
        private final P_OwnerDisposeListener m_ownerDisposeListener;

        public P_UiCallback(IWidget owner, IUiCallbackHandler<?, T> handler, String id) {
            this.m_id = id;
            this.m_handler = handler;
            this.m_owner = owner;
            this.m_ownerDisposeListener = new P_OwnerDisposeListener(this);
            owner.addPropertyChangeListener("disposeDone", this.m_ownerDisposeListener);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.dispose();
            return super.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean done(T result) {
            this.dispose();
            return super.done(result);
        }

        @Override
        public boolean failed(Throwable t) {
            this.dispose();
            return super.failed(t);
        }

        public void dispose() {
            this.m_owner.removePropertyChangeListener("disposeDone", this.m_ownerDisposeListener);
            UiCallbacks.this.removeCallback(this);
        }
    }
}

