/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback;

import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.scout.rt.platform.job.IBlockingCondition;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.concurrent.TimedOutError;

public class UiCallback<T>
implements Future<T> {
    private volatile boolean m_cancelled = false;
    private volatile boolean m_done = false;
    private volatile T m_result;
    private volatile ExecutionException m_failure;
    private final IBlockingCondition m_blockingCondition = Jobs.newBlockingCondition((boolean)true);

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean hasBeenCancelled;
        boolean alreadyCancelled = this.m_cancelled;
        this.m_cancelled = !this.m_done;
        boolean bl = hasBeenCancelled = !alreadyCancelled && this.m_cancelled;
        if (hasBeenCancelled) {
            this.m_blockingCondition.setBlocking(false);
        }
        return hasBeenCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.m_cancelled;
    }

    @Override
    public boolean isDone() {
        return this.m_done;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException, CancellationException {
        this.m_blockingCondition.waitFor(new String[]{"ui.interaction.required"});
        return this.report();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException, CancellationException {
        try {
            this.m_blockingCondition.waitFor(timeout, unit, new String[]{"ui.interaction.required"});
        }
        catch (TimedOutError t) {
            this.timedOut();
            throw new TimeoutException("UiCallback timed out after " + timeout + " " + unit.toString().toLowerCase(Locale.US) + ".");
        }
        return this.report();
    }

    protected void timedOut() {
    }

    public boolean done(T result) {
        if (this.m_cancelled || this.m_done) {
            return false;
        }
        this.m_done = true;
        this.m_result = result;
        this.m_blockingCondition.setBlocking(false);
        return true;
    }

    public boolean failed(Throwable t) {
        if (this.m_cancelled || this.m_done) {
            return false;
        }
        this.m_done = true;
        this.m_failure = new ExecutionException(t);
        this.m_blockingCondition.setBlocking(false);
        return true;
    }

    protected T report() throws InterruptedException, ExecutionException, CancellationException {
        if (this.m_cancelled) {
            throw new CancellationException();
        }
        if (!this.m_done) {
            throw new InterruptedException();
        }
        if (this.m_failure != null) {
            throw this.m_failure;
        }
        return this.m_result;
    }
}

