/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElements;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionType;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridEvent;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridEventListener;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.IHybridAction;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.IHybridManagerUIFacade;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.reflect.AbstractPropertyObserver;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StreamUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;

@Bean
public class HybridManager
extends AbstractPropertyObserver {
    public static final String PROP_WIDGETS = "widgets";
    private final IHybridManagerUIFacade m_uiFacade;
    private final P_WidgetDisposeListener m_widgetDisposeListener;
    private final FastListenerList<HybridEventListener> m_listeners = new FastListenerList();
    private Map<String, Class<? extends IHybridAction>> m_hybridActionMap = null;

    public HybridManager() {
        this.m_uiFacade = this.createUIFacade();
        this.m_widgetDisposeListener = this.createWidgetDisposeListener();
        this.setWidgetsInternal(Collections.emptyMap());
    }

    public static HybridManager get() {
        return IDesktop.CURRENT.get().getAddOn(HybridManager.class);
    }

    public void clear() {
        this.clearWidgets();
    }

    public void clearWidgets() {
        Collection widgets = this.getWidgets().values().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        this.setWidgetsInternal(Collections.emptyMap());
        widgets.forEach(this::disposeWidget);
    }

    protected void disposeWidget(IWidget widget) {
        if (widget == null) {
            return;
        }
        if (widget instanceof IForm) {
            ((IForm)widget).doClose();
        } else if (widget instanceof IFileChooser) {
            ((IFileChooser)widget).doClose();
        } else if (widget instanceof IMessageBox) {
            ((IMessageBox)widget).doClose();
        } else {
            widget.dispose();
        }
    }

    public void addWidget(String id, IWidget widget) {
        this.addWidgets(Collections.singletonMap(id, widget));
    }

    public void addWidgets(Map<String, IWidget> widgets) {
        HashMap<String, IWidget> result = new HashMap<String, IWidget>(this.getWidgets());
        widgets.forEach((id, widget) -> {
            if (widget == null) {
                throw new IllegalArgumentException("Widget for id '" + id + "' is null.");
            }
            IWidget previousWidget = result.put((String)id, (IWidget)widget);
            if (previousWidget != null && previousWidget != widget) {
                throw new IllegalArgumentException("Widget for id '" + id + "' already exists.");
            }
        });
        this.setWidgetsInternal(result);
    }

    public void removeWidgetById(String id) {
        this.removeWidgetsById(List.of(id));
    }

    public void removeWidgetsById(Collection<String> ids) {
        HashMap<String, IWidget> result = new HashMap<String, IWidget>(this.getWidgets());
        ids.forEach(result::remove);
        this.setWidgetsInternal(result);
    }

    public void removeWidget(IWidget widget) {
        this.removeWidgets(List.of(widget));
    }

    public void removeWidgets(Collection<IWidget> widgets) {
        this.setWidgetsInternal(this.getWidgets().entrySet().stream().filter(entry -> !widgets.contains(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    protected void setWidgetsInternal(Map<String, IWidget> widgets) {
        this.disarmWidgetDisposeListeners();
        this.propertySupport.setProperty(PROP_WIDGETS, widgets);
        this.armWidgetDisposeListeners();
    }

    protected void disarmWidgetDisposeListeners() {
        this.getWidgets().values().stream().filter(Objects::nonNull).forEach(this::disarmWidgetDisposeListener);
    }

    protected void disarmWidgetDisposeListener(IWidget widget) {
        widget.removePropertyChangeListener("disposeDone", this.getWidgetDisposeListener());
    }

    protected void armWidgetDisposeListeners() {
        this.getWidgets().values().stream().filter(Objects::nonNull).forEach(this::armWidgetDisposeListener);
    }

    protected void armWidgetDisposeListener(IWidget widget) {
        widget.addPropertyChangeListener("disposeDone", this.getWidgetDisposeListener());
    }

    protected String getWidgetId(IWidget widget) {
        return this.getWidgets().entrySet().stream().filter(entry -> ObjectUtility.equals((Object)((IWidget)entry.getValue()), (Object)widget)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    public IWidget getWidgetById(String id) {
        return this.getWidgets().get(id);
    }

    public Map<String, IWidget> getWidgets() {
        return Collections.unmodifiableMap((Map)ObjectUtility.nvl(this.getWidgetsInternal(), Collections.emptyMap()));
    }

    protected Map<String, IWidget> getWidgetsInternal() {
        return (Map)this.propertySupport.getProperty(PROP_WIDGETS, Map.class);
    }

    public void addHybridEventListener(HybridEventListener listener) {
        this.m_listeners.add((Object)listener);
    }

    public void removeHybridEventListener(HybridEventListener listener) {
        this.m_listeners.remove((Object)listener);
    }

    protected void fireHybridEvent(HybridEvent event) {
        this.m_listeners.list().forEach(listener -> listener.handle(event));
    }

    public void fireHybridEvent(String id, String eventType) {
        this.fireHybridEvent(id, eventType, null, null);
    }

    public void fireHybridEvent(String id, String eventType, IDoEntity data) {
        this.fireHybridEvent(id, eventType, data, null);
    }

    public void fireHybridEvent(String id, String eventType, HybridActionContextElements contextElements) {
        this.fireHybridEvent(id, eventType, null, contextElements);
    }

    public void fireHybridEvent(String id, String eventType, IDoEntity data, HybridActionContextElements contextElements) {
        this.fireHybridEvent(HybridEvent.createHybridEvent((Object)this, id, eventType, data, contextElements));
    }

    public void fireHybridActionEndEvent(String id) {
        this.fireHybridActionEndEvent(id, null, null);
    }

    public void fireHybridActionEndEvent(String id, IDoEntity data) {
        this.fireHybridActionEndEvent(id, data, null);
    }

    public void fireHybridActionEndEvent(String id, HybridActionContextElements contextElements) {
        this.fireHybridActionEndEvent(id, null, contextElements);
    }

    public void fireHybridActionEndEvent(String id, IDoEntity data, HybridActionContextElements contextElements) {
        this.fireHybridEvent(HybridEvent.createHybridActionEndEvent((Object)this, id, data, contextElements));
    }

    public void fireHybridWidgetEvent(String id, String eventType) {
        this.fireHybridWidgetEvent(id, eventType, null);
    }

    public void fireHybridWidgetEvent(IWidget widget, String eventType) {
        this.fireHybridWidgetEvent(widget, eventType, null);
    }

    public void fireHybridWidgetEvent(String id, String eventType, IDoEntity data) {
        this.fireHybridEvent(HybridEvent.createHybridWidgetEvent((Object)this, id, eventType, data));
    }

    public void fireHybridWidgetEvent(IWidget widget, String eventType, IDoEntity data) {
        this.fireHybridWidgetEvent(this.getWidgetId(widget), eventType, data);
    }

    private void handleHybridAction(String id, String actionType, IDoEntity data, HybridActionContextElements contextElements) {
        if (this.m_hybridActionMap == null) {
            this.m_hybridActionMap = (Map)BEANS.getBeanManager().getBeans(IHybridAction.class).stream().filter(bean -> bean.hasAnnotation(HybridActionType.class)).collect(StreamUtility.toMap(TreeMap::new, bean -> ((HybridActionType)bean.getBeanAnnotation(HybridActionType.class)).value(), IBean::getBeanClazz));
        }
        Optional.ofNullable(this.m_hybridActionMap.get(actionType)).map(BEANS::get).ifPresent(hybridAction -> hybridAction.execute(id, data, contextElements));
    }

    public IHybridManagerUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    protected P_UIFacade createUIFacade() {
        return new P_UIFacade();
    }

    protected P_WidgetDisposeListener getWidgetDisposeListener() {
        return this.m_widgetDisposeListener;
    }

    protected P_WidgetDisposeListener createWidgetDisposeListener() {
        return new P_WidgetDisposeListener();
    }

    protected class P_UIFacade
    implements IHybridManagerUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void handleHybridActionFromUI(String id, String actionType, IDoEntity data, HybridActionContextElements contextElements) {
            HybridManager.this.handleHybridAction(id, actionType, data, contextElements);
        }
    }

    protected class P_WidgetDisposeListener
    implements PropertyChangeListener {
        protected P_WidgetDisposeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("disposeDone".equals(event.getPropertyName()) && event.getSource() instanceof IWidget) {
                HybridManager.this.removeWidget((IWidget)event.getSource());
            }
        }
    }
}

