/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid;

import java.util.EventObject;
import java.util.Objects;
import org.eclipse.scout.rt.client.ui.IModelEvent;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElements;
import org.eclipse.scout.rt.dataobject.IDoEntity;

public class HybridEvent
extends EventObject
implements IModelEvent {
    private static final long serialVersionUID = 1L;
    public static final int TYPE_EVENT = 13;
    public static final int TYPE_WIDGET_EVENT = 42;
    public static final String HYBRID_ACTION_END = "hybridActionEnd";
    private final int m_type;
    private final String m_id;
    private final String m_eventType;
    private final IDoEntity m_data;
    private final HybridActionContextElements m_contextElements;

    protected HybridEvent(Object source, int type, String id, String eventType, IDoEntity data, HybridActionContextElements contextElements) {
        super(source);
        this.m_type = type;
        this.m_id = id;
        this.m_eventType = eventType;
        this.m_data = data;
        this.m_contextElements = contextElements;
    }

    public static HybridEvent createHybridEvent(Object source, String id, String eventType) {
        return HybridEvent.createHybridEvent(source, id, eventType, null, null);
    }

    public static HybridEvent createHybridEvent(Object source, String id, String eventType, IDoEntity data, HybridActionContextElements contextElements) {
        return new HybridEvent(source, 13, id, eventType, data, contextElements);
    }

    public static HybridEvent createHybridActionEndEvent(Object source, String id) {
        return HybridEvent.createHybridActionEndEvent(source, id, null, null);
    }

    public static HybridEvent createHybridActionEndEvent(Object source, String id, IDoEntity data, HybridActionContextElements contextElements) {
        return HybridEvent.createHybridEvent(source, id, HYBRID_ACTION_END, data, contextElements);
    }

    public static HybridEvent createHybridWidgetEvent(Object source, String id, String eventType) {
        return HybridEvent.createHybridWidgetEvent(source, id, eventType, null);
    }

    public static HybridEvent createHybridWidgetEvent(Object source, String id, String eventType, IDoEntity data) {
        return new HybridEvent(source, 42, id, eventType, data, null);
    }

    @Override
    public int getType() {
        return this.m_type;
    }

    public String getId() {
        return this.m_id;
    }

    public String getEventType() {
        return this.m_eventType;
    }

    public IDoEntity getData() {
        return this.m_data;
    }

    public HybridActionContextElements getContextElements() {
        return this.m_contextElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HybridEvent that = (HybridEvent)o;
        return this.m_type == that.m_type && Objects.equals(this.m_id, that.m_id) && Objects.equals(this.m_eventType, that.m_eventType) && Objects.equals(this.m_data, that.m_data) && Objects.equals(this.m_contextElements, that.m_contextElements);
    }

    public int hashCode() {
        return Objects.hash(this.m_type, this.m_id, this.m_eventType, this.m_data, this.m_contextElements);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HybridEvent [");
        builder.append("source=").append(this.source).append(", ");
        builder.append("type=").append(this.m_type);
        if (this.m_id != null) {
            builder.append(", ").append("id=").append(this.m_id);
        }
        if (this.m_eventType != null) {
            builder.append(", ").append("eventType=").append(this.m_eventType);
        }
        if (this.m_data != null) {
            builder.append(", ").append("data=").append(this.m_data);
        }
        if (this.m_contextElements != null) {
            builder.append(", ").append("contextElements=").append(this.m_contextElements);
        }
        builder.append("]");
        return builder.toString();
    }
}

