/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElement;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@Bean
public class HybridActionContextElements {
    private final Map<String, List<HybridActionContextElement>> m_map = new LinkedHashMap<String, List<HybridActionContextElement>>();

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public Map<String, List<HybridActionContextElement>> getMap() {
        return this.m_map;
    }

    public List<HybridActionContextElement> getList(String key) {
        List<HybridActionContextElement> contextElements = this.optList(key);
        return (List)Assertions.assertNotNull(contextElements, (String)"Missing context elements with key '{}'", (Object[])new Object[]{key});
    }

    public List<HybridActionContextElement> optList(String key) {
        return this.m_map.get(key);
    }

    public HybridActionContextElement getSingle(String key) {
        HybridActionContextElement contextElement = this.optSingle(key);
        return (HybridActionContextElement)Assertions.assertNotNull((Object)contextElement, (String)"Missing context element with key '{}'", (Object[])new Object[]{key});
    }

    public HybridActionContextElement optSingle(String key) {
        return (HybridActionContextElement)CollectionUtility.firstElement(this.optList(key));
    }

    public HybridActionContextElements withMap(Map<String, List<HybridActionContextElement>> map) {
        if (map != null) {
            this.m_map.putAll(map);
        }
        return this;
    }

    public HybridActionContextElements withElements(String key, List<HybridActionContextElement> contextElements) {
        Assertions.assertNotNull((Object)key);
        Assertions.assertNotNull(contextElements);
        this.m_map.put(key, contextElements);
        return this;
    }

    public HybridActionContextElements withElement(String key, HybridActionContextElement contextElement) {
        Assertions.assertNotNull((Object)key);
        this.m_map.put(key, CollectionUtility.arrayList((Object)contextElement));
        return this;
    }

    public HybridActionContextElements withElement(String key, IWidget widget) {
        return this.withElement(key, HybridActionContextElement.of(widget));
    }

    public HybridActionContextElements withElement(String key, IWidget widget, Object element) {
        return this.withElement(key, HybridActionContextElement.of(widget, element));
    }
}

