/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid;

import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.platform.util.Assertions;

public class HybridActionContextElement {
    private final IWidget m_widget;
    private final Object m_element;

    public static HybridActionContextElement of(IWidget widget) {
        return HybridActionContextElement.of(widget, null);
    }

    public static HybridActionContextElement of(IWidget widget, Object element) {
        return new HybridActionContextElement(widget, element);
    }

    protected HybridActionContextElement(IWidget widget, Object element) {
        this.m_widget = (IWidget)Assertions.assertNotNull((Object)widget);
        this.m_element = element;
    }

    public IWidget getWidget() {
        return this.m_widget;
    }

    public <T extends IWidget> T getWidget(Class<T> widgetType) {
        return (T)((IWidget)Assertions.assertInstance((Object)this.m_widget, widgetType));
    }

    public Object getElement() {
        return this.getElement(Object.class);
    }

    public <T> T getElement(Class<T> elementType) {
        return (T)Assertions.assertInstance((Object)Assertions.assertNotNull((Object)this.m_element), elementType);
    }

    public Object optElement() {
        return this.optElement(Object.class);
    }

    public <T> T optElement(Class<T> elementType) {
        if (this.m_element == null) {
            return null;
        }
        return (T)Assertions.assertInstance((Object)this.m_element, elementType);
    }
}

