/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElement;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElements;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionType;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridManager;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.IHybridAction;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public abstract class AbstractHybridAction<DO_ENTITY extends IDoEntity>
implements IHybridAction<DO_ENTITY> {
    private final Class<DO_ENTITY> m_doEntityClass = (Class)Assertions.assertNotNull((Object)TypeCastUtility.getGenericsParameterClass(this.getClass(), IHybridAction.class));
    private String m_id;
    private HybridActionContextElements m_contextElements;
    private boolean m_initialized;

    @Override
    public Class<DO_ENTITY> getDoEntityClass() {
        return this.m_doEntityClass;
    }

    protected String getHybridActionType() {
        return this.getClass().getAnnotation(HybridActionType.class).value();
    }

    @Override
    public void init(String id, HybridActionContextElements contextElements) {
        this.m_id = id;
        this.m_contextElements = contextElements;
        this.m_initialized = true;
    }

    @Override
    public ClientRunContext createRunContext() {
        ClientRunContext runContext = ClientRunContexts.copyCurrent();
        this.prepareRunContext(runContext);
        return runContext;
    }

    protected void prepareRunContext(ClientRunContext runContext) {
        Optional.ofNullable(this.optContextElement("runcontext.outline")).map(HybridActionContextElement::getWidget).filter(IOutline.class::isInstance).map(IOutline.class::cast).or(() -> Optional.of(runContext).map(ClientRunContext::getDesktop).map(IDesktop::getOutline)).ifPresent(outline -> {
            ClientRunContext clientRunContext2 = runContext.withOutline((IOutline)outline, false);
        });
        Optional.ofNullable(this.optContextElement("runcontext.form")).map(HybridActionContextElement::getWidget).filter(IForm.class::isInstance).map(IForm.class::cast).or(() -> Optional.of(runContext).map(ClientRunContext::getDesktop).map(IDesktop::getActiveForm)).ifPresent(runContext::withForm);
    }

    protected String getId() {
        return this.m_id;
    }

    protected HybridActionContextElements getContextElements() {
        return this.m_contextElements;
    }

    protected List<HybridActionContextElement> getContextElements(String key) {
        HybridActionContextElements contextElements = (HybridActionContextElements)Assertions.assertNotNull((Object)this.m_contextElements, (String)"Missing context elements", (Object[])new Object[0]);
        return contextElements.getList(key);
    }

    protected List<HybridActionContextElement> optContextElements(String key) {
        return this.m_contextElements == null ? null : this.m_contextElements.optList(key);
    }

    protected HybridActionContextElement getContextElement(String key) {
        HybridActionContextElements contextElements = (HybridActionContextElements)Assertions.assertNotNull((Object)this.m_contextElements, (String)"Missing context elements", (Object[])new Object[0]);
        return contextElements.getSingle(key);
    }

    protected HybridActionContextElement optContextElement(String key) {
        return this.m_contextElements == null ? null : this.m_contextElements.optSingle(key);
    }

    protected boolean isInitialized() {
        return this.m_initialized;
    }

    protected void assertInitialized() {
        Assertions.assertTrue((boolean)this.isInitialized(), (String)"{} is not initialized", (Object[])new Object[]{this});
    }

    protected HybridManager hybridManager() {
        return HybridManager.get();
    }

    protected void addWidget(IWidget widget) {
        this.assertInitialized();
        this.hybridManager().addWidget(this.getId(), widget);
    }

    protected void addWidgets(Map<String, ? extends IWidget> widgets) {
        this.assertInitialized();
        this.hybridManager().addWidgets(Optional.ofNullable(widgets).orElse(Map.of()).entrySet().stream().collect(Collectors.toMap(entry -> this.getId() + (String)entry.getKey(), Map.Entry::getValue)));
    }

    protected void removeWidget() {
        this.assertInitialized();
        this.hybridManager().removeWidgetById(this.getId());
    }

    protected void removeWidgetsById(Collection<String> ids) {
        this.assertInitialized();
        this.hybridManager().removeWidgetsById(((Collection)Optional.ofNullable(ids).orElse(Collections.emptySet())).stream().map(id -> this.getId() + id).collect(Collectors.toSet()));
    }

    protected void removeWidget(IWidget widget) {
        this.hybridManager().removeWidget(widget);
    }

    protected void removeWidgets(Collection<IWidget> widgets) {
        this.hybridManager().removeWidgets(widgets);
    }

    protected void fireHybridEvent(String eventType) {
        this.assertInitialized();
        this.hybridManager().fireHybridEvent(this.getId(), eventType);
    }

    protected void fireHybridEvent(String eventType, IDoEntity data) {
        this.assertInitialized();
        this.hybridManager().fireHybridEvent(this.getId(), eventType, data);
    }

    protected void fireHybridEvent(String eventType, HybridActionContextElements contextElements) {
        this.assertInitialized();
        this.hybridManager().fireHybridEvent(this.getId(), eventType, contextElements);
    }

    protected void fireHybridEvent(String eventType, IDoEntity data, HybridActionContextElements contextElements) {
        this.assertInitialized();
        this.hybridManager().fireHybridEvent(this.getId(), eventType, data, contextElements);
    }

    protected void fireHybridActionEndEvent() {
        this.assertInitialized();
        this.hybridManager().fireHybridActionEndEvent(this.getId());
    }

    protected void fireHybridActionEndEvent(IDoEntity data) {
        this.assertInitialized();
        this.hybridManager().fireHybridActionEndEvent(this.getId(), data);
    }

    protected void fireHybridActionEndEvent(HybridActionContextElements contextElements) {
        this.assertInitialized();
        this.hybridManager().fireHybridActionEndEvent(this.getId(), contextElements);
    }

    protected void fireHybridActionEndEvent(IDoEntity data, HybridActionContextElements contextElements) {
        this.assertInitialized();
        this.hybridManager().fireHybridActionEndEvent(this.getId(), data, contextElements);
    }

    protected void fireHybridWidgetEvent(String eventType) {
        this.assertInitialized();
        this.hybridManager().fireHybridWidgetEvent(this.getId(), eventType);
    }

    protected void fireHybridWidgetEvent(String eventType, IDoEntity data) {
        this.assertInitialized();
        this.hybridManager().fireHybridWidgetEvent(this.getId(), eventType, data);
    }

    protected void fireHybridWidgetEvent(String id, String eventType) {
        this.assertInitialized();
        this.hybridManager().fireHybridWidgetEvent(this.getId() + id, eventType);
    }

    protected void fireHybridWidgetEvent(String id, String eventType, IDoEntity data) {
        this.assertInitialized();
        this.hybridManager().fireHybridWidgetEvent(this.getId() + id, eventType, data);
    }

    protected void fireHybridWidgetEvent(IWidget widget, String eventType) {
        this.hybridManager().fireHybridWidgetEvent(widget, eventType);
    }

    protected void fireHybridWidgetEvent(IWidget widget, String eventType, IDoEntity data) {
        this.hybridManager().fireHybridWidgetEvent(widget, eventType, data);
    }
}

