/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.hybrid;

import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.AbstractHybridAction;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.StringUtility;

public abstract class AbstractFormHybridAction<FORM extends IForm, DO_ENTITY extends IDoEntity>
extends AbstractHybridAction<DO_ENTITY> {
    private static final String OPEN_FORM = "scout.openForm";
    protected static final String OPEN_FORM_PREFIX = "scout.openForm:";
    private static final String CREATE_FORM = "scout.createForm";
    protected static final String CREATE_FORM_PREFIX = "scout.createForm:";

    protected boolean isShowFormOnStart() {
        return StringUtility.startsWith((String)this.getHybridActionType(), (String)OPEN_FORM);
    }

    @Override
    public void execute(DO_ENTITY data) {
        FORM form = this.createForm(data);
        this.prepareForm(form);
        this.addFormListeners(form);
        this.startForm(form);
        this.addWidget((IWidget)form);
        this.fireHybridWidgetEvent("data", (IDoEntity)this.exportResultInternal(form));
    }

    protected abstract FORM createForm(DO_ENTITY var1);

    protected void prepareForm(FORM form) {
        form.setShowOnStart(this.isShowFormOnStart());
    }

    protected void addFormListeners(FORM form) {
        form.addFormListener(e -> {
            if (2020 == e.getType()) {
                DO_ENTITY result = this.exportResultInternal(form);
                this.fireHybridWidgetEvent("save", (IDoEntity)result);
            } else if (3020 == e.getType()) {
                DO_ENTITY result = this.exportResultInternal(form);
                this.fireHybridWidgetEvent("reset", (IDoEntity)result);
            } else if (3010 == e.getType()) {
                this.fireHybridWidgetEvent("close");
            }
        }, new Integer[0]);
    }

    protected void startForm(FORM form) {
        form.start();
    }

    protected DO_ENTITY createEmptyResult() {
        if (this.getDoEntityClass() == IDoEntity.class) {
            return (DO_ENTITY)((IDoEntity)BEANS.get(DoEntity.class));
        }
        return (DO_ENTITY)((IDoEntity)BEANS.get(this.getDoEntityClass()));
    }

    protected DO_ENTITY exportResultInternal(FORM form) {
        DO_ENTITY result = this.exportResult(form);
        if (result == null) {
            result = this.createEmptyResult();
        }
        return result;
    }

    protected DO_ENTITY exportResult(FORM form) {
        DO_ENTITY result = this.createEmptyResult();
        this.exportResult(form, result);
        return result;
    }

    protected void exportResult(FORM form, DO_ENTITY result) {
    }
}

