/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.datachange;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.datachange.DataChangeEvent;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeListener;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeManager;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;

@ApplicationScoped
public class ActiveFormDataChangeManager
implements IDataChangeListener {
    protected static final String DATA_CHANGE_MANAGERS_KEY = "activeFormDataChangeManagers";

    protected Map<IForm, IDataChangeManager> getDataChangeManagers() {
        IClientSession clientSession = ClientSessionProvider.currentSession();
        HashMap dataChangeManagers = (HashMap)clientSession.getData(DATA_CHANGE_MANAGERS_KEY);
        if (dataChangeManagers == null) {
            dataChangeManagers = new HashMap();
            clientSession.setData(DATA_CHANGE_MANAGERS_KEY, dataChangeManagers);
            this.attachToDesktop(clientSession.getDesktop());
        }
        return dataChangeManagers;
    }

    protected void attachToDesktop(IDesktop desktop) {
        desktop.addPropertyChangeListener("inBackground", e -> this.onDesktopInBackground((Boolean)e.getNewValue()));
        desktop.addDesktopListener(e -> this.onFormActivate(e.getForm()), 620);
        desktop.dataChangeListeners().add(this, true, new Object[0]);
    }

    @Override
    public void dataChanged(DataChangeEvent event) {
        this.getDataChangeManagers().values().forEach(m -> m.fireEvent(event));
    }

    public void add(IForm form, IDataChangeListener listener, boolean weak, Object ... dataTypes) {
        this.getDataChangeManagers().computeIfAbsent(form, this::createDataChangeManager).add(listener, weak, dataTypes);
    }

    public void remove(IDataChangeListener listener) {
        this.getDataChangeManagers().values().forEach(m -> m.remove(listener, new Object[0]));
    }

    protected IDataChangeManager createDataChangeManager(IForm form) {
        form.addFormListener(e -> this.onFormClosed(e.getForm()), 3010);
        return (IDataChangeManager)BEANS.get(IDataChangeManager.class);
    }

    protected void onFormActivate(IForm activatedForm) {
        this.getDataChangeManagers().forEach((f, m) -> m.setBuffering(f != activatedForm));
    }

    protected void onFormClosed(IForm closedForm) {
        this.getDataChangeManagers().remove(closedForm);
    }

    protected void onDesktopInBackground(boolean inBackground) {
        if (!inBackground) {
            this.getDataChangeManagers().values().forEach(m -> m.setBuffering(true));
        }
    }
}

