/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.menu;

import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="29cd5135-9b4d-4de7-a16b-e5cea26901ef")
public class ActivateBookmarkKeyStroke
extends KeyStroke {
    private static final Logger LOG = LoggerFactory.getLogger(ActivateBookmarkKeyStroke.class);
    private final Bookmark m_bookmark;

    public ActivateBookmarkKeyStroke(Bookmark b) {
        super(b.getKeyStroke());
        this.m_bookmark = b;
        this.callInitializer();
    }

    public Bookmark getBookmark() {
        return this.m_bookmark;
    }

    @Override
    protected void execAction() {
        if (this.m_bookmark != null) {
            try {
                ClientSessionProvider.currentSession().getDesktop().activateBookmark(this.m_bookmark);
            }
            catch (Exception t) {
                LOG.error("Could not activate bookmark {}", (Object)this.m_bookmark, (Object)t);
            }
        }
    }
}

