/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.bookmark.internal;

import java.security.Permission;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceEvent;
import org.eclipse.scout.rt.client.services.common.bookmark.BookmarkServiceListener;
import org.eclipse.scout.rt.client.services.common.bookmark.IBookmarkService;
import org.eclipse.scout.rt.client.ui.desktop.bookmark.AbstractBookmarkTreeField;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.shared.security.DeleteGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.DeleteUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.ReadUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateGlobalBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;

@ClassId(value="e233756c-9f3e-40bf-918d-a869b6321af8")
public class ManageBookmarksForm
extends AbstractForm
implements BookmarkServiceListener {
    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"Bookmarks");
    }

    @Override
    public void bookmarksChanged(BookmarkServiceEvent e) {
        this.getGlobalBookmarkTreeField().setBookmarkRootFolder(e.getBookmarkService().getBookmarkData().getGlobalBookmarks());
        this.getUserBookmarkTreeField().setBookmarkRootFolder(e.getBookmarkService().getBookmarkData().getUserBookmarks());
    }

    public void startModify() {
        this.startInternal(new ModifyHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.GlobalBox getGlobalBox() {
        return this.getFieldByClass(MainBox.GlobalBox.class);
    }

    public MainBox.UserBox getUserBox() {
        return this.getFieldByClass(MainBox.UserBox.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public MainBox.UserBox.UserBookmarkTreeField getUserBookmarkTreeField() {
        return this.getFieldByClass(MainBox.UserBox.UserBookmarkTreeField.class);
    }

    public MainBox.GlobalBox.GlobalBookmarkTreeField getGlobalBookmarkTreeField() {
        return this.getFieldByClass(MainBox.GlobalBox.GlobalBookmarkTreeField.class);
    }

    @Order(value=10.0)
    @ClassId(value="2970a2e1-2461-4154-869e-f5ee3884adfc")
    public class MainBox
    extends AbstractGroupBox {

        @Order(value=50.0)
        @ClassId(value="f8d566ec-58b6-4499-b435-e43bc3bd5268")
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=11.0)
        @ClassId(value="f7849d3b-3ed1-4eec-884b-d7fa33010702")
        public class GlobalBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"GlobalBookmarks");
            }

            @Override
            protected void execInitField() {
                this.setVisiblePermission((Permission)new UpdateGlobalBookmarkPermission());
            }

            @Order(value=10.0)
            @ClassId(value="10eaebc7-785a-4dd2-91b2-0052fa20cf21")
            public class GlobalBookmarkTreeField
            extends AbstractBookmarkTreeField {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 10;
                }

                @Override
                protected Permission getDeletePermission() {
                    return new DeleteGlobalBookmarkPermission();
                }

                @Override
                protected Permission getUpdatePermission() {
                    return new UpdateGlobalBookmarkPermission();
                }
            }
        }

        @Order(value=40.0)
        @ClassId(value="57108978-7b2f-41c6-b89f-dd1558cbb935")
        public class OkButton
        extends AbstractOkButton {
        }

        @Order(value=20.0)
        @ClassId(value="ba0c7a0f-db77-42ce-90ac-86caea9f2c1e")
        public class UserBox
        extends AbstractGroupBox {
            @Override
            protected String getConfiguredLabel() {
                return TEXTS.get((String)"Bookmarks");
            }

            @Override
            protected void execInitField() {
                this.setVisiblePermission((Permission)new ReadUserBookmarkPermission());
            }

            @Order(value=10.0)
            @ClassId(value="34f55c13-dd28-41a5-a619-9ad9aa5a35ea")
            public class UserBookmarkTreeField
            extends AbstractBookmarkTreeField {
                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 10;
                }

                @Override
                protected Permission getDeletePermission() {
                    return new DeleteUserBookmarkPermission();
                }

                @Override
                protected Permission getUpdatePermission() {
                    return new UpdateUserBookmarkPermission();
                }
            }
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
        @Override
        protected void execLoad() {
            IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
            service.addBookmarkServiceListener(ManageBookmarksForm.this);
            service.loadBookmarks();
            ManageBookmarksForm.this.getGlobalBookmarkTreeField().setBookmarkRootFolder(service.getBookmarkData().getGlobalBookmarks());
            ManageBookmarksForm.this.getUserBookmarkTreeField().setBookmarkRootFolder(service.getBookmarkData().getUserBookmarks());
            ManageBookmarksForm.this.getGlobalBookmarkTreeField().populateTree();
            ManageBookmarksForm.this.getUserBookmarkTreeField().populateTree();
        }

        @Override
        protected void execPostLoad() {
            ManageBookmarksForm.this.touch();
        }

        @Override
        protected void execStore() {
            ((IBookmarkService)BEANS.get(IBookmarkService.class)).storeBookmarks();
        }

        @Override
        protected void execDiscard() {
            ((IBookmarkService)BEANS.get(IBookmarkService.class)).loadBookmarks();
        }

        @Override
        protected void execFinally() {
            IBookmarkService service = (IBookmarkService)BEANS.get(IBookmarkService.class);
            service.removeBookmarkServiceListener(ManageBookmarksForm.this);
        }
    }
}

