/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.Collection;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.OpenUriAction;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.ui.UiSystem;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

@ApplicationScoped
public class OpenUriHelper {
    public IOpenUriAction getOpenUriActionForResource(BinaryResource resource) {
        UserAgent userAgent = UserAgentUtility.getCurrentUserAgent();
        if (userAgent.getUiSystem().equals(UiSystem.IOS) && userAgent.isStandalone()) {
            return OpenUriAction.DOWNLOAD;
        }
        if (resource != null) {
            if (this.isImage(resource)) {
                return this.getOpenUriActionImage();
            }
            if (this.isVideo(resource)) {
                return this.getOpenUriActionVideo();
            }
            if (this.isHtmlPage(resource)) {
                return this.getOpenUriActionHtmlPage();
            }
            if (this.isZipArchive(resource)) {
                return this.getOpenUriActionZipArchive();
            }
            if (this.isPdf(resource)) {
                return this.getOpenUriActionPdf();
            }
        }
        return this.getOpenUriActionDefault();
    }

    protected boolean isImage(BinaryResource resource) {
        return MimeType.isOneOf((Collection)MimeType.getCommonImageTypes(), (String)resource.getContentType());
    }

    protected IOpenUriAction getOpenUriActionImage() {
        return OpenUriAction.NEW_WINDOW;
    }

    protected boolean isVideo(BinaryResource resource) {
        return MimeType.isOneOf((Collection)MimeType.getCommonVideoTypes(), (String)resource.getContentType());
    }

    protected IOpenUriAction getOpenUriActionVideo() {
        return OpenUriAction.NEW_WINDOW;
    }

    protected boolean isHtmlPage(BinaryResource resource) {
        return MimeType.isOneOf((Collection)CollectionUtility.arrayList((Object[])new MimeType[]{MimeType.HTM, MimeType.HTML}), (String)resource.getContentType());
    }

    protected IOpenUriAction getOpenUriActionHtmlPage() {
        return OpenUriAction.DOWNLOAD;
    }

    protected boolean isZipArchive(BinaryResource resource) {
        return MimeType.ZIP.equals((Object)MimeType.convertToMimeType((String)resource.getContentType()));
    }

    protected IOpenUriAction getOpenUriActionZipArchive() {
        return OpenUriAction.DOWNLOAD;
    }

    protected boolean isPdf(BinaryResource resource) {
        return MimeType.PDF.equals((Object)MimeType.convertToMimeType((String)resource.getContentType()));
    }

    protected IOpenUriAction getOpenUriActionPdf() {
        return OpenUriAction.OPEN;
    }

    protected IOpenUriAction getOpenUriActionDefault() {
        return OpenUriAction.DOWNLOAD;
    }
}

