/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.List;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.index.AbstractMultiValueIndex;
import org.eclipse.scout.rt.platform.index.IIndex;
import org.eclipse.scout.rt.platform.index.IndexedStore;

@Bean
public class MessageBoxStore
extends IndexedStore<IMessageBox> {
    private final P_DisplayParentIndex m_displayParentIndex = (P_DisplayParentIndex)this.registerIndex((IIndex)new P_DisplayParentIndex());
    private final P_ApplicationModalIndex m_applicationModalIndex = (P_ApplicationModalIndex)this.registerIndex((IIndex)new P_ApplicationModalIndex());

    public List<IMessageBox> getByDisplayParent(IDisplayParent displayParent) {
        return this.m_displayParentIndex.get(displayParent);
    }

    public boolean containsApplicationModalMessageBoxes() {
        return !this.getApplicationModalMessageBoxes().isEmpty();
    }

    public List<IMessageBox> getApplicationModalMessageBoxes() {
        return this.m_applicationModalIndex.get(Boolean.TRUE);
    }

    private class P_ApplicationModalIndex
    extends AbstractMultiValueIndex<Boolean, IMessageBox> {
        private P_ApplicationModalIndex() {
        }

        protected Boolean calculateIndexFor(IMessageBox messageBox) {
            if (messageBox.getDisplayParent() == ClientSessionProvider.currentSession().getDesktop()) {
                return true;
            }
            return false;
        }
    }

    private class P_DisplayParentIndex
    extends AbstractMultiValueIndex<IDisplayParent, IMessageBox> {
        private P_DisplayParentIndex() {
        }

        protected IDisplayParent calculateIndexFor(IMessageBox messageBox) {
            return messageBox.getDisplayParent();
        }
    }
}

