/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import org.eclipse.scout.rt.api.data.ObjectType;
import org.eclipse.scout.rt.client.ui.Coordinates;
import org.eclipse.scout.rt.client.ui.desktop.GeoLocationDo;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.HybridActionContextElements;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.IUiCallbackHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.StringUtility;

@ObjectType(value="GeoLocationUiCallbackHandler")
public class GeoLocationUiCallbackHandler
implements IUiCallbackHandler<GeoLocationDo, Coordinates> {
    @Override
    public Pair<Coordinates, ProcessingException> onCallbackDone(GeoLocationDo data, HybridActionContextElements contextElements) {
        String latitude = data.getLatitude();
        String longitude = data.getLongitude();
        if (!StringUtility.hasText((CharSequence)latitude) || !StringUtility.hasText((CharSequence)longitude)) {
            return this.geolocationFailed(null, null);
        }
        return ImmutablePair.of((Object)new Coordinates(latitude, longitude), null);
    }

    @Override
    public Pair<Coordinates, ? extends Throwable> onCallbackFailed(ProcessingException exception, String message, String code) {
        return this.geolocationFailed(message, code);
    }

    protected Pair<Coordinates, ProcessingException> geolocationFailed(String errorMessage, String errorCode) {
        IDesktop desktop = IDesktop.CURRENT.get();
        if (desktop != null) {
            desktop.setGeolocationServiceAvailable(false);
        }
        String locationFailed = TEXTS.get((String)"GeolocationFailed");
        String msg = StringUtility.hasText((CharSequence)errorMessage) ? locationFailed + ": " + errorMessage : locationFailed + ".";
        ProcessingException pe = new ProcessingException(msg, new Object[0]);
        return ImmutablePair.of(null, (Object)((Object)pe));
    }
}

