/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.ContributionCommand;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;

public abstract class AbstractDesktopExtension
implements IDesktopExtension {
    private IDesktop m_coreDesktop;

    @Override
    public ContributionCommand initDelegate() {
        return this.execInit();
    }

    @Override
    public ContributionCommand desktopOpenedDelegate() {
        return this.execOpened();
    }

    @Override
    public ContributionCommand desktopBeforeClosingDelegate() {
        return this.execBeforeClosing();
    }

    @Override
    public ContributionCommand desktopClosingDelegate() {
        return this.execClosing();
    }

    @Override
    public ContributionCommand guiAttachedDelegate() {
        return this.execGuiAttached();
    }

    @Override
    public ContributionCommand guiDetachedDelegate() {
        return this.execGuiDetached();
    }

    @Override
    public ContributionCommand outlineChangedDelegate(IOutline oldOutline, IOutline newOutline) {
        return this.execOutlineChanged(oldOutline, newOutline);
    }

    @Override
    public ContributionCommand formAboutToShowDelegate(IHolder<IForm> formHolder) {
        return this.execFormAboutToShow(formHolder);
    }

    @Override
    public ContributionCommand pageSearchFormChangedDelegate(IForm oldForm, IForm newForm) {
        return this.execPageSearchFormChanged(oldForm, newForm);
    }

    @Override
    public ContributionCommand pageDetailFormChangedDelegate(IForm oldForm, IForm newForm) {
        return this.execPageDetailFormChanged(oldForm, newForm);
    }

    @Override
    public ContributionCommand pageDetailTableChangedDelegate(ITable oldTable, ITable newTable) {
        return this.execPageDetailTableChanged(oldTable, newTable);
    }

    @Override
    public ContributionCommand tablePageLoadedDelegate(IPageWithTable<?> tablePage) {
        return this.execTablePageLoaded(tablePage);
    }

    @Override
    public void contributeOutlines(OrderedCollection<IOutline> outlines) {
        List<Class<? extends IOutline>> contributedOutlines = this.getConfiguredOutlines();
        if (contributedOutlines == null) {
            return;
        }
        for (Class<? extends IOutline> element : contributedOutlines) {
            try {
                IOutline o = element.getConstructor(new Class[0]).newInstance(new Object[0]);
                outlines.addOrdered((IOrdered)o);
            }
            catch (Exception t) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + element.getName() + "'.", new Object[]{t}));
            }
        }
    }

    @Override
    public void contributeActions(Collection<IAction> actions) {
        for (Class<? extends IAction> actionClazz : this.getConfiguredActions()) {
            actions.add((IAction)ConfigurationUtility.newInnerInstance((Object)this, actionClazz));
        }
    }

    @Override
    public IDesktop getCoreDesktop() {
        return this.m_coreDesktop;
    }

    @Override
    public void setCoreDesktop(IDesktop desktop) {
        this.m_coreDesktop = desktop;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected ContributionCommand execInit() {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=12.0)
    protected ContributionCommand execOpened() {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=14.0)
    protected ContributionCommand execBeforeClosing() {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=15.0)
    protected ContributionCommand execClosing() {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected ContributionCommand execGuiAttached() {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=25.0)
    protected ContributionCommand execGuiDetached() {
        return ContributionCommand.Continue;
    }

    @ConfigOperation
    @Order(value=30.0)
    protected ContributionCommand execOutlineChanged(IOutline oldOutline, IOutline newOutline) {
        return ContributionCommand.Continue;
    }

    protected ContributionCommand execFormAboutToShow(IHolder<IForm> formHolder) {
        return ContributionCommand.Continue;
    }

    @Order(value=40.0)
    @ConfigOperation
    protected ContributionCommand execPageSearchFormChanged(IForm oldForm, IForm newForm) {
        return ContributionCommand.Continue;
    }

    @Order(value=50.0)
    @ConfigOperation
    protected ContributionCommand execPageDetailFormChanged(IForm oldForm, IForm newForm) {
        return ContributionCommand.Continue;
    }

    @Order(value=60.0)
    @ConfigOperation
    protected ContributionCommand execPageDetailTableChanged(ITable oldTable, ITable newTable) {
        return ContributionCommand.Continue;
    }

    @Order(value=62.0)
    @ConfigOperation
    protected ContributionCommand execTablePageLoaded(IPageWithTable<?> tablePage) {
        return ContributionCommand.Continue;
    }

    @ConfigProperty(value="OUTLINES")
    @Order(value=20.0)
    protected List<Class<? extends IOutline>> getConfiguredOutlines() {
        return null;
    }

    private List<Class<? extends IAction>> getConfiguredActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IAction.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }
}

