/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.context.ClientRunContext;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.client.deeplink.DeepLinkException;
import org.eclipse.scout.rt.client.deeplink.IDeepLinks;
import org.eclipse.scout.rt.client.deeplink.OutlineDeepLinkHandler;
import org.eclipse.scout.rt.client.extension.ui.desktop.DefaultDesktopEventHistory;
import org.eclipse.scout.rt.client.extension.ui.desktop.DesktopChains;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.services.common.bookmark.internal.BookmarkUtility;
import org.eclipse.scout.rt.client.session.ClientSessionProvider;
import org.eclipse.scout.rt.client.transformation.IDeviceTransformationService;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.Coordinates;
import org.eclipse.scout.rt.client.ui.IDisplayParent;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.BrowserHistoryEntry;
import org.eclipse.scout.rt.client.ui.desktop.ContributionCommand;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListeners;
import org.eclipse.scout.rt.client.ui.desktop.FileChooserStore;
import org.eclipse.scout.rt.client.ui.desktop.FormStore;
import org.eclipse.scout.rt.client.ui.desktop.GeoLocationUiCallbackHandler;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.IOpenUriAction;
import org.eclipse.scout.rt.client.ui.desktop.MessageBoxStore;
import org.eclipse.scout.rt.client.ui.desktop.OpenUriHelper;
import org.eclipse.scout.rt.client.ui.desktop.UnsavedFormChangesForm;
import org.eclipse.scout.rt.client.ui.desktop.bench.layout.BenchLayoutData;
import org.eclipse.scout.rt.client.ui.desktop.datachange.DataChangeEvent;
import org.eclipse.scout.rt.client.ui.desktop.datachange.IDataChangeManager;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.IUiCallbackHandler;
import org.eclipse.scout.rt.client.ui.desktop.hybrid.uicallback.UiCallbacks;
import org.eclipse.scout.rt.client.ui.desktop.notification.IDesktopNotification;
import org.eclipse.scout.rt.client.ui.desktop.notification.NativeNotificationDefaults;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.FormUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormHandler;
import org.eclipse.scout.rt.client.ui.form.IFormMenu;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxes;
import org.eclipse.scout.rt.client.ui.popup.PopupManager;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.OrderedComparator;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.context.PropertyMap;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.exception.VetoException;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.holders.IHolder;
import org.eclipse.scout.rt.platform.job.JobState;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.job.filter.future.SessionFutureFilter;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="a6761d3f-7627-4e10-8440-f5c4865ca73c")
public abstract class AbstractDesktop
extends AbstractWidget
implements IDesktop,
IContributionOwner,
IExtensibleObject {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDesktop.class);
    private IEventHistory<DesktopEvent> m_eventHistory;
    private final IDesktopExtension m_localDesktopExtension;
    private List<IDesktopExtension> m_desktopExtensions;
    private final DesktopListeners m_listeners;
    private int m_dataChanging;
    private final IDesktopUIFacade m_uiFacade;
    private List<IOutline> m_availableOutlines;
    private IOutline m_outline;
    private boolean m_outlineChanging = false;
    private P_ActiveOutlineListener m_activeOutlineListener;
    private ITable m_pageDetailTable;
    private IForm m_pageDetailForm;
    private IForm m_pageSearchForm;
    private final FormStore m_formStore;
    private final Map<String, IForm> m_selectedViewTabs;
    private final MessageBoxStore m_messageBoxStore;
    private final FileChooserStore m_fileChooserStore;
    private final Set<IDesktopNotification> m_notifications = new LinkedHashSet<IDesktopNotification>();
    private List<IMenu> m_menus;
    private List<IViewButton> m_viewButtons;
    private boolean m_autoPrefixWildcardForTextSearch;
    private boolean m_isForcedClosing = false;
    private final List<Object> m_addOns;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractDesktop, org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> m_objectExtensions;
    private int m_attachedCount;
    private int m_attachedGuiCount;
    private boolean m_activatingDefaultView;
    private final IDataChangeManager m_dataChangeListeners;
    private final IDataChangeManager m_dataChangeDesktopInForegroundListeners;

    public AbstractDesktop() {
        this(true);
    }

    public AbstractDesktop(boolean callInitializer) {
        super(false);
        this.m_localDesktopExtension = new P_LocalDesktopExtension();
        this.m_listeners = new DesktopListeners();
        this.m_formStore = (FormStore)((Object)BEANS.get(FormStore.class));
        this.m_selectedViewTabs = new HashMap<String, IForm>();
        this.m_messageBoxStore = (MessageBoxStore)((Object)BEANS.get(MessageBoxStore.class));
        this.m_fileChooserStore = (FileChooserStore)((Object)BEANS.get(FileChooserStore.class));
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(new P_UIFacade(), ModelContextProxy.ModelContext.copyCurrent().withDesktop(this));
        this.m_addOns = new ArrayList<Object>();
        this.m_objectExtensions = new ObjectExtensions((Object)this, true);
        this.m_dataChangeListeners = (IDataChangeManager)BEANS.get(IDataChangeManager.class);
        this.m_dataChangeDesktopInForegroundListeners = (IDataChangeManager)BEANS.get(IDataChangeManager.class);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfigInternal() {
        this.initStartupRequestParams();
        this.runWithDesktop(this::interceptInitConfig);
    }

    private void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected IEventHistory<DesktopEvent> createEventHistory() {
        return new DefaultDesktopEventHistory(5000L);
    }

    @Override
    public IEventHistory<DesktopEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getAvailableOutlines(), this.getActions(), this.m_notifications, this.m_messageBoxStore.values(), this.m_selectedViewTabs.values(), this.m_formStore.values()});
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="OUTLINES")
    @Order(value=20.0)
    protected List<Class<? extends IOutline>> getConfiguredOutlines() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredSelectViewTabsKeyStrokesEnabled() {
        return true;
    }

    @ConfigProperty(value="STRING")
    @Order(value=40.0)
    protected String getConfiguredSelectViewTabsKeyStrokeModifier() {
        return "control";
    }

    @ConfigProperty(value="STRING")
    @Order(value=50.0)
    protected String getConfiguredDisplayStyle() {
        return "default";
    }

    protected String getConfiguredLogoId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredCacheSplitterPosition() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    protected boolean getConfiguredNavigationVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=75.0)
    protected boolean getConfiguredNavigationHandleVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredHeaderVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredBenchVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredLogoActionEnabled() {
        return false;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=110.0)
    protected NativeNotificationDefaults getConfiguredNativeNotificationDefaults() {
        return new NativeNotificationDefaults().withTitle(this.getTitle()).withIconId(this.getLogoId()).withVisibility("none");
    }

    private List<Class<? extends IAction>> getConfiguredActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IAction.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredDense() {
        return false;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInit() {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execOpened() {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execBeforeClosing() {
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execClosing() {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execGuiAttached() {
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execGuiDetached() {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execOutlineChanged(IOutline oldOutline, IOutline newOutline) {
    }

    @ConfigOperation
    @Order(value=80.0)
    protected IForm execFormAboutToShow(IForm form) {
        return form;
    }

    @Order(value=90.0)
    @ConfigOperation
    protected void execPageSearchFormChanged(IForm oldForm, IForm newForm) {
    }

    @Order(value=100.0)
    @ConfigOperation
    protected void execPageDetailFormChanged(IForm oldForm, IForm newForm) {
    }

    @Order(value=110.0)
    @ConfigOperation
    protected void execPageDetailTableChanged(ITable oldTable, ITable newTable) {
    }

    @Order(value=120.0)
    @ConfigOperation
    protected void execTablePageLoaded(IPageWithTable<?> tablePage) {
    }

    @Order(value=130.0)
    @ConfigOperation
    protected void execDefaultView() {
    }

    @Order(value=140.0)
    @ConfigOperation
    protected void execLogoAction() {
    }

    public List<IDesktopExtension> getDesktopExtensions() {
        return CollectionUtility.arrayList(this.m_desktopExtensions);
    }

    protected IDesktopExtension getLocalDesktopExtension() {
        return this.m_localDesktopExtension;
    }

    protected org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop> createLocalExtension() {
        return new LocalDesktopExtension<AbstractDesktop>(this);
    }

    public final List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_eventHistory = this.createEventHistory();
        this.addDesktopListener(e -> {
            IEventHistory<DesktopEvent> h = this.getEventHistory();
            if (h != null) {
                h.notifyEvent(e);
            }
        }, new Integer[0]);
        ClientSessionProvider.currentSession().getMemoryPolicy().registerDesktop(this);
        ((IDeviceTransformationService)BEANS.get(IDeviceTransformationService.class)).install(this);
        this.initDesktopExtensions();
        this.setTitle(this.getConfiguredTitle());
        this.setCssClass(this.getConfiguredCssClass());
        this.setSelectViewTabsKeyStrokesEnabled(this.getConfiguredSelectViewTabsKeyStrokesEnabled());
        this.setSelectViewTabsKeyStrokeModifier(this.getConfiguredSelectViewTabsKeyStrokeModifier());
        this.setLogoId(this.getConfiguredLogoId());
        this.setDisplayStyle(this.getConfiguredDisplayStyle());
        this.initDisplayStyle(this.getDisplayStyle());
        this.setCacheSplitterPosition(this.getConfiguredCacheSplitterPosition());
        this.setLogoActionEnabled(this.getConfiguredLogoActionEnabled());
        this.setNativeNotificationDefaults(this.getConfiguredNativeNotificationDefaults());
        List<IDesktopExtension> extensions = this.getDesktopExtensions();
        this.m_contributionHolder = new ContributionComposite((Object)this);
        OrderedCollection outlines = new OrderedCollection();
        for (IDesktopExtension ext : extensions) {
            try {
                ext.contributeOutlines((OrderedCollection<IOutline>)outlines);
            }
            catch (Exception t) {
                LOG.error("contributing outlines by {}", (Object)ext, (Object)t);
            }
        }
        List contributedOutlines = this.m_contributionHolder.getContributionsByClass(IOutline.class);
        outlines.addAllOrdered((Collection)contributedOutlines);
        ExtensionUtility.moveModelObjects((Iterable)outlines);
        this.setAvailableOutlines(outlines.getOrderedList());
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        for (IDesktopExtension ext : extensions) {
            ext.contributeActions(actionList);
        }
        List contributedActions = this.m_contributionHolder.getContributionsByClass(IAction.class);
        actionList.addAll(contributedActions);
        OrderedComparator orderedComparator = new OrderedComparator();
        List<IMenu> menuList = new ActionFinder().findActions(actionList, IMenu.class, false);
        ExtensionUtility.moveModelObjects(menuList);
        menuList.sort((Comparator<IMenu>)orderedComparator);
        this.m_menus = menuList;
        List<IViewButton> viewButtonList = new ActionFinder().findActions(actionList, IViewButton.class, false);
        ExtensionUtility.moveModelObjects(viewButtonList);
        viewButtonList.sort((Comparator<IViewButton>)orderedComparator);
        this.m_viewButtons = viewButtonList;
        List<IKeyStroke> ksList = new ActionFinder().findActions(actionList, IKeyStroke.class, true);
        this.addKeyStrokes(ksList.toArray(new IKeyStroke[0]));
        this.addPropertyChangeListener(new P_LocalPropertyChangeListener());
        this.addAddOn(BEANS.get(PopupManager.class));
    }

    protected final void interceptInit() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopInitChain chain = new DesktopChains.DesktopInitChain(extensions);
        chain.execInit();
    }

    private void initDesktopExtensions() {
        this.m_desktopExtensions = new ArrayList<IDesktopExtension>();
        this.m_desktopExtensions.add(this.getLocalDesktopExtension());
        this.injectDesktopExtensions(this.m_desktopExtensions);
    }

    protected void injectDesktopExtensions(List<IDesktopExtension> desktopExtensions) {
        List extensions = BEANS.all(IDesktopExtension.class);
        for (IDesktopExtension e : extensions) {
            e.setCoreDesktop(this);
        }
        desktopExtensions.addAll(extensions);
    }

    @Override
    protected void initInternal() {
        this.runWithDesktop(this::interceptInitInternal);
    }

    protected void interceptInitInternal() {
        super.initInternal();
        for (IDesktopExtension ext : this.getDesktopExtensions()) {
            ContributionCommand cc = ext.initDelegate();
            if (cc == ContributionCommand.Stop) break;
        }
    }

    protected void initDisplayStyle(String displayStyle) {
        if ("bench".equals(displayStyle)) {
            this.setNavigationVisible(false);
            this.setNavigationHandleVisible(false);
            this.setHeaderVisible(false);
            this.setBenchVisible(true);
            this.setDense(this.getConfiguredDense());
        } else if ("compact".equals(displayStyle)) {
            this.setNavigationVisible(true);
            this.setNavigationHandleVisible(false);
            this.setHeaderVisible(false);
            this.setBenchVisible(false);
            this.setDense(false);
        } else {
            this.setNavigationVisible(this.getConfiguredNavigationVisible());
            this.setNavigationHandleVisible(this.getConfiguredNavigationHandleVisible());
            this.setHeaderVisible(this.getConfiguredHeaderVisible());
            this.setBenchVisible(this.getConfiguredBenchVisible());
            this.setDense(this.getConfiguredDense());
        }
    }

    @Override
    public boolean isShowing(IForm form) {
        if (form == null) {
            return false;
        }
        if (form.getOuterForm() != null) {
            return form.getOuterForm().isShowing();
        }
        if (this.m_formStore.contains(form)) {
            return true;
        }
        if (form == this.m_pageDetailForm || form == this.m_pageSearchForm) {
            return true;
        }
        for (IMenu menu : this.getMenus()) {
            if (!(menu instanceof IFormMenu) || !menu.isSelected() || ((IFormMenu)menu).getForm() != form) continue;
            return true;
        }
        return false;
    }

    public <FORM extends IForm> FORM findForm(Class<FORM> formType) {
        if (formType == null) {
            return null;
        }
        for (IForm candidate : this.m_formStore.values()) {
            if (!formType.isAssignableFrom(candidate.getClass())) continue;
            IForm form = candidate;
            return (FORM)form;
        }
        return null;
    }

    public <FORM extends IForm> List<FORM> findForms(Class<FORM> formType) {
        if (formType == null) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<IForm> forms = new ArrayList<IForm>();
        for (IForm candidate : this.m_formStore.values()) {
            if (!formType.isAssignableFrom(candidate.getClass())) continue;
            IForm form = candidate;
            forms.add(form);
        }
        return forms;
    }

    @Override
    public <T extends IOutline> T findOutline(Class<T> outlineType) {
        for (IOutline o : this.getAvailableOutlines()) {
            if (!outlineType.isAssignableFrom(o.getClass())) continue;
            return (T)o;
        }
        return null;
    }

    @Override
    public <T extends IAction> T findAction(Class<T> actionType) {
        return new ActionFinder().findAction(this.getActions(), actionType);
    }

    @Override
    public <T extends IViewButton> T findViewButton(Class<T> viewButtonType) {
        return (T)((IViewButton)this.findAction(viewButtonType));
    }

    @Override
    public String getDisplayStyle() {
        return this.propertySupport.getPropertyString("displayStyle");
    }

    @Override
    public void setDisplayStyle(String displayStyle) {
        this.propertySupport.setProperty("displayStyle", (Object)displayStyle);
    }

    @Override
    public String getLogoId() {
        return this.propertySupport.getPropertyString("logoId");
    }

    @Override
    public void setLogoId(String id) {
        this.propertySupport.setPropertyString("logoId", id);
    }

    @Override
    public IForm getActiveForm() {
        return (IForm)this.propertySupport.getProperty("activeForm");
    }

    protected void setActiveForm(IForm form) {
        if (form != null) {
            form.getUIFacade().fireFormActivatedFromUI();
            if (form.getDisplayHint() == 20) {
                String displayViewId = FormUtility.normalizeDisplayViewId(form.getDisplayViewId());
                this.m_selectedViewTabs.put(displayViewId, form);
            }
        }
        this.propertySupport.setProperty("activeForm", (Object)form);
    }

    @Override
    public IWidget getFocusedElement() {
        return (IWidget)this.propertySupport.getProperty("focusedElement");
    }

    protected void setFocusedElement(IWidget focusedElement) {
        if (ObjectUtility.equals((Object)focusedElement, (Object)this.getFocusedElement())) {
            return;
        }
        if (this.getFocusedElement() instanceof AbstractWidget) {
            ((AbstractWidget)this.getFocusedElement()).notifyFocusOut();
        }
        this.propertySupport.setProperty("focusedElement", (Object)focusedElement);
        if (focusedElement instanceof AbstractWidget) {
            ((AbstractWidget)focusedElement).notifyFocusIn();
        }
    }

    @Override
    public void setTrackFocus(boolean trackFocus) {
        int trackFocusCount = this.getTrackFocus();
        trackFocusCount = trackFocus ? ++trackFocusCount : Math.max(trackFocusCount - 1, 0);
        this.propertySupport.setPropertyInt("trackFocus", trackFocusCount);
    }

    protected int getTrackFocus() {
        return this.propertySupport.getPropertyInt("trackFocus");
    }

    @Override
    public boolean isTrackFocus() {
        return this.getTrackFocus() > 0;
    }

    @Override
    public List<IForm> getForms(IDisplayParent displayParent) {
        return this.m_formStore.getByDisplayParent(displayParent);
    }

    @Override
    public List<IForm> getViews() {
        return this.m_formStore.getViews();
    }

    @Override
    public List<IForm> getViews(IDisplayParent displayParent) {
        return this.m_formStore.getViewsByDisplayParent(displayParent);
    }

    @Override
    public Collection<IForm> getSelectedViews(IDisplayParent displayParent) {
        ArrayList<IForm> selectedViewTabs = new ArrayList<IForm>();
        for (IForm f : this.m_selectedViewTabs.values()) {
            if (f.getDisplayParent() != displayParent) continue;
            selectedViewTabs.add(f);
        }
        return selectedViewTabs;
    }

    @Override
    public <F extends IForm, H extends IFormHandler> List<F> findAllOpenViews(Class<? extends F> formClass, Class<? extends H> handlerClass, Object exclusiveKey) {
        ArrayList<IForm> forms = new ArrayList<IForm>();
        if (exclusiveKey != null) {
            for (IForm view : this.getViews()) {
                Object candidateKey;
                if (this.getPageDetailForm() == view || this.getPageSearchForm() == view || (candidateKey = view.computeExclusiveKey()) == null) continue;
                LOG.debug("form: {} vs {}", candidateKey, exclusiveKey);
                if (!exclusiveKey.equals(candidateKey) || view.getClass() != formClass || view.getHandler() == null || view.getHandler().getClass() != handlerClass || !view.getHandler().isOpenExclusive()) continue;
                forms.add((IForm)formClass.cast(view));
            }
        }
        return forms;
    }

    @Override
    public <F extends IForm, H extends IFormHandler> F findOpenView(Class<? extends F> formClass, Class<? extends H> handlerClass, Object exclusiveKey) {
        return (F)((IForm)CollectionUtility.firstElement(this.findAllOpenViews(formClass, handlerClass, exclusiveKey)));
    }

    @Override
    public List<IForm> getDialogs() {
        return this.m_formStore.getDialogs();
    }

    @Override
    public List<IForm> getDialogs(IDisplayParent displayParent, boolean includeChildDialogs) {
        ArrayList<IForm> dialogs = new ArrayList<IForm>();
        for (IForm dialog : this.m_formStore.getDialogsByDisplayParent(displayParent)) {
            if (includeChildDialogs) {
                dialogs.addAll(this.getDialogs(dialog, true));
            }
            dialogs.add(dialog);
        }
        return dialogs;
    }

    public List<IMessageBox> getMessageBoxStack() {
        return this.getMessageBoxes();
    }

    @Override
    public List<IMessageBox> getMessageBoxes() {
        return this.m_messageBoxStore.values();
    }

    @Override
    public List<IDesktopNotification> getNotifications() {
        return new ArrayList<IDesktopNotification>(this.m_notifications);
    }

    @Override
    public List<IMessageBox> getMessageBoxes(IDisplayParent displayParent) {
        return this.m_messageBoxStore.getByDisplayParent(displayParent);
    }

    @Override
    public List<IForm> getSimilarForms(IForm form) {
        Object formKey;
        if (form == null) {
            return CollectionUtility.emptyArrayList();
        }
        try {
            formKey = form.computeExclusiveKey();
        }
        catch (RuntimeException | PlatformError e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            return CollectionUtility.emptyArrayList();
        }
        if (formKey == null) {
            return CollectionUtility.emptyArrayList();
        }
        IForm currentDetailForm = this.getPageDetailForm();
        IForm currentSearchForm = this.getPageSearchForm();
        ArrayList<IForm> similarForms = new ArrayList<IForm>();
        for (IForm candidateView : this.m_formStore.getFormsByExclusiveKey(formKey)) {
            if (candidateView == currentDetailForm || candidateView == currentSearchForm || !candidateView.getClass().equals(form.getClass())) continue;
            similarForms.add(candidateView);
        }
        return similarForms;
    }

    @Override
    public void ensureViewStackVisible() {
        for (IForm view : this.m_formStore.getViews()) {
            this.activateForm(view);
        }
    }

    @Override
    public void activateForm(IForm form) {
        if (form == null) {
            this.setActiveForm(form);
            return;
        }
        if (!this.m_formStore.contains(form)) {
            return;
        }
        IDisplayParent displayParent = form.getDisplayParent();
        if (displayParent instanceof IForm) {
            this.activateForm((IForm)displayParent);
        } else if (displayParent instanceof IOutline && !displayParent.equals(this.getOutline())) {
            this.activateOutline((IOutline)displayParent);
        }
        this.setActiveForm(form);
        this.fireFormActivate(form);
    }

    @Override
    public void activateOutline(IOutline outline) {
        if (this.m_outlineChanging) {
            return;
        }
        IOutline newOutline = this.resolveOutline(outline);
        if (this.m_outline == newOutline) {
            if (this.m_outline != null) {
                this.m_outline.createDisplayParentRunContext().run(this::fireOutlineContentActivate);
            }
            return;
        }
        try {
            this.m_outlineChanging = true;
            this.setOutlineInternal(newOutline);
        }
        finally {
            this.m_outlineChanging = false;
        }
    }

    protected void setOutlineInternal(IOutline newOutline) {
        IOutline oldOutline = this.m_outline;
        if (oldOutline != null) {
            if (this.m_activeOutlineListener != null) {
                oldOutline.removePropertyChangeListener(this.m_activeOutlineListener);
                this.m_activeOutlineListener = null;
            }
            this.m_outline.deactivate();
        }
        this.m_outline = newOutline;
        if (oldOutline != null) {
            oldOutline.clearContextPage();
        }
        ClientRunContext ctx = this.m_outline == null ? ClientRunContexts.copyCurrent().withOutline(null, true) : this.m_outline.createDisplayParentRunContext();
        ctx.run(() -> {
            if (this.m_outline != null) {
                this.m_activeOutlineListener = new P_ActiveOutlineListener();
                this.m_outline.addPropertyChangeListener(this.m_activeOutlineListener);
                this.setBrowserHistoryEntry(((OutlineDeepLinkHandler)BEANS.get(OutlineDeepLinkHandler.class)).createBrowserHistoryEntry(this.m_outline, this.m_activatingDefaultView));
            }
            if (this.m_outline == null) {
                this.setPageDetailForm(null);
                this.setPageDetailTable(null);
                this.setPageSearchForm(null, true);
            }
            this.updateActiveFormOnOutlineChanged();
            this.fireOutlineChanged(oldOutline, this.m_outline);
            this.onOutlineChangedInternal();
            this.fireOutlineContentActivate();
        });
    }

    protected void updateActiveFormOnOutlineChanged() {
        IForm activeForm = this.getActiveForm();
        if (activeForm == null || activeForm.getDisplayParent() == this) {
            return;
        }
        List<IForm> formsByOutline = this.m_formStore.getByDisplayParent(this.m_outline);
        if (!formsByOutline.contains(activeForm)) {
            this.setActiveForm(null);
        }
    }

    protected void onOutlineChangedInternal() {
        if (this.m_outline == null) {
            return;
        }
        if (this.m_outline.getActivePage() != null) {
            try {
                this.m_outline.getActivePage().ensureChildrenLoaded();
            }
            catch (RuntimeException | PlatformError e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
            }
        }
        this.m_outline.setNodeExpanded(this.m_outline.getRootNode(), true);
        this.setPageDetailForm(this.m_outline.getDetailForm());
        this.setPageDetailTable(this.m_outline.getDetailTable());
        this.setPageSearchForm(this.m_outline.getSearchForm(), true);
        this.m_outline.makeActivePageToContextPage();
        this.m_outline.activate();
    }

    @Override
    public void showForm(IForm form) {
        boolean view;
        Assertions.assertFalse((boolean)ClientSessionProvider.currentSession().isStopping(), (String)"Session is stopping", (Object[])new Object[0]);
        Holder formHolder = new Holder((Object)form);
        for (IDesktopExtension extension : this.getDesktopExtensions()) {
            try {
                if (extension.formAboutToShowDelegate((IHolder<IForm>)formHolder) != ContributionCommand.Stop) continue;
                break;
            }
            catch (Exception e) {
                formHolder.setValue((Object)form);
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        }
        form = (IForm)formHolder.getValue();
        if (form == null || this.m_formStore.contains(form)) {
            return;
        }
        Assertions.assertNotNull((Object)form.getDisplayParent(), (String)"Property 'displayParent' must not be null", (Object[])new Object[0]);
        boolean bl = view = form.getDisplayHint() == 20;
        if (view && form.isModal()) {
            boolean applicationLocked;
            boolean bl2 = applicationLocked = this.m_formStore.containsApplicationModalDialogs() || this.m_messageBoxStore.containsApplicationModalMessageBoxes() || this.m_fileChooserStore.containsApplicationModalFileChoosers();
            if (applicationLocked) {
                Assertions.fail((String)this.generateApplicationModalErrorMessage(), (Object[])new Object[0]);
            }
        }
        this.m_formStore.add(form);
        this.activateForm(form);
        this.fireFormShow(form);
    }

    protected String generateApplicationModalErrorMessage() {
        String message = "Modal view cannot be shown because application is in 'desktop-modal' state; otherwise, no user interaction would be possible.";
        String applicationModalForms = this.m_formStore.getApplicationModalDialogs().stream().map(f -> f.getClass().getSimpleName() + "; " + f.getTitle()).collect(Collectors.joining(", "));
        String applicationModalMessageBoxes = this.m_messageBoxStore.getApplicationModalMessageBoxes().stream().map(f -> f.getClass().getSimpleName() + "; " + f.getHeader()).collect(Collectors.joining(", "));
        String applicationModalFileChoosers = this.m_fileChooserStore.getApplicationModalFileChoosers().stream().map(f -> f.getClass().getSimpleName()).collect(Collectors.joining(", "));
        return message + "\nForms: [" + applicationModalForms + "]; MessageBoxes: [" + applicationModalMessageBoxes + "]; FileChoosers: [" + applicationModalFileChoosers + "]";
    }

    @Override
    public void hideForm(IForm form) {
        String displayViewId;
        if (form == null || !this.m_formStore.contains(form)) {
            return;
        }
        if (this.getActiveForm() == form) {
            this.setActiveForm(null);
        }
        if (form.getDisplayHint() == 20 && this.m_selectedViewTabs.get(displayViewId = FormUtility.normalizeDisplayViewId(form.getDisplayViewId())) == form) {
            this.m_selectedViewTabs.remove(displayViewId);
        }
        this.m_formStore.remove(form);
        this.fireFormHide(form);
    }

    @Override
    public void showMessageBox(IMessageBox messageBox) {
        Assertions.assertFalse((boolean)ClientSessionProvider.currentSession().isStopping(), (String)"Session is stopping", (Object[])new Object[0]);
        if (messageBox == null || this.m_messageBoxStore.contains(messageBox)) {
            return;
        }
        Assertions.assertNotNull((Object)messageBox.getDisplayParent(), (String)"Property 'displayParent' must not be null", (Object[])new Object[0]);
        this.m_messageBoxStore.add(messageBox);
        this.fireMessageBoxShow(messageBox);
    }

    @Override
    public void hideMessageBox(IMessageBox messageBox) {
        if (messageBox == null || !this.m_messageBoxStore.contains(messageBox)) {
            return;
        }
        this.m_messageBoxStore.remove(messageBox);
        this.fireMessageBoxHide(messageBox);
    }

    @Override
    public boolean isShowing(IMessageBox messageBox) {
        return this.m_messageBoxStore.contains(messageBox);
    }

    @Override
    public List<IOutline> getAvailableOutlines() {
        return CollectionUtility.arrayList(this.m_availableOutlines);
    }

    @Override
    public void setAvailableOutlines(List<? extends IOutline> availableOutlines) {
        this.activateOutline(null);
        if (this.m_availableOutlines != null) {
            for (IOutline o : this.m_availableOutlines) {
                ClientSessionProvider.currentSession().getMemoryPolicy().deregisterOutline(o);
            }
        }
        this.m_availableOutlines = CollectionUtility.arrayList(availableOutlines);
        for (IOutline o : this.m_availableOutlines) {
            ClientSessionProvider.currentSession().getMemoryPolicy().registerOutline(o);
        }
    }

    @Override
    public IOutline getOutline() {
        return this.m_outline;
    }

    @Override
    public boolean isOutlineChanging() {
        return this.m_outlineChanging;
    }

    @Override
    public void activateFirstPage() {
        if (this.m_outline.isRootNodeVisible()) {
            this.m_outline.selectNode(this.m_outline.getRootNode(), false);
        } else {
            List<ITreeNode> children = this.m_outline.getRootNode().getChildNodes();
            if (CollectionUtility.hasElements(children)) {
                for (ITreeNode node : children) {
                    if (!node.isVisible() || !node.isEnabled()) continue;
                    this.m_outline.selectNode(node, false);
                    break;
                }
            }
        }
    }

    private IOutline resolveOutline(IOutline outline) {
        for (IOutline o : this.getAvailableOutlines()) {
            if (o != outline) continue;
            return o;
        }
        return null;
    }

    @Override
    public void setOutline(Class<? extends IOutline> outlineType) {
        if (outlineType == null) {
            return;
        }
        for (IOutline o : this.getAvailableOutlines()) {
            if (!outlineType.isInstance(o)) continue;
            this.activateOutline(o);
            return;
        }
    }

    @Override
    public Set<IKeyStroke> getKeyStrokes() {
        return CollectionUtility.hashSet(this.getKeyStrokesInternal());
    }

    protected Set<IKeyStroke> getKeyStrokesInternal() {
        return this.propertySupport.getPropertySet("keyStrokes");
    }

    @Override
    public void setKeyStrokes(Collection<? extends IKeyStroke> ks) {
        this.propertySupport.setPropertySet("keyStrokes", (Set)CollectionUtility.hashSetWithoutNullElements(ks));
    }

    @Override
    public void addKeyStrokes(IKeyStroke ... keyStrokes) {
        if (keyStrokes != null && keyStrokes.length > 0) {
            Map<String, IKeyStroke> map = this.getKeyStrokesInternalMap();
            IKeyStroke[] iKeyStrokeArray = keyStrokes;
            int n = keyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyStroke ks = iKeyStrokeArray[n2];
                map.put(ks.getKeyStroke(), ks);
                ++n2;
            }
            this.setKeyStrokes(map.values());
        }
    }

    @Override
    public void removeKeyStrokes(IKeyStroke ... keyStrokes) {
        if (keyStrokes != null && keyStrokes.length > 0) {
            Map<String, IKeyStroke> map = this.getKeyStrokesInternalMap();
            IKeyStroke[] iKeyStrokeArray = keyStrokes;
            int n = keyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyStroke ks = iKeyStrokeArray[n2];
                map.remove(ks.getKeyStroke());
                ++n2;
            }
            this.setKeyStrokes(map.values());
        }
    }

    protected Map<String, IKeyStroke> getKeyStrokesInternalMap() {
        HashMap<String, IKeyStroke> map = new HashMap<String, IKeyStroke>();
        Set<IKeyStroke> currentKeyStrokes = this.getKeyStrokesInternal();
        if (CollectionUtility.hasElements(currentKeyStrokes)) {
            for (IKeyStroke ks : currentKeyStrokes) {
                map.put(ks.getKeyStroke(), ks);
            }
        }
        return map;
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    @Override
    public IContextMenu getContextMenu() {
        return null;
    }

    @Override
    public List<IMenu> getMenus() {
        return CollectionUtility.arrayList(this.m_menus);
    }

    @Override
    public List<IAction> getActions() {
        Set<IKeyStroke> keyStrokes = this.getKeyStrokesInternal();
        ArrayList<IAction> result = new ArrayList<IAction>(CollectionUtility.size(keyStrokes) + CollectionUtility.size(this.m_menus) + CollectionUtility.size(this.m_viewButtons));
        CollectionUtility.appendAllList(result, keyStrokes);
        CollectionUtility.appendAllList(result, this.m_menus);
        CollectionUtility.appendAllList(result, this.m_viewButtons);
        return result;
    }

    @Override
    public <T extends IViewButton> T getViewButton(Class<? extends T> searchType) {
        return (T)((IViewButton)new ActionFinder().findAction(this.getViewButtons(), searchType));
    }

    @Override
    public List<IViewButton> getViewButtons() {
        return CollectionUtility.arrayList(this.m_viewButtons);
    }

    @Override
    public IForm getPageDetailForm() {
        return this.m_pageDetailForm;
    }

    @Override
    public void setPageDetailForm(IForm f) {
        if (this.m_pageDetailForm != f) {
            IForm oldForm = this.m_pageDetailForm;
            this.m_pageDetailForm = f;
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.pageDetailFormChangedDelegate(oldForm, this.m_pageDetailForm);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Exception e) {
                    LOG.error("extension {}", (Object)ext, (Object)e);
                }
            }
        }
    }

    @Override
    public IForm getPageSearchForm() {
        return this.m_pageSearchForm;
    }

    @Override
    public void setPageSearchForm(IForm f) {
        this.setPageSearchForm(f, false);
    }

    public void setPageSearchForm(IForm f, boolean force) {
        if (force || this.m_pageSearchForm != f) {
            IForm oldForm = this.m_pageSearchForm;
            this.m_pageSearchForm = f;
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.pageSearchFormChangedDelegate(oldForm, this.m_pageSearchForm);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Exception t) {
                    LOG.error("extension {}", (Object)ext, (Object)t);
                }
            }
        }
    }

    @Override
    public ITable getPageDetailTable() {
        return this.m_pageDetailTable;
    }

    @Override
    public void setPageDetailTable(ITable t) {
        if (this.m_pageDetailTable != t) {
            ITable oldTable = this.m_pageDetailTable;
            this.m_pageDetailTable = t;
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.pageDetailTableChangedDelegate(oldTable, this.m_pageDetailTable);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Exception x) {
                    LOG.error("extension {}", (Object)ext, (Object)x);
                }
            }
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public boolean isSelectViewTabsKeyStrokesEnabled() {
        return this.propertySupport.getPropertyBool("selectViewTabsKeyStrokesEnabled");
    }

    @Override
    public void setSelectViewTabsKeyStrokesEnabled(boolean selectViewTabsKeyStrokesEnabled) {
        this.propertySupport.setPropertyBool("selectViewTabsKeyStrokesEnabled", selectViewTabsKeyStrokesEnabled);
    }

    @Override
    public String getSelectViewTabsKeyStrokeModifier() {
        return this.propertySupport.getPropertyString("selectViewTabsKeyStrokeModifier");
    }

    @Override
    public void setSelectViewTabsKeyStrokeModifier(String selectViewTabsKeyStrokeModifier) {
        this.propertySupport.setPropertyString("selectViewTabsKeyStrokeModifier", selectViewTabsKeyStrokeModifier);
    }

    @Override
    public PropertyMap getStartupRequestParams() {
        return (PropertyMap)this.propertySupport.getProperty("startupRequestParams");
    }

    @Override
    public <VALUE> VALUE getStartupRequestParam(String propertyName) {
        return (VALUE)this.getStartupRequestParams().get((Object)propertyName);
    }

    @Override
    public String getStartupUrl() {
        return (String)this.getStartupRequestParam("url");
    }

    protected void initStartupRequestParams() {
        PropertyMap copy = new PropertyMap((PropertyMap)PropertyMap.CURRENT.get());
        this.propertySupport.setProperty("startupRequestParams", (Object)copy);
    }

    @Override
    public void addNotification(IDesktopNotification notification) {
        if (notification != null && this.m_notifications.add(notification)) {
            this.fireNotification(1040, notification);
            if (notification.getDuration() > 0L) {
                ModelJobs.schedule(() -> this.removeNotification(notification), ModelJobs.newInput(ClientRunContexts.copyCurrent()).withExecutionHint("scout.testing.doNotWaitForThisJob").withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn(notification.getDuration(), TimeUnit.MILLISECONDS)));
            }
        }
    }

    @Override
    public void removeNotification(IDesktopNotification notification) {
        this.removeNotificationInternal(notification, true);
    }

    protected void removeNotificationInternal(IDesktopNotification notification, boolean notifyUI) {
        if (this.m_notifications.remove(notification) && notifyUI) {
            this.fireNotification(1050, notification);
        }
    }

    @Override
    public BrowserHistoryEntry getBrowserHistoryEntry() {
        return (BrowserHistoryEntry)this.propertySupport.getProperty("browserHistoryEntry");
    }

    @Override
    public void setBrowserHistoryEntry(BrowserHistoryEntry browserHistory) {
        this.propertySupport.setProperty("browserHistoryEntry", (Object)browserHistory);
    }

    @Override
    public boolean isCacheSplitterPosition() {
        return this.propertySupport.getPropertyBool("cacheSplitterPosition");
    }

    @Override
    public void setCacheSplitterPosition(boolean b) {
        this.propertySupport.setPropertyBool("cacheSplitterPosition", b);
    }

    @Override
    public List<IFileChooser> getFileChoosers() {
        return this.m_fileChooserStore.values();
    }

    @Override
    public List<IFileChooser> getFileChoosers(IDisplayParent displayParent) {
        return this.m_fileChooserStore.getByDisplayParent(displayParent);
    }

    @Override
    public void showFileChooser(IFileChooser fileChooser) {
        if (fileChooser == null || this.m_fileChooserStore.contains(fileChooser)) {
            return;
        }
        Assertions.assertNotNull((Object)fileChooser.getDisplayParent(), (String)"Property 'displayParent' must not be null", (Object[])new Object[0]);
        this.m_fileChooserStore.add(fileChooser);
        this.fireFileChooserShow(fileChooser);
    }

    @Override
    public void hideFileChooser(IFileChooser fileChooser) {
        if (fileChooser == null || !this.m_fileChooserStore.contains(fileChooser)) {
            return;
        }
        this.m_fileChooserStore.remove(fileChooser);
        this.fireFileChooserHide(fileChooser);
    }

    @Override
    public boolean isShowing(IFileChooser fileChooser) {
        return this.m_fileChooserStore.contains(fileChooser);
    }

    @Override
    public void openUri(String url, IOpenUriAction openUriAction) {
        Assertions.assertNotNull((Object)url);
        Assertions.assertNotNull((Object)openUriAction);
        this.fireOpenUri(url, openUriAction);
    }

    @Override
    public void openUri(BinaryResource res) {
        Assertions.assertNotNull((Object)res);
        this.openUri(res, ((OpenUriHelper)BEANS.get(OpenUriHelper.class)).getOpenUriActionForResource(res));
    }

    @Override
    public void openUri(BinaryResource res, IOpenUriAction openUriAction) {
        Assertions.assertNotNull((Object)res);
        Assertions.assertNotNull((Object)openUriAction);
        this.fireOpenUri(res, openUriAction);
    }

    @Override
    public boolean isAutoPrefixWildcardForTextSearch() {
        return this.m_autoPrefixWildcardForTextSearch;
    }

    @Override
    public void setAutoPrefixWildcardForTextSearch(boolean b) {
        this.m_autoPrefixWildcardForTextSearch = b;
    }

    @Override
    public boolean isOpened() {
        return this.propertySupport.getPropertyBool("opened");
    }

    private void setOpenedInternal(boolean b) {
        this.propertySupport.setPropertyBool("opened", b);
    }

    @Override
    public boolean isReady() {
        return this.propertySupport.getPropertyBool("ready");
    }

    private void setReadyInternal(boolean b) {
        this.propertySupport.setPropertyBool("ready", b);
    }

    @Override
    public boolean isGuiAvailable() {
        return this.propertySupport.getPropertyBool("guiAvailable");
    }

    @Override
    public void reloadGui() {
        this.fireReloadGUI();
    }

    @Override
    public boolean isGeolocationServiceAvailable() {
        return this.propertySupport.getPropertyBool("geolocationServiceAvailable");
    }

    @Override
    public void setGeolocationServiceAvailable(boolean available) {
        this.propertySupport.setPropertyBool("geolocationServiceAvailable", available);
    }

    @Override
    public Future<Coordinates> requestGeolocation() {
        return UiCallbacks.get().send((IWidget)this, (IUiCallbackHandler)BEANS.get(GeoLocationUiCallbackHandler.class), UiCallbacks.newInput().withCallbackId("request-geolocation"));
    }

    @Override
    public DesktopListeners desktopListeners() {
        return this.m_listeners;
    }

    @Override
    public IDataChangeManager dataChangeListeners() {
        return this.m_dataChangeListeners;
    }

    @Override
    public IDataChangeManager dataChangeDesktopInForegroundListeners() {
        return this.m_dataChangeDesktopInForegroundListeners;
    }

    @Override
    public boolean isDataChanging() {
        return this.m_dataChanging > 0;
    }

    @Override
    public void setDataChanging(boolean b) {
        if (b) {
            ++this.m_dataChanging;
        } else if (this.m_dataChanging > 0) {
            --this.m_dataChanging;
        }
        this.m_dataChangeListeners.setBuffering(this.isDataChanging());
        this.m_dataChangeDesktopInForegroundListeners.setBuffering(this.isDataChanging() || this.isInBackground());
    }

    @Override
    public void dataChanged(Object ... eventTypes) {
        if (eventTypes == null) {
            return;
        }
        Object[] objectArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object eventType = objectArray[n2];
            if (eventType instanceof DataChangeEvent) {
                LOG.warn("Calling IDesktop.dataChanged with an argument of type '{}'. Call IDesktop.fireDataChangeEvent instead!", eventType.getClass());
                this.fireDataChangeEvent((DataChangeEvent)eventType);
            } else {
                this.fireDataChangeEvent(new DataChangeEvent(eventType, 2));
            }
            ++n2;
        }
    }

    @Override
    public void fireDataChangeEvent(DataChangeEvent event) {
        if (event == null) {
            return;
        }
        this.m_dataChangeListeners.fireEvent(event);
        this.m_dataChangeDesktopInForegroundListeners.fireEvent(event);
    }

    private void fireDesktopClosed() {
        DesktopEvent e = new DesktopEvent(this, 100);
        this.fireDesktopEvent(e);
    }

    private void fireOutlineChanged(IOutline oldOutline, IOutline newOutline) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 200, newOutline);
        this.fireDesktopEvent(e);
        if (oldOutline != newOutline) {
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.outlineChangedDelegate(oldOutline, newOutline);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (RuntimeException | PlatformError ex) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(ex);
                }
            }
        }
    }

    private void fireOutlineContentActivate() {
        DesktopEvent e = new DesktopEvent(this, 210);
        this.fireDesktopEvent(e);
    }

    private void fireFormShow(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 600, form);
        this.fireDesktopEvent(e);
    }

    private void fireFormActivate(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 620, form);
        this.fireDesktopEvent(e);
    }

    private void fireFormHide(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 610, form);
        this.fireDesktopEvent(e);
    }

    private void fireMessageBoxShow(IMessageBox messageBox) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 700, messageBox);
        this.fireDesktopEvent(e);
    }

    private void fireMessageBoxHide(IMessageBox messageBox) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 710, messageBox);
        this.fireDesktopEvent(e);
    }

    private void fireFileChooserShow(IFileChooser fileChooser) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 910, fileChooser);
        this.fireDesktopEvent(e);
    }

    private void fireFileChooserHide(IFileChooser fileChooser) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 915, fileChooser);
        this.fireDesktopEvent(e);
    }

    private void fireOpenUri(String uri, IOpenUriAction openUriAction) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 920, uri, openUriAction);
        this.fireDesktopEvent(e);
    }

    private void fireOpenUri(BinaryResource res, IOpenUriAction openUriAction) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 920, res, openUriAction);
        this.fireDesktopEvent(e);
    }

    private void fireNotification(int eventType, IDesktopNotification notification) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, eventType, notification);
        this.fireDesktopEvent(e);
    }

    private void fireReloadGUI() {
        DesktopEvent e = new DesktopEvent(this, 1060);
        this.fireDesktopEvent(e);
    }

    protected void fireDesktopEvent(DesktopEvent e) {
        this.desktopListeners().fireEvent(e);
    }

    @Override
    public void activateBookmark(Bookmark bm) {
        this.activateBookmark(bm, true);
    }

    @Override
    public void activateBookmark(Bookmark bm, boolean activateOutline) {
        BookmarkUtility.activateBookmark(this, bm, activateOutline);
    }

    @Override
    public Bookmark createBookmark() {
        return BookmarkUtility.createBookmark(this);
    }

    @Override
    public Bookmark createBookmark(IPage<?> page) {
        return BookmarkUtility.createBookmark(page);
    }

    @Override
    public void refreshPages(Class<?> ... pageTypes) {
        for (IOutline outline : this.getAvailableOutlines()) {
            outline.refreshPages(pageTypes);
        }
    }

    @Override
    public void refreshPages(List<Class<? extends IPage<?>>> pages) {
        for (IOutline outline : this.getAvailableOutlines()) {
            outline.refreshPages(pages);
        }
    }

    @Override
    public void reloadPageFromRoot(IPage<?> page) {
        Bookmark bm = this.createBookmark();
        page.setChildrenDirty(true);
        this.activateBookmark(bm, false);
    }

    @Override
    public void releaseUnusedPages() {
        for (IOutline outline : this.getAvailableOutlines()) {
            outline.releaseUnusedPages();
        }
    }

    @Override
    public void afterTablePageLoaded(IPageWithTable<?> tablePage) {
        for (IDesktopExtension ext : this.getDesktopExtensions()) {
            try {
                ContributionCommand cc = ext.tablePageLoadedDelegate(tablePage);
                if (cc != ContributionCommand.Stop) continue;
                break;
            }
            catch (Exception t) {
                LOG.error("extension {}", (Object)ext, (Object)t);
            }
        }
    }

    @Override
    protected void disposeChildren(List<? extends IWidget> widgetsToDispose) {
        widgetsToDispose.removeAll(this.m_formStore.values());
        super.disposeChildren(widgetsToDispose);
    }

    @Override
    protected void initChildren(List<? extends IWidget> widgets) {
        this.runWithDesktop(() -> this.interceptInitChildren(widgets));
    }

    protected void interceptInitChildren(List<? extends IWidget> widgets) {
        widgets.removeAll(this.m_formStore.values());
        super.initChildren(widgets);
    }

    protected void runWithDesktop(IRunnable runnable) {
        ClientRunContexts.copyCurrent().withDesktop(this).run(runnable);
    }

    @Override
    protected final void disposeInternal() {
        try {
            this.closeInternal();
        }
        catch (RuntimeException e) {
            LOG.warn("Exception while disposing desktop.", (Throwable)e);
        }
        super.disposeInternal();
    }

    @Override
    public void closeInternal() {
        this.setOpenedInternal(false);
        while (this.m_attachedGuiCount > 0) {
            this.detachGui();
        }
        ArrayList<IForm> showedForms = new ArrayList<IForm>();
        for (IForm form : this.m_formStore.values()) {
            this.hideForm(form);
            showedForms.add(form);
        }
        this.internalInterruptBlockingConditions();
        this.internalCloseMessageBoxes(this.getMessageBoxes());
        this.internalCloseFileChoosers(this.getFileChoosers());
        this.internalCloseForms(showedForms);
        this.internalCloseDesktopExtensions();
        this.internalInterruptBlockingConditions();
        this.internalCloseMessageBoxes(this.getMessageBoxes());
        this.internalCloseFileChoosers(this.getFileChoosers());
        this.fireDesktopClosed();
    }

    protected void internalInterruptBlockingConditions() {
        Jobs.getJobManager().cancel(ModelJobs.newFutureFilterBuilder().andMatch((Predicate)new SessionFutureFilter((ISession)ISession.CURRENT.get())).andMatchState(new JobState[]{JobState.WAITING_FOR_BLOCKING_CONDITION}).toFilter(), true);
    }

    protected void internalCloseDesktopExtensions() {
        for (IDesktopExtension ext : this.getDesktopExtensions()) {
            try {
                ContributionCommand cc = ext.desktopClosingDelegate();
                if (cc != ContributionCommand.Stop) continue;
                break;
            }
            catch (RuntimeException | PlatformError t) {
                LOG.error("extension {}", (Object)ext, (Object)t);
            }
        }
    }

    protected void internalCloseMessageBoxes(List<IMessageBox> list) {
        for (IMessageBox m : list) {
            if (m == null) continue;
            try {
                try {
                    m.doClose();
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.error("Exception while closing messagebox", e);
                    this.m_messageBoxStore.remove(m);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.m_messageBoxStore.remove(m);
                throw throwable;
            }
            this.m_messageBoxStore.remove(m);
        }
    }

    protected void internalCloseFileChoosers(List<IFileChooser> list) {
        for (IFileChooser f : list) {
            if (f == null) continue;
            try {
                try {
                    f.doClose();
                }
                catch (RuntimeException | PlatformError e) {
                    LOG.error("Exception while closing FileChooser", e);
                    this.m_fileChooserStore.remove(f);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.m_fileChooserStore.remove(f);
                throw throwable;
            }
            this.m_fileChooserStore.remove(f);
        }
    }

    protected boolean internalCloseForms(Collection<IForm> forms) {
        for (IForm form : forms) {
            if (form == null) continue;
            try {
                this.internalCloseMessageBoxes(this.getMessageBoxes(form));
                this.internalCloseFileChoosers(this.getFileChoosers(form));
                try {
                    form.doClose();
                }
                finally {
                    form.dispose();
                }
            }
            catch (RuntimeException | PlatformError e) {
                LOG.error("Exception while closing forms", e);
            }
        }
        return true;
    }

    protected int getAttachedCount() {
        return this.m_attachedCount;
    }

    private void setAttachedGuiCount(int attachedGuiCount) {
        this.m_attachedGuiCount = attachedGuiCount;
        this.propertySupport.setPropertyBool("guiAvailable", this.m_attachedGuiCount > 0);
    }

    private void attachGui() {
        ++this.m_attachedCount;
        this.setAttachedGuiCount(this.m_attachedGuiCount + 1);
        if (this.m_attachedGuiCount == 1) {
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.guiAttachedDelegate();
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Exception e) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                }
            }
        }
        PropertyMap params = this.getStartupRequestParams();
        String geolocationServiceAvailableStr = (String)params.get((Object)"geolocationServiceAvailable");
        boolean geolocationServiceAvailable = (Boolean)TypeCastUtility.castValue((Object)geolocationServiceAvailableStr, Boolean.TYPE);
        this.setGeolocationServiceAvailable(geolocationServiceAvailable);
        boolean handleDeepLink = (Boolean)params.getOrDefault((Object)"handleDeepLink", (Object)true);
        if (handleDeepLink) {
            String deepLinkPath = (String)params.get((Object)"dl");
            this.activateDefaultView(deepLinkPath);
        }
    }

    protected void activateDefaultView(String deepLinkPath) {
        if (this.safeHandleDeepLink(deepLinkPath)) {
            return;
        }
        if (this.m_attachedCount <= 1) {
            try {
                this.m_activatingDefaultView = true;
                this.interceptDefaultView();
            }
            finally {
                this.m_activatingDefaultView = false;
            }
        }
    }

    protected boolean safeHandleDeepLink(String deepLinkPath) {
        try {
            if (this.handleDeepLink(deepLinkPath)) {
                return true;
            }
        }
        catch (DeepLinkException e) {
            LOG.info("Failed to execute deep-link '{}', reason: {}", (Object)deepLinkPath, (Object)e.getMessage());
            this.showDeepLinkError(e);
        }
        return false;
    }

    @Override
    public void doLogoAction() {
        if (this.isLogoActionEnabled()) {
            this.interceptLogoAction();
        }
    }

    protected boolean handleDeepLink(String deepLinkPath) throws DeepLinkException {
        if (this.hasApplicationModalElement()) {
            LOG.debug("Could not handle deep-link because modal element prevents changes on UI state. deepLinkPath={}", (Object)deepLinkPath);
            return false;
        }
        if (StringUtility.isNullOrEmpty((CharSequence)deepLinkPath)) {
            return false;
        }
        BrowserHistoryEntry entry = this.getBrowserHistoryEntry();
        if (entry != null && deepLinkPath.equals(entry.getDeepLinkPath())) {
            return false;
        }
        boolean handled = false;
        IDeepLinks deepLinks = (IDeepLinks)BEANS.get(IDeepLinks.class);
        if (deepLinks.canHandleDeepLink(deepLinkPath)) {
            try {
                handled = deepLinks.handleDeepLink(deepLinkPath);
            }
            catch (RuntimeException e) {
                throw new DeepLinkException(e);
            }
        } else {
            throw new DeepLinkException("No deep-link handler found. deepLinkPath={" + deepLinkPath + " }");
        }
        return handled;
    }

    protected boolean hasApplicationModalElement() {
        if (this.m_messageBoxStore.containsApplicationModalMessageBoxes()) {
            return true;
        }
        if (this.m_formStore.containsApplicationModalDialogs()) {
            return true;
        }
        return this.m_fileChooserStore.containsApplicationModalFileChoosers();
    }

    protected void showDeepLinkError(DeepLinkException e) {
        if (e.getCause() instanceof VetoException) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e.getCause());
        } else {
            String errorMessage = TEXTS.get((String)"DeepLinkError");
            MessageBoxes.createOk().withBody(errorMessage).show();
        }
    }

    private void detachGui() {
        this.setAttachedGuiCount(this.m_attachedGuiCount - 1);
        if (this.m_attachedGuiCount == 0) {
            this.setReadyInternal(false);
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.guiDetachedDelegate();
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Exception e) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                }
            }
        }
    }

    public boolean runMenu(Class<? extends IMenu> menuType) {
        for (IMenu m : this.getMenus()) {
            if (!this.runMenuRec(m, menuType)) continue;
            return true;
        }
        return false;
    }

    private boolean runMenuRec(IMenu m, Class<? extends IMenu> menuType) {
        if (m.getClass() == menuType) {
            if (m.isVisible() && m.isEnabled()) {
                m.doAction();
                return true;
            }
            return false;
        }
        for (IMenu c : m.getChildActions()) {
            if (!this.runMenuRec(c, menuType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<Object> getAddOns() {
        return Collections.unmodifiableCollection(this.m_addOns);
    }

    @Override
    public <T> T getAddOn(Class<T> addOnClass) {
        return this.m_addOns.stream().filter(a -> addOnClass.isAssignableFrom(a.getClass())).map(addOnClass::cast).findAny().orElse(null);
    }

    @Override
    public void addAddOn(Object addOn) {
        this.m_addOns.add(addOn);
    }

    @Override
    public void removeAddOn(Object addOn) {
        this.m_addOns.remove(addOn);
    }

    @Override
    public IDesktopUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private boolean isForcedClosing() {
        return this.m_isForcedClosing;
    }

    private void setForcedClosing(boolean forcedClosing) {
        this.m_isForcedClosing = forcedClosing;
    }

    @Override
    public void setNavigationVisible(boolean visible) {
        this.propertySupport.setProperty("navigationVisible", (Object)visible);
    }

    @Override
    public boolean isNavigationVisible() {
        return (Boolean)this.propertySupport.getProperty("navigationVisible");
    }

    @Override
    public void setNavigationHandleVisible(boolean visible) {
        this.propertySupport.setProperty("navigationHandleVisible", (Object)visible);
    }

    @Override
    public boolean isNavigationHandleVisible() {
        return (Boolean)this.propertySupport.getProperty("navigationHandleVisible");
    }

    @Override
    public void setBenchVisible(boolean visible) {
        this.propertySupport.setProperty("benchVisible", (Object)visible);
    }

    @Override
    public boolean isBenchVisible() {
        return (Boolean)this.propertySupport.getProperty("benchVisible");
    }

    @Override
    public BenchLayoutData getBenchLayoutData() {
        return (BenchLayoutData)this.propertySupport.getProperty("benchLayoutData");
    }

    @Override
    public void setBenchLayoutData(BenchLayoutData layoutData) {
        this.propertySupport.setProperty("benchLayoutData", (Object)layoutData);
    }

    @Override
    public void setHeaderVisible(boolean visible) {
        this.propertySupport.setProperty("headerVisible", (Object)visible);
    }

    @Override
    public boolean isHeaderVisible() {
        return (Boolean)this.propertySupport.getProperty("headerVisible");
    }

    protected void setInBackground(boolean inBackground) {
        this.propertySupport.setPropertyBool("inBackground", inBackground);
        this.m_dataChangeDesktopInForegroundListeners.setBuffering(inBackground || this.isDataChanging());
    }

    @Override
    public boolean isInBackground() {
        return this.propertySupport.getPropertyBool("inBackground");
    }

    @Override
    public boolean isLogoActionEnabled() {
        return this.propertySupport.getPropertyBool("logoActionEnabled");
    }

    @Override
    public void setLogoActionEnabled(boolean logoActionEnabled) {
        this.propertySupport.setPropertyBool("logoActionEnabled", logoActionEnabled);
    }

    @Override
    public void setDense(boolean dense) {
        this.propertySupport.setPropertyBool("dense", dense);
    }

    @Override
    public boolean isDense() {
        return this.propertySupport.getPropertyBool("dense");
    }

    @Override
    public boolean doBeforeClosingInternal() {
        return this.isForcedClosing() || this.continueClosingInDesktopExtensions() && this.continueClosingConsideringUnsavedForms(this.getUnsavedForms(), true);
    }

    protected boolean continueClosingConsideringUnsavedForms(List<IForm> forms, boolean isStopSession) {
        if (forms.isEmpty()) {
            return true;
        }
        try {
            UnsavedFormChangesForm f = new UnsavedFormChangesForm(forms, isStopSession);
            f.startNew();
            f.waitFor();
            if (f.getCloseSystemType() == 1) {
                return false;
            }
        }
        catch (RuntimeException | PlatformError e) {
            LOG.error("Error closing forms", e);
        }
        return true;
    }

    private boolean continueClosingInDesktopExtensions() {
        boolean continueClosing = true;
        List<IDesktopExtension> extensions = this.getDesktopExtensions();
        if (extensions != null) {
            for (IDesktopExtension ext : extensions) {
                try {
                    ContributionCommand cc = ext.desktopBeforeClosingDelegate();
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (VetoException e) {
                    continueClosing = false;
                }
                catch (RuntimeException | PlatformError e) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle(e);
                }
            }
        }
        return continueClosing;
    }

    @Override
    public List<IForm> getUnsavedForms() {
        return this.getUnsavedForms(null);
    }

    protected List<IForm> getUnsavedForms(Set<IForm> formSet) {
        ArrayList<IForm> saveNeededForms = new ArrayList<IForm>();
        List showedForms = this.m_formStore.values();
        if (formSet != null) {
            for (IForm form : showedForms) {
                if (!formSet.contains(form.getDisplayParent())) continue;
                formSet.add(form);
            }
        }
        int i = showedForms.size() - 1;
        while (i >= 0) {
            IForm f = (IForm)showedForms.get(i);
            if ((formSet == null || formSet.contains(f)) && f.isAskIfNeedSave() && f.isSaveNeeded()) {
                saveNeededForms.add(f);
            }
            --i;
        }
        return saveNeededForms;
    }

    @Override
    public boolean cancelForms(Set<IForm> formSet, boolean alwaysShowUnsavedChangesForm) {
        if (formSet == null || formSet.isEmpty()) {
            return true;
        }
        formSet = formSet.stream().filter(form -> this.getForms((IDisplayParent)form).stream().noneMatch(IForm::isModal)).collect(Collectors.toSet());
        if (!alwaysShowUnsavedChangesForm && formSet.size() == 1) {
            IForm form2 = (IForm)CollectionUtility.firstElement(formSet);
            form2.activate();
            form2.doCancel();
            return true;
        }
        return this.continueClosingConsideringUnsavedForms(this.getUnsavedForms(formSet), false) && this.internalCloseForms(formSet);
    }

    @Override
    public boolean cancelForms(Set<IForm> formSet) {
        return this.cancelForms(formSet, false);
    }

    @Override
    public void closeForms(Set<IForm> formSet) {
        if (formSet == null || formSet.isEmpty()) {
            return;
        }
        this.getUnsavedForms(formSet);
        this.internalCloseForms(formSet);
    }

    @Override
    public String getTheme() {
        return this.propertySupport.getPropertyString("theme");
    }

    @Override
    public void setTheme(String theme) {
        this.propertySupport.setProperty("theme", (Object)theme);
    }

    @Override
    public NativeNotificationDefaults getNativeNotificationDefaults() {
        return (NativeNotificationDefaults)this.propertySupport.getProperty("nativeNotificationDefaults");
    }

    @Override
    public void setNativeNotificationDefaults(NativeNotificationDefaults nativeNotificationDefaults) {
        this.propertySupport.setProperty("nativeNotificationDefaults", (Object)nativeNotificationDefaults);
    }

    protected final void interceptOpened() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopOpenedChain chain = new DesktopChains.DesktopOpenedChain(extensions);
        chain.execOpened();
    }

    protected final void interceptBeforeClosing() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopBeforeClosingChain chain = new DesktopChains.DesktopBeforeClosingChain(extensions);
        chain.execBeforeClosing();
    }

    protected final void interceptPageDetailFormChanged(IForm oldForm, IForm newForm) {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopPageDetailFormChangedChain chain = new DesktopChains.DesktopPageDetailFormChangedChain(extensions);
        chain.execPageDetailFormChanged(oldForm, newForm);
    }

    protected final void interceptTablePageLoaded(IPageWithTable<?> tablePage) {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopTablePageLoadedChain chain = new DesktopChains.DesktopTablePageLoadedChain(extensions);
        chain.execTablePageLoaded(tablePage);
    }

    protected final void interceptOutlineChanged(IOutline oldOutline, IOutline newOutline) {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopOutlineChangedChain chain = new DesktopChains.DesktopOutlineChangedChain(extensions);
        chain.execOutlineChanged(oldOutline, newOutline);
    }

    protected final IForm interceptFormAboutToShow(IForm form) {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopFormAboutToShowChain chain = new DesktopChains.DesktopFormAboutToShowChain(extensions);
        return chain.execFormAboutToShow(form);
    }

    protected final void interceptClosing() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopClosingChain chain = new DesktopChains.DesktopClosingChain(extensions);
        chain.execClosing();
    }

    protected final void interceptPageSearchFormChanged(IForm oldForm, IForm newForm) {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopPageSearchFormChangedChain chain = new DesktopChains.DesktopPageSearchFormChangedChain(extensions);
        chain.execPageSearchFormChanged(oldForm, newForm);
    }

    protected final void interceptPageDetailTableChanged(ITable oldTable, ITable newTable) {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopPageDetailTableChangedChain chain = new DesktopChains.DesktopPageDetailTableChangedChain(extensions);
        chain.execPageDetailTableChanged(oldTable, newTable);
    }

    protected final void interceptGuiAttached() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopGuiAttachedChain chain = new DesktopChains.DesktopGuiAttachedChain(extensions);
        chain.execGuiAttached();
    }

    protected final void interceptGuiDetached() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopGuiDetachedChain chain = new DesktopChains.DesktopGuiDetachedChain(extensions);
        chain.execGuiDetached();
    }

    protected final void interceptDefaultView() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopDefaultViewChain chain = new DesktopChains.DesktopDefaultViewChain(extensions);
        chain.execDefaultView();
    }

    protected final void interceptLogoAction() {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopLogoActionChain chain = new DesktopChains.DesktopLogoActionChain(extensions);
        chain.execLogoAction();
    }

    protected static class LocalDesktopExtension<DESKTOP extends AbstractDesktop>
    extends AbstractExtension<DESKTOP>
    implements org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<DESKTOP> {
        public LocalDesktopExtension(DESKTOP desktop) {
            super(desktop);
        }

        @Override
        public void execInit(DesktopChains.DesktopInitChain chain) {
            ((AbstractDesktop)this.getOwner()).execInit();
        }

        @Override
        public void execOpened(DesktopChains.DesktopOpenedChain chain) {
            ((AbstractDesktop)this.getOwner()).execOpened();
        }

        @Override
        public void execBeforeClosing(DesktopChains.DesktopBeforeClosingChain chain) {
            ((AbstractDesktop)this.getOwner()).execBeforeClosing();
        }

        @Override
        public void execPageDetailFormChanged(DesktopChains.DesktopPageDetailFormChangedChain chain, IForm oldForm, IForm newForm) {
            ((AbstractDesktop)this.getOwner()).execPageDetailFormChanged(oldForm, newForm);
        }

        @Override
        public void execTablePageLoaded(DesktopChains.DesktopTablePageLoadedChain chain, IPageWithTable<?> tablePage) {
            ((AbstractDesktop)this.getOwner()).execTablePageLoaded(tablePage);
        }

        @Override
        public void execOutlineChanged(DesktopChains.DesktopOutlineChangedChain chain, IOutline oldOutline, IOutline newOutline) {
            ((AbstractDesktop)this.getOwner()).execOutlineChanged(oldOutline, newOutline);
        }

        @Override
        public IForm execFormAboutToShow(DesktopChains.DesktopFormAboutToShowChain chain, IForm form) {
            return ((AbstractDesktop)this.getOwner()).execFormAboutToShow(form);
        }

        @Override
        public void execClosing(DesktopChains.DesktopClosingChain chain) {
            ((AbstractDesktop)this.getOwner()).execClosing();
        }

        @Override
        public void execPageSearchFormChanged(DesktopChains.DesktopPageSearchFormChangedChain chain, IForm oldForm, IForm newForm) {
            ((AbstractDesktop)this.getOwner()).execPageSearchFormChanged(oldForm, newForm);
        }

        @Override
        public void execPageDetailTableChanged(DesktopChains.DesktopPageDetailTableChangedChain chain, ITable oldTable, ITable newTable) {
            ((AbstractDesktop)this.getOwner()).execPageDetailTableChanged(oldTable, newTable);
        }

        @Override
        public void execGuiAttached(DesktopChains.DesktopGuiAttachedChain chain) {
            ((AbstractDesktop)this.getOwner()).execGuiAttached();
        }

        @Override
        public void execGuiDetached(DesktopChains.DesktopGuiDetachedChain chain) {
            ((AbstractDesktop)this.getOwner()).execGuiDetached();
        }

        @Override
        public void execDefaultView(DesktopChains.DesktopDefaultViewChain chain) {
            ((AbstractDesktop)this.getOwner()).execDefaultView();
        }

        @Override
        public void execLogoAction(DesktopChains.DesktopLogoActionChain chain) {
            ((AbstractDesktop)this.getOwner()).execLogoAction();
        }
    }

    private class P_ActiveOutlineListener
    implements PropertyChangeListener {
        private P_ActiveOutlineListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("detailForm")) {
                AbstractDesktop.this.setPageDetailForm(((IOutline)e.getSource()).getDetailForm());
            } else if (e.getPropertyName().equals("detailTable")) {
                AbstractDesktop.this.setPageDetailTable(((IOutline)e.getSource()).getDetailTable());
            } else if (e.getPropertyName().equals("searchForm")) {
                AbstractDesktop.this.setPageSearchForm(((IOutline)e.getSource()).getSearchForm());
            }
        }
    }

    private class P_LocalDesktopExtension
    implements IDesktopExtension {
        private P_LocalDesktopExtension() {
        }

        @Override
        public IDesktop getCoreDesktop() {
            return AbstractDesktop.this;
        }

        @Override
        public void setCoreDesktop(IDesktop desktop) {
        }

        @Override
        public void contributeOutlines(OrderedCollection<IOutline> outlines) {
            List<Class<? extends IOutline>> configuredOutlines = AbstractDesktop.this.getConfiguredOutlines();
            if (configuredOutlines != null) {
                for (Class<? extends IOutline> element : configuredOutlines) {
                    try {
                        IOutline o = element.getConstructor(new Class[0]).newInstance(new Object[0]);
                        outlines.addOrdered((IOrdered)o);
                    }
                    catch (Exception e) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + element.getName() + "'.", new Object[]{e}));
                    }
                }
            }
        }

        @Override
        public void contributeActions(Collection<IAction> actions) {
            for (Class<? extends IAction> actionClazz : AbstractDesktop.this.getConfiguredActions()) {
                actions.add((IAction)ConfigurationUtility.newInnerInstance((Object)AbstractDesktop.this, actionClazz));
            }
        }

        @Override
        public ContributionCommand initDelegate() {
            AbstractDesktop.this.interceptInit();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopOpenedDelegate() {
            AbstractDesktop.this.interceptOpened();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopBeforeClosingDelegate() {
            AbstractDesktop.this.interceptBeforeClosing();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopClosingDelegate() {
            AbstractDesktop.this.interceptClosing();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand guiAttachedDelegate() {
            AbstractDesktop.this.interceptGuiAttached();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand guiDetachedDelegate() {
            AbstractDesktop.this.interceptGuiDetached();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand outlineChangedDelegate(IOutline oldOutline, IOutline newOutline) {
            AbstractDesktop.this.interceptOutlineChanged(oldOutline, newOutline);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand formAboutToShowDelegate(IHolder<IForm> formHolder) {
            formHolder.setValue((Object)AbstractDesktop.this.interceptFormAboutToShow((IForm)formHolder.getValue()));
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageSearchFormChangedDelegate(IForm oldForm, IForm newForm) {
            AbstractDesktop.this.interceptPageSearchFormChanged(oldForm, newForm);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageDetailFormChangedDelegate(IForm oldForm, IForm newForm) {
            AbstractDesktop.this.interceptPageDetailFormChanged(oldForm, newForm);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageDetailTableChangedDelegate(ITable oldTable, ITable newTable) {
            AbstractDesktop.this.interceptPageDetailTableChanged(oldTable, newTable);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand tablePageLoadedDelegate(IPageWithTable<?> tablePage) {
            AbstractDesktop.this.interceptTablePageLoaded(tablePage);
            return ContributionCommand.Continue;
        }
    }

    protected class P_LocalPropertyChangeListener
    implements PropertyChangeListener {
        protected P_LocalPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("displayStyle".equals(evt.getPropertyName())) {
                AbstractDesktop.this.initDisplayStyle((String)evt.getNewValue());
            }
        }
    }

    protected class P_UIFacade
    implements IDesktopUIFacade {
        protected P_UIFacade() {
        }

        @Override
        public void historyEntryActivateFromUI(String deepLinkPath) {
            try {
                AbstractDesktop.this.handleDeepLink(deepLinkPath);
            }
            catch (DeepLinkException e) {
                AbstractDesktop.this.showDeepLinkError(e);
            }
        }

        @Override
        public void fireGuiAttached() {
            AbstractDesktop.this.attachGui();
        }

        @Override
        public void fireGuiDetached() {
            AbstractDesktop.this.detachGui();
        }

        @Override
        public void readyFromUI() {
            AbstractDesktop.this.setReadyInternal(true);
        }

        @Override
        public void openFromUI() {
            AbstractDesktop.this.setOpenedInternal(true);
            for (IDesktopExtension ext : AbstractDesktop.this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.desktopOpenedDelegate();
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Exception e) {
                    ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
                }
            }
        }

        @Override
        public void closeFromUI(boolean forcedClosing) {
            AbstractDesktop.this.setForcedClosing(forcedClosing);
            AbstractDesktop.this.setReadyInternal(false);
            if (forcedClosing) {
                AbstractDesktop.this.setOpenedInternal(false);
            }
            ClientSessionProvider.currentSession().stop();
        }

        @Override
        public void activateForm(IForm form) {
            if (form == null) {
                AbstractDesktop.this.m_selectedViewTabs.remove("C");
            }
            AbstractDesktop.this.activateForm(form);
        }

        @Override
        public void setFocusedElementFromUI(IWidget widget) {
            AbstractDesktop.this.setFocusedElement(widget);
        }

        @Override
        public void setNavigationVisibleFromUI(boolean visible) {
            AbstractDesktop.this.setNavigationVisible(visible);
        }

        @Override
        public void setNavigationHandleVisibleFromUI(boolean visible) {
            AbstractDesktop.this.setNavigationHandleVisible(visible);
        }

        @Override
        public void setHeaderVisibleFromUI(boolean visible) {
            AbstractDesktop.this.setHeaderVisible(visible);
        }

        @Override
        public void setBenchVisibleFromUI(boolean visible) {
            AbstractDesktop.this.setBenchVisible(visible);
        }

        @Override
        public void setInBackgroundFromUI(boolean inBackground) {
            AbstractDesktop.this.setInBackground(inBackground);
        }

        @Override
        public void setGeoLocationServiceAvailableFromUI(boolean available) {
            AbstractDesktop.this.setGeolocationServiceAvailable(available);
        }

        @Override
        public void initStartupRequestParamsFromUI() {
            AbstractDesktop.this.initStartupRequestParams();
        }

        @Override
        public void fireLogoAction() {
            AbstractDesktop.this.doLogoAction();
        }

        @Override
        public void removedNotificationFromUI(IDesktopNotification notification) {
            AbstractDesktop.this.removeNotificationInternal(notification, false);
        }
    }
}

