/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeTraversals;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;

public final class TreeUtility {
    private TreeUtility() {
    }

    public static ITreeNode calculateCommonParentNode(Collection<? extends ITreeNode> nodes) {
        if (CollectionUtility.isEmpty(nodes)) {
            return null;
        }
        Iterator<? extends ITreeNode> nodeIt = nodes.iterator();
        ITreeNode commonParent = nodeIt.next().getParentNode();
        while (nodeIt.hasNext()) {
            if (nodeIt.next().getParentNode() == commonParent) continue;
            return null;
        }
        return commonParent;
    }

    public static ITreeNode findLowestCommonAncestorNode(List<ITreeNode> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.get(0).getParentNode();
        }
        ITreeNode commonParent = nodes.get(0).getParentNode();
        int i = 1;
        while (i < nodes.size()) {
            ITreeNode parentNode = nodes.get(i).getParentNode();
            if (parentNode != commonParent) {
                commonParent = TreeUtility.findLowestCommonAncestorNode(commonParent, parentNode);
            }
            ++i;
        }
        return commonParent;
    }

    public static ITreeNode findLowestCommonAncestorNode(ITreeNode firstNode, ITreeNode secondNode) {
        if (firstNode == null || secondNode == null) {
            return null;
        }
        if (firstNode.getTree() != secondNode.getTree()) {
            return null;
        }
        if (firstNode.getParentNode() == secondNode.getParentNode()) {
            return firstNode.getParentNode();
        }
        if (secondNode.getTreeLevel() > firstNode.getTreeLevel()) {
            secondNode = TreeUtility.findAncestorNodeAtLevel(secondNode, firstNode.getTreeLevel());
        } else if (firstNode.getTreeLevel() > secondNode.getTreeLevel()) {
            firstNode = TreeUtility.findAncestorNodeAtLevel(firstNode, secondNode.getTreeLevel());
        }
        while (firstNode.getParentNode() != secondNode.getParentNode()) {
            firstNode = firstNode.getParentNode();
            secondNode = secondNode.getParentNode();
        }
        return firstNode.getParentNode();
    }

    /*
     * Unable to fully structure code
     */
    public static ITreeNode findAncestorNodeAtLevel(ITreeNode node, int level) {
        if (node == null) {
            return null;
        }
        if (node.getTreeLevel() >= level) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.getParentNode();
lbl6:
            // 2 sources

            ** while (node.getTreeLevel() > level)
        }
lbl7:
        // 1 sources

        return node;
    }

    public static TreeVisitResult visitNodes(Collection<ITreeNode> nodes, IDepthFirstTreeVisitor<ITreeNode> v) {
        return TreeUtility.visitNodes(nodes, v, ITreeNode::getChildNodes);
    }

    public static TreeVisitResult visitNodes(Collection<ITreeNode> nodes, IDepthFirstTreeVisitor<ITreeNode> v, Function<ITreeNode, Collection<? extends ITreeNode>> childrenSupplier) {
        if (CollectionUtility.isEmpty(nodes)) {
            return TreeVisitResult.CONTINUE;
        }
        for (ITreeNode node : nodes) {
            TreeVisitResult result;
            if (node == null || (result = TreeUtility.visitNode(node, v, childrenSupplier)) != TreeVisitResult.TERMINATE && result != TreeVisitResult.SKIP_SIBLINGS) continue;
            return result;
        }
        return TreeVisitResult.CONTINUE;
    }

    public static TreeVisitResult visitNode(ITreeNode node, IDepthFirstTreeVisitor<ITreeNode> visitor) {
        return TreeUtility.visitNode(node, visitor, ITreeNode::getChildNodes);
    }

    public static TreeVisitResult visitNode(ITreeNode node, IDepthFirstTreeVisitor<ITreeNode> visitor, Function<ITreeNode, Collection<? extends ITreeNode>> childrenSupplier) {
        return TreeTraversals.create(visitor, childrenSupplier.andThen(TreeUtility::filterNodesWithoutTree)).traverse((Object)node);
    }

    private static List<? extends ITreeNode> filterNodesWithoutTree(Collection<? extends ITreeNode> candidates) {
        ArrayList<ITreeNode> result = new ArrayList<ITreeNode>(candidates.size());
        for (ITreeNode iTreeNode : candidates) {
            if (iTreeNode == null || iTreeNode.getTree() == null) continue;
            result.add(iTreeNode);
        }
        return result;
    }
}

