/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeNodeExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.TreeNodeChains;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.IContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPage;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.concurrent.OptimisticLock;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeNode
implements ITreeNode,
ICellObserver,
IContributionOwner,
IExtensibleObject {
    private static final String INITIALIZED = "INITIALIZED";
    private static final String DISPOSING = "DISPOSING";
    private static final String CHILDREN_DIRTY = "CHILDREN_DIRTY";
    private static final String CHILDREN_LOADED = "CHILDREN_LOADED";
    private static final String CHILDREN_VOLATILE = "CHILDREN_VOLATILE";
    private static final String FILTER_ACCEPTED = "FILTER_ACCEPTED";
    private static final String LEAF = "LEAF";
    private static final String REJECTED_BY_USER = "REJECTED_BY_USER";
    private static final String EXPANDED = "EXPANDED";
    private static final String EXPANDED_LAZY = "EXPANDED_LAZY";
    private static final String INITIALLY_EXPANDED = "INITIALLY_EXPANDED";
    private static final String LAZY_EXPANDING_ENABLED = "LAZY_EXPANDING_ENABLED";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTreeNode.class);
    private static final NamedBitMaskHelper VISIBLE_BIT_HELPER = new NamedBitMaskHelper(new String[]{"VISIBLE", "VISIBLE_GRANTED"});
    private static final NamedBitMaskHelper ENABLED_BIT_HELPER = new NamedBitMaskHelper(new String[]{"ENABLED", "ENABLED_GRANTED"});
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"INITIALIZED", "CHILDREN_DIRTY", "CHILDREN_LOADED", "CHILDREN_VOLATILE", "FILTER_ACCEPTED", "LEAF", "REJECTED_BY_USER", "DISPOSING"});
    private static final NamedBitMaskHelper EXPANDED_BIT_HELPER = new NamedBitMaskHelper(new String[]{"EXPANDED", "EXPANDED_LAZY", "INITIALLY_EXPANDED", "LAZY_EXPANDING_ENABLED"});
    private int m_initializing = 0;
    private ITree m_tree;
    private ITreeNode m_parentNode;
    private ITreeNode m_oldParentNode;
    private final Object m_childNodeListLock;
    private final Object m_filteredChildNodesLock;
    private final OptimisticLock m_childrenLoadedLock;
    private final Cell m_cell;
    private List<ITreeNode> m_childNodeList;
    private volatile List<ITreeNode> m_filteredChildNodes;
    private int m_status;
    private List<IMenu> m_menus;
    private int m_childNodeIndex;
    private Object m_primaryKey;
    private byte m_expanded;
    private byte m_enabled;
    private byte m_visible;
    private byte m_flags;
    protected IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractTreeNode, ITreeNodeExtension<? extends AbstractTreeNode>> m_objectExtensions;

    public AbstractTreeNode() {
        this(true);
    }

    public AbstractTreeNode(boolean callInitializer) {
        this.setFilterAccepted(true);
        this.m_childNodeListLock = new Object();
        this.m_childNodeList = new ArrayList<ITreeNode>();
        this.m_filteredChildNodesLock = new Object();
        this.m_childrenLoadedLock = new OptimisticLock();
        this.m_cell = new Cell(this);
        this.m_enabled = (byte)-1;
        this.m_visible = (byte)-1;
        this.m_objectExtensions = new ObjectExtensions((Object)this, this instanceof AbstractPage);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.isInitialized()) {
            this.interceptInitConfig();
            this.initTreeNode();
            this.m_flags = FLAGS_BIT_HELPER.setBit(INITIALIZED, this.m_flags);
        }
    }

    protected boolean isInitialized() {
        return FLAGS_BIT_HELPER.isBitSet(INITIALIZED, this.m_flags);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=20.0)
    protected boolean getConfiguredLeaf() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredExpanded() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredLazyExpandingEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execInitTreeNode() {
    }

    @ConfigOperation
    @Order(value=25.0)
    protected void execDispose() {
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execDecorateCell(Cell cell) {
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfigAndBackupExtensionContext(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        this.setLeafInternal(this.getConfiguredLeaf());
        this.setEnabled(this.getConfiguredEnabled(), "ENABLED");
        this.setExpandedInternal(this.getConfiguredExpanded());
        this.setLazyExpandingEnabled(this.getConfiguredLazyExpandingEnabled());
        this.setExpandedLazyInternal(this.isLazyExpandingEnabled());
        this.setInitialExpanded(this.getConfiguredExpanded());
        this.m_contributionHolder = new ContributionComposite((Object)this);
    }

    public final List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ITreeNodeExtension<? extends AbstractTreeNode> createLocalExtension() {
        return new LocalTreeNodeExtension<AbstractTreeNode>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void runInExtensionContext(Runnable runnable) {
        this.m_objectExtensions.runInExtensionContext(runnable);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public void initTreeNode() {
        this.setInitializing(true);
        try {
            for (ITreeNode childNode : this.getChildNodes()) {
                childNode.initTreeNode();
            }
            this.interceptInitTreeNode();
        }
        finally {
            this.setInitializing(false);
        }
    }

    @Override
    public boolean isInitializing() {
        return this.m_initializing > 0;
    }

    @Override
    public void setInitializing(boolean b) {
        this.m_initializing = b ? ++this.m_initializing : --this.m_initializing;
    }

    @Override
    public String getNodeId() {
        String s = this.getClass().getName();
        int i = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
        s = s.substring(i + 1);
        return s;
    }

    @Override
    public int getStatus() {
        return this.m_status;
    }

    @Override
    public void setStatusInternal(int status) {
        this.m_status = status;
    }

    @Override
    public void setStatus(int status) {
        if (this.getTree() != null) {
            this.getTree().setNodeStatus(this, status);
        } else {
            this.setStatusInternal(status);
        }
    }

    @Override
    public boolean isStatusInserted() {
        return this.m_status == 1;
    }

    @Override
    public boolean isStatusUpdated() {
        return this.m_status == 2;
    }

    @Override
    public boolean isStatusDeleted() {
        return this.m_status == 3;
    }

    @Override
    public boolean isStatusNonchanged() {
        return this.m_status == 0;
    }

    @Override
    public boolean isSelectedNode() {
        if (this.getTree() != null) {
            return this.getTree().isSelectedNode(this);
        }
        return false;
    }

    @Override
    public boolean isFilterAccepted() {
        return FLAGS_BIT_HELPER.isBitSet(FILTER_ACCEPTED, this.m_flags);
    }

    @Override
    public void setFilterAccepted(boolean b) {
        if (FLAGS_BIT_HELPER.isBit(FILTER_ACCEPTED, this.m_flags, b)) {
            return;
        }
        this.m_flags = FLAGS_BIT_HELPER.changeBit(FILTER_ACCEPTED, b, this.m_flags);
        if (this.getParentNode() != null) {
            this.getParentNode().resetFilterCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFilterCache() {
        Object object = this.m_filteredChildNodesLock;
        synchronized (object) {
            this.m_filteredChildNodes = null;
        }
    }

    @Override
    public boolean isRejectedByUser() {
        return FLAGS_BIT_HELPER.isBitSet(REJECTED_BY_USER, this.m_flags);
    }

    @Override
    public void setRejectedByUser(boolean rejectedByUser) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(REJECTED_BY_USER, rejectedByUser, this.m_flags);
    }

    @Override
    public final ICell getCell() {
        return this.m_cell;
    }

    @Override
    public final Cell getCellForUpdate() {
        return this.m_cell;
    }

    @Override
    public final void decorateCell() {
        try {
            this.interceptDecorateCell(this.m_cell);
        }
        catch (Exception t) {
            LOG.error("node {} {}", new Object[]{this.getClass(), this.toPlainText(), t});
        }
    }

    @Override
    public boolean isLeaf() {
        return FLAGS_BIT_HELPER.isBitSet(LEAF, this.m_flags);
    }

    @Override
    public void setLeafInternal(boolean leaf) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(LEAF, leaf, this.m_flags);
    }

    @Override
    public void setLeaf(boolean b) {
        ITree tree = this.getTree();
        if (tree != null) {
            tree.setNodeLeaf(this, b);
        } else {
            this.setLeafInternal(b);
        }
    }

    @Override
    public boolean isChecked() {
        if (this.getTree() != null) {
            return this.getTree().isNodeChecked(this);
        }
        return false;
    }

    @Override
    public void setChecked(boolean checked) {
        if (this.getTree() != null) {
            this.getTree().setNodeChecked(this, checked);
        }
    }

    @Override
    public void setChecked(boolean checked, boolean enabledNodesOnly) {
        if (this.getTree() != null) {
            this.getTree().setNodeChecked(this, checked, enabledNodesOnly);
        }
    }

    @Override
    public void setChecked(boolean checked, boolean enabledNodesOnly, boolean forceUpdateNode) {
        if (this.getTree() != null) {
            this.getTree().setNodeChecked(this, checked, enabledNodesOnly, forceUpdateNode);
        }
    }

    @Override
    public boolean isExpanded() {
        return EXPANDED_BIT_HELPER.isBitSet(EXPANDED, this.m_expanded);
    }

    @Override
    public void setExpandedInternal(boolean expanded) {
        this.m_expanded = EXPANDED_BIT_HELPER.changeBit(EXPANDED, expanded, this.m_expanded);
    }

    @Override
    public boolean isInitialExpanded() {
        return EXPANDED_BIT_HELPER.isBitSet(INITIALLY_EXPANDED, this.m_expanded);
    }

    @Override
    public void setInitialExpanded(boolean expanded) {
        this.m_expanded = EXPANDED_BIT_HELPER.changeBit(INITIALLY_EXPANDED, expanded, this.m_expanded);
    }

    @Override
    public void setExpanded(boolean b) {
        if (this.getTree() != null) {
            this.getTree().setNodeExpanded(this, b);
        } else {
            this.setExpandedInternal(b);
        }
    }

    @Override
    public void setExpanded(boolean b, boolean lazy) {
        if (this.getTree() != null) {
            this.getTree().setNodeExpanded(this, b, lazy);
        } else {
            this.setExpandedInternal(b);
            this.setExpandedLazyInternal(lazy);
        }
    }

    @Override
    public boolean isExpandedLazy() {
        return EXPANDED_BIT_HELPER.isBitSet(EXPANDED_LAZY, this.m_expanded);
    }

    @Override
    public void setExpandedLazyInternal(boolean expandedLazy) {
        this.m_expanded = EXPANDED_BIT_HELPER.changeBit(EXPANDED_LAZY, expandedLazy, this.m_expanded);
    }

    @Override
    public boolean isLazyExpandingEnabled() {
        return EXPANDED_BIT_HELPER.isBitSet(LAZY_EXPANDING_ENABLED, this.m_expanded);
    }

    @Override
    public void setLazyExpandingEnabled(boolean lazyExpandingEnabled) {
        if (EXPANDED_BIT_HELPER.isBit(LAZY_EXPANDING_ENABLED, this.m_expanded, lazyExpandingEnabled)) {
            return;
        }
        this.m_expanded = EXPANDED_BIT_HELPER.changeBit(LAZY_EXPANDING_ENABLED, lazyExpandingEnabled, this.m_expanded);
        if (!lazyExpandingEnabled || this.getTree() != null && !this.getTree().isLazyExpandingEnabled()) {
            this.setExpandedLazyInternal(false);
        }
        if (this.getTree() != null) {
            this.getTree().fireNodeChanged(this);
        }
    }

    @Override
    public boolean isVisible() {
        return NamedBitMaskHelper.allBitsSet((byte)this.m_visible);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.isVisible("VISIBLE_GRANTED");
    }

    public void setVisible(boolean visible, String dimension) {
        this.m_visible = VISIBLE_BIT_HELPER.changeBit(dimension, visible, this.m_visible);
    }

    public boolean isVisible(String dimension) {
        return VISIBLE_BIT_HELPER.isBitSet(dimension, this.m_visible);
    }

    @Override
    public void setVisiblePermission(Permission p) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisiblePermission(this, p);
        } else {
            AbstractTreeNode.setVisiblePermission(p, this);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisible(this, visible);
        } else {
            this.setVisible(visible, "VISIBLE");
        }
    }

    @Override
    public void setVisibleGranted(boolean visible) {
        if (this.getTree() != null) {
            this.getTree().setNodeVisibleGranted(this, visible);
        } else {
            this.setVisible(visible, "VISIBLE_GRANTED");
        }
    }

    public static void setVisiblePermission(Permission p, ITreeNode node) {
        boolean visible = true;
        if (p != null) {
            visible = ACCESS.check((Permission)p);
        }
        node.setVisible(visible, "VISIBLE_GRANTED");
    }

    @Override
    public boolean isEnabled() {
        return NamedBitMaskHelper.allBitsSet((byte)this.m_enabled);
    }

    @Override
    public boolean isEnabledGranted() {
        return this.isEnabled("ENABLED_GRANTED");
    }

    public void setEnabled(boolean enabled, String dimension) {
        this.m_enabled = ENABLED_BIT_HELPER.changeBit(dimension, enabled, this.m_enabled);
    }

    public boolean isEnabled(String dimension) {
        return ENABLED_BIT_HELPER.isBitSet(dimension, this.m_enabled);
    }

    @Override
    public void setEnabledPermission(Permission p) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabledPermission(this, p);
        } else {
            AbstractTreeNode.setEnabledPermission(p, this);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabled(this, enabled);
        } else {
            this.setEnabled(enabled, "ENABLED");
        }
    }

    @Override
    public void setEnabledGranted(boolean enabled) {
        if (this.getTree() != null) {
            this.getTree().setNodeEnabledGranted(this, enabled);
        } else {
            this.setEnabled(enabled, "ENABLED_GRANTED");
        }
    }

    public static void setEnabledPermission(Permission p, ITreeNode node) {
        boolean enabled = true;
        if (p != null) {
            enabled = ACCESS.check((Permission)p);
        }
        node.setEnabled(enabled, "ENABLED_GRANTED");
    }

    @Override
    public boolean isChildrenVolatile() {
        return FLAGS_BIT_HELPER.isBitSet(CHILDREN_VOLATILE, this.m_flags);
    }

    @Override
    public void setChildrenVolatile(boolean childrenVolatile) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(CHILDREN_VOLATILE, childrenVolatile, this.m_flags);
    }

    @Override
    public boolean isChildrenDirty() {
        return FLAGS_BIT_HELPER.isBitSet(CHILDREN_DIRTY, this.m_flags);
    }

    @Override
    public void setChildrenDirty(boolean dirty) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(CHILDREN_DIRTY, dirty, this.m_flags);
    }

    @Override
    public Object getPrimaryKey() {
        return this.m_primaryKey;
    }

    @Override
    public void setPrimaryKey(Object key) {
        this.m_primaryKey = key;
    }

    @Override
    public List<IMenu> getMenus() {
        if (this.m_menus == null) {
            this.m_menus = this.lazyCreateAndInitializeMenus();
        }
        return this.m_menus;
    }

    protected List<IMenu> lazyCreateAndInitializeMenus() {
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
            menus.addOrdered((IOrdered)menu);
        }
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e) {
            LOG.error("Error occurred while dynamically contributing menus.", (Throwable)e);
        }
        menus.addAllOrdered((Collection)contributedMenus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.m_menus = menus.getOrderedList();
        for (IMenu m : this.m_menus) {
            m.init();
        }
        return this.m_menus;
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    @Override
    public IContextMenu getContextMenu() {
        return null;
    }

    @Override
    public void setMenus(List<? extends IMenu> menus) {
        this.m_menus = CollectionUtility.arrayListWithoutNullElements(menus);
    }

    @Override
    public ITreeNode getParentNode() {
        return this.m_parentNode;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        if (node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getParentNode(Class<T> type, int backCount) {
        ITreeNode node = this;
        while (node != null && backCount > 0) {
            node = node.getParentNode();
            --backCount;
        }
        if (backCount == 0 && node != null && type.isAssignableFrom(node.getClass())) {
            return (T)node;
        }
        return null;
    }

    @Override
    public <T extends ITreeNode> T getAncestorNode(Class<T> type) {
        ITreeNode node = this.getParentNode();
        while (node != null && !type.isAssignableFrom(node.getClass())) {
            node = node.getParentNode();
        }
        return (T)node;
    }

    @Override
    public void setParentNodeInternal(ITreeNode parent) {
        if (parent == null && this.m_parentNode != null) {
            this.m_oldParentNode = this.m_parentNode;
        }
        this.m_parentNode = parent;
    }

    @Override
    public ITreeNode getOldParentNode() {
        return this.m_oldParentNode;
    }

    @Override
    public int getChildNodeCount() {
        return this.m_childNodeList.size();
    }

    @Override
    public int getChildNodeIndex() {
        return this.m_childNodeIndex;
    }

    @Override
    public void setChildNodeIndexInternal(int index) {
        this.m_childNodeIndex = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITreeNode> getFilteredChildNodes() {
        if (this.m_filteredChildNodes == null) {
            Object object = this.m_filteredChildNodesLock;
            synchronized (object) {
                if (this.m_filteredChildNodes == null) {
                    Object object2 = this.m_childNodeListLock;
                    synchronized (object2) {
                        ArrayList<ITreeNode> list = new ArrayList<ITreeNode>(this.m_childNodeList.size());
                        for (ITreeNode node : this.m_childNodeList) {
                            if (!node.isFilterAccepted()) continue;
                            list.add(node);
                        }
                        this.m_filteredChildNodes = list;
                    }
                }
            }
        }
        return CollectionUtility.arrayList(this.m_filteredChildNodes);
    }

    @Override
    public int getTreeLevel() {
        int level = 0;
        ITreeNode parent = this.getParentNode();
        while (parent != null) {
            ++level;
            parent = parent.getParentNode();
        }
        return level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITreeNode getChildNode(int childIndex) {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            if (childIndex >= 0 && childIndex < this.m_childNodeList.size()) {
                return this.m_childNodeList.get(childIndex);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITreeNode> getChildNodes() {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            return CollectionUtility.arrayList(this.m_childNodeList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectChildNodes(Set<ITreeNode> collector, boolean recursive) {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            for (ITreeNode node : this.m_childNodeList) {
                if (node == null) continue;
                collector.add(node);
                if (!recursive) continue;
                node.collectChildNodes(collector, recursive);
            }
        }
    }

    @Override
    public ITreeNode findParentNode(Class<?> interfaceType) {
        ITreeNode test = this.getParentNode();
        while (test != null) {
            if (interfaceType.isInstance(test)) break;
            test = test.getParentNode();
        }
        return test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setChildNodeOrderInternal(List<ITreeNode> nodes) {
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            ArrayList<ITreeNode> newList = new ArrayList<ITreeNode>(this.m_childNodeList.size());
            int index = 0;
            for (ITreeNode n : nodes) {
                n.setChildNodeIndexInternal(index);
                newList.add(n);
                ++index;
            }
            this.m_childNodeList = newList;
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChildNodesInternal(int startIndex, List<? extends ITreeNode> nodes, boolean includeSubtree) {
        for (ITreeNode iTreeNode : nodes) {
            iTreeNode.setTreeInternal(this.m_tree, true);
            iTreeNode.setParentNodeInternal(this);
        }
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            this.m_childNodeList.addAll(startIndex, nodes);
            int endIndex = this.m_childNodeList.size() - 1;
            int i = startIndex;
            while (i <= endIndex) {
                this.m_childNodeList.get(i).setChildNodeIndexInternal(i);
                ++i;
            }
        }
        for (ITreeNode iTreeNode : nodes) {
            this.postProcessAddRec(iTreeNode, includeSubtree);
        }
        this.resetFilterCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChildNodesInternal(Collection<? extends ITreeNode> nodes, boolean includeSubtree, boolean disposeNodes) {
        ArrayList<ITreeNode> removedNodes = new ArrayList<ITreeNode>();
        Object object = this.m_childNodeListLock;
        synchronized (object) {
            for (ITreeNode iTreeNode : nodes) {
                if (this.m_childNodeList.remove(iTreeNode)) {
                    removedNodes.add(iTreeNode);
                }
                iTreeNode.setTreeInternal(null, true);
                iTreeNode.setParentNodeInternal(null);
            }
            int n = 0;
            int endIndex = this.m_childNodeList.size() - 1;
            int i = n;
            while (i <= endIndex) {
                this.m_childNodeList.get(i).setChildNodeIndexInternal(i);
                ++i;
            }
        }
        for (ITreeNode removedNode : removedNodes) {
            this.postProcessRemoveRec(removedNode, this.getTree(), includeSubtree, disposeNodes);
        }
        this.resetFilterCache();
    }

    private void postProcessAddRec(ITreeNode node, boolean includeSubtree) {
        if (node.getTree() != null) {
            try {
                node.nodeAddedNotify();
            }
            catch (Exception t) {
                LOG.error("Could not notify node added {}", (Object)node, (Object)t);
            }
            if (!node.isVisible() && (this.getTree().isRootNodeVisible() || node != this.getTree().getRootNode())) {
                this.getTree().removeNode(node);
                return;
            }
        }
        if (includeSubtree) {
            for (ITreeNode ch : node.getChildNodes()) {
                if (ch != node) {
                    this.postProcessAddRec(ch, includeSubtree);
                    continue;
                }
                LOG.warn("The node {} is child of itself!", (Object)node);
            }
        }
    }

    @Override
    public void nodeAddedNotify() {
    }

    @Override
    public void nodeRemovedNotify() {
    }

    private void postProcessRemoveRec(ITreeNode node, ITree formerTree, boolean includeSubtree, boolean dispose) {
        if (includeSubtree) {
            for (ITreeNode ch : node.getChildNodes()) {
                this.postProcessRemoveRec(ch, formerTree, includeSubtree, dispose);
            }
        }
        if (formerTree != null) {
            try {
                node.nodeRemovedNotify();
                if (dispose) {
                    node.dispose();
                }
            }
            catch (Exception t) {
                LOG.error("Error removing node", (Throwable)t);
            }
        }
    }

    @Override
    public boolean isChildrenLoaded() {
        return FLAGS_BIT_HELPER.isBitSet(CHILDREN_LOADED, this.m_flags);
    }

    @Override
    public void setChildrenLoaded(boolean loaded) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(CHILDREN_LOADED, loaded, this.m_flags);
    }

    @Override
    public final void ensureChildrenLoaded() {
        if (!this.isChildrenLoaded()) {
            try {
                if (this.m_childrenLoadedLock.acquire()) {
                    this.loadChildren();
                }
            }
            finally {
                this.m_childrenLoadedLock.release();
            }
        }
    }

    @Override
    public ITree getTree() {
        return this.m_tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTreeInternal(ITree tree, boolean includeSubtree) {
        this.m_tree = tree;
        if (this.m_tree != null && this.isExpanded()) {
            this.m_tree.setNodeExpandedInternal(this, true, this.isLazyExpandingEnabled());
        }
        if (includeSubtree) {
            Object object = this.m_childNodeListLock;
            synchronized (object) {
                for (ITreeNode aM_childNodeList : this.m_childNodeList) {
                    aM_childNodeList.setTreeInternal(tree, includeSubtree);
                }
            }
        }
    }

    @Override
    public void loadChildren() {
    }

    @Override
    public void update() {
        this.getTree().updateNode(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "[" + String.valueOf(this.getCell()) + "]";
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        if (this.getTree() != null) {
            this.getTree().fireNodeChanged(this);
        }
    }

    @Override
    public Object validateValue(ICell cell, Object value) {
        return value;
    }

    protected final void interceptDecorateCell(Cell cell) {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        TreeNodeChains.TreeNodeDecorateCellChain chain = new TreeNodeChains.TreeNodeDecorateCellChain(extensions);
        chain.execDecorateCell(cell);
    }

    protected final void interceptInitTreeNode() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        TreeNodeChains.TreeNodeInitTreeNodeChain chain = new TreeNodeChains.TreeNodeInitTreeNodeChain(extensions);
        chain.execInitTreeNode();
    }

    protected final void interceptDispose() {
        List<? extends ITreeNodeExtension<? extends AbstractTreeNode>> extensions = this.getAllExtensions();
        TreeNodeChains.TreeNodeDisposeChain chain = new TreeNodeChains.TreeNodeDisposeChain(extensions);
        chain.execDispose();
    }

    @Override
    public final void dispose() {
        this.setDisposing(true);
        try {
            try {
                this.disposeInternal();
            }
            catch (RuntimeException e) {
                LOG.warn("Exception while disposing node.", (Throwable)e);
            }
            try {
                this.interceptDispose();
            }
            catch (RuntimeException e) {
                LOG.warn("Exception while disposing node.", (Throwable)e);
            }
        }
        finally {
            this.setDisposing(false);
        }
    }

    protected void disposeInternal() {
        for (ITreeNode childNode : this.getChildNodes()) {
            try {
                childNode.dispose();
            }
            catch (RuntimeException e) {
                LOG.warn("Exception while disposing node.", (Throwable)e);
            }
        }
        if (this.m_menus != null) {
            for (IMenu m : this.m_menus) {
                m.dispose();
            }
        }
    }

    private void setDisposing(boolean disposing) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(DISPOSING, disposing, this.m_flags);
    }

    @Override
    public boolean isDisposing() {
        return FLAGS_BIT_HELPER.isBitSet(DISPOSING, this.m_flags);
    }

    @Override
    public void unload() {
        if (this.getTree() == null) {
            return;
        }
        this.setExpanded(false);
        this.getTree().removeAllChildNodes(this);
        this.setChildrenLoaded(false);
    }

    protected static class LocalTreeNodeExtension<OWNER extends AbstractTreeNode>
    extends AbstractExtension<OWNER>
    implements ITreeNodeExtension<OWNER> {
        public LocalTreeNodeExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDecorateCell(TreeNodeChains.TreeNodeDecorateCellChain chain, Cell cell) {
            ((AbstractTreeNode)this.getOwner()).execDecorateCell(cell);
        }

        @Override
        public void execInitTreeNode(TreeNodeChains.TreeNodeInitTreeNodeChain chain) {
            ((AbstractTreeNode)this.getOwner()).execInitTreeNode();
        }

        @Override
        public void execDispose(TreeNodeChains.TreeNodeDisposeChain chain) {
            ((AbstractTreeNode)this.getOwner()).execDispose();
        }
    }
}

