/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.scout.rt.client.ModelContextProxy;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.TreeChains;
import org.eclipse.scout.rt.client.ui.AbstractEventBuffer;
import org.eclipse.scout.rt.client.ui.AbstractWidget;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.MouseButton;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuUtility;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITreeContextMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.internal.TreeContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.AutoCheckStyle;
import org.eclipse.scout.rt.client.ui.basic.tree.CheckableStyle;
import org.eclipse.scout.rt.client.ui.basic.tree.DefaultTreeEventHistory;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeUIFacade;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEventBuffer;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListeners;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeUtility;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IUserFilter;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.platform.util.visitor.CollectingVisitor;
import org.eclipse.scout.rt.platform.util.visitor.DepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.IDepthFirstTreeVisitor;
import org.eclipse.scout.rt.platform.util.visitor.TreeTraversals;
import org.eclipse.scout.rt.platform.util.visitor.TreeVisitResult;
import org.eclipse.scout.rt.shared.data.basic.NamedBitMaskHelper;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.TreeNodeData;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClassId(value="b177affd-790b-4908-b608-ac00b996b10e")
public abstract class AbstractTree
extends AbstractWidget
implements ITree,
IContributionOwner,
IExtensibleObject {
    private static final String AUTO_DISCARD_ON_DELETE = "AUTO_DISCARD_ON_DELETE";
    private static final String AUTO_TITLE = "AUTO_TITLE";
    private static final String ACTION_RUNNING = "ACTION_RUNNING";
    private static final String SAVE_AND_RESTORE_SCROLLBARS = "SAVE_AND_RESTORE_SCROLLBARS";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractTree.class);
    private static final NamedBitMaskHelper FLAGS_BIT_HELPER = new NamedBitMaskHelper(new String[]{"AUTO_DISCARD_ON_DELETE", "AUTO_TITLE", "ACTION_RUNNING", "SAVE_AND_RESTORE_SCROLLBARS"});
    private final TreeListeners m_listeners = new TreeListeners();
    private final Set<ITreeNode> m_checkedNodes;
    private final Map<Object, ITreeNode> m_deletedNodes;
    private final List<ITreeNodeFilter> m_nodeFilters;
    private final ObjectExtensions<AbstractTree, ITreeExtension<? extends AbstractTree>> m_objectExtensions;
    private byte m_flags;
    private ITreeNode m_rootNode;
    private int m_treeChanging;
    private AbstractEventBuffer<TreeEvent> m_eventBuffer;
    private ITreeUIFacade m_uiFacade;
    private Set<ITreeNode> m_nodeDecorationBuffer = new HashSet<ITreeNode>();
    private Set<ITreeNode> m_selectedNodes = new HashSet<ITreeNode>();
    private List<IKeyStroke> m_baseKeyStrokes;
    private IEventHistory<TreeEvent> m_eventHistory;
    private ITreeNode m_lastSeenDropNode;
    private IContributionOwner m_contributionHolder;
    private List<IMenu> m_currentNodeMenus;
    private int m_processTreeBufferLoopDetection;

    public AbstractTree() {
        this(true);
    }

    public AbstractTree(boolean callInitializer) {
        super(false);
        this.m_checkedNodes = new HashSet<ITreeNode>();
        this.m_deletedNodes = new HashMap<Object, ITreeNode>();
        this.m_nodeFilters = new ArrayList<ITreeNodeFilter>(1);
        this.m_objectExtensions = new ObjectExtensions((Object)this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    @Override
    protected void initConfigInternal() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=20.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=21.0)
    protected String getConfiguredDefaultIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    protected boolean getConfiguredAutoTitle() {
        return false;
    }

    @Order(value=40.0)
    @ConfigProperty(value="BOOLEAN")
    protected final boolean getConfiguredMultiSelect() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=42.0)
    protected boolean getConfiguredMultiCheck() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=45.0)
    protected boolean getConfiguredCheckable() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=46.0)
    protected int getConfiguredNodeHeightHint() {
        return -1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    protected boolean getConfiguredDragEnabled() {
        return false;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=51.0)
    protected final int getConfiguredDragType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=52.0)
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="LONG")
    @Order(value=190.0)
    protected long getConfiguredDropMaximumSize() {
        return 0x3200000L;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredAutoDiscardOnDelete() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    protected boolean getConfiguredRootNodeVisible() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=71.0)
    protected boolean getConfiguredRootHandlesVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredScrollToSelection() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredSaveAndRestoreScrollbars() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    protected boolean getConfiguredAutoCheckChildNodes() {
        return false;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=105.0)
    protected AutoCheckStyle getConfiguredAutoCheckStyle() {
        return AutoCheckStyle.NONE;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=110.0)
    protected boolean getConfiguredLazyExpandingEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    protected String getConfiguredDisplayStyle() {
        return "default";
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=145.0)
    protected boolean getConfiguredToggleBreadcrumbStyleEnabled() {
        return false;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=155.0)
    protected CheckableStyle getConfiguredCheckableStyle() {
        return CheckableStyle.CHECKBOX_TREE_NODE;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredTextFilterEnabled() {
        return true;
    }

    private List<Class<? extends IKeyStroke>> getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    protected List<Class<? extends IMenu>> getDeclaredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List filtered = ConfigurationUtility.filterClasses((Class[])dca, IMenu.class);
        return ConfigurationUtility.removeReplacedClasses((List)filtered);
    }

    @Override
    public boolean isAutoCheckChildNodes() {
        return this.propertySupport.getPropertyBool("autoCheckChildren");
    }

    @Override
    public void setAutoCheckChildNodes(boolean b) {
        this.propertySupport.setPropertyBool("autoCheckChildren", b);
    }

    @Override
    public AutoCheckStyle getAutoCheckStyle() {
        return (AutoCheckStyle)((Object)this.propertySupport.getProperty("autoCheckStyle", AutoCheckStyle.class));
    }

    @Override
    public void setAutoCheckStyle(AutoCheckStyle autoCheckStyle) {
        this.propertySupport.setProperty("autoCheckStyle", (Object)autoCheckStyle);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitTree() {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeTree() {
    }

    @ConfigOperation
    @Order(value=18.0)
    protected void execAppLinkAction(String ref) {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected final TransferObject execDrag(ITreeNode node) {
        return null;
    }

    @ConfigOperation
    @Order(value=30.0)
    protected TransferObject execDrag(Collection<ITreeNode> nodes) {
        return null;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execDrop(ITreeNode node, TransferObject t) {
    }

    @ConfigOperation
    @Order(value=45.0)
    protected void execDropTargetChanged(ITreeNode node) {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateCell(ITreeNode node, Cell cell) {
        if (cell.getIconId() == null && this.getDefaultIconId() != null) {
            cell.setIconId(this.getDefaultIconId());
        }
        node.decorateCell();
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execNodesSelected(TreeEvent e) {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execNodeClick(ITreeNode node, MouseButton mouseButton) {
        TreeEvent e = new TreeEvent((ITree)this, 820, node);
        this.fireTreeEventInternal(e);
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execNodeAction(ITreeNode node) {
        TreeEvent e = new TreeEvent((ITree)this, 705, node);
        this.fireTreeEventInternal(e);
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execNodesChecked(List<ITreeNode> nodes) {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_eventHistory = this.createEventHistory();
        this.m_eventBuffer = this.createEventBuffer();
        this.m_uiFacade = ((ModelContextProxy)BEANS.get(ModelContextProxy.class)).newProxy(this.createUIFacade(), ModelContextProxy.ModelContext.copyCurrent());
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setTitle(this.getConfiguredTitle());
        this.setIconId(this.getConfiguredIconId());
        this.setDefaultIconId(this.getConfiguredDefaultIconId());
        this.setCssClass(this.getConfiguredCssClass());
        this.setAutoTitle(this.getConfiguredAutoTitle());
        this.setCheckable(this.getConfiguredCheckable());
        this.setCheckableStyle(this.getConfiguredCheckableStyle());
        this.setTextFilterEnabled(this.getConfiguredTextFilterEnabled());
        this.setNodeHeightHint(this.getConfiguredNodeHeightHint());
        this.setMultiCheck(this.getConfiguredMultiCheck());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setAutoDiscardOnDelete(this.getConfiguredAutoDiscardOnDelete());
        this.setDragEnabled(this.getConfiguredDragEnabled());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setDropMaximumSize(this.getConfiguredDropMaximumSize());
        this.setRootNodeVisible(this.getConfiguredRootNodeVisible());
        this.setRootHandlesVisible(this.getConfiguredRootHandlesVisible());
        this.setScrollToSelection(this.getConfiguredScrollToSelection());
        this.setSaveAndRestoreScrollbars(this.getConfiguredSaveAndRestoreScrollbars());
        this.setAutoCheckChildNodes(this.getConfiguredAutoCheckChildNodes());
        this.setAutoCheckStyle(this.getConfiguredAutoCheckStyle());
        this.setLazyExpandingEnabled(this.getConfiguredLazyExpandingEnabled());
        this.setDisplayStyle(this.getConfiguredDisplayStyle());
        this.setToggleBreadcrumbStyleEnabled(this.getConfiguredToggleBreadcrumbStyleEnabled());
        this.setRootNode(new AbstractTreeNode(){});
        this.addTreeListener(e -> {
            IEventHistory<TreeEvent> h = this.getEventHistory();
            if (h != null) {
                h.notifyEvent(e);
            }
            switch (e.getType()) {
                case 730: {
                    this.m_lastSeenDropNode = null;
                    if (e.getDragObject() != null) break;
                    try {
                        TransferObject transferObject = this.interceptDrag(e.getNode());
                        if (transferObject == null) {
                            transferObject = this.interceptDrag(e.getNodes());
                        }
                        e.setDragObject(transferObject);
                    }
                    catch (Exception t) {
                        LOG.error("Drag", (Throwable)t);
                    }
                    break;
                }
                case 740: {
                    this.m_lastSeenDropNode = null;
                    if (e.getDropObject() == null) break;
                    try {
                        this.interceptDrop(e.getNode(), e.getDropObject());
                    }
                    catch (Exception t) {
                        LOG.error("Drop", (Throwable)t);
                    }
                    break;
                }
                case 40: {
                    this.rebuildKeyStrokesInternal();
                    break;
                }
                case 870: {
                    try {
                        this.interceptNodesChecked(CollectionUtility.arrayList(e.getNodes()));
                    }
                    catch (RuntimeException ex) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                    }
                    break;
                }
                case 860: {
                    try {
                        if (this.m_lastSeenDropNode != null && this.m_lastSeenDropNode == e.getNode()) break;
                        this.m_lastSeenDropNode = e.getNode();
                        this.interceptDropTargetChanged(e.getNode());
                    }
                    catch (RuntimeException ex) {
                        LOG.error("DropTargetChanged", (Throwable)ex);
                    }
                    break;
                }
                case 735: {
                    this.m_lastSeenDropNode = null;
                }
            }
        }, new Integer[]{730, 740, 40, 870, 860, 735});
        List<Class<? extends IKeyStroke>> configuredKeyStrokes = this.getConfiguredKeyStrokes();
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>(configuredKeyStrokes.size());
        for (Class<? extends IKeyStroke> keystrokeClazz : configuredKeyStrokes) {
            ksList.add((IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, keystrokeClazz));
        }
        if (ConfigurationUtility.isMethodOverwrite(AbstractTree.class, (String)"execNodeAction", (Class[])new Class[]{ITreeNode.class}, this.getClass())) {
            ksList.add(new KeyStroke("ENTER"){

                @Override
                protected void execAction() {
                    AbstractTree.this.fireNodeAction(AbstractTree.this.getSelectedNode());
                }
            });
        }
        List contributedKeyStrokes = this.m_contributionHolder.getContributionsByClass(IKeyStroke.class);
        ksList.addAll(contributedKeyStrokes);
        this.m_baseKeyStrokes = ksList;
        this.setKeyStrokesInternal(this.m_baseKeyStrokes);
        List<Class<? extends IMenu>> declaredMenus = this.getDeclaredMenus();
        List contributedMenus = this.m_contributionHolder.getContributionsByClass(IMenu.class);
        OrderedCollection menus = new OrderedCollection();
        for (Class<? extends IMenu> menuClazz : declaredMenus) {
            IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, menuClazz);
            menus.addOrdered((IOrdered)menu);
        }
        try {
            this.injectMenusInternal((OrderedCollection<IMenu>)menus);
        }
        catch (Exception e2) {
            LOG.error("Error occurred while dynamically contributing menus.", (Throwable)e2);
        }
        menus.addAllOrdered((Collection)contributedMenus);
        new MoveActionNodesHandler(menus).moveModelObjects();
        TreeContextMenu contextMenu = new TreeContextMenu(this, (List<? extends IMenu>)menus.getOrderedList());
        this.setContextMenuInternal(contextMenu);
    }

    @Override
    protected final void initInternal() {
        super.initInternal();
        this.initTreeInternal();
        this.interceptInitTree();
    }

    @Override
    public List<? extends IWidget> getChildren() {
        return CollectionUtility.flatten((Collection[])new Collection[]{super.getChildren(), this.getMenus(), this.getKeyStrokesInternal()});
    }

    protected void initTreeInternal() {
    }

    @Override
    protected final void disposeInternal() {
        this.disposeTreeInternal();
        try {
            this.interceptDisposeTree();
        }
        catch (Exception e) {
            LOG.warn("Exception while disposing tree", (Throwable)e);
        }
        super.disposeInternal();
    }

    protected void disposeTreeInternal() {
        this.getRootNode().dispose();
        this.clearDeletedNodes();
    }

    public final List<? extends ITreeExtension<? extends AbstractTree>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected ITreeExtension<? extends AbstractTree> createLocalExtension() {
        return new LocalTreeExtension<AbstractTree>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
    }

    @Override
    public ITreeContextMenu getContextMenu() {
        return (ITreeContextMenu)this.propertySupport.getProperty("contextMenu");
    }

    protected void setContextMenuInternal(ITreeContextMenu contextMenu) {
        this.propertySupport.setProperty("contextMenu", (Object)contextMenu);
    }

    @Override
    public List<IMenu> getMenus() {
        return this.getContextMenu().getChildActions();
    }

    @Override
    public <T extends IMenu> T getMenuByClass(Class<T> menuType) {
        return MenuUtility.getMenuByClass(this, menuType);
    }

    @Override
    public boolean hasNodeFilters() {
        return !this.m_nodeFilters.isEmpty();
    }

    @Override
    public List<ITreeNodeFilter> getNodeFilters() {
        return CollectionUtility.arrayList(this.m_nodeFilters);
    }

    @Override
    public void addNodeFilter(ITreeNodeFilter filter) {
        if (filter != null) {
            boolean exists = false;
            for (ITreeNodeFilter existingFilter : this.m_nodeFilters) {
                if (existingFilter != filter) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.m_nodeFilters.add(filter);
            }
            this.applyNodeFilters();
        }
    }

    @Override
    public void removeNodeFilter(ITreeNodeFilter filter) {
        if (filter != null) {
            this.m_nodeFilters.remove(filter);
            this.applyNodeFilters();
        }
    }

    @Override
    public void applyNodeFilters() {
        this.applyNodeFiltersRecInternal(this.getRootNode(), true, 0);
        this.fireNodeFilterChanged();
    }

    private void applyNodeFiltersRecInternal(ITreeNode inode, boolean parentAccepted, int level) {
        if (inode == null) {
            return;
        }
        ArrayList<ITreeNodeFilter> rejectingFilters = new ArrayList<ITreeNodeFilter>();
        inode.setFilterAccepted(true);
        inode.setRejectedByUser(false);
        if (!this.m_nodeFilters.isEmpty()) {
            for (ITreeNodeFilter filter : this.m_nodeFilters) {
                if (filter.accept(inode, level)) continue;
                inode.setFilterAccepted(false);
                rejectingFilters.add(filter);
            }
        }
        inode.setRejectedByUser(inode.isRejectedByUser() || rejectingFilters.size() == 1 && rejectingFilters.get(0) instanceof IUserFilter);
        if (!inode.isFilterAccepted() && this.isSelectedNode(inode)) {
            this.deselectNode(inode);
        }
        if (!parentAccepted && inode.isFilterAccepted()) {
            ITreeNode tmp = inode.getParentNode();
            while (tmp != null) {
                tmp.setFilterAccepted(true);
                tmp.setRejectedByUser(false);
                tmp = tmp.getParentNode();
            }
        }
        for (ITreeNode child : inode.getChildNodes()) {
            this.applyNodeFiltersRecInternal(child, inode.isFilterAccepted(), level + 1);
        }
    }

    @Override
    public AbstractEventBuffer<TreeEvent> createEventBuffer() {
        return (AbstractEventBuffer)BEANS.get(TreeEventBuffer.class);
    }

    protected AbstractEventBuffer<TreeEvent> getEventBuffer() {
        return this.m_eventBuffer;
    }

    @Override
    public void requestFocus() {
        this.fireRequestFocus();
    }

    @Override
    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public boolean isAutoTitle() {
        return FLAGS_BIT_HELPER.isBitSet(AUTO_TITLE, this.m_flags);
    }

    @Override
    public void setAutoTitle(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(AUTO_TITLE, b, this.m_flags);
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public String getDefaultIconId() {
        return this.propertySupport.getPropertyString("defaultIconId");
    }

    @Override
    public void setDefaultIconId(String defaultIconId) {
        this.propertySupport.setPropertyString("defaultIconId", defaultIconId);
    }

    @Override
    public boolean isCheckable() {
        return this.propertySupport.getPropertyBool("checkable");
    }

    @Override
    public void setCheckable(boolean b) {
        this.propertySupport.setPropertyBool("checkable", b);
    }

    @Override
    public int getNodeHeightHint() {
        return this.propertySupport.getPropertyInt("propNodeHeightHint");
    }

    @Override
    public void setNodeHeightHint(int h) {
        this.propertySupport.setPropertyInt("propNodeHeightHint", h);
    }

    @Override
    public boolean isDragEnabled() {
        return this.propertySupport.getPropertyBool("dragEnabled");
    }

    @Override
    public void setDragEnabled(boolean b) {
        this.propertySupport.setPropertyBool("dragEnabled", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setDropMaximumSize(long dropMaximumSize) {
        this.propertySupport.setPropertyLong("dropMaximumSize", dropMaximumSize);
    }

    @Override
    public long getDropMaximumSize() {
        return this.propertySupport.getPropertyInt("dropMaximumSize");
    }

    @Override
    public boolean isLazyExpandingEnabled() {
        return this.propertySupport.getPropertyBool("lazyExpandingEnabled");
    }

    @Override
    public void setLazyExpandingEnabled(boolean lazyExpandingEnabled) {
        this.propertySupport.setPropertyBool("lazyExpandingEnabled", lazyExpandingEnabled);
    }

    @Override
    public String getDisplayStyle() {
        return this.propertySupport.getPropertyString("displayStyle");
    }

    @Override
    public void setDisplayStyle(String style) {
        this.propertySupport.setPropertyString("displayStyle", style);
    }

    @Override
    public boolean isToggleBreadcrumbStyleEnabled() {
        return this.propertySupport.getPropertyBool("toggleBreadcrumbStyleEnabled");
    }

    @Override
    public void setToggleBreadcrumbStyleEnabled(boolean b) {
        this.propertySupport.setPropertyBool("toggleBreadcrumbStyleEnabled", b);
    }

    @Override
    public CheckableStyle getCheckableStyle() {
        return (CheckableStyle)((Object)this.propertySupport.getProperty("checkableStyle"));
    }

    @Override
    public void setCheckableStyle(CheckableStyle checkableStyle) {
        this.propertySupport.setProperty("checkableStyle", (Object)checkableStyle);
    }

    @Override
    public boolean isTextFilterEnabled() {
        return this.propertySupport.getPropertyBool("textFilterEnabled");
    }

    @Override
    public void setTextFilterEnabled(boolean textFilterEnabled) {
        this.propertySupport.setProperty("textFilterEnabled", (Object)textFilterEnabled);
    }

    @Override
    public String getPathText(ITreeNode selectedNode) {
        return this.getPathText(selectedNode, " - ");
    }

    @Override
    public String getPathText(ITreeNode selectedNode, String delimiter) {
        ITreeNode root = this.getRootNode();
        StringBuilder pathStr = new StringBuilder();
        ITreeNode node = selectedNode;
        while (node != null) {
            if (node != root || this.isRootNodeVisible()) {
                if (pathStr.length() != 0) {
                    pathStr.insert(0, delimiter);
                }
                pathStr.insert(0, node.toPlainText());
            }
            node = node.getParentNode();
        }
        return pathStr.toString();
    }

    private void rebuildTitleInternal() {
        this.setTitle(this.getPathText(this.getSelectedNode()));
    }

    private void rebuildKeyStrokesInternal() {
        this.setKeyStrokesInternal(this.m_baseKeyStrokes);
    }

    @Override
    public ITreeNode findNode(Object primaryKey) {
        List<ITreeNode> a = this.findNodes(CollectionUtility.hashSet((Object)primaryKey));
        if (a != null && !a.isEmpty()) {
            return (ITreeNode)CollectionUtility.firstElement(a);
        }
        return null;
    }

    @Override
    public List<ITreeNode> findNodes(Collection<?> primaryKeys) {
        if (primaryKeys == null || primaryKeys.size() <= 0) {
            return CollectionUtility.emptyArrayList();
        }
        final HashSet keySet = new HashSet(primaryKeys);
        CollectingVisitor<ITreeNode> v = new CollectingVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                super.preVisit((Object)element, level, index);
                if (keySet.isEmpty()) {
                    return TreeVisitResult.TERMINATE;
                }
                return TreeVisitResult.CONTINUE;
            }

            protected boolean accept(ITreeNode node) {
                return keySet.remove(node.getPrimaryKey());
            }
        };
        this.visitNode(this.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
        return v.getCollection();
    }

    @Override
    public void setRootNode(ITreeNode root) {
        this.setTreeChanging(true);
        try {
            if (this.m_rootNode != null) {
                this.deselectNode(this.m_rootNode);
                this.setNodeChecked(this.m_rootNode, false);
                this.m_rootNode.setTreeInternal(null, true);
                this.m_rootNode.nodeRemovedNotify();
                this.m_rootNode.dispose();
                if (this.isInitConfigDone()) {
                    this.fireNodesDeleted(null, Arrays.asList(this.m_rootNode));
                }
            }
            this.m_rootNode = root;
            if (this.m_rootNode != null) {
                if (this.isInitConfigDone()) {
                    this.fireNodesInserted(null, Arrays.asList(this.m_rootNode));
                }
                this.m_rootNode.setTreeInternal(this, true);
                this.m_rootNode.nodeAddedNotify();
                if (!this.isRootNodeVisible()) {
                    try {
                        this.m_rootNode.ensureChildrenLoaded();
                    }
                    catch (RuntimeException e) {
                        LOG.error("expanding root node of {}", (Object)this.getTitle(), (Object)e);
                    }
                }
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public boolean isRootNodeVisible() {
        return this.propertySupport.getPropertyBool("rootNodeVisible");
    }

    @Override
    public void setRootNodeVisible(boolean b) {
        this.propertySupport.setPropertyBool("rootNodeVisible", b);
    }

    @Override
    public boolean isRootHandlesVisible() {
        return this.propertySupport.getPropertyBool("rootHandlesVisible");
    }

    @Override
    public void setRootHandlesVisible(boolean b) {
        this.propertySupport.setPropertyBool("rootHandlesVisible", b);
    }

    @Override
    public boolean isTreeChanging() {
        return this.m_treeChanging > 0;
    }

    @Override
    public void setTreeChanging(boolean b) {
        if (b) {
            ++this.m_treeChanging;
            if (this.m_treeChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_treeChanging > 0) {
            --this.m_treeChanging;
            if (this.m_treeChanging == 0) {
                try {
                    this.processTreeBuffers();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    @Override
    public boolean isNodeExpanded(ITreeNode node) {
        if (node != null) {
            return node.isExpanded();
        }
        return false;
    }

    @Override
    public void setNodeExpanded(ITreeNode node, boolean expanded) {
        boolean lazy = node.isExpanded() == expanded ? node.isExpandedLazy() : (expanded ? node.isLazyExpandingEnabled() : false);
        this.setNodeExpanded(node, expanded, lazy);
    }

    @Override
    public void setNodeExpanded(ITreeNode node, boolean expand, boolean lazy) {
        if (!this.isLazyExpandingEnabled()) {
            lazy = false;
        }
        if ((node = this.resolveNode(node)) != null && (node.isExpanded() != expand || node.isExpandedLazy() != lazy)) {
            this.setNodeExpandedInternal(node, expand, lazy);
        }
    }

    @Override
    public void setNodeExpandedInternal(ITreeNode node, boolean expand, boolean lazy) {
        if (expand) {
            node.ensureChildrenLoaded();
            this.ensureParentExpanded(node.getParentNode());
        }
        node.setExpandedInternal(expand);
        node.setExpandedLazyInternal(lazy);
        this.fireNodeExpanded(node, expand);
    }

    @Override
    public boolean isAncestorNodeOf(ITreeNode parent, ITreeNode child) {
        ITreeNode t = child;
        while (t != null && t != parent) {
            t = t.getParentNode();
        }
        return t == parent;
    }

    @Override
    public boolean isAutoDiscardOnDelete() {
        return FLAGS_BIT_HELPER.isBitSet(AUTO_DISCARD_ON_DELETE, this.m_flags);
    }

    @Override
    public void setAutoDiscardOnDelete(boolean on) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(AUTO_DISCARD_ON_DELETE, on, this.m_flags);
    }

    @Override
    public void setNodeEnabledPermission(ITreeNode node, Permission p) {
        if ((node = this.resolveNode(node)) == null) {
            return;
        }
        boolean oldValue = node.isEnabled();
        AbstractTreeNode.setEnabledPermission(p, node);
        boolean newValue = node.isEnabled();
        if (oldValue != newValue) {
            this.fireNodesUpdated(node.getParentNode(), CollectionUtility.hashSet((Object)node));
        }
    }

    @Override
    public boolean isNodeEnabled(ITreeNode node) {
        if (node != null) {
            return node.isEnabled();
        }
        return false;
    }

    @Override
    public boolean isNodeEnabledGranted(ITreeNode node) {
        if (node != null) {
            return node.isEnabledGranted();
        }
        return false;
    }

    @Override
    public void setNodeEnabled(ITreeNode node, boolean enabled) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabled(enabled, "ENABLED");
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
            }
        }
    }

    @Override
    public void setNodeEnabledGranted(ITreeNode node, boolean enabled) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabled(enabled, "ENABLED_GRANTED");
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
            }
        }
    }

    @Override
    public void setNodeVisiblePermission(ITreeNode node, Permission permission) {
        if ((node = this.resolveNode(node)) != null) {
            AbstractTreeNode.setVisiblePermission(permission, node);
        }
    }

    @Override
    public boolean isNodeVisible(ITreeNode node) {
        if (node != null) {
            return node.isVisible();
        }
        return false;
    }

    @Override
    public boolean isNodeVisibleGranted(ITreeNode node) {
        if (node != null) {
            return node.isVisibleGranted();
        }
        return false;
    }

    @Override
    public void setNodeVisible(ITreeNode node, boolean visible) {
        if ((node = this.resolveNode(node)) != null) {
            node.setVisible(visible, "VISIBLE");
        }
    }

    @Override
    public void setNodeVisibleGranted(ITreeNode node, boolean visible) {
        if ((node = this.resolveNode(node)) != null) {
            node.setVisible(visible, "VISIBLE_GRANTED");
        }
    }

    @Override
    public boolean isNodeLeaf(ITreeNode node) {
        if (node != null) {
            return node.isLeaf();
        }
        return false;
    }

    @Override
    public void setNodeLeaf(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null && node.isLeaf() != b) {
            node.setLeafInternal(b);
            this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
        }
    }

    @Override
    public boolean isNodeChecked(ITreeNode node) {
        if (node != null) {
            return this.m_checkedNodes.contains(node);
        }
        return false;
    }

    @Override
    public void setNodeChecked(ITreeNode node, boolean checked) {
        this.setNodesChecked(CollectionUtility.arrayList((Object)node), checked);
    }

    @Override
    public void setNodeChecked(ITreeNode node, boolean checked, boolean enabledNodesOnly) {
        this.setNodesChecked(CollectionUtility.arrayList((Object)node), checked, enabledNodesOnly);
    }

    @Override
    public void setNodeChecked(ITreeNode node, boolean checked, boolean enabledNodesOnly, boolean forceUpdateNode) {
        this.setNodesChecked(CollectionUtility.arrayList((Object)node), checked, enabledNodesOnly, forceUpdateNode);
    }

    @Override
    public void setNodesChecked(List<ITreeNode> nodes, boolean checked) {
        this.setNodesChecked(nodes, checked, false);
    }

    @Override
    public void setNodesChecked(List<ITreeNode> nodes, boolean checked, boolean enabledNodesOnly) {
        this.setNodesChecked(nodes, checked, enabledNodesOnly, false);
    }

    @Override
    public void setNodesChecked(List<ITreeNode> nodes, boolean checked, boolean enabledNodesOnly, boolean forceUpdateNode) {
        if (!this.isCheckable()) {
            return;
        }
        ArrayList<ITreeNode> changedNodes = new ArrayList<ITreeNode>();
        for (ITreeNode node : nodes) {
            if ((node = this.resolveNode(node)) == null || node.isChecked() == checked && !forceUpdateNode || enabledNodesOnly && !node.isEnabled()) continue;
            if (checked) {
                this.m_checkedNodes.add(node);
            } else {
                this.m_checkedNodes.remove(node);
            }
            changedNodes.add(node);
            if (!checked || this.isMultiCheck()) continue;
            Iterator<ITreeNode> it = this.m_checkedNodes.iterator();
            while (it.hasNext()) {
                if (it.next() == node) continue;
                it.remove();
            }
            break block0;
        }
        if (!changedNodes.isEmpty()) {
            this.fireNodesChecked(changedNodes);
        }
    }

    @Override
    public void checkAllNodes() {
        this.setAllNodesChecked(true);
    }

    @Override
    public void uncheckAllNodes() {
        this.setAllNodesChecked(false);
    }

    @Override
    public void setAllNodesChecked(final boolean checked) {
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                if (element.isChecked() != checked) {
                    AbstractTree.this.setNodeChecked(element, checked);
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.visitTree((IDepthFirstTreeVisitor<ITreeNode>)v);
    }

    private void uncheckAllRec(ITreeNode parent, boolean b) {
        if (parent == null) {
            return;
        }
        this.setNodeChecked(parent, b);
        for (ITreeNode node : parent.getChildNodes()) {
            this.uncheckAllRec(node, b);
        }
    }

    @Override
    public int getNodeStatus(ITreeNode node) {
        if (node != null) {
            return node.getStatus();
        }
        return 0;
    }

    @Override
    public void setNodeStatus(ITreeNode node, int status) {
        if ((node = this.resolveNode(node)) != null && node.getStatus() != status) {
            node.setStatusInternal(status);
            this.fireNodesUpdated(node.getParentNode(), CollectionUtility.arrayList((Object)node));
        }
    }

    private void ensureParentExpanded(ITreeNode parent) {
        if (parent != null) {
            this.ensureParentExpanded(parent.getParentNode());
            if (!parent.isExpanded()) {
                this.setNodeExpanded(parent, true);
            }
        }
    }

    @Override
    public void ensureVisible(ITreeNode node) {
        this.fireNodeEnsureVisible(node);
    }

    @Override
    public void expandAll(ITreeNode parent) {
        try {
            this.setTreeChanging(true);
            this.expandAllRec(parent, 0);
            this.fireNodeExpandedRecursive(parent, true);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    private void expandAllRec(ITreeNode parent, int level) {
        this.setNodeExpanded(parent, true);
        if (level >= 32) {
            LOG.warn("detected loop on tree node {}", (Object)parent);
        } else {
            List<ITreeNode> children = parent.getChildNodes();
            for (ITreeNode child : children) {
                this.expandAllRec(child, level + 1);
            }
        }
    }

    @Override
    public void collapseAll(ITreeNode parent) {
        try {
            this.setTreeChanging(true);
            ArrayList<ITreeNode> list = new ArrayList<ITreeNode>();
            this.fetchAllCollapsingNodesRec(parent, 0, list);
            int n = list.size();
            int i = n - 1;
            while (i >= 0) {
                this.setNodeExpanded((ITreeNode)list.get(i), false);
                --i;
            }
            this.fireNodeExpandedRecursive(parent, false);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    private void fetchAllCollapsingNodesRec(ITreeNode parent, int level, List<ITreeNode> list) {
        if (level >= 32) {
            LOG.warn("detected loop on tree node {}", (Object)parent);
        } else {
            if (parent.isExpanded()) {
                list.add(parent);
            }
            List<ITreeNode> children = parent.getChildNodes();
            for (ITreeNode child : children) {
                this.fetchAllCollapsingNodesRec(child, level + 1, list);
            }
        }
    }

    @Override
    public List<IKeyStroke> getKeyStrokes() {
        return CollectionUtility.arrayList(this.getKeyStrokesInternal());
    }

    protected List<IKeyStroke> getKeyStrokesInternal() {
        return this.propertySupport.getPropertyList("keyStrokes");
    }

    @Override
    public void setKeyStrokes(List<? extends IKeyStroke> keyStrokes) {
        this.m_baseKeyStrokes = CollectionUtility.arrayListWithoutNullElements(keyStrokes);
        this.rebuildKeyStrokesInternal();
    }

    private void setKeyStrokesInternal(List<? extends IKeyStroke> keyStrokes) {
        this.propertySupport.setPropertyList("keyStrokes", keyStrokes);
    }

    @Override
    public void addChildNode(ITreeNode parent, ITreeNode child) {
        if (child != null) {
            this.addChildNodes(parent, CollectionUtility.arrayList((Object)child));
        }
    }

    @Override
    public void addChildNode(int startIndex, ITreeNode parent, ITreeNode child) {
        if (child != null) {
            this.addChildNodes(startIndex, parent, CollectionUtility.arrayList((Object)child));
        }
    }

    @Override
    public void addChildNodes(ITreeNode parent, List<? extends ITreeNode> children) {
        this.addChildNodes(parent.getChildNodeCount(), parent, children);
    }

    @Override
    public void addChildNodes(int startIndex, ITreeNode parent, List<? extends ITreeNode> children) {
        if (!CollectionUtility.hasElements(children)) {
            return;
        }
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            if (parent == null) {
                return;
            }
            ArrayList<ITreeNode> newChildren = new ArrayList<ITreeNode>(children);
            this.fireNodesInserted(parent, newChildren);
            ((AbstractTreeNode)parent).addChildNodesInternal(startIndex, children, true);
            newChildren.removeIf(child -> child.getParentNode() == null);
            this.decorateAffectedNodeCells(parent, newChildren);
            int level = 0;
            ITreeNode tmp = parent;
            while (tmp != null) {
                tmp = tmp.getParentNode();
                ++level;
            }
            for (ITreeNode child2 : newChildren) {
                this.applyNodeFiltersRecInternal(child2, parent.isFilterAccepted(), level);
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void updateNode(ITreeNode node) {
        if (node != null) {
            this.updateChildNodes(node.getParentNode(), CollectionUtility.hashSet((Object)node));
        }
    }

    @Override
    public void updateChildNodes(ITreeNode parent, Collection<? extends ITreeNode> children) {
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            List<ITreeNode> resolvedChildren = this.resolveNodes(children);
            this.decorateAffectedNodeCells(parent, resolvedChildren);
            this.fireNodesUpdated(parent, resolvedChildren);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void updateChildNodeOrder(ITreeNode parent, List<? extends ITreeNode> newChildren) {
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            if (parent == null) {
                return;
            }
            List<ITreeNode> newChildrenResolved = this.resolveNodes(newChildren);
            if (!newChildren.isEmpty() && newChildrenResolved.size() == newChildren.size()) {
                ((AbstractTreeNode)parent).setChildNodeOrderInternal(newChildrenResolved);
                this.decorateAffectedNodeCells(parent, newChildrenResolved);
                this.fireChildNodeOrderChanged(parent, newChildrenResolved);
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void removeNode(ITreeNode node) {
        ITreeNode parent = node.getParentNode();
        ITreeNode child = node;
        this.removeChildNode(parent, child);
    }

    @Override
    public void removeChildNode(ITreeNode parent, ITreeNode child) {
        this.removeChildNodes(parent, CollectionUtility.hashSet((Object)child));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeChildNodes(ITreeNode parent, Collection<? extends ITreeNode> children) {
        if (!CollectionUtility.hasElements(children)) {
            return;
        }
        try {
            void var3_8;
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            if (parent == null) {
                return;
            }
            children = this.resolveNodes(children);
            this.deselectNodes(children);
            for (ITreeNode iTreeNode : children) {
                this.uncheckAllRec(iTreeNode, false);
            }
            ((AbstractTreeNode)parent).removeChildNodesInternal(children, true, this.isAutoDiscardOnDelete());
            this.decorateAffectedNodeCells(parent, parent.getChildNodes());
            if (!this.isAutoDiscardOnDelete()) {
                for (ITreeNode iTreeNode : children) {
                    if (iTreeNode.getStatus() == 1) {
                        iTreeNode.dispose();
                        continue;
                    }
                    iTreeNode.setStatusInternal(3);
                    this.m_deletedNodes.put(iTreeNode.getPrimaryKey(), iTreeNode);
                }
            }
            boolean bl = false;
            ITreeNode tmp = parent;
            while (tmp != null) {
                tmp = tmp.getParentNode();
                ++var3_8;
            }
            for (ITreeNode child : parent.getChildNodes()) {
                this.applyNodeFiltersRecInternal(child, parent.isFilterAccepted(), (int)var3_8);
            }
            if (parent.getChildNodeCount() == 0) {
                this.fireAllChildNodesDeleted(parent, children);
            } else {
                this.fireNodesDeleted(parent, children);
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void removeAllChildNodes(ITreeNode parent) {
        if (parent != null) {
            this.removeChildNodes(parent, parent.getChildNodes());
        }
    }

    @Override
    public void discardDeletedNode(ITreeNode node) {
        this.discardDeletedNodes(CollectionUtility.arrayList((Object)node));
    }

    @Override
    public void discardDeletedNodes(Collection<ITreeNode> nodes) {
        for (ITreeNode node : nodes) {
            ITreeNode delNode = this.m_deletedNodes.get(node.getPrimaryKey());
            if (delNode != node) continue;
            this.m_deletedNodes.remove(node.getPrimaryKey());
        }
    }

    @Override
    public void disposeDeletedNode(ITreeNode node) {
        this.disposeDeletedNodes(CollectionUtility.arrayList((Object)node));
    }

    @Override
    public void disposeDeletedNodes(Collection<ITreeNode> nodes) {
        for (ITreeNode node : CollectionUtility.arrayList(nodes)) {
            ITreeNode delNode = this.m_deletedNodes.get(node.getPrimaryKey());
            if (delNode != node) continue;
            node.setTreeInternal(null, true);
            try {
                node.dispose();
            }
            catch (RuntimeException e) {
                LOG.warn("Exception while disposing node: {}.", (Object)node, (Object)e);
            }
            this.discardDeletedNode(node);
        }
    }

    @Override
    public void clearDeletedNodes() {
        this.disposeDeletedNodes(this.m_deletedNodes.values());
    }

    @Override
    public TreeVisitResult visitTree(IDepthFirstTreeVisitor<ITreeNode> v) {
        return TreeUtility.visitNode(this.getRootNode(), v);
    }

    @Override
    public TreeVisitResult visitNode(ITreeNode node, IDepthFirstTreeVisitor<ITreeNode> v) {
        return TreeUtility.visitNode(node, v);
    }

    @Override
    public TreeVisitResult visitVisibleTree(IDepthFirstTreeVisitor<ITreeNode> v) {
        Function<ITreeNode, Collection<? extends ITreeNode>> childrenSupplier = ITreeNode::getFilteredChildNodes;
        if (this.isRootNodeVisible()) {
            return TreeTraversals.create(v, childrenSupplier).traverse((Object)this.getRootNode());
        }
        ArrayList<ITreeNode> visibleTopLevel = new ArrayList<ITreeNode>(childrenSupplier.apply(this.getRootNode()));
        return TreeUtility.visitNodes(visibleTopLevel, v, childrenSupplier);
    }

    @Override
    public int getDeletedNodeCount() {
        return this.m_deletedNodes.size();
    }

    @Override
    public Set<ITreeNode> getDeletedNodes() {
        return CollectionUtility.hashSet(this.m_deletedNodes.values());
    }

    @Override
    public int getInsertedNodeCount() {
        P_AbstractCountingTreeVisitor v = new P_AbstractCountingTreeVisitor(){

            @Override
            protected boolean accept(ITreeNode node) {
                return node.isStatusInserted();
            }
        };
        this.visitNode(this.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
        return v.getCount();
    }

    @Override
    public Set<ITreeNode> getInsertedNodes() {
        CollectingVisitor<ITreeNode> v = new CollectingVisitor<ITreeNode>(){

            protected boolean accept(ITreeNode element) {
                return element.isStatusInserted();
            }
        };
        this.visitNode(this.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
        return CollectionUtility.hashSet((Collection)v.getCollection());
    }

    @Override
    public int getUpdatedNodeCount() {
        P_AbstractCountingTreeVisitor v = new P_AbstractCountingTreeVisitor(){

            @Override
            protected boolean accept(ITreeNode node) {
                return node.isStatusUpdated();
            }
        };
        this.visitNode(this.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
        return v.getCount();
    }

    @Override
    public Set<ITreeNode> getUpdatedNodes() {
        CollectingVisitor<ITreeNode> v = new CollectingVisitor<ITreeNode>(){

            protected boolean accept(ITreeNode element) {
                return element.isStatusUpdated();
            }
        };
        this.visitNode(this.getRootNode(), (IDepthFirstTreeVisitor<ITreeNode>)v);
        return CollectionUtility.hashSet((Collection)v.getCollection());
    }

    @Override
    public int getSelectedNodeCount() {
        return this.m_selectedNodes.size();
    }

    @Override
    public ITreeNode getSelectedNode() {
        if (!this.m_selectedNodes.isEmpty()) {
            return this.m_selectedNodes.iterator().next();
        }
        return null;
    }

    @Override
    public Set<ITreeNode> getSelectedNodes() {
        return CollectionUtility.hashSet(this.m_selectedNodes);
    }

    @Override
    public boolean isSelectedNode(ITreeNode node) {
        if ((node = this.resolveNode(node)) != null) {
            return this.m_selectedNodes.contains(node);
        }
        return false;
    }

    @Override
    public void selectNode(ITreeNode node) {
        this.selectNode(node, false);
    }

    @Override
    public void selectNode(ITreeNode node, boolean append) {
        if (node != null) {
            this.selectNodes(CollectionUtility.hashSet((Object)node), append);
        } else {
            this.selectNodes(null, append);
        }
    }

    @Override
    public void selectNodes(Collection<? extends ITreeNode> nodes, boolean append) {
        if ((nodes = this.resolveNodes(nodes)) == null) {
            nodes = CollectionUtility.hashSet((Object[])new ITreeNode[0]);
        }
        HashSet<ITreeNode> newSelection = new HashSet<ITreeNode>();
        if (append) {
            newSelection.addAll(this.m_selectedNodes);
            newSelection.addAll(nodes);
        } else {
            newSelection.addAll(nodes);
        }
        if (newSelection.size() > 1 && !this.isMultiSelect()) {
            ITreeNode first = (ITreeNode)newSelection.iterator().next();
            newSelection.clear();
            newSelection.add(first);
        }
        if (!this.m_selectedNodes.equals(newSelection) || !this.m_selectedNodes.containsAll(nodes)) {
            Set<ITreeNode> oldSelection = this.m_selectedNodes;
            this.fireBeforeNodesSelected(oldSelection, newSelection);
            this.m_selectedNodes = newSelection;
            this.fireNodesSelected(oldSelection, this.m_selectedNodes);
        }
    }

    @Override
    public void selectNextNode() {
        final ITreeNode current = this.getSelectedNode();
        if (current != null) {
            final Holder next = new Holder(ITreeNode.class);
            DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){
                boolean m_foundCurrent;

                public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                    if (this.m_foundCurrent) {
                        if (element.isFilterAccepted()) {
                            next.setValue((Object)element);
                            return TreeVisitResult.TERMINATE;
                        }
                    } else {
                        this.m_foundCurrent = element == current;
                    }
                    return TreeVisitResult.CONTINUE;
                }
            };
            this.visitVisibleTree((IDepthFirstTreeVisitor<ITreeNode>)v);
            if (next.getValue() != null) {
                this.selectNode((ITreeNode)next.getValue());
            }
        } else {
            this.selectFirstNode();
        }
    }

    @Override
    public void selectPreviousNode() {
        final ITreeNode current = this.getSelectedNode();
        if (current != null) {
            final Holder foundVisited = new Holder(ITreeNode.class);
            DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

                public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                    if (element == current) {
                        return TreeVisitResult.TERMINATE;
                    }
                    if (element.isFilterAccepted()) {
                        foundVisited.setValue((Object)element);
                    }
                    return TreeVisitResult.CONTINUE;
                }
            };
            this.visitVisibleTree((IDepthFirstTreeVisitor<ITreeNode>)v);
            if (foundVisited.getValue() != null) {
                this.selectNode((ITreeNode)foundVisited.getValue());
            }
        } else {
            this.selectLastNode();
        }
    }

    @Override
    public ITreeNode selectFirstNode() {
        if (!this.isRootNodeVisible()) {
            this.getRootNode().ensureChildrenLoaded();
        }
        final Holder foundVisited = new Holder(ITreeNode.class);
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                if (element.isFilterAccepted()) {
                    foundVisited.setValue((Object)element);
                    return TreeVisitResult.TERMINATE;
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.visitVisibleTree((IDepthFirstTreeVisitor<ITreeNode>)v);
        ITreeNode firstNode = (ITreeNode)foundVisited.getValue();
        if (firstNode != null) {
            this.selectNode(firstNode);
        }
        return firstNode;
    }

    @Override
    public void selectLastNode() {
        if (!this.isRootNodeVisible()) {
            try {
                this.getRootNode().ensureChildrenLoaded();
            }
            catch (RuntimeException e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        }
        final Holder foundVisited = new Holder(ITreeNode.class);
        DepthFirstTreeVisitor<ITreeNode> v = new DepthFirstTreeVisitor<ITreeNode>(){

            public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
                if (element.isFilterAccepted()) {
                    foundVisited.setValue((Object)element);
                }
                return TreeVisitResult.CONTINUE;
            }
        };
        this.visitVisibleTree((IDepthFirstTreeVisitor<ITreeNode>)v);
        if (foundVisited.getValue() != null) {
            this.selectNode((ITreeNode)foundVisited.getValue());
        }
    }

    @Override
    public void selectNextChildNode() {
        ITreeNode current = this.getSelectedNode();
        if (current != null) {
            current.setExpanded(true);
        }
        this.selectNextNode();
    }

    @Override
    public void selectPreviousParentNode() {
        ITreeNode n = this.getSelectedNode();
        if (n != null) {
            ITreeNode parent = n.getParentNode();
            while (parent != null) {
                if ((parent != this.getRootNode() || this.isRootNodeVisible()) && parent.isFilterAccepted()) {
                    this.selectNode(parent);
                    return;
                }
                parent = parent.getParentNode();
            }
        } else {
            this.selectFirstNode();
        }
    }

    @Override
    public void deselectNode(ITreeNode node) {
        if (node != null) {
            this.deselectNodes(CollectionUtility.hashSet((Object)node));
        } else {
            this.deselectNodes(null);
        }
    }

    @Override
    public void deselectNodes(Collection<? extends ITreeNode> nodes) {
        if (CollectionUtility.hasElements(nodes = this.resolveNodes(nodes))) {
            HashSet<ITreeNode> oldSelection = new HashSet<ITreeNode>(this.m_selectedNodes);
            HashSet<ITreeNode> newSelection = new HashSet<ITreeNode>();
            if (this.m_selectedNodes != null) {
                for (ITreeNode selChild : this.m_selectedNodes) {
                    boolean accept = true;
                    for (ITreeNode iTreeNode : nodes) {
                        if (!this.isAncestorNodeOf(iTreeNode, selChild)) continue;
                        accept = false;
                        break;
                    }
                    if (!accept) continue;
                    newSelection.add(selChild);
                }
            }
            if (oldSelection.size() != newSelection.size()) {
                this.fireBeforeNodesSelected(oldSelection, newSelection);
                this.m_selectedNodes = newSelection;
                this.fireNodesSelected(oldSelection, this.m_selectedNodes);
            }
        }
    }

    @Override
    public Set<ITreeNode> getCheckedNodes() {
        return CollectionUtility.hashSet(this.m_checkedNodes);
    }

    @Override
    public int getCheckedNodesCount() {
        return this.m_checkedNodes.size();
    }

    @Override
    public boolean isScrollToSelection() {
        return this.propertySupport.getPropertyBool("scrollToSelection");
    }

    @Override
    public void setScrollToSelection(boolean b) {
        this.propertySupport.setPropertyBool("scrollToSelection", b);
    }

    @Override
    public void scrollToSelection() {
        this.fireTreeEventInternal(new TreeEvent(this, 830));
    }

    private ITreeNode resolveNode(ITreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.getTree() == this) {
            return node;
        }
        return null;
    }

    private List<ITreeNode> resolveNodes(Collection<? extends ITreeNode> nodes) {
        if (!CollectionUtility.hasElements(nodes)) {
            return CollectionUtility.emptyArrayList();
        }
        ArrayList<ITreeNode> resolvedNodes = new ArrayList<ITreeNode>(nodes.size());
        for (ITreeNode iTreeNode : nodes) {
            if (this.resolveNode(iTreeNode) == null) continue;
            resolvedNodes.add(iTreeNode);
        }
        return resolvedNodes;
    }

    @Override
    public TreeListeners treeListeners() {
        return this.m_listeners;
    }

    protected IEventHistory<TreeEvent> createEventHistory() {
        return new DefaultTreeEventHistory(5000L);
    }

    @Override
    public IEventHistory<TreeEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    protected void filterInitializingTreeNodes(Collection<? extends ITreeNode> nodes) {
        if (nodes == null) {
            return;
        }
        nodes.removeIf(node -> node != null && node.isInitializing());
    }

    private void fireNodesInserted(ITreeNode parent, List<ITreeNode> children) {
        if (parent != null && parent.isInitializing()) {
            return;
        }
        this.filterInitializingTreeNodes(children);
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 10, parent, children));
        }
    }

    private void fireNodesUpdated(ITreeNode parent, Collection<ITreeNode> children) {
        if (parent != null && parent.isInitializing()) {
            return;
        }
        this.filterInitializingTreeNodes(children);
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 20, parent, children));
        }
    }

    private void fireNodesChecked(List<ITreeNode> nodes) {
        this.filterInitializingTreeNodes(nodes);
        if (CollectionUtility.hasElements(nodes)) {
            this.fireTreeEventInternal(new TreeEvent((ITree)this, 870, nodes));
        }
    }

    @Override
    public void fireNodeChanged(ITreeNode node) {
        if (node != null && node.isInitializing()) {
            return;
        }
        this.fireTreeEventInternal(new TreeEvent((ITree)this, 850, node));
    }

    private void fireNodeFilterChanged() {
        if (this.getRootNode() != null && this.getRootNode().isInitializing()) {
            return;
        }
        this.fireTreeEventInternal(new TreeEvent((ITree)this, 400, this.getRootNode()));
    }

    private void fireNodesDeleted(ITreeNode parent, Collection<? extends ITreeNode> children) {
        if (parent != null && parent.isInitializing()) {
            return;
        }
        this.filterInitializingTreeNodes(children);
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 30, parent, children));
        }
    }

    private void fireAllChildNodesDeleted(ITreeNode parent, Collection<? extends ITreeNode> children) {
        if (parent != null && parent.isInitializing()) {
            return;
        }
        this.filterInitializingTreeNodes(children);
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 31, parent, children));
        }
    }

    private void fireChildNodeOrderChanged(ITreeNode parent, List<? extends ITreeNode> children) {
        if (parent != null && parent.isInitializing()) {
            return;
        }
        this.filterInitializingTreeNodes(children);
        if (CollectionUtility.hasElements(children)) {
            this.fireTreeEventInternal(new TreeEvent(this, 50, parent, children));
        }
    }

    private void fireBeforeNodesSelected(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        TreeEvent e = new TreeEvent((ITree)this, 35, newSelection);
        HashSet<ITreeNode> deselectedNodes = new HashSet<ITreeNode>(oldSelection);
        deselectedNodes.removeAll(newSelection);
        e.setDeselectedNodes(deselectedNodes);
        HashSet<ITreeNode> newSelectedNodes = new HashSet<ITreeNode>(newSelection);
        newSelectedNodes.removeAll(oldSelection);
        boolean emptySelection = newSelectedNodes.isEmpty();
        this.filterInitializingTreeNodes(newSelectedNodes);
        if (!emptySelection && newSelectedNodes.isEmpty()) {
            return;
        }
        e.setNewSelectedNodes(newSelectedNodes);
        this.fireTreeEventInternal(e);
    }

    private void fireNodesSelected(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        if (this.isAutoTitle()) {
            this.rebuildTitleInternal();
        }
        TreeEvent e = new TreeEvent((ITree)this, 40, newSelection);
        HashSet<ITreeNode> deselectedNodes = new HashSet<ITreeNode>(oldSelection);
        deselectedNodes.removeAll(newSelection);
        e.setDeselectedNodes(deselectedNodes);
        HashSet<ITreeNode> newSelectedNodes = new HashSet<ITreeNode>(newSelection);
        newSelectedNodes.removeAll(oldSelection);
        boolean emptySelection = newSelectedNodes.isEmpty();
        this.filterInitializingTreeNodes(newSelectedNodes);
        if (!emptySelection && newSelectedNodes.isEmpty()) {
            return;
        }
        e.setNewSelectedNodes(newSelectedNodes);
        try {
            this.nodesSelectedInternal(deselectedNodes, newSelectedNodes);
            this.interceptNodesSelected(e);
        }
        catch (Exception ex) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
        }
        this.fireTreeEventInternal(e);
    }

    protected void nodesSelectedInternal(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        this.updateNodeMenus(this.m_selectedNodes);
    }

    protected void updateNodeMenus(Set<ITreeNode> newSelectedNodes) {
        if (this.m_currentNodeMenus != null) {
            this.getContextMenu().removeChildActions(this.m_currentNodeMenus);
            this.m_currentNodeMenus = null;
        }
        if (CollectionUtility.hasElements(newSelectedNodes)) {
            ArrayList<IMenu> nodeMenus = new ArrayList<IMenu>(((ITreeNode)CollectionUtility.firstElement(newSelectedNodes)).getMenus());
            this.m_currentNodeMenus = nodeMenus;
            this.getContextMenu().addChildActions(nodeMenus);
        }
    }

    private void fireNodeExpanded(ITreeNode node, boolean b) {
        if (node != null && !node.isInitializing()) {
            if (b) {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 100, node));
            } else {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 101, node));
            }
        }
    }

    private void fireNodeExpandedRecursive(ITreeNode node, boolean b) {
        if (node != null && !node.isInitializing()) {
            if (b) {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 102, node));
            } else {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 103, node));
            }
        }
    }

    private void fireNodeClick(ITreeNode node, MouseButton mouseButton) {
        if (node != null && !node.isInitializing()) {
            try {
                this.interceptNodeClick(node, mouseButton);
            }
            catch (Exception ex) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
            }
        }
    }

    protected void interceptNodesChecked(List<ITreeNode> nodes) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeNodesCheckedChain chain = new TreeChains.TreeNodesCheckedChain(extensions);
        chain.execNodesChecked(nodes);
    }

    private void fireNodeAction(ITreeNode node) {
        if (this.isActionRunning()) {
            return;
        }
        if (node == null || node.isInitializing() || !node.isLeaf()) {
            return;
        }
        try {
            this.setActionRunning(true);
            try {
                this.interceptNodeAction(node);
            }
            catch (Exception ex) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
            }
        }
        finally {
            this.setActionRunning(false);
        }
    }

    private void fireRequestFocus() {
        TreeEvent e = new TreeEvent(this, 800);
        this.fireTreeEventInternal(e);
    }

    private TransferObject fireNodesDragRequest(Collection<ITreeNode> nodes) {
        this.filterInitializingTreeNodes(nodes);
        if (CollectionUtility.hasElements(nodes)) {
            TreeEvent e = new TreeEvent((ITree)this, 730, nodes);
            this.fireTreeEventInternal(e);
            return e.getDragObject();
        }
        return null;
    }

    private void fireNodeDropAction(ITreeNode node, TransferObject dropData) {
        if (node != null && node.isInitializing()) {
            return;
        }
        TreeEvent e = new TreeEvent((ITree)this, 740, node);
        e.setDropObject(dropData);
        this.fireTreeEventInternal(e);
    }

    public void fireNodeDropTargetChanged(ITreeNode node) {
        if (node != null && node.isInitializing()) {
            return;
        }
        TreeEvent e = new TreeEvent((ITree)this, 860, node);
        this.fireTreeEventInternal(e);
    }

    public void fireDragFinished() {
        TreeEvent e = new TreeEvent(this, 735);
        this.fireTreeEventInternal(e);
    }

    private void fireNodeEnsureVisible(ITreeNode node) {
        if (node != null && node.isInitializing()) {
            return;
        }
        TreeEvent e = new TreeEvent((ITree)this, 300, node);
        this.fireTreeEventInternal(e);
    }

    protected void fireTreeEventInternal(TreeEvent e) {
        if (this.isTreeChanging()) {
            this.getEventBuffer().add(e);
        } else {
            this.doFireTreeEvent(e);
        }
    }

    protected void doFireTreeEvent(TreeEvent e) {
        this.m_listeners.fireEvent(e);
    }

    private void decorateAffectedNodeCells(ITreeNode parent, Collection<ITreeNode> children) {
        this.decorateAffectedNodeCellsOnPathToRoot(parent);
        for (ITreeNode child : children) {
            this.decorateAffectedNodeCellsOnSubtree(child);
        }
    }

    private void decorateAffectedNodeCellsOnPathToRoot(ITreeNode node) {
        ITreeNode tmp = node;
        while (tmp != null) {
            this.m_nodeDecorationBuffer.add(tmp);
            tmp = tmp.getParentNode();
        }
    }

    private void decorateAffectedNodeCellsOnSubtree(ITreeNode node) {
        this.m_nodeDecorationBuffer.add(node);
        for (ITreeNode child : node.getChildNodes()) {
            this.decorateAffectedNodeCellsOnSubtree(child);
        }
    }

    private void processTreeBuffers() {
        try {
            ++this.m_processTreeBufferLoopDetection;
            if (this.m_processTreeBufferLoopDetection > 100) {
                LOG.error("LOOP DETECTION in {}. see stack trace for more details.", this.getClass(), (Object)new Exception("LOOP DETECTION"));
                return;
            }
            this.processDecorationBuffer();
            this.processEventBuffer();
        }
        finally {
            --this.m_processTreeBufferLoopDetection;
        }
    }

    private void processDecorationBuffer() {
        if (!this.m_nodeDecorationBuffer.isEmpty()) {
            Set<ITreeNode> set = this.m_nodeDecorationBuffer;
            this.m_nodeDecorationBuffer = new HashSet<ITreeNode>();
            try {
                this.setTreeChanging(true);
                for (ITreeNode node : set) {
                    if (node.getTree() == null) continue;
                    try {
                        this.interceptDecorateCell(node, node.getCellForUpdate());
                    }
                    catch (Exception t) {
                        LOG.warn("node {} ({})", new Object[]{node.getClass(), node.toPlainText(), t});
                    }
                }
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    private void processEventBuffer() {
        if (!this.getEventBuffer().isEmpty()) {
            List<TreeEvent> list = this.getEventBuffer().consumeAndCoalesceEvents();
            try {
                this.setTreeChanging(true);
                this.m_listeners.fireEvents(list);
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setMultiSelect(boolean b) {
        this.propertySupport.setPropertyBool("multiSelect", b);
    }

    @Override
    public boolean isMultiCheck() {
        return this.propertySupport.getPropertyBool("multiCheck");
    }

    @Override
    public void setMultiCheck(boolean b) {
        this.propertySupport.setPropertyBool("multiCheck", b);
    }

    @Override
    public void unloadNode(ITreeNode node) {
        try {
            this.setTreeChanging(true);
            node.unload();
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void doAppLinkAction(String ref) {
        if (this.isActionRunning()) {
            return;
        }
        try {
            this.setActionRunning(true);
            this.interceptAppLinkAction(ref);
        }
        finally {
            this.setActionRunning(false);
        }
    }

    @Override
    public void exportTreeData(AbstractTreeFieldData target) {
        this.exportTreeNodeDataRec(this.getRootNode().getChildNodes(), target, null);
    }

    private void exportTreeNodeDataRec(List<ITreeNode> nodes, AbstractTreeFieldData treeData, TreeNodeData parentNodeData) {
        ArrayList<TreeNodeData> nodeDataList = new ArrayList<TreeNodeData>(nodes.size());
        for (ITreeNode node : nodes) {
            TreeNodeData nodeData = this.exportTreeNodeData(node, treeData);
            if (nodeData == null) continue;
            this.exportTreeNodeDataRec(node.getChildNodes(), treeData, nodeData);
            nodeDataList.add(nodeData);
        }
        if (parentNodeData != null) {
            parentNodeData.setChildNodes(nodeDataList);
        } else {
            treeData.setRoots(nodeDataList);
        }
    }

    protected TreeNodeData exportTreeNodeData(ITreeNode node, AbstractTreeFieldData treeData) {
        TreeNodeData nodeData = new TreeNodeData();
        return nodeData;
    }

    @Override
    public void importTreeData(AbstractTreeFieldData source) {
        if (source.isValueSet()) {
            try {
                this.setTreeChanging(true);
                this.removeAllChildNodes(this.getRootNode());
                this.importTreeNodeDataRec(this.getRootNode(), source, source.getRoots());
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    private void importTreeNodeDataRec(ITreeNode parentNode, AbstractTreeFieldData treeData, List<TreeNodeData> nodeDataList) {
        if (nodeDataList != null) {
            for (TreeNodeData nodeData : nodeDataList) {
                ITreeNode node = this.importTreeNodeData(parentNode, treeData, nodeData);
                if (node == null) continue;
                this.importTreeNodeDataRec(node, treeData, nodeData.getChildNodes());
            }
        }
    }

    protected ITreeNode importTreeNodeData(ITreeNode parentNode, AbstractTreeFieldData treeData, TreeNodeData nodeData) {
        return null;
    }

    protected ITreeUIFacade createUIFacade() {
        return new P_UIFacade();
    }

    @Override
    public ITreeUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private boolean isActionRunning() {
        return FLAGS_BIT_HELPER.isBitSet(ACTION_RUNNING, this.m_flags);
    }

    private void setActionRunning(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(ACTION_RUNNING, b, this.m_flags);
    }

    @Override
    public boolean isSaveAndRestoreScrollbars() {
        return FLAGS_BIT_HELPER.isBitSet(SAVE_AND_RESTORE_SCROLLBARS, this.m_flags);
    }

    @Override
    public void setSaveAndRestoreScrollbars(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit(SAVE_AND_RESTORE_SCROLLBARS, b, this.m_flags);
    }

    protected final void interceptDrop(ITreeNode node, TransferObject t) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDropChain chain = new TreeChains.TreeDropChain(extensions);
        chain.execDrop(node, t);
    }

    protected final void interceptInitTree() {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeInitTreeChain chain = new TreeChains.TreeInitTreeChain(extensions);
        chain.execInitTree();
    }

    protected final void interceptDropTargetChanged(ITreeNode node) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDropTargetChangedChain chain = new TreeChains.TreeDropTargetChangedChain(extensions);
        chain.execDropTargetChanged(node);
    }

    protected final TransferObject interceptDrag(Collection<ITreeNode> nodes) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDragNodesChain chain = new TreeChains.TreeDragNodesChain(extensions);
        return chain.execDrag(nodes);
    }

    protected final void interceptNodeAction(ITreeNode node) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeNodeActionChain chain = new TreeChains.TreeNodeActionChain(extensions);
        chain.execNodeAction(node);
    }

    protected final void interceptNodeClick(ITreeNode node, MouseButton mouseButton) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeNodeClickChain chain = new TreeChains.TreeNodeClickChain(extensions);
        chain.execNodeClick(node, mouseButton);
    }

    protected final void interceptAppLinkAction(String ref) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeHyperlinkActionChain chain = new TreeChains.TreeHyperlinkActionChain(extensions);
        chain.execHyperlinkAction(ref);
    }

    protected final void interceptNodesSelected(TreeEvent e) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeNodesSelectedChain chain = new TreeChains.TreeNodesSelectedChain(extensions);
        chain.execNodesSelected(e);
    }

    protected final void interceptDisposeTree() {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDisposeTreeChain chain = new TreeChains.TreeDisposeTreeChain(extensions);
        chain.execDisposeTree();
    }

    protected final void interceptDecorateCell(ITreeNode node, Cell cell) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDecorateCellChain chain = new TreeChains.TreeDecorateCellChain(extensions);
        chain.execDecorateCell(node, cell);
    }

    protected final TransferObject interceptDrag(ITreeNode node) {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        TreeChains.TreeDragNodeChain chain = new TreeChains.TreeDragNodeChain(extensions);
        return chain.execDrag(node);
    }

    protected static class LocalTreeExtension<OWNER extends AbstractTree>
    extends AbstractExtension<OWNER>
    implements ITreeExtension<OWNER> {
        public LocalTreeExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execDrop(TreeChains.TreeDropChain chain, ITreeNode node, TransferObject t) {
            ((AbstractTree)this.getOwner()).execDrop(node, t);
        }

        @Override
        public void execInitTree(TreeChains.TreeInitTreeChain chain) {
            ((AbstractTree)this.getOwner()).execInitTree();
        }

        @Override
        public void execDropTargetChanged(TreeChains.TreeDropTargetChangedChain chain, ITreeNode node) {
            ((AbstractTree)this.getOwner()).execDropTargetChanged(node);
        }

        @Override
        public TransferObject execDrag(TreeChains.TreeDragNodesChain chain, Collection<ITreeNode> nodes) {
            return ((AbstractTree)this.getOwner()).execDrag(nodes);
        }

        @Override
        public void execNodeAction(TreeChains.TreeNodeActionChain chain, ITreeNode node) {
            ((AbstractTree)this.getOwner()).execNodeAction(node);
        }

        @Override
        public void execNodeClick(TreeChains.TreeNodeClickChain chain, ITreeNode node, MouseButton mouseButton) {
            ((AbstractTree)this.getOwner()).execNodeClick(node, mouseButton);
        }

        @Override
        public void execAppLinkAction(TreeChains.TreeHyperlinkActionChain chain, String ref) {
            ((AbstractTree)this.getOwner()).execAppLinkAction(ref);
        }

        @Override
        public void execNodesSelected(TreeChains.TreeNodesSelectedChain chain, TreeEvent e) {
            ((AbstractTree)this.getOwner()).execNodesSelected(e);
        }

        @Override
        public void execDisposeTree(TreeChains.TreeDisposeTreeChain chain) {
            ((AbstractTree)this.getOwner()).execDisposeTree();
        }

        @Override
        public void execDecorateCell(TreeChains.TreeDecorateCellChain chain, ITreeNode node, Cell cell) {
            ((AbstractTree)this.getOwner()).execDecorateCell(node, cell);
        }

        @Override
        public TransferObject execDrag(TreeChains.TreeDragNodeChain chain, ITreeNode node) {
            return ((AbstractTree)this.getOwner()).execDrag(node);
        }

        @Override
        public void execNodesChecked(TreeChains.TreeNodesCheckedChain chain, List<ITreeNode> nodes) {
            ((AbstractTree)this.getOwner()).execNodesChecked(nodes);
        }
    }

    private static abstract class P_AbstractCountingTreeVisitor
    extends DepthFirstTreeVisitor<ITreeNode> {
        private int m_count;

        private P_AbstractCountingTreeVisitor() {
        }

        public TreeVisitResult preVisit(ITreeNode element, int level, int index) {
            if (this.accept(element)) {
                ++this.m_count;
            }
            return TreeVisitResult.CONTINUE;
        }

        protected boolean accept(ITreeNode node) {
            return true;
        }

        public int getCount() {
            return this.m_count;
        }
    }

    protected class P_UIFacade
    implements ITreeUIFacade {
        private int m_uiProcessorCount = 0;

        protected P_UIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void setNodesCheckedFromUI(List<ITreeNode> nodes, boolean checked) {
            block11: {
                if (!AbstractTree.this.isEnabled()) {
                    return;
                }
                try {
                    try {
                        this.pushUIProcessor();
                        try {
                            AbstractTree.this.setTreeChanging(true);
                            nodes = AbstractTree.this.resolveNodes(nodes);
                            if (!nodes.isEmpty()) {
                                AbstractTree.this.setNodesChecked(nodes, checked, AbstractTree.this.isAutoCheckChildNodes() == false);
                            }
                            break block11;
                        }
                        finally {
                            AbstractTree.this.setTreeChanging(false);
                        }
                    }
                    catch (RuntimeException e) {
                        msg = new StringBuilder();
                        ** for (node : nodes)
                    }
lbl-1000:
                    // 1 sources

                    {
                        msg.append("[");
                        msg.append(node.toPlainText());
                        msg.append("]");
                        continue;
                    }
lbl25:
                    // 1 sources

                    throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("nodes", (Object)msg.toString(), new Object[0]);
                }
                finally {
                    this.popUIProcessor();
                }
            }
        }

        @Override
        public void setNodeExpandedFromUI(ITreeNode node, boolean on, boolean lazy) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        node = AbstractTree.this.resolveNode(node);
                        if (node != null && (node.isExpanded() != on || node.isExpandedLazy() != lazy)) {
                            if (on && (node.isChildrenDirty() || node.isChildrenVolatile())) {
                                node.loadChildren();
                            }
                            AbstractTree.this.setNodeExpanded(node, on, lazy);
                        }
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (RuntimeException e) {
                    if (node != null) {
                        throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("node", (Object)node.toPlainText(), new Object[0]);
                    }
                    throw e;
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setNodeSelectedAndExpandedFromUI(ITreeNode node) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        node = AbstractTree.this.resolveNode(node);
                        if (node != null) {
                            if (node.isChildrenDirty() || node.isChildrenVolatile()) {
                                node.loadChildren();
                            }
                            AbstractTree.this.setNodeExpanded(node, true);
                            AbstractTree.this.selectNode(node, false);
                            if (!AbstractTree.this.isScrollToSelection()) {
                                AbstractTree.this.scrollToSelection();
                            }
                        }
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (RuntimeException e) {
                    if (node != null) {
                        throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("cell", (Object)node.toPlainText(), new Object[0]);
                    }
                    throw e;
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setNodesSelectedFromUI(List<ITreeNode> nodes) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        List<ITreeNode> validNodes = AbstractTree.this.resolveNodes(nodes);
                        validNodes.removeIf(iTreeNode -> !iTreeNode.isFilterAccepted());
                        for (ITreeNode node : validNodes) {
                            if (!node.isChildrenLoaded() || !node.isChildrenDirty() && !node.isChildrenVolatile()) continue;
                            node.loadChildren();
                        }
                        AbstractTree.this.selectNodes(validNodes, false);
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (RuntimeException e) {
                    if (nodes != null) {
                        throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("nodes", (Object)nodes.toString(), new Object[0]);
                    }
                    throw e;
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeClickFromUI(ITreeNode node, MouseButton mouseButton) {
            try {
                this.pushUIProcessor();
                node = AbstractTree.this.resolveNode(node);
                if (node != null) {
                    AbstractTree.this.fireNodeClick(node, mouseButton);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeActionFromUI(ITreeNode node) {
            try {
                this.pushUIProcessor();
                node = AbstractTree.this.resolveNode(node);
                if (node != null) {
                    AbstractTree.this.fireNodeAction(node);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public TransferObject fireNodesDragRequestFromUI() {
            try {
                this.pushUIProcessor();
                Set<ITreeNode> nodes = AbstractTree.this.getSelectedNodes();
                TransferObject transferObject = AbstractTree.this.fireNodesDragRequest(nodes);
                return transferObject;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireDragFinishedFromUI() {
            try {
                this.pushUIProcessor();
                AbstractTree.this.fireDragFinished();
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeDropTargetChangedFromUI(ITreeNode node) {
            try {
                this.pushUIProcessor();
                node = AbstractTree.this.resolveNode(node);
                if (node != null) {
                    AbstractTree.this.fireNodeDropTargetChanged(node);
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeDropActionFromUI(ITreeNode node, TransferObject dropData) {
            try {
                this.pushUIProcessor();
                node = AbstractTree.this.resolveNode(node);
                AbstractTree.this.fireNodeDropAction(node, dropData);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireAppLinkActionFromUI(String ref) {
            try {
                this.pushUIProcessor();
                AbstractTree.this.doAppLinkAction(ref);
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setDisplayStyleFromUI(String style) {
            AbstractTree.this.setDisplayStyle(style);
        }
    }
}

