/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.userfilter;

import java.util.Set;
import org.eclipse.scout.rt.client.services.common.bookmark.internal.BookmarkUtility;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.userfilter.AbstractUserFilterState;
import org.eclipse.scout.rt.client.ui.basic.userfilter.IColumnAwareUserFilterState;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class ColumnUserFilterState
extends AbstractUserFilterState
implements IColumnAwareUserFilterState {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "column";
    private transient IColumn<?> m_column;
    private String m_columnId;
    private Set<Object> m_selectedValues;

    public ColumnUserFilterState(IColumn<?> column) {
        this.setColumn(column);
        this.setType(TYPE);
    }

    public IColumn<?> getColumn() {
        return this.m_column;
    }

    public void setColumn(IColumn<?> column) {
        this.m_column = column;
        this.m_columnId = column.getColumnId();
    }

    public Set<Object> getSelectedValues() {
        return this.m_selectedValues;
    }

    public void setSelectedValues(Set<Object> selectedValues) {
        this.m_selectedValues = selectedValues;
    }

    @Override
    public Object createKey() {
        return this.m_columnId;
    }

    @Override
    public String getDisplayText() {
        return TEXTS.get((String)"Column") + " \"" + this.getColumn().getHeaderCell().getText() + "\"";
    }

    @Override
    public boolean notifyDeserialized(Object obj) {
        ITable table = (ITable)obj;
        this.m_column = BookmarkUtility.resolveColumn(table.getColumns(), this.m_columnId);
        return this.m_column != null;
    }

    @Override
    public void replaceColumn(IColumn<?> col) {
        if (ObjectUtility.equals((Object)this.m_columnId, (Object)col.getColumnId())) {
            this.setColumn(col);
        }
    }
}

