/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.organizer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractAlphanumericSortingStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.IOrganizeColumnsForm;
import org.eclipse.scout.rt.client.ui.dnd.JavaTransferObject;
import org.eclipse.scout.rt.client.ui.dnd.TransferObject;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.HorizontalGroupBoxBodyGrid;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.html.IHtmlContent;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

@ClassId(value="5bd26d3c-604d-4991-a246-7fff74e32faa")
public class OrganizeColumnsForm
extends AbstractForm
implements IOrganizeColumnsForm {
    private static final String UNICODE_ARROW_UP = "\u2191";
    private static final String UNICODE_ARROW_DOWN = "\u2193";
    private final ITable m_organizedTable;
    protected boolean m_loading;

    public OrganizeColumnsForm(ITable table) {
        super(false);
        this.m_organizedTable = table;
        this.callInitializer();
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.getRootGroupBox().setScrollable(true);
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"TableOrganize");
    }

    @Override
    protected Boolean getConfiguredHeaderVisible() {
        return true;
    }

    public MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField getColumnsTableField() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.class);
    }

    public MainBox.GroupBox.ProfilesBox.ProfilesTableField getProfilesTableField() {
        return this.getFieldByClass(MainBox.GroupBox.ProfilesBox.ProfilesTableField.class);
    }

    public MainBox.GroupBox getGroupBox() {
        return this.getFieldByClass(MainBox.GroupBox.class);
    }

    public MainBox getMainBox() {
        return this.getFieldByClass(MainBox.class);
    }

    public ITable getOrganizedTable() {
        return this.m_organizedTable;
    }

    public void updateColumnVisibilityAndOrder() {
        List visibleColumns = ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getKeyColumn().getValues();
        this.m_organizedTable.getColumnSet().setVisibleColumns(visibleColumns);
        ClientUIPreferences.getInstance().setAllTableColumnPreferences(this.m_organizedTable);
    }

    public void moveUp(ITableRow row) {
        this.moveUp(row, row.getRowIndex() - 1);
    }

    public void moveUp(ITableRow row, int targetIndex) {
        if (row != null && targetIndex >= 0) {
            ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), targetIndex);
        }
        this.updateColumnVisibilityAndOrder();
        this.enableDisableMenus();
    }

    public void moveDown(ITableRow row) {
        this.moveDown(row, row.getRowIndex() + 1);
    }

    public void moveDown(ITableRow row, int targetIndex) {
        if (row != null && targetIndex < ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getRowCount()) {
            ((MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), targetIndex);
        }
        this.updateColumnVisibilityAndOrder();
        this.enableDisableMenus();
    }

    public void enableDisableMenus() {
        boolean moveUpEnabled = false;
        boolean moveDownEnabled = false;
        boolean addEnabled = false;
        boolean modifyEnabled = false;
        boolean removeEnabled = false;
        MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable = (MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable();
        List<ITableRow> selectedRows = columnsTable.getSelectedRows();
        addEnabled = this.isColumnAddable();
        for (ITableRow row : selectedRows) {
            IColumn selectedColumn = (IColumn)columnsTable.getKeyColumn().getValue(row);
            if (this.isColumnMovableUp(selectedColumn)) {
                moveUpEnabled = true;
            }
            if (this.isColumnMovableDown(selectedColumn)) {
                moveDownEnabled = true;
            }
            if (this.isColumnRemovable(selectedColumn)) {
                removeEnabled = true;
            }
            if (!this.isColumnModifiable(selectedColumn)) continue;
            modifyEnabled = true;
        }
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.AddColumnMenu.class, addEnabled);
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.ModifyCustomColumnMenu.class, modifyEnabled);
        this.setEnabledAndVisible(columnsTable, MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.RemoveMenu.class, removeEnabled);
        columnsTable.getMenuByClass(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.MoveUpMenu.class).setEnabled(moveUpEnabled);
        columnsTable.getMenuByClass(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table.MoveDownMenu.class).setEnabled(moveDownEnabled);
    }

    private void setEnabledAndVisible(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable, Class<? extends IMenu> menuType, boolean enabled) {
        IMenu menu = columnsTable.getMenuByClass(menuType);
        menu.setEnabled(enabled);
        menu.setVisible(enabled);
    }

    @Override
    public void reload() {
        this.m_loading = true;
        try {
            this.getColumnsTableField().reloadTableData();
            this.getProfilesTableField().reloadTableData();
        }
        finally {
            this.m_loading = false;
        }
    }

    @Override
    public boolean isFormLoading() {
        return super.isFormLoading() || this.m_loading;
    }

    public void storeCurrentStateAsConfig(String configName) {
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        prefs.addTableColumnsConfig(this.m_organizedTable, configName);
        prefs.setAllTableColumnPreferences(this.m_organizedTable, configName);
        if (this.isCustomizable()) {
            prefs.setTableCustomizerData(this.m_organizedTable.getTableCustomizer(), configName);
        }
    }

    public void deleteConfig(String config) {
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        if (prefs != null) {
            prefs.removeTableColumnsConfig(this.m_organizedTable, config);
        }
    }

    public void resetAll() {
        this.m_organizedTable.reset(false);
        ClientUIPreferences.getInstance().removeTableColumnsConfig(this.m_organizedTable, null);
        if (this.isCustomizable() && this.m_organizedTable.getReloadHandler() != null) {
            this.m_organizedTable.getReloadHandler().reload("organizeColumns");
        }
        this.getColumnsTableField().reloadTableData();
    }

    public void applyConfig(String configName) {
        this.applyConfigImpl(configName);
        ClientUIPreferences.getInstance().setAllTableColumnPreferences(this.m_organizedTable, null);
        if (this.isCustomizable() && this.m_organizedTable.getReloadHandler() != null) {
            this.m_organizedTable.getReloadHandler().reload("organizeColumns");
        }
        this.getColumnsTableField().reloadTableData();
    }

    protected void applyConfigImpl(String configName) {
        try {
            this.m_organizedTable.setTableChanging(true);
            ClientUIPreferences prefs = ClientUIPreferences.getInstance();
            if (this.isCustomizable()) {
                byte[] tableCustomizerData = prefs.getTableCustomizerData(this.m_organizedTable.getTableCustomizer(), configName);
                if (tableCustomizerData != null) {
                    this.m_organizedTable.getTableCustomizer().removeAllColumns();
                    this.m_organizedTable.getTableCustomizer().setSerializedData(tableCustomizerData);
                }
                if (this.m_organizedTable.getReloadHandler() != null) {
                    this.m_organizedTable.resetColumnConfiguration();
                }
            }
            for (IColumn<?> col : this.m_organizedTable.getColumnSet().getColumns()) {
                col.setVisible(prefs.getTableColumnVisible(col, col.isInitialVisible(), configName));
                col.setWidth(prefs.getTableColumnWidth(col, col.getInitialWidth(), configName));
                col.setVisibleColumnIndexHint(prefs.getTableColumnViewIndex(col, col.getInitialSortIndex(), configName));
                if (!(col instanceof INumberColumn)) continue;
                ((INumberColumn)col).setBackgroundEffect(prefs.getTableColumnBackgroundEffect(col, ((INumberColumn)col).getInitialBackgroundEffect(), configName));
            }
            this.m_organizedTable.getColumnSet().applySortingAndGrouping(configName);
        }
        finally {
            this.m_organizedTable.setTableChanging(false);
        }
    }

    protected boolean isColumnMovableUp(IColumn<?> column) {
        if (column.isFixedPosition() || !column.isVisible()) {
            return false;
        }
        List<IColumn<?>> visibleColumns = column.getTable().getColumnSet().getVisibleColumns();
        int index = visibleColumns.indexOf(column);
        if (index - 1 < 0) {
            return false;
        }
        return !visibleColumns.get(index - 1).isFixedPosition();
    }

    protected boolean isColumnMovableDown(IColumn<?> column) {
        if (column.isFixedPosition() || !column.isVisible()) {
            return false;
        }
        List<IColumn<?>> visibleColumns = column.getTable().getColumnSet().getVisibleColumns();
        int index = visibleColumns.indexOf(column);
        if (index + 1 >= visibleColumns.size()) {
            return false;
        }
        return !visibleColumns.get(index + 1).isFixedPosition();
    }

    protected boolean isColumnAddable() {
        return this.getOrganizedTable().getTableOrganizer().isColumnAddable();
    }

    protected boolean isColumnRemovable(IColumn<?> column) {
        return column.isRemovable();
    }

    protected boolean isColumnModifiable(IColumn<?> column) {
        return column.isModifiable();
    }

    protected void execAddColumnAction() {
        MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable = (MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable();
        ArrayList existingColumnIds = new ArrayList();
        columnsTable.getKeyColumn().getValues().forEach(col -> {
            boolean bl = existingColumnIds.add(col.getColumnId());
        });
        IColumn insertAfterColumn = null;
        List selectedColumns = columnsTable.getKeyColumn().getSelectedValues();
        if (selectedColumns.size() > 0) {
            insertAfterColumn = (IColumn)selectedColumns.get(selectedColumns.size() - 1);
        }
        this.getOrganizedTable().getTableOrganizer().addColumn(insertAfterColumn);
        this.getColumnsTableField().reloadTableData();
        List newRows = columnsTable.getRows().stream().filter(row -> !existingColumnIds.contains(((IColumn)columnsTable.getKeyColumn().getValue((ITableRow)row)).getColumnId())).collect(Collectors.toList());
        columnsTable.selectRows(newRows);
    }

    protected void execRemoveColumnAction() {
        MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable = (MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable();
        for (ITableRow selectedRow : columnsTable.getSelectedRows()) {
            IColumn selectedColumn = (IColumn)columnsTable.getKeyColumn().getValue(selectedRow);
            this.getOrganizedTable().getTableOrganizer().removeColumn(selectedColumn);
        }
        this.getColumnsTableField().reloadTableData();
    }

    protected boolean acceptColumnForColumnsTable(IColumn<?> column) {
        return column.isVisible();
    }

    protected List<ITableRow> createColumnsTableRows(MainBox.GroupBox.ColumnsGroupBox.ColumnsTableField.Table columnsTable) {
        ArrayList<ITableRow> rowList = new ArrayList<ITableRow>();
        for (IColumn<?> col : this.m_organizedTable.getColumnSet().getAllColumnsInUserOrder()) {
            if (!this.acceptColumnForColumnsTable(col)) continue;
            IHeaderCell headerCell = col.getHeaderCell();
            TableRow row = new TableRow(columnsTable.getColumnSet());
            columnsTable.getKeyColumn().setValue(row, col);
            String columnTitle = headerCell.getText();
            if (StringUtility.isNullOrEmpty((CharSequence)columnTitle)) {
                columnTitle = headerCell.getTooltipText();
                row.setFont(FontSpec.parse((String)"ITALIC"));
            } else if (headerCell.isHtmlEnabled()) {
                columnTitle = ((HtmlHelper)BEANS.get(HtmlHelper.class)).toPlainText(columnTitle);
            }
            columnsTable.getTitleColumn().setValue(row, columnTitle);
            columnsTable.getStatusColumn().setValue(row, this.computeColumnStatus(col));
            columnsTable.getWidthColumn().setValue(row, Integer.valueOf(col.getWidth()));
            rowList.add(row);
        }
        return rowList;
    }

    protected String computeColumnStatus(IColumn<?> column) {
        String groupSymbol = "G";
        String filterSymbol = "F";
        String sortSymbol = column.isSortAscending() ? UNICODE_ARROW_UP : UNICODE_ARROW_DOWN;
        String sortIndex = String.valueOf(column.getSortIndex() + 1);
        int sortCount = this.getOrganizedTable().getColumnSet().getSortColumnCount();
        IHtmlElement htmlGrouped = HTML.div((CharSequence[])new CharSequence[]{groupSymbol}).toggleCssClass((CharSequence)"hidden", !column.isGroupingActive());
        IHtmlElement htmlFiltered = HTML.div((CharSequence[])new CharSequence[]{filterSymbol}).toggleCssClass((CharSequence)"hidden", !column.isColumnFilterActive());
        if (!column.isGroupingActive() && !column.isColumnFilterActive()) {
            htmlGrouped.removeCssClass((CharSequence)"hidden").addCssClass((CharSequence)"invisible");
        }
        IHtmlContent container = HTML.fragment((CharSequence[])new CharSequence[]{HTML.div((CharSequence[])new CharSequence[]{HTML.span((CharSequence[])new CharSequence[]{htmlGrouped, htmlFiltered}).addCssClass((CharSequence)"group-filter"), HTML.span((CharSequence[])new CharSequence[]{sortSymbol}).addCssClass((CharSequence)"sort-direction").toggleCssClass((CharSequence)"invisible", !column.isSortActive()), HTML.span((CharSequence[])new CharSequence[]{sortIndex}).addCssClass((CharSequence)"sort-index").toggleCssClass((CharSequence)"invisible", !column.isSortActive() || sortCount <= 1)}).addCssClass((CharSequence)"status")});
        return container.toHtml();
    }

    protected String computeColumnStatusTooltip(IColumn<?> column) {
        ArrayList<String> result = new ArrayList<String>();
        if (column.isGroupingActive()) {
            result.add(TEXTS.get((String)"Grouped"));
        }
        if (column.isColumnFilterActive()) {
            result.add(TEXTS.get((String)"Filtered"));
        }
        if (column.isSortActive()) {
            result.add(TEXTS.get((String)"Sorted"));
        }
        return StringUtility.join((String)"\n", result);
    }

    protected List<String> getVisibleColumnIds() {
        List<IColumn<?>> visibleColumns = this.m_organizedTable.getColumnSet().getVisibleColumns();
        ArrayList<String> columnIds = new ArrayList<String>(visibleColumns.size());
        for (IColumn<?> column : visibleColumns) {
            columnIds.add(column.getColumnId());
        }
        return columnIds;
    }

    private boolean isCustomizable() {
        return this.m_organizedTable.isCustomizable();
    }

    public static enum ConfigType {
        DEFAULT,
        CUSTOM;

    }

    @Order(value=10.0)
    @ClassId(value="d9f2e54a-cb41-4453-8ce9-ba41b8e247bd")
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredWidthInPixel() {
            return 750;
        }

        @Override
        protected int getConfiguredHeightInPixel() {
            return 350;
        }

        @Override
        protected boolean execIsEmpty() {
            return true;
        }

        @Order(value=10.0)
        @ClassId(value="abaf2e0c-1c14-4b99-81dc-8b83453f5766")
        public class GroupBox
        extends AbstractGroupBox {
            @Override
            protected Class<? extends IGroupBoxBodyGrid> getConfiguredBodyGrid() {
                return HorizontalGroupBoxBodyGrid.class;
            }

            @Override
            protected boolean getConfiguredBorderVisible() {
                return false;
            }

            @Order(value=10.0)
            @ClassId(value="952e2572-c7ed-400f-a8d0-a6b445bc1e41")
            public class ColumnsGroupBox
            extends AbstractGroupBox {
                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"Columns");
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected boolean getConfiguredStatusVisible() {
                    return false;
                }

                @Override
                protected String getConfiguredMenuBarPosition() {
                    return "title";
                }

                @Order(value=10.0)
                @ClassId(value="eefd05cf-b8b6-4c07-82c9-91aaafe9b8b6")
                public class ColumnsTableField
                extends AbstractTableField<Table> {
                    @Override
                    protected int getConfiguredGridW() {
                        return 1;
                    }

                    @Override
                    protected byte getConfiguredLabelPosition() {
                        return 4;
                    }

                    @Override
                    protected boolean getConfiguredLabelVisible() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredStatusVisible() {
                        return false;
                    }

                    @Override
                    protected void execReloadTableData() {
                        Table columnsTable = (Table)this.getTable();
                        List<ITableRow> rowList = OrganizeColumnsForm.this.createColumnsTableRows(columnsTable);
                        try {
                            columnsTable.setTableChanging(true);
                            columnsTable.discardAllRows();
                            columnsTable.addRows(rowList);
                        }
                        finally {
                            columnsTable.setTableChanging(false);
                        }
                        OrganizeColumnsForm.this.enableDisableMenus();
                    }

                    @ClassId(value="76937f06-5cc2-4281-9eae-28b59d7bd770")
                    public class Table
                    extends AbstractTable {
                        @Override
                        protected int getConfiguredDropType() {
                            return 2;
                        }

                        @Override
                        protected String getConfiguredCssClass() {
                            return "no-menubar-separators";
                        }

                        @Override
                        protected boolean getConfiguredTextFilterEnabled() {
                            return false;
                        }

                        @Override
                        protected void execDrop(ITableRow row, TransferObject transfer) {
                            ITableRow draggedRow;
                            List<ITableRow> draggedRows;
                            if (row != null && transfer instanceof JavaTransferObject && CollectionUtility.hasElements(draggedRows = ((JavaTransferObject)transfer).getLocalObjectAsList(ITableRow.class)) && (draggedRow = (ITableRow)CollectionUtility.firstElement(draggedRows)).getRowIndex() != row.getRowIndex()) {
                                try {
                                    ((Table)ColumnsTableField.this.getTable()).setTableChanging(true);
                                    if (draggedRow.getRowIndex() < row.getRowIndex()) {
                                        OrganizeColumnsForm.this.moveDown(draggedRow, row.getRowIndex());
                                    } else {
                                        OrganizeColumnsForm.this.moveUp(draggedRow, row.getRowIndex());
                                    }
                                    OrganizeColumnsForm.this.updateColumnVisibilityAndOrder();
                                }
                                finally {
                                    ((Table)ColumnsTableField.this.getTable()).setTableChanging(false);
                                }
                            }
                        }

                        @Override
                        protected boolean getConfiguredAutoResizeColumns() {
                            return true;
                        }

                        @Override
                        protected boolean getConfiguredHeaderEnabled() {
                            return false;
                        }

                        public KeyColumn getKeyColumn() {
                            return this.getColumnSet().getColumnByClass(KeyColumn.class);
                        }

                        public StatusColumn getStatusColumn() {
                            return this.getColumnSet().getColumnByClass(StatusColumn.class);
                        }

                        public WidthColumn getWidthColumn() {
                            return this.getColumnSet().getColumnByClass(WidthColumn.class);
                        }

                        public TitleColumn getTitleColumn() {
                            return this.getColumnSet().getColumnByClass(TitleColumn.class);
                        }

                        @Override
                        protected void execRowsSelected(List<? extends ITableRow> rows) {
                            OrganizeColumnsForm.this.enableDisableMenus();
                            if (rows.size() > 0) {
                                ((ProfilesBox.ProfilesTableField.Table)OrganizeColumnsForm.this.getProfilesTableField().getTable()).deselectAllRows();
                            }
                        }

                        @Override
                        protected void execInitTable() {
                            this.getWidthColumn().setVisible(!((MainBox)((GroupBox)((ColumnsGroupBox)((ColumnsTableField)ColumnsTableField.this).ColumnsGroupBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_organizedTable.isAutoResizeColumns());
                        }

                        @Order(value=10.0)
                        @ClassId(value="36a172fa-c7ef-4682-9724-6cfdd950907a")
                        public class AddColumnMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue01b";
                            }

                            @Override
                            protected String getConfiguredTooltipText() {
                                return TEXTS.get((String)"AddColumn");
                            }

                            @Override
                            protected void execAction() {
                                OrganizeColumnsForm.this.execAddColumnAction();
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="88b70ee3-05d8-458d-bd92-d7b4bfb22383")
                        public class KeyColumn
                        extends AbstractColumn<IColumn<?>> {
                            @Override
                            protected boolean getConfiguredPrimaryKey() {
                                return true;
                            }

                            @Override
                            protected boolean getConfiguredDisplayable() {
                                return false;
                            }
                        }

                        @Order(value=25.0)
                        @ClassId(value="1636f632-aca4-4e96-ae9e-060c9d0c8317")
                        public class ModifyCustomColumnMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue02f";
                            }

                            @Override
                            protected String getConfiguredTooltipText() {
                                return TEXTS.get((String)"ModifyColumn");
                            }

                            @Override
                            protected void execAction() {
                                Table columnsTable = (Table)OrganizeColumnsForm.this.getColumnsTableField().getTable();
                                if (OrganizeColumnsForm.this.isCustomizable() && columnsTable.getSelectedRow() != null) {
                                    IColumn selectedCol = (IColumn)columnsTable.getKeyColumn().getValue(columnsTable.getSelectedRow());
                                    if (OrganizeColumnsForm.this.isColumnModifiable(selectedCol)) {
                                        ((MainBox)((GroupBox)((ColumnsGroupBox)((ColumnsTableField)((Table)Table.this).ColumnsTableField.this).ColumnsGroupBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_organizedTable.getTableCustomizer().modifyColumn(selectedCol);
                                        OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                                    }
                                }
                            }
                        }

                        @Order(value=40.0)
                        @ClassId(value="8d30af92-6da2-420f-9c81-6d32928a68be")
                        public class MoveDownMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return AbstractAction.combineKeyStrokes("alt", "down", new String[0]);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue014";
                            }

                            @Override
                            protected byte getConfiguredHorizontalAlignment() {
                                return 1;
                            }

                            @Override
                            protected String getConfiguredTooltipText() {
                                return TEXTS.get((String)"MoveColumnBackward");
                            }

                            @Override
                            protected void execAction() {
                                List<ITableRow> selectedRows = Table.this.getSelectedRows();
                                Collections.reverse(selectedRows);
                                for (ITableRow row : selectedRows) {
                                    if (!this.canMoveDown(row)) continue;
                                    OrganizeColumnsForm.this.moveDown(row);
                                }
                            }

                            protected boolean canMoveDown(ITableRow candidateRow) {
                                for (ITableRow row : Table.this.getSelectedRows()) {
                                    if (candidateRow == row || row.getRowIndex() != candidateRow.getRowIndex() + 1) continue;
                                    return false;
                                }
                                return true;
                            }
                        }

                        @Order(value=30.0)
                        @ClassId(value="c81f96dc-5b4c-44ed-9737-63a85b22600f")
                        public class MoveUpMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue015";
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return AbstractAction.combineKeyStrokes("alt", "up", new String[0]);
                            }

                            @Override
                            protected byte getConfiguredHorizontalAlignment() {
                                return 1;
                            }

                            @Override
                            protected String getConfiguredTooltipText() {
                                return TEXTS.get((String)"MoveColumnForward");
                            }

                            @Override
                            protected void execAction() {
                                for (ITableRow row : Table.this.getSelectedRows()) {
                                    if (!this.canMoveUp(row)) continue;
                                    OrganizeColumnsForm.this.moveUp(row);
                                }
                            }

                            protected boolean canMoveUp(ITableRow candidateRow) {
                                for (ITableRow row : Table.this.getSelectedRows()) {
                                    if (candidateRow == row || row.getRowIndex() != candidateRow.getRowIndex() - 1) continue;
                                    return false;
                                }
                                return true;
                            }
                        }

                        @Order(value=20.0)
                        @ClassId(value="da55a088-a05f-4c94-8933-c5a2a7d6ab15")
                        public class RemoveMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredIconId() {
                                return "font:\ue01a";
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return "delete";
                            }

                            @Override
                            protected String getConfiguredTooltipText() {
                                return TEXTS.get((String)"RemoveColumn");
                            }

                            @Override
                            protected void execAction() {
                                OrganizeColumnsForm.this.execRemoveColumnAction();
                            }
                        }

                        @Order(value=40.0)
                        @ClassId(value="23b153bc-1d74-46a2-b08b-87aecba6c1b0")
                        public class StatusColumn
                        extends AbstractStringColumn {
                            @Override
                            protected String getConfiguredHeaderText() {
                                return TEXTS.get((String)"Status");
                            }

                            @Override
                            protected int getConfiguredWidth() {
                                return 70;
                            }

                            @Override
                            protected boolean getConfiguredFixedWidth() {
                                return true;
                            }

                            @Override
                            protected boolean getConfiguredHtmlEnabled() {
                                return true;
                            }

                            @Override
                            protected String getConfiguredCssClass() {
                                return "table-organizer-column-status-cell";
                            }

                            @Override
                            protected void execDecorateCell(Cell cell, ITableRow row) {
                                cell.setTooltipText(OrganizeColumnsForm.this.computeColumnStatusTooltip((IColumn)Table.this.getKeyColumn().getValue(row)));
                            }
                        }

                        @Order(value=30.0)
                        @ClassId(value="a5dcb98c-aca9-49e5-a80c-eb47d22041a2")
                        public class TitleColumn
                        extends AbstractStringColumn {
                            @Override
                            protected String getConfiguredHeaderText() {
                                return TEXTS.get((String)"Column");
                            }

                            @Override
                            protected int getConfiguredWidth() {
                                return 120;
                            }
                        }

                        @Order(value=70.0)
                        @ClassId(value="c0bfe89c-2402-419a-bda1-68fc61b23ec7")
                        public class WidthColumn
                        extends AbstractIntegerColumn {
                            @Override
                            protected String getConfiguredHeaderText() {
                                return TEXTS.get((String)"Width");
                            }

                            @Override
                            protected boolean getConfiguredAutoOptimizeWidth() {
                                return true;
                            }

                            @Override
                            protected int getConfiguredAutoOptimizeMaxWidth() {
                                return 85;
                            }
                        }
                    }
                }
            }

            @Order(value=5.0)
            @ClassId(value="698da86a-d878-439e-9a1c-da7b63d4f2e3")
            public class ProfilesBox
            extends AbstractGroupBox {
                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"SavedSettings");
                }

                @Override
                protected boolean getConfiguredStatusVisible() {
                    return false;
                }

                @Order(value=10.0)
                @ClassId(value="f96ddd7f-634b-486b-a4be-fbb69b5162e4")
                public class ProfilesTableField
                extends AbstractTableField<Table> {
                    @Override
                    protected boolean getConfiguredGridUseUiHeight() {
                        return UserAgentUtility.isMobileDevice();
                    }

                    @Override
                    protected int getConfiguredGridW() {
                        return 1;
                    }

                    @Override
                    protected byte getConfiguredLabelPosition() {
                        return 4;
                    }

                    @Override
                    protected boolean getConfiguredLabelVisible() {
                        return false;
                    }

                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"Configurations");
                    }

                    @Override
                    protected boolean getConfiguredStatusVisible() {
                        return false;
                    }

                    @Override
                    protected void execReloadTableData() {
                        List<Object> rowList = new ArrayList<TableRow>();
                        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
                        TableRow row = new TableRow(((Table)this.getTable()).getColumnSet());
                        ((Table)this.getTable()).getConfigNameColumn().setValue(row, TEXTS.get((String)"DefaultSettings"));
                        ((Table)this.getTable()).getConfigTypeColumn().setValue(row, ConfigType.DEFAULT);
                        rowList.add(row);
                        if (prefs != null) {
                            Set<String> configs = prefs.getAllTableColumnsConfigs(((MainBox)((GroupBox)((ProfilesBox)ProfilesBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_organizedTable);
                            for (String config : configs) {
                                row = new TableRow(((Table)this.getTable()).getColumnSet());
                                ((Table)this.getTable()).getConfigNameColumn().setValue(row, config);
                                ((Table)this.getTable()).getConfigTypeColumn().setValue(row, ConfigType.CUSTOM);
                                rowList.add(row);
                            }
                        }
                        try {
                            ((Table)this.getTable()).setTableChanging(true);
                            ((Table)this.getTable()).discardAllRows();
                            rowList = ((Table)this.getTable()).addRows(rowList);
                            for (ITableRow configRow : ((Table)this.getTable()).getRows()) {
                                configRow.getCellForUpdate(((Table)this.getTable()).getConfigNameColumn()).setEditable(false);
                            }
                        }
                        finally {
                            ((Table)this.getTable()).setTableChanging(false);
                        }
                    }

                    @ClassId(value="359e1e7e-26f0-411d-baf1-2ba9f554212d")
                    public class Table
                    extends AbstractTable {
                        @Override
                        protected Class<? extends IMenu> getConfiguredDefaultMenu() {
                            return ApplyMenu.class;
                        }

                        @Override
                        protected boolean getConfiguredHeaderEnabled() {
                            return false;
                        }

                        @Override
                        protected String getConfiguredCssClass() {
                            return "table-organizer-profiles-table";
                        }

                        @Override
                        protected boolean getConfiguredAutoResizeColumns() {
                            return true;
                        }

                        public ConfigNameColumn getConfigNameColumn() {
                            return this.getColumnSet().getColumnByClass(ConfigNameColumn.class);
                        }

                        public ConfigTypeColumn getConfigTypeColumn() {
                            return this.getColumnSet().getColumnByClass(ConfigTypeColumn.class);
                        }

                        @Override
                        protected void execRowsSelected(List<? extends ITableRow> rows) {
                            this.getMenuByClass(DeleteMenu.class).setVisible(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(RenameMenu.class).setVisible(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(UpdateMenu.class).setVisible(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(DeleteMenu.class).setEnabled(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(RenameMenu.class).setEnabled(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            this.getMenuByClass(UpdateMenu.class).setEnabled(!this.isDefaultConfigSelected() && !rows.isEmpty());
                            if (rows.size() > 0) {
                                ((ColumnsGroupBox.ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).deselectAllRows();
                            }
                        }

                        protected boolean isOnlyCustomConfigsSelected() {
                            for (ITableRow row : this.getSelectedRows()) {
                                if (row.getCell(this.getConfigTypeColumn()).getValue() == ConfigType.CUSTOM) continue;
                                return false;
                            }
                            return true;
                        }

                        protected String newConfigName() {
                            int profileNr = 1;
                            String baseName = TEXTS.get((String)"New") + " ";
                            while (this.getColumnSet().getColumnByClass(ConfigNameColumn.class).getValues().contains(baseName + profileNr)) {
                                ++profileNr;
                            }
                            return baseName + profileNr;
                        }

                        protected boolean isDefaultConfigSelected() {
                            for (ITableRow row : this.getSelectedRows()) {
                                if (row.getCell(this.getConfigTypeColumn()).getValue() != ConfigType.DEFAULT) continue;
                                return true;
                            }
                            return false;
                        }

                        @Order(value=20.0)
                        @ClassId(value="203277ac-846d-4781-8547-32e0530c9521")
                        public class ApplyMenu
                        extends AbstractMenu {
                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"Load");
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return "enter";
                            }

                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected void execAction() {
                                if (Table.this.getConfigTypeColumn().getSelectedValue() == ConfigType.DEFAULT) {
                                    OrganizeColumnsForm.this.resetAll();
                                } else {
                                    String configName = (String)Table.this.getConfigNameColumn().getSelectedValue();
                                    OrganizeColumnsForm.this.applyConfig(configName);
                                }
                                ((Table)ProfilesTableField.this.getTable()).deselectAllEnabledRows();
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="f607ab39-e616-4b27-b7c4-f6e437b6b1a3")
                        public class ConfigNameColumn
                        extends AbstractAlphanumericSortingStringColumn {
                            @Override
                            protected String getConfiguredHeaderText() {
                                return TEXTS.get((String)"SavedSettings");
                            }

                            @Override
                            protected boolean getConfiguredEditable() {
                                return true;
                            }

                            @Override
                            protected int getConfiguredSortIndex() {
                                return 1;
                            }

                            @Override
                            protected IFormField execPrepareEdit(ITableRow row) {
                                IStringField field = (IStringField)super.execPrepareEdit(row);
                                field.selectAll();
                                return field;
                            }

                            @Override
                            protected void execCompleteEdit(ITableRow row, IFormField editingField) {
                                block5: {
                                    String oldValue;
                                    block4: {
                                        oldValue = (String)Table.this.getConfigNameColumn().getValue(row);
                                        super.execCompleteEdit(row, editingField);
                                        String newValue = (String)((IStringField)editingField).getValue();
                                        if (StringUtility.isNullOrEmpty((CharSequence)newValue)) break block4;
                                        switch ((ConfigType)((Object)Table.this.getConfigTypeColumn().getValue(row))) {
                                            case CUSTOM: {
                                                ClientUIPreferences prefs = ClientUIPreferences.getInstance();
                                                prefs.renameTableColumnsConfig(((MainBox)((GroupBox)((ProfilesBox)((ProfilesTableField)((Table)Table.this).ProfilesTableField.this).ProfilesBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_organizedTable, oldValue, newValue);
                                                break block5;
                                            }
                                            default: {
                                                throw new IllegalStateException("Rows of configType " + ((ConfigType)((Object)Table.this.getConfigTypeColumn().getValue(row))).name() + " should never be editable.");
                                            }
                                        }
                                    }
                                    if (Table.this.getConfigTypeColumn().getValue(row) == ConfigType.CUSTOM) {
                                        Table.this.getConfigNameColumn().setValue(row, oldValue);
                                    }
                                }
                                row.getCellForUpdate(Table.this.getConfigNameColumn()).setEditable(false);
                                this.getTable().sort();
                            }
                        }

                        @Order(value=20.0)
                        @ClassId(value="d84a8d65-59c2-449d-b375-7a2f2da1844b")
                        public class ConfigTypeColumn
                        extends AbstractColumn<ConfigType> {
                            @Override
                            protected boolean getConfiguredDisplayable() {
                                return false;
                            }

                            @Override
                            protected int getConfiguredSortIndex() {
                                return 0;
                            }
                        }

                        @Order(value=40.0)
                        @ClassId(value="8325ee81-5ae4-4b82-b27f-26cab198c77c")
                        public class DeleteMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object[])new IMenuType[]{TableMenuType.MultiSelection, TableMenuType.SingleSelection});
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"DeleteMenu");
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return "delete";
                            }

                            @Override
                            protected void execAction() {
                                List<ITableRow> rows = Table.this.getSelectedRows();
                                Table.this.deleteRows(rows);
                                for (ITableRow row : rows) {
                                    if (Table.this.getConfigTypeColumn().getValue(row) != ConfigType.CUSTOM) continue;
                                    String config = (String)Table.this.getConfigNameColumn().getValue(row);
                                    OrganizeColumnsForm.this.deleteConfig(config);
                                }
                            }
                        }

                        @Order(value=10.0)
                        @ClassId(value="f830ba85-1629-407e-9935-e241713a35c7")
                        public class NewMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.EmptySpace);
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"New");
                            }

                            @Override
                            protected void execAction() {
                                String newConfigName = Table.this.newConfigName();
                                OrganizeColumnsForm.this.storeCurrentStateAsConfig(newConfigName);
                                ITableRow newRow = new TableRow(((Table)ProfilesTableField.this.getTable()).getColumnSet());
                                ((Table)ProfilesTableField.this.getTable()).getConfigTypeColumn().setValue(newRow, ConfigType.CUSTOM);
                                ((Table)ProfilesTableField.this.getTable()).getConfigNameColumn().setValue(newRow, newConfigName);
                                try {
                                    ((Table)ProfilesTableField.this.getTable()).setTableChanging(true);
                                    newRow = ((Table)ProfilesTableField.this.getTable()).addRow(newRow);
                                    ((Table)ProfilesTableField.this.getTable()).selectRow(newRow);
                                    Table.this.getMenuByClass(RenameMenu.class).rename();
                                }
                                finally {
                                    ((Table)ProfilesTableField.this.getTable()).setTableChanging(false);
                                }
                            }
                        }

                        @Order(value=50.0)
                        @ClassId(value="1ae293da-528c-4e37-abfa-497e9c1892a6")
                        public class RenameMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"Rename");
                            }

                            @Override
                            protected String getConfiguredKeyStroke() {
                                return RenameMenu.combineKeyStrokes("control", "enter", new String[0]);
                            }

                            @Override
                            protected void execAction() {
                                this.rename();
                            }

                            protected void rename() {
                                Table.this.getSelectedRow().getCellForUpdate(Table.this.getConfigNameColumn()).setEditable(true);
                                ((Table)ProfilesTableField.this.getTable()).requestFocusInCell(Table.this.getConfigNameColumn(), Table.this.getSelectedRow());
                            }
                        }

                        @Order(value=30.0)
                        @ClassId(value="d0415e79-3f85-49f8-ab64-f87bc3a8363b")
                        public class UpdateMenu
                        extends AbstractMenu {
                            @Override
                            protected Set<? extends IMenuType> getConfiguredMenuTypes() {
                                return CollectionUtility.hashSet((Object)TableMenuType.SingleSelection);
                            }

                            @Override
                            protected String getConfiguredText() {
                                return TEXTS.get((String)"Update");
                            }

                            @Override
                            protected void execAction() {
                                List<ITableRow> rows = Table.this.getSelectedRows();
                                for (ITableRow row : rows) {
                                    if (Table.this.getConfigTypeColumn().getValue(row) != ConfigType.CUSTOM) continue;
                                    String config = (String)Table.this.getConfigNameColumn().getValue(row);
                                    OrganizeColumnsForm.this.deleteConfig(config);
                                    OrganizeColumnsForm.this.storeCurrentStateAsConfig(config);
                                }
                                ((Table)ProfilesTableField.this.getTable()).deselectAllEnabledRows();
                            }
                        }
                    }
                }
            }
        }
    }
}

