/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.menus;

import java.util.Set;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.IOrganizeColumnsForm;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.IOrganizeColumnsFormProvider;
import org.eclipse.scout.rt.client.ui.form.AbstractFormMenu;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

@ClassId(value="dc8237d6-18b8-4406-91b0-bb4a95bf9fec")
public class OrganizeColumnsMenu
extends AbstractFormMenu<IOrganizeColumnsForm> {
    private final ITable m_table;

    public OrganizeColumnsMenu(ITable table) {
        this.m_table = table;
    }

    @Override
    protected boolean getConfiguredInheritAccessibility() {
        return false;
    }

    protected Set<IMenuType> getConfiguredMenuTypes() {
        return CollectionUtility.hashSet((Object)TableMenuType.Header);
    }

    public ITable getTable() {
        return this.m_table;
    }

    @Override
    protected void execSelectionChanged(boolean selected) {
        if (selected) {
            super.execSelectionChanged(selected);
            ((IOrganizeColumnsForm)this.getForm()).reload();
        } else {
            ((IOrganizeColumnsForm)this.getForm()).doClose();
        }
    }

    @Override
    protected IOrganizeColumnsForm createForm() {
        return ((IOrganizeColumnsFormProvider)BEANS.get(IOrganizeColumnsFormProvider.class)).createOrganizeColumnsForm(this.m_table);
    }

    @Override
    protected String getConfiguredIconId() {
        return "font:\ue031";
    }

    @Override
    protected String getConfiguredTooltipText() {
        return TEXTS.get((String)"TableOrganize");
    }

    @Override
    protected boolean getConfiguredPopupResizable() {
        return true;
    }

    @Override
    protected boolean getConfiguredPopupMovable() {
        return true;
    }

    public boolean isColumnsCustomizable() {
        return this.getTable().getTableCustomizer() != null;
    }
}

