/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICellObserver;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.VerboseUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;

public class InternalTableRow
extends TableRow
implements ICellObserver {
    private final Map<ICell, Integer> m_updatedCells;
    private ITable m_table;
    private int m_rowIndex;
    private int m_rowChanging = 0;

    public InternalTableRow(ITable table) {
        super(table.getColumnSet());
        this.m_updatedCells = new HashMap<ICell, Integer>(table.getColumnSet().getColumnCount());
        this.setFilterAcceptedInternal(true);
        this.m_table = table;
    }

    public InternalTableRow(ITable table, ITableRow row) {
        super(table.getColumnSet(), row);
        this.m_updatedCells = new HashMap<ICell, Integer>(table.getColumnSet().getColumnCount());
        this.setFilterAcceptedInternal(true);
        this.setEnabled(row.isEnabled());
        this.m_rowIndex = row.getRowIndex();
        for (IColumn<?> c : table.getColumns()) {
            c.parseValueAndSet(this, c.getValue(row));
        }
        this.setStatus(row.getStatus());
        this.setCssClass(row.getCssClass());
        this.setIconId(row.getIconId());
        this.m_table = table;
    }

    @Override
    public int getRowIndex() {
        return this.m_rowIndex;
    }

    public void setRowIndex(int index) {
        this.m_rowIndex = index;
    }

    @Override
    public void setStatus(int status) {
        try {
            this.setRowChanging(true);
            if (this.getStatus() != status) {
                super.setStatus(status);
                this.setRowPropertiesChanged(true);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    public void setStatusInternal(int status) {
        super.setStatus(status);
    }

    @Override
    public void setEnabled(boolean b) {
        try {
            this.setRowChanging(true);
            if (this.isEnabled() != b) {
                super.setEnabled(b);
                this.setRowPropertiesChanged(true);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public boolean isSelected() {
        if (this.getTable() != null) {
            return this.getTable().isSelectedRow(this);
        }
        return false;
    }

    @Override
    public boolean isChecked() {
        if (this.getTable() != null) {
            return this.getTable().isCheckedRow(this);
        }
        return false;
    }

    @Override
    public void setChecked(boolean b) {
        if (this.getTable() != null) {
            this.getTable().checkRow(this, b);
        }
    }

    @Override
    public boolean isFilterAccepted() {
        return FLAGS_BIT_HELPER.isBitSet("FILTER_ACCEPTED", this.m_flags);
    }

    public void setFilterAcceptedInternal(boolean b) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit("FILTER_ACCEPTED", b, this.m_flags);
    }

    @Override
    public boolean isRejectedByUser() {
        return FLAGS_BIT_HELPER.isBitSet("REJECTED_BY_USER", this.m_flags);
    }

    public void setRejectedByUser(boolean rejectedByUser) {
        this.m_flags = FLAGS_BIT_HELPER.changeBit("REJECTED_BY_USER", rejectedByUser, this.m_flags);
    }

    @Override
    public int getCellCount() {
        return this.m_cells.size();
    }

    @Override
    public ICell getCell(IColumn column) {
        return this.getCell(column.getColumnIndex());
    }

    @Override
    public ICell getCell(int columnIndex) {
        return this.getCellForUpdate(columnIndex);
    }

    @Override
    public void setCell(IColumn column, ICell cell) {
        this.setCell(column.getColumnIndex(), cell);
    }

    @Override
    public void setCell(int columnIndex, ICell cell) {
        if (cell != null) {
            try {
                this.setRowChanging(true);
                this.m_cells.set(columnIndex, new Cell(this, cell));
            }
            finally {
                this.setRowChanging(false);
            }
        }
    }

    @Override
    public Cell getCellForUpdate(IColumn column) {
        return this.getCellForUpdate(column.getColumnIndex());
    }

    @Override
    public Cell getCellForUpdate(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.m_cells.size()) {
            return new Cell();
        }
        return (Cell)this.m_cells.get(columnIndex);
    }

    @Override
    public Object getCellValue(int columnIndex) {
        return this.getCell(columnIndex).getValue();
    }

    @Override
    public List<Object> getKeyValues() {
        if (this.getTable() == null) {
            return new ArrayList<Object>(0);
        }
        ColumnSet columnSet = this.getTable().getColumnSet();
        int[] keyColumns = columnSet.getKeyColumnCount() > 0 ? columnSet.getKeyColumnIndexes() : columnSet.getAllColumnIndexes();
        ArrayList<Object> pk = new ArrayList<Object>(keyColumns.length);
        int[] nArray = keyColumns;
        int n = keyColumns.length;
        int n2 = 0;
        while (n2 < n) {
            int keyIndex = nArray[n2];
            pk.add(this.getCell(keyIndex).getValue());
            ++n2;
        }
        return pk;
    }

    @Override
    public List<Object> getParentKeyValues() {
        ArrayList<Object> pk = new ArrayList<Object>();
        if (this.getTable() != null) {
            int[] keyColumns;
            int[] nArray = keyColumns = this.getTable().getColumnSet().getParentKeyColumnIndexes();
            int n = keyColumns.length;
            int n2 = 0;
            while (n2 < n) {
                int keyIndex = nArray[n2];
                pk.add(this.getCell(keyIndex).getValue());
                ++n2;
            }
        }
        return pk;
    }

    @Override
    public boolean isRowChanging() {
        return this.m_rowChanging > 0;
    }

    @Override
    public void setRowChanging(boolean b) {
        if (b) {
            ++this.m_rowChanging;
        } else {
            --this.m_rowChanging;
            if (this.m_rowChanging == 0 && this.isRowPropertiesChanged()) {
                this.setRowPropertiesChanged(false);
                if (this.getTable() != null) {
                    this.getTable().updateRow(this);
                }
                if (this.m_updatedCells != null) {
                    this.m_updatedCells.clear();
                }
            }
        }
    }

    @Override
    public boolean setCellValue(int columnIndex, Object value) {
        boolean changed = this.getCellForUpdate(columnIndex).setValue(value);
        return changed;
    }

    @Override
    public boolean setCellValues(List<?> values) {
        boolean changed = false;
        int i = 0;
        while (i < values.size()) {
            boolean b = this.setCellValue(i, values.get(i));
            changed = changed || b;
            ++i;
        }
        return changed;
    }

    @Override
    public ITable getTable() {
        return this.m_table;
    }

    public void setTableInternal(ITable table) {
        this.m_table = table;
    }

    @Override
    public void touch() {
        try {
            this.setRowChanging(true);
            this.setRowPropertiesChanged(true);
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void delete() {
        if (this.getTable() != null) {
            this.getTable().deleteRow(this);
        }
    }

    @Override
    public void setBackgroundColor(String c) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setBackgroundColor(c);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setForegroundColor(String c) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setForegroundColor(c);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setCssClass(String cssClass) {
        try {
            this.setRowChanging(true);
            super.setCssClass(cssClass);
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setFont(FontSpec f) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setFont(f);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setTooltipText(String s) {
        try {
            this.setRowChanging(true);
            for (Cell cell : this.m_cells) {
                cell.setTooltipText(s);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void setIconId(String id) {
        try {
            this.setRowChanging(true);
            if (ObjectUtility.notEquals((Object)this.getIconId(), (Object)id)) {
                super.setIconId(id);
                this.setRowPropertiesChanged(true);
            }
        }
        finally {
            this.setRowChanging(false);
        }
    }

    @Override
    public void moveToTop() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), 0);
        }
    }

    @Override
    public void moveToBottom() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getTable().getRowCount());
        }
    }

    @Override
    public void moveUp() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getRowIndex() - 1);
        }
    }

    @Override
    public void moveDown() {
        if (this.getTable() != null) {
            this.getTable().moveRow(this.getRowIndex(), this.getRowIndex() + 1);
        }
    }

    @Override
    public Object validateValue(ICell cell, Object value) {
        Object oldValue = cell.getValue();
        if (ObjectUtility.equals((Object)oldValue, (Object)value)) {
            return value;
        }
        if (this.getTable() != null) {
            int colIndex = -1;
            int i = 0;
            while (i < this.m_cells.size()) {
                if (this.getCell(i) == cell) {
                    colIndex = i;
                    break;
                }
                ++i;
            }
            if (colIndex >= 0) {
                IColumn column = this.getTable().getColumnSet().getColumn(colIndex);
                value = column.parseValue(this, value);
            }
        }
        return value;
    }

    @Override
    public void cellChanged(ICell cell, int changedBit) {
        try {
            this.setRowChanging(true);
            if (this.isStatusNonchanged() && this.isRowUpdate(changedBit)) {
                this.setStatusUpdated();
            }
            this.setRowPropertiesChanged(true);
            this.setCellChanged(cell, changedBit);
        }
        finally {
            this.setRowChanging(false);
        }
    }

    private boolean isRowUpdate(int changedBit) {
        return changedBit == 1;
    }

    private void setCellChanged(ICell cell, int changeBit) {
        this.m_updatedCells.compute(cell, (iCell, bitMask) -> this.setBit((Integer)bitMask, changeBit));
    }

    private List<ICell> getChangedCells(int changedBit) {
        ArrayList<ICell> cells = new ArrayList<ICell>();
        for (Map.Entry<ICell, Integer> e : this.m_updatedCells.entrySet()) {
            if (!this.isBitSet(e.getValue(), changedBit)) continue;
            cells.add(e.getKey());
        }
        return cells;
    }

    private List<ICell> getChangedCells() {
        ArrayList<ICell> cells = new ArrayList<ICell>(this.m_updatedCells.size());
        for (Map.Entry<ICell, Integer> e : this.m_updatedCells.entrySet()) {
            Integer changedBits = e.getValue();
            if (changedBits == null) continue;
            cells.add(e.getKey());
        }
        return cells;
    }

    @Override
    public Set<Integer> getUpdatedColumnIndexes() {
        return this.getColumnIndexes(this.getChangedCells());
    }

    @Override
    public Set<Integer> getUpdatedColumnIndexes(int changedBit) {
        return this.getColumnIndexes(this.getChangedCells(changedBit));
    }

    private Set<Integer> getColumnIndexes(List<ICell> cells) {
        if (CollectionUtility.isEmpty(cells)) {
            return Collections.emptySet();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (ICell cell : cells) {
            result.add(this.m_cells.indexOf(cell));
        }
        return result;
    }

    private Integer setBit(Integer bitMask, int bitPos) {
        return bitMask == null ? 1 << bitPos : bitMask | 1 << bitPos;
    }

    private boolean isBitSet(Integer bitMask, int bitPos) {
        return bitMask != null && (bitMask & 1 << bitPos) != 0;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + VerboseUtility.dumpObjects((Object[])this.m_cells.toArray()) + "]";
    }
}

