/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.CompactBeanBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableCompactHandler;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.CompactBean;
import org.eclipse.scout.rt.client.ui.basic.table.columns.CompactLine;
import org.eclipse.scout.rt.client.ui.basic.table.columns.CompactLineBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.IHtmlElement;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCompactHandler
implements ITableCompactHandler {
    private static final Logger LOG = LoggerFactory.getLogger(TableCompactHandler.class);
    private ITable m_table;
    private TableListener m_tableListener;
    private Map<String, Object> m_oldStates;
    private boolean m_useOnlyVisibleColumns;
    private int m_maxContentLines;
    private boolean m_moreLinkAvailable;
    private CompactBeanBuilder m_beanBuilder;
    private CompactLineBuilder m_titleBuilder;
    private CompactLineBuilder m_subtitleBuilder;
    private CompactLineBuilder m_titleSuffixBuilder;
    private List<CompactLineBuilder> m_contentBuilder;
    private CompactLineBuilder m_defaultContentLineBuilder;
    private Consumer<CompactLine> m_lineCustomizer;
    private Predicate<IColumn<?>> m_columnFilter;

    public TableCompactHandler(ITable table) {
        this.m_table = table;
        this.m_oldStates = new HashMap<String, Object>();
        this.withUseOnlyVisibleColumns(true);
        this.withMaxContentLines(3);
        this.withMoreLinkAvailable(true);
        this.m_beanBuilder = new BeanBuilder();
        this.m_titleBuilder = new TitleBuilder(this::getDefaultTitleColumn);
        this.m_subtitleBuilder = new SubtitleBuilder(this::getDefaultSubtitleColumn);
        this.m_titleSuffixBuilder = new TitleSuffixBuilder(null);
        this.m_defaultContentLineBuilder = new ContentLineBuilder();
        this.m_contentBuilder = new ArrayList<CompactLineBuilder>();
    }

    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public boolean isUseOnlyVisibleColumns() {
        return this.m_useOnlyVisibleColumns;
    }

    @Override
    public TableCompactHandler withUseOnlyVisibleColumns(boolean useOnlyVisibleColumns) {
        this.m_useOnlyVisibleColumns = useOnlyVisibleColumns;
        return this;
    }

    @Override
    public int getMaxContentLines() {
        return this.m_maxContentLines;
    }

    @Override
    public TableCompactHandler withMaxContentLines(int maxContentLines) {
        this.m_maxContentLines = maxContentLines;
        return this;
    }

    @Override
    public boolean isMoreLinkAvailable() {
        return this.m_moreLinkAvailable;
    }

    @Override
    public TableCompactHandler withMoreLinkAvailable(boolean moreLinkAvailable) {
        this.m_moreLinkAvailable = moreLinkAvailable;
        return this;
    }

    @Override
    public void handle(boolean compact) {
        if (compact) {
            this.compactColumns(true);
            this.attachTableListener();
        } else {
            this.detachTableListener();
            this.compactColumns(false);
        }
        this.adjustTable(compact);
        if (compact) {
            this.updateValues(this.getTable().getRows());
        }
    }

    protected void adjustTable(boolean compact) {
        if (compact) {
            this.cacheAndSetProperty("headerVisible", () -> this.getTable().isHeaderVisible(), () -> this.getTable().setHeaderVisible(false));
            this.cacheAndSetProperty("autoResizeColumns", () -> this.getTable().isAutoResizeColumns(), () -> this.getTable().setAutoResizeColumns(true));
        } else {
            this.resetProperty("headerVisible", value -> this.getTable().setHeaderVisible((boolean)value), Boolean.class);
            this.resetProperty("autoResizeColumns", value -> this.getTable().setAutoResizeColumns((boolean)value), Boolean.class);
        }
    }

    protected void cacheAndSetProperty(String propertyName, Supplier getter, Runnable setter) {
        this.m_oldStates.putIfAbsent(propertyName, getter.get());
        setter.run();
    }

    protected <T> void resetProperty(String propertyName, Consumer<T> setter, Class<T> type) {
        if (this.m_oldStates.containsKey(propertyName)) {
            setter.accept(type.cast(this.m_oldStates.get(propertyName)));
            this.m_oldStates.remove(propertyName);
        }
    }

    protected void compactColumns(boolean compact) {
        for (IColumn<?> column : this.getTable().getColumnSet().getDisplayableColumns()) {
            column.setCompacted(compact);
        }
        TableEvent e = new TableEvent(this.m_table, 1);
        if (this.m_table instanceof AbstractTable) {
            ((AbstractTable)this.m_table).fireTableEventInternal(e);
        }
    }

    private void attachTableListener() {
        if (this.m_tableListener == null) {
            this.m_tableListener = new P_TableListener();
            this.getTable().addTableListener(this.m_tableListener, 100, 101, 1, 780);
        }
    }

    private void detachTableListener() {
        if (this.m_tableListener != null) {
            this.getTable().removeTableListener(this.m_tableListener, 100, 101, 1, 780);
            this.m_tableListener = null;
        }
    }

    public void updateValues(List<ITableRow> rows) {
        if (rows.size() == 0) {
            return;
        }
        List<IColumn<?>> columns = this.getColumns();
        rows.forEach(row -> this.updateValue(columns, (ITableRow)row));
    }

    protected void updateValue(List<IColumn<?>> columns, ITableRow row) {
        row.setCompactValue(this.buildValue(columns, row));
    }

    @Override
    public String buildValue(ITableRow row) {
        return this.buildValue(this.getColumns(), row);
    }

    @Override
    public CompactBean buildBean(ITableRow row) {
        return this.buildBean(this.getColumns(), row);
    }

    protected String buildValue(List<IColumn<?>> columns, ITableRow row) {
        return this.buildValue(this.buildBean(columns, row));
    }

    protected CompactBean buildBean(List<IColumn<?>> columns, ITableRow row) {
        CompactBean bean = (CompactBean)this.m_beanBuilder.apply(columns, row);
        this.postProcessBean(bean);
        return bean;
    }

    protected void processColumns(List<IColumn<?>> columns, ITableRow row, CompactBean bean) {
        for (IColumn<?> column : columns) {
            this.processColumn(column, row, bean);
        }
    }

    @Override
    public List<IColumn<?>> getColumns() {
        this.m_beanBuilder.prepare();
        for (CompactLineBuilder builder : this.getBuilders()) {
            builder.prepare();
        }
        List columns = this.getTable().getColumns().stream().filter(this::acceptColumn).collect(Collectors.toList());
        List titleColumns = columns.stream().filter(column -> this.getTitleBuilder().accept((IColumn<?>)column) || this.getTitleSuffixBuilder().accept((IColumn<?>)column) || this.getSubtitleBuilder().accept((IColumn<?>)column)).collect(Collectors.toList());
        List<IColumn<?>> contentBuilderColumns = this.getLinkedAndAcceptedCompactBuilderColumns(this.getContentBuilders());
        List<IColumn<?>> providedColumns = Stream.concat(titleColumns.stream(), contentBuilderColumns.stream()).collect(Collectors.toList());
        columns.removeAll(providedColumns);
        providedColumns.addAll(columns);
        return providedColumns;
    }

    protected List<IColumn<?>> getLinkedAndAcceptedCompactBuilderColumns(List<CompactLineBuilder> builders) {
        return builders.stream().map(builder -> {
            IColumn<?> column = builder.getColumn();
            if (column != null && builder.accept(column)) {
                return column;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public CompactBeanBuilder getBeanBuilder() {
        return this.m_beanBuilder;
    }

    @Override
    public TableCompactHandler withBeanBuilder(CompactBeanBuilder builder) {
        this.m_beanBuilder = builder;
        return this;
    }

    @Override
    public CompactLineBuilder getTitleBuilder() {
        return this.m_titleBuilder;
    }

    @Override
    public TableCompactHandler withTitleBuilder(CompactLineBuilder builder) {
        this.m_titleBuilder = builder;
        return this;
    }

    @Override
    public TableCompactHandler withTitleColumnSupplier(Supplier<IColumn<?>> titleColumnSupplier) {
        return this.withTitleBuilder(new TitleBuilder(titleColumnSupplier));
    }

    @Override
    public CompactLineBuilder getTitleSuffixBuilder() {
        return this.m_titleSuffixBuilder;
    }

    @Override
    public TableCompactHandler withTitleSuffixBuilder(CompactLineBuilder builder) {
        this.m_titleSuffixBuilder = builder;
        return this;
    }

    @Override
    public TableCompactHandler withTitleSuffixColumnSupplier(Supplier<IColumn<?>> titleSuffixColumnSupplier) {
        return this.withTitleSuffixBuilder(new TitleSuffixBuilder(titleSuffixColumnSupplier));
    }

    @Override
    public CompactLineBuilder getSubtitleBuilder() {
        return this.m_subtitleBuilder;
    }

    @Override
    public TableCompactHandler withSubtitleBuilder(CompactLineBuilder builder) {
        this.m_subtitleBuilder = builder;
        return this;
    }

    @Override
    public TableCompactHandler withSubtitleColumnSupplier(Supplier<IColumn<?>> subtitleColumnSupplier) {
        return this.withSubtitleBuilder(new SubtitleBuilder(subtitleColumnSupplier));
    }

    @Override
    public List<CompactLineBuilder> getContentBuilders() {
        return this.m_contentBuilder;
    }

    @Override
    public TableCompactHandler addContentLineBuilder(CompactLineBuilder builder) {
        this.m_contentBuilder.add(builder);
        return this;
    }

    @Override
    public TableCompactHandler withContentColumnSuppliers(List<Supplier<IColumn<?>>> contentColumnSuppliers) {
        for (Supplier<IColumn<?>> supplier : contentColumnSuppliers) {
            this.addContentLineBuilder(new CompactLineBuilder(supplier));
        }
        return this;
    }

    @Override
    public TableCompactHandler addContentColumnSupplier(Supplier<IColumn<?>> contentColumnSupplier) {
        return this.addContentLineBuilder(new CompactLineBuilder(contentColumnSupplier));
    }

    @Override
    public CompactLineBuilder getDefaultContentLineBuilder() {
        return this.m_defaultContentLineBuilder;
    }

    @Override
    public TableCompactHandler withDefaultContentLineBuilder(CompactLineBuilder compactLineBuilder) {
        this.m_defaultContentLineBuilder = compactLineBuilder;
        return this;
    }

    @Override
    public TableCompactHandler withColumnFilter(Predicate<IColumn<?>> filter) {
        this.m_columnFilter = filter;
        return this;
    }

    @Override
    public TableCompactHandler addColumnFilter(Predicate<IColumn<?>> filter) {
        if (this.m_columnFilter != null) {
            filter = this.m_columnFilter.and(filter);
        }
        return this.withColumnFilter((Predicate)filter);
    }

    @Override
    public Predicate<IColumn<?>> getColumnFilter() {
        return this.m_columnFilter;
    }

    protected List<CompactLineBuilder> getBuilders() {
        ArrayList builders = CollectionUtility.arrayList((Object[])new CompactLineBuilder[]{this.getTitleBuilder(), this.getTitleSuffixBuilder(), this.getSubtitleBuilder()});
        builders.addAll(this.getContentBuilders());
        return builders;
    }

    protected boolean acceptColumn(IColumn<?> column) {
        if (this.m_columnFilter != null && !this.m_columnFilter.test(column)) {
            return false;
        }
        return !this.isUseOnlyVisibleColumns() || column.isVisible();
    }

    protected boolean acceptedByBuilder(IColumn<?> column) {
        return this.getBuilders().stream().anyMatch(builder -> builder.accept(column));
    }

    protected void processColumn(IColumn<?> column, ITableRow row, CompactBean bean) {
        this.updateBean(bean, column, row);
    }

    protected void updateBean(CompactBean bean, IColumn<?> column, ITableRow row) {
        if (this.getTitleBuilder().accept(column)) {
            bean.setTitleLine(this.buildCompactLine(this.getTitleBuilder(), column, row));
        } else if (this.getTitleSuffixBuilder().accept(column)) {
            bean.setTitleSuffixLine(this.buildCompactLine(this.getTitleSuffixBuilder(), column, row));
        } else if (this.getSubtitleBuilder().accept(column)) {
            bean.setSubtitleLine(this.buildCompactLine(this.getSubtitleBuilder(), column, row));
        } else {
            for (CompactLineBuilder contentBuilder : this.getContentBuilders()) {
                if (!contentBuilder.accept(column)) continue;
                bean.addContentLine(this.buildCompactLine(contentBuilder, column, row));
                return;
            }
            if (this.getDefaultContentLineBuilder().accept(column)) {
                bean.addContentLine(this.buildCompactLine(this.getDefaultContentLineBuilder(), column, row));
            }
        }
    }

    protected CompactLine buildCompactLine(CompactLineBuilder builder, IColumn<?> column, ITableRow row) {
        CompactLine line = builder.build(column, row);
        this.adaptCompactLine(line, column, row);
        return line;
    }

    protected void adaptCompactLine(CompactLine line, IColumn<?> column, ITableRow row) {
        if (this.getLineCustomizer() != null) {
            this.getLineCustomizer().accept(line);
        }
    }

    @Override
    public Consumer<CompactLine> getLineCustomizer() {
        return this.m_lineCustomizer;
    }

    @Override
    public TableCompactHandler withLineCustomizer(Consumer<CompactLine> customizer) {
        this.m_lineCustomizer = customizer;
        return this;
    }

    protected void postProcessBean(CompactBean bean) {
        bean.transform(true, this.getMaxContentLines(), this.isMoreLinkAvailable());
        if (!StringUtility.isNullOrEmpty((CharSequence)bean.getTitle()) && StringUtility.isNullOrEmpty((CharSequence)bean.getSubtitle()) && StringUtility.isNullOrEmpty((CharSequence)bean.getTitleSuffix()) && StringUtility.isNullOrEmpty((CharSequence)bean.getContent())) {
            bean.setContent(bean.getTitle());
            bean.setTitle("");
        }
    }

    @Override
    public String buildValue(CompactBean bean) {
        String hasHeader = StringUtility.hasText((CharSequence)(bean.getTitle() + bean.getTitleSuffix() + bean.getSubtitle())) ? "has-header" : "";
        IHtmlElement moreLink = this.isMoreLinkAvailable() && StringUtility.hasText((CharSequence)bean.getMoreContent()) ? HTML.div((CharSequence[])new CharSequence[]{HTML.span((CharSequence[])new CharSequence[]{TEXTS.get((String)"More")}).addCssClass((CharSequence)"more-link link")}).cssClass((CharSequence)"compact-cell-more") : null;
        String value = HTML.fragment((CharSequence[])new CharSequence[]{HTML.div((CharSequence[])new CharSequence[]{HTML.div((CharSequence[])new CharSequence[]{HTML.span((CharSequence[])new CharSequence[]{HTML.raw((CharSequence[])new CharSequence[]{bean.getTitle()})}).cssClass((CharSequence)"left"), HTML.span((CharSequence[])new CharSequence[]{HTML.raw((CharSequence[])new CharSequence[]{bean.getTitleSuffix()})}).cssClass((CharSequence)"right")}).cssClass((CharSequence)"compact-cell-title"), HTML.div((CharSequence[])new CharSequence[]{HTML.raw((CharSequence[])new CharSequence[]{bean.getSubtitle()})}).cssClass((CharSequence)"compact-cell-subtitle")}).cssClass((CharSequence)"compact-cell-header"), HTML.div((CharSequence[])new CharSequence[]{HTML.raw((CharSequence[])new CharSequence[]{bean.getContent()})}).cssClass((CharSequence)("compact-cell-content " + hasHeader)), HTML.div((CharSequence[])new CharSequence[]{HTML.raw((CharSequence[])new CharSequence[]{bean.getMoreContent()})}).cssClass((CharSequence)("compact-cell-more-content hidden " + hasHeader)), moreLink}).toHtml();
        return value;
    }

    protected IColumn<?> getDefaultTitleColumn() {
        return this.getColumnAt(0);
    }

    protected IColumn<?> getDefaultSubtitleColumn() {
        return this.getColumnAt(1);
    }

    protected IColumn<?> getColumnAt(int index) {
        List<IColumn<Object>> columns = this.getTable().getColumnSet().getColumns();
        if ((columns = columns.stream().filter(this::acceptColumn).collect(Collectors.toList())).size() < index + 1) {
            return null;
        }
        return columns.get(index);
    }

    protected class BeanBuilder
    implements CompactBeanBuilder {
        protected BeanBuilder() {
        }

        @Override
        public CompactBean apply(List<IColumn<?>> columns, ITableRow row) {
            CompactBean bean = new CompactBean();
            TableCompactHandler.this.processColumns(columns, row, bean);
            return bean;
        }
    }

    public static class ContentLineBuilder
    extends CompactLineBuilder {
        @Override
        public boolean accept(IColumn<?> column) {
            return true;
        }
    }

    protected class P_TableListener
    extends TableAdapter {
        protected P_TableListener() {
        }

        @Override
        public void tableChanged(TableEvent e) {
            List<ITableRow> rows = e.getRows();
            if (ObjectUtility.isOneOf((Object)e.getType(), (Object)1, (Object[])new Object[]{780})) {
                rows = TableCompactHandler.this.getTable().getRows();
            }
            long time = System.currentTimeMillis();
            TableCompactHandler.this.updateValues(rows);
            LOG.debug("Event {} handled. Updating values took {}ms for {} rows.", new Object[]{e.getType(), System.currentTimeMillis() - time, rows.size()});
        }
    }

    public static class SubtitleBuilder
    extends CompactLineBuilder {
        public SubtitleBuilder(Supplier<IColumn<?>> columnSupplier) {
            super(columnSupplier);
            this.withShowLabel(false);
        }
    }

    public static class TitleBuilder
    extends CompactLineBuilder {
        public TitleBuilder(Supplier<IColumn<?>> columnSupplier) {
            super(columnSupplier);
            this.withShowLabel(false);
        }
    }

    public static class TitleSuffixBuilder
    extends CompactLineBuilder {
        public TitleSuffixBuilder(Supplier<IColumn<?>> columnSupplier) {
            super(columnSupplier);
            this.withShowLabel(false);
        }
    }
}

