/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class CompactLineBlock {
    private String m_text;
    private String m_processedText;
    private String m_icon;
    private boolean m_encodeHtmlEnabled = true;
    private boolean m_nlToBrEnabled;
    private boolean m_htmlToPlainTextEnabled;
    private HtmlHelper m_htmlHelper;

    public CompactLineBlock() {
    }

    public CompactLineBlock(String text, String icon) {
        this.setText(text);
        this.setIcon(icon);
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
    }

    public String getProcessedText() {
        if (this.m_processedText == null) {
            this.m_processedText = this.processText();
        }
        return this.m_processedText;
    }

    public String getIcon() {
        return this.m_icon;
    }

    public void setIcon(String icon) {
        this.m_icon = icon;
    }

    public boolean isEncodeHtmlEnabled() {
        return this.m_encodeHtmlEnabled;
    }

    public void setEncodeHtmlEnabled(boolean encodeHtmlEnabled) {
        if (this.m_encodeHtmlEnabled != encodeHtmlEnabled) {
            this.m_processedText = null;
        }
        this.m_encodeHtmlEnabled = encodeHtmlEnabled;
    }

    public boolean isNlToBrEnabled() {
        return this.m_nlToBrEnabled;
    }

    public void setNlToBrEnabled(boolean nlToBrEnabled) {
        if (this.m_nlToBrEnabled != nlToBrEnabled) {
            this.m_processedText = null;
        }
        this.m_nlToBrEnabled = nlToBrEnabled;
    }

    public boolean isHtmlToPlainTextEnabled() {
        return this.m_htmlToPlainTextEnabled;
    }

    public void setHtmlToPlainTextEnabled(boolean htmlToPlainTextEnabled) {
        if (this.m_htmlToPlainTextEnabled != htmlToPlainTextEnabled) {
            this.m_processedText = null;
        }
        this.m_htmlToPlainTextEnabled = htmlToPlainTextEnabled;
    }

    protected String processText() {
        String text = this.getText();
        if (this.isHtmlToPlainTextEnabled()) {
            if (this.isNlToBrEnabled()) {
                text = this.getHtmlHelper().newLineToBr(text);
            }
            text = this.getHtmlHelper().toPlainText(text);
        } else if (this.isEncodeHtmlEnabled()) {
            text = this.getHtmlHelper().escape(text);
        }
        if (this.isNlToBrEnabled()) {
            text = this.getHtmlHelper().newLineToBr(text);
        }
        return text;
    }

    protected HtmlHelper getHtmlHelper() {
        if (this.m_htmlHelper == null) {
            this.m_htmlHelper = (HtmlHelper)BEANS.get(HtmlHelper.class);
        }
        return this.m_htmlHelper;
    }

    public String build() {
        if (this.getIcon() != null) {
            return String.valueOf(HTML.icon((CharSequence)this.getIcon()).addCssClass((CharSequence)("icon " + (StringUtility.hasText((CharSequence)this.getProcessedText()) ? "with-text" : "")))) + (String)ObjectUtility.nvl((Object)this.getProcessedText(), (Object)"");
        }
        return this.getProcessedText();
    }
}

