/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.columns.CompactLineBlock;
import org.eclipse.scout.rt.platform.html.HTML;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class CompactLine {
    private CompactLineBlock m_labelBlock;
    private CompactLineBlock m_textBlock;

    public CompactLine() {
        this.setLabelBlock(new CompactLineBlock());
        this.setTextBlock(new CompactLineBlock());
    }

    public CompactLine(String label, String text) {
        this.setLabelBlock(new CompactLineBlock(label, null));
        this.setTextBlock(new CompactLineBlock(text, null));
    }

    public CompactLine(IHeaderCell headerCell, ICell cell) {
        this.setLabelBlock(this.convertHeaderCellToBlock(headerCell));
        this.setTextBlock(this.convertCellToBlock(cell));
    }

    protected CompactLineBlock convertHeaderCellToBlock(IHeaderCell cell) {
        CompactLineBlock block = new CompactLineBlock();
        if (cell != null) {
            block.setText(cell.getText());
            block.setIcon(cell.getIconId());
            block.setEncodeHtmlEnabled(!cell.isHtmlEnabled());
        }
        return block;
    }

    protected CompactLineBlock convertCellToBlock(ICell cell) {
        CompactLineBlock block = new CompactLineBlock();
        if (cell != null) {
            block.setText(cell.getText());
            block.setIcon(cell.getIconId());
            block.setEncodeHtmlEnabled(!cell.isHtmlEnabled());
        }
        return block;
    }

    public CompactLineBlock getLabelBlock() {
        return this.m_labelBlock;
    }

    public void setLabelBlock(CompactLineBlock block) {
        Assertions.assertNotNull((Object)block);
        this.m_labelBlock = block;
    }

    public CompactLineBlock getTextBlock() {
        return this.m_textBlock;
    }

    public void setTextBlock(CompactLineBlock block) {
        Assertions.assertNotNull((Object)block);
        this.m_textBlock = block;
    }

    public String build() {
        String value;
        Object label = this.getLabelBlock().build();
        if (StringUtility.hasText((CharSequence)label)) {
            label = (String)label + ": ";
        }
        if (!StringUtility.hasText((CharSequence)(value = this.getTextBlock().build()))) {
            return "";
        }
        return HTML.div((CharSequence[])new CharSequence[]{HTML.span((CharSequence[])new CharSequence[]{HTML.raw((CharSequence[])new CharSequence[]{label})}).cssClass((CharSequence)"compact-cell-line-label"), HTML.span((CharSequence[])new CharSequence[]{HTML.raw((CharSequence[])new CharSequence[]{value})}).cssClass((CharSequence)"compact-cell-line-value")}).cssClass((CharSequence)"compact-cell-line").toHtml();
    }
}

