/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.ISmartColumnExtension;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.SmartColumnChains;
import org.eclipse.scout.rt.client.services.lookup.ILookupCallProvisioningService;
import org.eclipse.scout.rt.client.services.lookup.TableProvisioningContext;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IOrdered;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.platform.util.collection.OrderedCollection;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupResultCache;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.IBatchLookupService;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;

@ClassId(value="65eaf372-09ff-425a-ad82-5be17fa9f1a7")
public abstract class AbstractSmartColumn<VALUE>
extends AbstractColumn<VALUE>
implements ISmartColumn<VALUE>,
IContributionOwner {
    private Class<? extends ICodeType<?, VALUE>> m_codeTypeClass;
    private ILookupCall<VALUE> m_lookupCall;
    private boolean m_sortCodesByDisplayText;
    private IContributionOwner m_contributionHolder;

    public AbstractSmartColumn() {
        this(true);
    }

    public AbstractSmartColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected ISmartColumnExtension<VALUE, ? extends AbstractSmartColumn<VALUE>> createLocalExtension() {
        return new LocalSmartColumnExtension(this);
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    public final <T> T optContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.optContribution(contribution);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredSortCodesByDisplayText() {
        return false;
    }

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=140.0)
    protected Class<? extends ILookupCall<VALUE>> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=150.0)
    protected Class<? extends ICodeType<?, VALUE>> getConfiguredCodeType() {
        return null;
    }

    @ConfigOperation
    @Order(value=160.0)
    protected void execPrepareLookup(ILookupCall<VALUE> call, ITableRow row) {
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    protected boolean getConfiguredBrowseHierarchy() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredBrowseAutoExpandAll() {
        return true;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=265.0)
    protected int getConfiguredBrowseMaxRowCount() {
        return 100;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredActiveFilterEnabled() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredBrowseLoadIncremental() {
        return false;
    }

    protected ILookupCall<VALUE> prepareLookupCall(ITableRow row, VALUE value) {
        if (this.getLookupCall() != null) {
            ILookupCall<VALUE> call = ((ILookupCallProvisioningService)BEANS.get(ILookupCallProvisioningService.class)).newClonedInstance(this.getLookupCall(), new TableProvisioningContext(this.getTable(), row, this));
            call.setKey(value);
            call.setText(null);
            call.setAll(null);
            call.setRec(null);
            this.interceptPrepareLookup(call, row);
            return call;
        }
        return null;
    }

    @Override
    public ILookupCall<VALUE> prepareLookupCall(ITableRow row) {
        return this.prepareLookupCall(row, this.getValueInternal(row));
    }

    @Override
    protected void initConfig() {
        Class<ILookupCall<VALUE>> lookupCallClass;
        super.initConfig();
        this.m_contributionHolder = new ContributionComposite((Object)this);
        this.setSortCodesByDisplayText(this.getConfiguredSortCodesByDisplayText());
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            try {
                ILookupCall call = (ILookupCall)BEANS.get(lookupCallClass);
                this.setLookupCall(call);
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)new ProcessingException("error creating instance of class '" + lookupCallClass.getName() + "'.", new Object[]{e}));
            }
        }
    }

    @Override
    public Class<? extends ICodeType<?, VALUE>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType<?, VALUE>> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = CodeLookupCall.newInstanceByService(this.m_codeTypeClass);
        }
        this.refreshValues();
    }

    @Override
    public ILookupCall<VALUE> getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(ILookupCall<VALUE> call) {
        this.m_lookupCall = call;
    }

    public Class<VALUE> getLookupType() {
        return TypeCastUtility.getGenericsParameterClass(this.getClass(), AbstractSmartColumn.class, (int)1);
    }

    @Override
    protected VALUE parseValueInternal(ITableRow row, Object rawValue) {
        Object validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (this.getDataType().isAssignableFrom(rawValue.getClass())) {
            validValue = rawValue;
        } else {
            try {
                validValue = TypeCastUtility.castValue((Object)rawValue, this.getDataType());
            }
            catch (RuntimeException e) {
                throw new ProcessingException("invalid {} value in column '{}': {} class={}", new Object[]{this.getDataType().getSimpleName(), this.getClass().getName(), rawValue, rawValue.getClass(), e});
            }
        }
        return (VALUE)validValue;
    }

    @Override
    public void updateDisplayTexts(List<ITableRow> rows) {
        try {
            if (!rows.isEmpty()) {
                BatchLookupCall batchCall = new BatchLookupCall();
                ArrayList<ITableRow> batchRowList = new ArrayList<ITableRow>();
                BatchLookupResultCache lookupResultCache = new BatchLookupResultCache();
                for (ITableRow row : rows) {
                    ILookupCall<VALUE> call = this.prepareLookupCall(row);
                    if (call != null && call.getKey() != null) {
                        if (call instanceof LocalLookupCall) {
                            this.applyLookupResult(row, lookupResultCache.getDataByKey(call));
                            continue;
                        }
                        batchRowList.add(row);
                        batchCall.addLookupCall(call);
                        continue;
                    }
                    this.applyLookupResult(row, new ArrayList(0));
                }
                if (!batchCall.isEmpty()) {
                    ITableRow[] tableRows = batchRowList.toArray(new ITableRow[0]);
                    IBatchLookupService service = (IBatchLookupService)BEANS.get(IBatchLookupService.class);
                    List resultArray = service.getBatchDataByKey(batchCall);
                    int i = 0;
                    while (i < tableRows.length) {
                        this.applyLookupResult(tableRows[i], (List)resultArray.get(i));
                        ++i;
                    }
                }
            }
        }
        catch (RuntimeException e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    @Override
    public void updateDisplayText(ITableRow row, VALUE value) {
        ILookupCall<VALUE> call = this.prepareLookupCall(row, value);
        if (call != null && call.getKey() != null) {
            try {
                List result = call.getDataByKey();
                this.applyLookupResult(row, result);
            }
            catch (RuntimeException pe) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)pe);
            }
        } else {
            super.updateDisplayText(row, value);
        }
    }

    @Override
    public void updateDisplayText(ITableRow row, Cell cell) {
        ILookupCall<VALUE> call = this.prepareLookupCall(row);
        if (call != null && call.getKey() != null) {
            try {
                List result = call.getDataByKey();
                this.applyLookupResult(row, result);
            }
            catch (RuntimeException pe) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)pe);
            }
        } else {
            super.updateDisplayText(row, cell);
        }
    }

    protected void applyLookupResult(ITableRow tableRow, List<? extends ILookupRow<?>> result) {
        try {
            tableRow.setRowChanging(true);
            Cell cell = tableRow.getCellForUpdate(this);
            String separator = this.getResultRowSeparator();
            ArrayList texts = CollectionUtility.emptyArrayList();
            ArrayList tooltipTexts = CollectionUtility.emptyArrayList();
            for (ILookupRow<?> row : result) {
                texts.add(row.getText());
                tooltipTexts.add(row.getTooltipText());
            }
            cell.setText(StringUtility.join((String)separator, (Collection)texts));
            cell.setTooltipText(StringUtility.join((String)separator, (Collection)tooltipTexts));
        }
        finally {
            tableRow.setRowPropertiesChanged(false);
            tableRow.setRowChanging(false);
        }
    }

    private String getResultRowSeparator() {
        if (this.getTable().isMultilineText()) {
            return "\n";
        }
        return ", ";
    }

    protected void mapEditorFieldProperties(ISmartField<VALUE> f) {
        super.mapEditorFieldProperties(f);
        f.setCodeTypeClass(this.getCodeTypeClass());
        f.setLookupCall(this.getLookupCall());
        f.setBrowseHierarchy(this.getConfiguredBrowseHierarchy());
        f.setBrowseMaxRowCount(this.getConfiguredBrowseMaxRowCount());
        f.setActiveFilterEnabled(this.getConfiguredActiveFilterEnabled());
        f.setBrowseAutoExpandAll(this.getConfiguredBrowseAutoExpandAll());
        f.setBrowseLoadIncremental(this.getConfiguredBrowseLoadIncremental());
    }

    @Override
    public boolean isSortCodesByDisplayText() {
        return this.m_sortCodesByDisplayText;
    }

    @Override
    public void setSortCodesByDisplayText(boolean b) {
        this.m_sortCodesByDisplayText = b;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) {
        SmartFieldEditor f = (SmartFieldEditor)this.getDefaultEditor();
        f.setRow(row);
        this.mapEditorFieldProperties(f);
        return f;
    }

    @Override
    protected ISmartField<VALUE> createDefaultEditor() {
        return new SmartFieldEditor();
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        ILookupCall<VALUE> call;
        ICodeType codeType = this.getCodeTypeClass() != null ? (ICodeType)BEANS.opt(this.getCodeTypeClass()) : null;
        ILookupCall<VALUE> iLookupCall = call = this.getLookupCall() != null ? this.getLookupCall() : null;
        if (codeType != null) {
            if (this.isSortCodesByDisplayText()) {
                String s1 = this.getDisplayText(r1);
                String s2 = this.getDisplayText(r2);
                return StringUtility.compareIgnoreCase((String)s1, (String)s2);
            }
            Object t1 = this.getValue(r1);
            Object t2 = this.getValue(r2);
            Integer sort1 = t1 != null ? codeType.getCodeIndex(t1) : -1;
            Integer sort2 = t2 != null ? codeType.getCodeIndex(t2) : -1;
            int c = sort1.compareTo(sort2);
            return c;
        }
        if (call != null) {
            String s1 = this.getDisplayText(r1);
            String s2 = this.getDisplayText(r2);
            return StringUtility.compareIgnoreCase((String)s1, (String)s2);
        }
        return super.compareTableRows(r1, r2);
    }

    protected final void interceptPrepareLookup(ILookupCall<VALUE> call, ITableRow row) {
        List extensions = this.getAllExtensions();
        SmartColumnChains.SmartColumnPrepareLookupChain<VALUE> chain = new SmartColumnChains.SmartColumnPrepareLookupChain<VALUE>(extensions);
        chain.execPrepareLookup(call, row);
    }

    protected static class LocalSmartColumnExtension<VALUE, OWNER extends AbstractSmartColumn<VALUE>>
    extends AbstractColumn.LocalColumnExtension<VALUE, OWNER>
    implements ISmartColumnExtension<VALUE, OWNER> {
        public LocalSmartColumnExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execPrepareLookup(SmartColumnChains.SmartColumnPrepareLookupChain<VALUE> chain, ILookupCall<VALUE> call, ITableRow row) {
            ((AbstractSmartColumn)this.getOwner()).execPrepareLookup(call, row);
        }
    }

    @ClassId(value="18e7b5e0-b4e4-424f-869b-7dab2f526560")
    protected class SmartFieldEditor
    extends AbstractSmartField<VALUE> {
        private ITableRow m_row;

        protected SmartFieldEditor() {
        }

        protected ITableRow getRow() {
            return this.m_row;
        }

        protected void setRow(ITableRow row) {
            this.m_row = row;
        }

        @Override
        protected void initConfig() {
            super.initConfig();
            this.propertySupport.putPropertiesMap(AbstractSmartColumn.this.propertySupport.getPropertiesMap());
        }

        @Override
        public Class<VALUE> getHolderType() {
            return AbstractSmartColumn.this.getDataType();
        }

        @Override
        protected void execPrepareLookup(ILookupCall<VALUE> call) {
            AbstractSmartColumn.this.interceptPrepareLookup(call, this.getRow());
        }

        @Override
        protected void injectMenusInternal(OrderedCollection<IMenu> menus) {
            Class[] menuCandidates = ConfigurationUtility.getDeclaredPublicClasses(AbstractSmartColumn.this.getClass());
            List menuClazzes = ConfigurationUtility.filterClasses((Class[])menuCandidates, IMenu.class);
            for (Class menuClazz : menuClazzes) {
                menus.addOrdered((IOrdered)((IMenu)ConfigurationUtility.newInnerInstance((Object)AbstractSmartColumn.this, (Class)menuClazz)));
            }
            List contributedMenus = AbstractSmartColumn.this.m_contributionHolder.getContributionsByClass(IMenu.class);
            menus.addAllOrdered((Collection)contributedMenus);
        }
    }
}

