/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

@ClassId(value="3ffdbb40-21be-4bca-93b6-eea592cf030c")
public abstract class AbstractRowDataColumn<T>
extends AbstractColumn<T> {
    private TableListener m_updateTableRowListener;

    @Override
    public void initColumn() {
        super.initColumn();
        if (this.getTable() != null) {
            if (this.m_updateTableRowListener != null) {
                this.getTable().removeTableListener(this.m_updateTableRowListener, new Integer[0]);
            }
            AbstractRowDataColumn self = this;
            this.m_updateTableRowListener = e -> {
                try {
                    try {
                        this.getTable().setTableChanging(true);
                        for (ITableRow row : e.getRows()) {
                            if (e.getType() != 100 && !e.getUpdatedColumns(row).contains(self)) continue;
                            int origStatus = row.getStatus();
                            this.updateTableColumns(row, this.getValue(row));
                            row.setStatus(origStatus);
                        }
                    }
                    catch (RuntimeException ex) {
                        ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)ex);
                        this.getTable().setTableChanging(false);
                    }
                }
                finally {
                    this.getTable().setTableChanging(false);
                }
            };
            this.getTable().addTableListener(this.m_updateTableRowListener, 100, 101);
        }
    }

    @Override
    public void disposeColumn() {
        super.disposeColumn();
        if (this.getTable() != null && this.m_updateTableRowListener != null) {
            this.getTable().removeTableListener(this.m_updateTableRowListener, new Integer[0]);
        }
        this.m_updateTableRowListener = null;
    }

    @Override
    protected boolean getConfiguredDisplayable() {
        return false;
    }

    @Override
    public void setValue(ITableRow r, T rawValue) {
        int oldRowState = r.getStatus();
        Object oldValue = this.getValue(r);
        super.setValue(r, rawValue);
        if (r.getCell(this).getObserver() != null) {
            r.getCell(this).getObserver().cellChanged(r.getCell(this), 1);
        }
        if (!this.hasValueChanged(oldValue, rawValue)) {
            r.setStatus(oldRowState);
        }
    }

    protected boolean hasValueChanged(T oldValue, T newValue) {
        return !ObjectUtility.equals(oldValue, newValue);
    }

    protected abstract void updateTableColumns(ITableRow var1, T var2);
}

