/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.client.services.lookup.AbstractRestLookupCall;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractSmartColumn;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;

@ClassId(value="f8f5dfa4-cca7-4c61-8d40-641e70154641")
public abstract class AbstractRestLookupSmartColumn<VALUE>
extends AbstractSmartColumn<VALUE> {
    @Override
    protected abstract Class<? extends AbstractRestLookupCall<?, VALUE>> getConfiguredLookupCall();

    public AbstractRestLookupCall<?, VALUE> getLookupCall() {
        return (AbstractRestLookupCall)super.getLookupCall();
    }

    @Override
    public void updateDisplayTexts(List<ITableRow> rows) {
        if (rows.isEmpty()) {
            return;
        }
        Set keys = this.getValues().stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            return;
        }
        ILookupCall call = this.getLookupCall();
        if (call == null) {
            return;
        }
        try {
            ILookupCall lookupCall = call.copy();
            this.execPrepareLookup((AbstractRestLookupCall<?, VALUE>)lookupCall);
            lookupCall.setKeys(keys);
            List dataByKey = lookupCall.getDataByKey();
            for (ITableRow row : rows) {
                List lookupResult = dataByKey.stream().filter(lookupRow -> ObjectUtility.equals((Object)lookupRow.getKey(), (Object)row.getCell(this).getValue())).collect(Collectors.toList());
                this.applyLookupResult(row, lookupResult);
            }
        }
        catch (RuntimeException e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    protected void execPrepareLookup(AbstractRestLookupCall<?, VALUE> call) {
    }
}

