/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Set;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.INumberColumnExtension;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.INumberColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.NumberUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

@ClassId(value="6b77a24f-8685-4023-b353-cbbe7d4bf22a")
public abstract class AbstractNumberColumn<NUMBER extends Number>
extends AbstractColumn<NUMBER>
implements INumberColumn<NUMBER> {
    private boolean m_validateOnAnyKey;
    private String m_initialAggregationFunction;
    private String m_initialBackgroundEffect;

    public AbstractNumberColumn() {
        this(true);
    }

    public AbstractNumberColumn(boolean callInitializer) {
        super(callInitializer);
    }

    protected abstract NUMBER getConfiguredMinValue();

    protected abstract NUMBER getConfiguredMaxValue();

    @ConfigProperty(value="INTEGER")
    @Order(value=280.0)
    protected int getConfiguredMaxIntegerDigits() {
        return 32;
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    protected boolean getConfiguredValidateOnAnyKey() {
        return false;
    }

    @ConfigProperty(value="ROUNDING_MODE")
    @Order(value=170.0)
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.UNNECESSARY;
    }

    @Override
    protected boolean getConfiguredUiSortPossible() {
        return true;
    }

    protected Set<String> getConfiguredAllowedAggregationFunctions() {
        return CollectionUtility.hashSet((Object[])new String[]{"sum", "min", "max", "avg", "none"});
    }

    protected String getConfiguredAggregationFunction() {
        return "sum";
    }

    @ConfigProperty(value="STRING")
    protected String getConfiguredBackgroundEffect() {
        return null;
    }

    @Override
    public void initColumn() {
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        this.setBackgroundEffect(prefs.getTableColumnBackgroundEffect(this, this.getBackgroundEffect(), null));
        super.initColumn();
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.initFormat();
        this.setRoundingMode(this.getConfiguredRoundingMode());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
        this.setValidateOnAnyKey(this.getConfiguredValidateOnAnyKey());
        this.setMaxValue(this.getConfiguredMaxValue());
        this.setMinValue(this.getConfiguredMinValue());
        this.setInitialAggregationFunction(this.getConfiguredAggregationFunction());
        this.setAllowedAggregationFunctions(this.getConfiguredAllowedAggregationFunctions());
        this.setAggregationFunction(this.getConfiguredAggregationFunction());
        this.setInitialBackgroundEffect(this.getConfiguredBackgroundEffect());
        this.setBackgroundEffect(this.getConfiguredBackgroundEffect());
    }

    protected void initFormat() {
        DecimalFormat format = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getNumberInstance(NlsLocale.get());
        format.setParseBigDecimal(true);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(0);
        format.setMaximumIntegerDigits(this.getConfiguredMaxIntegerDigits());
        this.propertySupport.setProperty("decimalFormat", (Object)format);
    }

    @Override
    public void setFormat(DecimalFormat format) {
        Assertions.assertNotNull((Object)format);
        DecimalFormat newFormat = (DecimalFormat)format.clone();
        newFormat.setParseBigDecimal(true);
        this.propertySupport.setProperty("decimalFormat", (Object)newFormat);
        this.updateDisplayTexts();
    }

    @Override
    public DecimalFormat getFormat() {
        return (DecimalFormat)((Format)this.propertySupport.getProperty("decimalFormat")).clone();
    }

    @Override
    public void setMaxIntegerDigits(int maxIntegerDigits) {
        DecimalFormat format = this.getFormat();
        format.setMaximumIntegerDigits(maxIntegerDigits);
        this.setFormat(format);
    }

    @Override
    public int getMaxIntegerDigits() {
        return this.getFormatInternal().getMaximumIntegerDigits();
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        DecimalFormat format = this.getFormat();
        format.setRoundingMode(roundingMode);
        this.setFormat(format);
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.getFormatInternal().getRoundingMode();
    }

    protected DecimalFormat getFormatInternal() {
        return (DecimalFormat)this.propertySupport.getProperty("decimalFormat");
    }

    @Override
    public void setGroupingUsed(boolean b) {
        DecimalFormat format = this.getFormat();
        format.setGroupingUsed(b);
        this.setFormat(format);
    }

    @Override
    public boolean isGroupingUsed() {
        return this.getFormatInternal().isGroupingUsed();
    }

    @Override
    public void setMaxValue(NUMBER maxValue) {
        NUMBER min = this.getMinValue();
        if (maxValue != null && min != null && this.compareInternal(maxValue, min) < 0) {
            this.propertySupport.setProperty("minValue", maxValue);
        }
        this.propertySupport.setProperty("maxValue", maxValue);
        this.refreshValues();
    }

    @Override
    public NUMBER getMaxValue() {
        return (NUMBER)((Number)this.propertySupport.getProperty("maxValue"));
    }

    private int compareInternal(NUMBER a, NUMBER b) {
        return ObjectUtility.compareTo((Comparable)NumberUtility.numberToBigDecimal(a), (Comparable)NumberUtility.numberToBigDecimal(b));
    }

    @Override
    public void setMinValue(NUMBER minValue) {
        NUMBER max = this.getMaxValue();
        if (minValue != null && max != null && this.compareInternal(minValue, max) > 0) {
            this.propertySupport.setProperty("maxValue", minValue);
        }
        this.propertySupport.setProperty("minValue", minValue);
        this.refreshValues();
    }

    @Override
    public NUMBER getMinValue() {
        return (NUMBER)((Number)this.propertySupport.getProperty("minValue"));
    }

    @Override
    public String getInitialAggregationFunction() {
        return this.m_initialAggregationFunction;
    }

    @Override
    public void setInitialAggregationFunction(String f) {
        this.m_initialAggregationFunction = f;
    }

    @Override
    public Set<String> getAllowedAggregationFunctions() {
        return this.propertySupport.getPropertySet("allowedAggregationFunctions");
    }

    @Override
    public void setAllowedAggregationFunctions(Set<String> functions) {
        this.propertySupport.setPropertySet("allowedAggregationFunctions", functions);
    }

    @Override
    public String getAggregationFunction() {
        return this.propertySupport.getPropertyString("aggregationFunction");
    }

    @Override
    public void setAggregationFunction(String f) {
        this.propertySupport.setPropertyString("aggregationFunction", f);
    }

    @Override
    public String getBackgroundEffect() {
        return this.propertySupport.getPropertyString("backgroundEffect");
    }

    @Override
    public void setBackgroundEffect(String effect) {
        this.propertySupport.setPropertyString("backgroundEffect", effect);
    }

    @Override
    public void setInitialBackgroundEffect(String effect) {
        this.m_initialBackgroundEffect = effect;
    }

    @Override
    public String getInitialBackgroundEffect() {
        return this.m_initialBackgroundEffect;
    }

    @Override
    public void setValidateOnAnyKey(boolean b) {
        this.m_validateOnAnyKey = b;
    }

    @Override
    public boolean isValidateOnAnyKey() {
        return this.m_validateOnAnyKey;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) {
        INumberField f = (INumberField)this.getDefaultEditor();
        this.mapEditorFieldProperties(f);
        return f;
    }

    protected void mapEditorFieldProperties(INumberField<NUMBER> f) {
        super.mapEditorFieldProperties(f);
        f.setFormat(this.getFormat());
        f.setMinValue((Number)this.getMinValue());
        f.setMaxValue((Number)this.getMaxValue());
    }

    @Override
    protected String formatValueInternal(ITableRow row, NUMBER value) {
        return value != null ? this.getFormat().format(value) : "";
    }

    @Override
    protected INumberColumnExtension<NUMBER, ? extends AbstractNumberColumn<NUMBER>> createLocalExtension() {
        return new LocalNumberColumnExtension(this);
    }

    protected static class LocalNumberColumnExtension<NUMBER extends Number, OWNER extends AbstractNumberColumn<NUMBER>>
    extends AbstractColumn.LocalColumnExtension<NUMBER, OWNER>
    implements INumberColumnExtension<NUMBER, OWNER> {
        public LocalNumberColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

