/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IDecimalColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractNumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDecimalColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.decimalfield.IDecimalField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;

@ClassId(value="961989bf-d585-40a2-ab9f-b7e545baaac9")
public abstract class AbstractDecimalColumn<NUMBER extends Number>
extends AbstractNumberColumn<NUMBER>
implements IDecimalColumn<NUMBER> {
    public AbstractDecimalColumn() {
        this(true);
    }

    public AbstractDecimalColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected RoundingMode getConfiguredRoundingMode() {
        return RoundingMode.HALF_UP;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=160.0)
    protected int getConfiguredMinFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=170.0)
    protected int getConfiguredMaxFractionDigits() {
        return 2;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=180.0)
    protected boolean getConfiguredPercent() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=190.0)
    protected int getConfiguredMultiplier() {
        return 1;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=200.0)
    protected int getConfiguredFractionDigits() {
        return 2;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setMinFractionDigits(this.getConfiguredMinFractionDigits());
        this.setMaxFractionDigits(this.getConfiguredMaxFractionDigits());
        this.setPercent(this.getConfiguredPercent());
        this.setFractionDigits(this.getConfiguredFractionDigits());
        this.setMultiplier(this.getConfiguredMultiplier());
    }

    @Override
    public void setMinFractionDigits(int i) {
        DecimalFormat format = this.getFormat();
        format.setMinimumFractionDigits(i);
        this.setFormat(format);
    }

    @Override
    public int getMinFractionDigits() {
        return this.getFormatInternal().getMinimumFractionDigits();
    }

    @Override
    public void setMaxFractionDigits(int i) {
        DecimalFormat format = this.getFormat();
        format.setMaximumFractionDigits(i);
        this.setFormat(format);
    }

    @Override
    public int getMaxFractionDigits() {
        return this.getFormatInternal().getMaximumFractionDigits();
    }

    @Override
    public void setPercent(boolean b) {
        DecimalFormat percentDF = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getPercentInstance(NlsLocale.get());
        DecimalFormat format = this.getFormat();
        if (b) {
            format.setPositiveSuffix(percentDF.getPositiveSuffix());
            format.setNegativeSuffix(percentDF.getNegativeSuffix());
        } else if (this.isPercent()) {
            format.setPositiveSuffix("");
            format.setNegativeSuffix("");
        }
        this.setFormat(format);
    }

    @Override
    public boolean isPercent() {
        DecimalFormat percentDF = ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getPercentInstance(NlsLocale.get());
        DecimalFormat internalDF = this.getFormatInternal();
        return internalDF.getPositiveSuffix().equals(percentDF.getPositiveSuffix()) && internalDF.getNegativeSuffix().equals(percentDF.getNegativeSuffix());
    }

    @Override
    public void setFractionDigits(int i) {
        this.propertySupport.setPropertyInt("parsingFractionDigits", i);
    }

    @Override
    public int getFractionDigits() {
        return this.propertySupport.getPropertyInt("parsingFractionDigits");
    }

    @Override
    public void setMultiplier(int i) {
        DecimalFormat format = this.getFormat();
        format.setMultiplier(i);
        this.setFormat(format);
    }

    @Override
    public int getMultiplier() {
        return this.getFormatInternal().getMultiplier();
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) {
        IValueField f = this.createDefaultEditor();
        this.mapEditorFieldProperties((IDecimalField<NUMBER>)f);
        return f;
    }

    @Override
    protected abstract IDecimalField<NUMBER> createDefaultEditor();

    @Override
    protected void mapEditorFieldProperties(IDecimalField<NUMBER> f) {
        super.mapEditorFieldProperties(f);
        f.setFractionDigits(this.getFractionDigits());
    }

    @Override
    protected IDecimalColumnExtension<NUMBER, ? extends AbstractDecimalColumn<NUMBER>> createLocalExtension() {
        return new LocalDecimalColumnExtension(this);
    }

    protected static class LocalDecimalColumnExtension<NUMBER extends Number, OWNER extends AbstractDecimalColumn<NUMBER>>
    extends AbstractNumberColumn.LocalNumberColumnExtension<NUMBER, OWNER>
    implements IDecimalColumnExtension<NUMBER, OWNER> {
        public LocalDecimalColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

