/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IDateColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.IDateField;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.date.DateFormatProvider;

@ClassId(value="9185f9ed-3dc2-459b-b06b-f39c6c6fed2e")
public abstract class AbstractDateColumn
extends AbstractColumn<Date>
implements IDateColumn {
    private String m_format;
    private boolean m_hasTime;
    private boolean m_hasDate;
    private Date m_autoDate;

    public AbstractDateColumn() {
        this(true);
    }

    public AbstractDateColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="STRING")
    @Order(value=140.0)
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    protected boolean getConfiguredHasDate() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=151.0)
    protected boolean getConfiguredHasTime() {
        return false;
    }

    @ConfigProperty(value="LONG")
    @Order(value=152.0)
    protected Date getConfiguredAutoDate() {
        return null;
    }

    @ConfigProperty(value="OBJECT")
    @Order(value=153.0)
    protected String getConfiguredGroupFormat() {
        return "yyyy";
    }

    @Override
    protected boolean getConfiguredUiSortPossible() {
        return true;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setHasDate(this.getConfiguredHasDate());
        this.setHasTime(this.getConfiguredHasTime());
        this.setAutoDate(this.getConfiguredAutoDate());
        this.setGroupFormat(this.getConfiguredGroupFormat());
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        this.updateDisplayTexts();
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public void setHasDate(boolean b) {
        this.m_hasDate = b;
        this.refreshValues();
    }

    @Override
    public void setHasTime(boolean b) {
        this.m_hasTime = b;
        this.refreshValues();
    }

    @Override
    public boolean isHasDate() {
        return this.m_hasDate;
    }

    @Override
    public boolean isHasTime() {
        return this.m_hasTime;
    }

    @Override
    public Date getAutoDate() {
        return this.m_autoDate;
    }

    @Override
    public void setAutoDate(Date autoDate) {
        this.m_autoDate = autoDate;
    }

    @Override
    public String getGroupFormat() {
        return this.propertySupport.getPropertyString("groupFormat");
    }

    @Override
    public void setGroupFormat(String groupFormat) {
        this.propertySupport.setPropertyString("groupFormat", groupFormat);
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) {
        IDateField f = (IDateField)this.getDefaultEditor();
        this.mapEditorFieldProperties(f);
        return f;
    }

    @Override
    protected IValueField<Date> createDefaultEditor() {
        return new AbstractDateField(){};
    }

    protected void mapEditorFieldProperties(IDateField f) {
        super.mapEditorFieldProperties(f);
        f.setFormat(this.getFormat());
        f.setHasDate(this.isHasDate());
        f.setHasTime(this.isHasTime());
        f.setAutoDate(this.getAutoDate());
    }

    @Override
    protected void cellTextToEditField(String cellText, IFormField editorField) {
        if (!(editorField instanceof IDateField)) {
            throw new ProcessingException("Expected a date field.", new Object[0]);
        }
        IDateField field = (IDateField)editorField;
        field.setDisplayText(cellText);
    }

    @Override
    protected String formatValueInternal(ITableRow row, Date value) {
        if (value != null) {
            return this.getDateFormat().format(value);
        }
        return "";
    }

    protected DateFormat getDateFormat() {
        DateFormat df = null;
        if (this.getFormat() != null) {
            df = new SimpleDateFormat(this.getFormat(), NlsLocale.get());
        } else {
            df = this.isHasDate() && !this.isHasTime() ? ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateInstance(2, NlsLocale.get()) : (!this.isHasDate() && this.isHasTime() ? ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getTimeInstance(3, NlsLocale.get()) : ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateTimeInstance(3, 3, NlsLocale.get()));
            df.setLenient(true);
        }
        return df;
    }

    protected IDateColumnExtension<? extends AbstractDateColumn> createLocalExtension() {
        return new LocalDateColumnExtension<AbstractDateColumn>(this);
    }

    protected static class LocalDateColumnExtension<OWNER extends AbstractDateColumn>
    extends AbstractColumn.LocalColumnExtension<Date, OWNER>
    implements IDateColumnExtension<OWNER> {
        public LocalDateColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

