/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IBooleanColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.AbstractBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.BooleanUtility;

@ClassId(value="62fcae6b-6b75-4e8c-bb3f-ea3b400e7e30")
public abstract class AbstractBooleanColumn
extends AbstractColumn<Boolean>
implements IBooleanColumn {
    public AbstractBooleanColumn() {
        this(true);
    }

    public AbstractBooleanColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setVerticalAlignment(this.getConfiguredVerticalAlignment());
        this.setTriStateEnabled(this.getConfiguredTriStateEnabled());
    }

    @Override
    public int getVerticalAlignment() {
        return this.propertySupport.getPropertyInt("verticalAlignment");
    }

    @Override
    public void setVerticalAlignment(int verticalAlignment) {
        this.propertySupport.setProperty("verticalAlignment", (Object)verticalAlignment);
    }

    @Override
    public void setTriStateEnabled(boolean triStateEnabled) {
        this.propertySupport.setPropertyBool("triStateEnabled", triStateEnabled);
        if (!triStateEnabled && this.getTable() != null) {
            for (ITableRow row : this.getTable().getRows()) {
                this.setValue(row, (Boolean)this.getValue(row));
            }
        }
    }

    @Override
    public boolean isTriStateEnabled() {
        return this.propertySupport.getPropertyBool("triStateEnabled");
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        this.updateDisplayText(row, cell);
    }

    @Override
    protected String formatValueInternal(ITableRow row, Boolean value) {
        if (this.isTriStateEnabled() && value == null) {
            return "?";
        }
        return BooleanUtility.nvl((Boolean)value) ? "X" : "";
    }

    @Override
    protected Boolean parseValueInternal(ITableRow row, Object rawValue) {
        Boolean validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Boolean) {
            validValue = (Boolean)rawValue;
        } else if (rawValue instanceof Number) {
            validValue = ((Number)rawValue).intValue() == 1;
        } else {
            throw new ProcessingException("invalid Boolean value in column '" + this.getClass().getSimpleName() + "': " + String.valueOf(rawValue) + " class=" + String.valueOf(rawValue.getClass()), new Object[0]);
        }
        return validValue;
    }

    @Override
    protected Boolean validateValueInternal(ITableRow row, Boolean rawValue) {
        rawValue = super.validateValueInternal(row, rawValue);
        if (!this.isTriStateEnabled() && rawValue == null) {
            rawValue = Boolean.FALSE;
        }
        return rawValue;
    }

    @Override
    protected IValueField<Boolean> createDefaultEditor() {
        return new AbstractBooleanField(){};
    }

    @Override
    protected void mapEditorFieldProperties(IFormField f) {
        super.mapEditorFieldProperties(f);
        if (f instanceof IBooleanField) {
            ((IBooleanField)f).setTriStateEnabled(this.isTriStateEnabled());
        }
    }

    @Override
    protected int getConfiguredHorizontalAlignment() {
        return 0;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=200.0)
    protected int getConfiguredVerticalAlignment() {
        return -1;
    }

    @Order(value=220.0)
    @ConfigProperty(value="BOOLEAN")
    protected boolean getConfiguredTriStateEnabled() {
        return false;
    }

    @Override
    protected int getConfiguredMinWidth() {
        return 38;
    }

    protected IBooleanColumnExtension<? extends AbstractBooleanColumn> createLocalExtension() {
        return new LocalBooleanColumnExtension<AbstractBooleanColumn>(this);
    }

    protected static class LocalBooleanColumnExtension<OWNER extends AbstractBooleanColumn>
    extends AbstractColumn.LocalColumnExtension<Boolean, OWNER>
    implements IBooleanColumnExtension<OWNER> {
        public LocalBooleanColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

