/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.math.BigInteger;
import org.eclipse.scout.rt.client.extension.ui.basic.table.columns.IBigIntegerColumnExtension;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractNumberColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigIntegerColumn;
import org.eclipse.scout.rt.client.ui.form.fields.bigintegerfield.AbstractBigIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.bigintegerfield.IBigIntegerField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;

@ClassId(value="bb1b70a8-0d69-4427-8034-bfa6ea31805e")
public abstract class AbstractBigIntegerColumn
extends AbstractNumberColumn<BigInteger>
implements IBigIntegerColumn {
    public AbstractBigIntegerColumn() {
        this(true);
    }

    public AbstractBigIntegerColumn(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    @ConfigProperty(value="BIG_INTEGER")
    @Order(value=160.0)
    protected BigInteger getConfiguredMaxValue() {
        return null;
    }

    @Override
    @ConfigProperty(value="BIG_INTEGER")
    @Order(value=170.0)
    protected BigInteger getConfiguredMinValue() {
        return null;
    }

    @Override
    protected BigInteger parseValueInternal(ITableRow row, Object rawValue) {
        BigInteger validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof BigInteger) {
            validValue = (BigInteger)rawValue;
        } else {
            throw new ProcessingException("invalid BigInteger value in column '" + this.getClass().getSimpleName() + "': " + String.valueOf(rawValue) + " class=" + String.valueOf(rawValue.getClass()), new Object[0]);
        }
        return validValue;
    }

    protected IBigIntegerField createDefaultEditor() {
        return new AbstractBigIntegerField(){};
    }

    @Override
    protected IBigIntegerColumnExtension<? extends AbstractBigIntegerColumn> createLocalExtension() {
        return new LocalBigIntegerColumnExtension<AbstractBigIntegerColumn>(this);
    }

    protected static class LocalBigIntegerColumnExtension<OWNER extends AbstractBigIntegerColumn>
    extends AbstractNumberColumn.LocalNumberColumnExtension<BigInteger, OWNER>
    implements IBigIntegerColumnExtension<OWNER> {
        public LocalBigIntegerColumnExtension(OWNER owner) {
            super(owner);
        }
    }
}

