/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.html.HtmlHelper;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableUtility {
    private static final Logger LOG = LoggerFactory.getLogger(TableUtility.class);

    private TableUtility() {
    }

    public static <T> void resolveLookupCall(Map<ILookupCall<T>, List<? extends ILookupRow<T>>> lookupCache, ITableRow row, ISmartColumn<T> col, boolean multilineText) {
        try {
            ILookupCall<T> call = col.prepareLookupCall(row);
            if (call != null) {
                List result = null;
                boolean verifiedQuality = TableUtility.verifyLookupCallBeanQuality(call);
                if (verifiedQuality) {
                    result = lookupCache.get(call);
                }
                if (result == null) {
                    result = call.getDataByKey();
                    if (verifiedQuality) {
                        lookupCache.put(call, result);
                    }
                }
                TableUtility.applyLookupResult(row, col, result, multilineText);
            }
        }
        catch (RuntimeException e) {
            ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
        }
    }

    public static boolean verifyLookupCallBeanQuality(ILookupCall<?> call) {
        Class<?> clazz = call.getClass();
        if (LocalLookupCall.class == clazz) {
            return true;
        }
        if (LookupCall.class == clazz) {
            return true;
        }
        if (LocalLookupCall.class.isAssignableFrom(clazz)) {
            Class<?> tmp = clazz;
            while (tmp != LocalLookupCall.class) {
                if (ConfigurationUtility.isMethodOverwrite(LocalLookupCall.class, (String)"equals", (Class[])new Class[]{Object.class}, tmp)) {
                    return true;
                }
                Field[] fields = tmp.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    Field[] fieldArray = fields;
                    int n = fields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        if ((field.getModifiers() & 0x18) == 0) {
                            LOG.warn("{} subclasses LocalLookupCall with additional member {} and should therefore override the 'equals' and 'hashCode' methods", clazz, (Object)field.getName());
                            return false;
                        }
                        ++n2;
                    }
                }
                tmp = tmp.getSuperclass();
            }
            return true;
        }
        if (LookupCall.class.isAssignableFrom(clazz)) {
            Class<?> tmp = clazz;
            while (tmp != LookupCall.class) {
                if (ConfigurationUtility.isMethodOverwrite(LookupCall.class, (String)"equals", (Class[])new Class[]{Object.class}, tmp)) {
                    return true;
                }
                Field[] fields = tmp.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    Field[] fieldArray = fields;
                    int n = fields.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Field field = fieldArray[n3];
                        if ((field.getModifiers() & 0x18) == 0) {
                            LOG.warn("{} subclasses LookupCall with additional member {} and should therefore override the 'equals' and 'hashCode' methods", clazz, (Object)field.getName());
                            return false;
                        }
                        ++n3;
                    }
                }
                tmp = tmp.getSuperclass();
            }
            return true;
        }
        return false;
    }

    public static <T> void applyLookupResult(ITableRow row, IColumn<T> col, List<? extends ILookupRow<T>> result, boolean multilineText) {
        try {
            row.setRowChanging(true);
            Cell cell = (Cell)row.getCell(col.getColumnIndex());
            if (result.size() == 1) {
                cell.setText(result.get(0).getText());
            } else if (result.size() > 1) {
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while (i < result.size()) {
                    if (i > 0) {
                        if (multilineText) {
                            buf.append("\n");
                        } else {
                            buf.append(", ");
                        }
                    }
                    buf.append(result.get(i).getText());
                    ++i;
                }
                cell.setText(buf.toString());
            } else {
                cell.setText("");
            }
        }
        finally {
            row.setRowPropertiesChanged(false);
            row.setRowChanging(false);
        }
    }

    public static Object[][] exportRowsAsCSV(List<? extends ITableRow> rows, List<? extends IColumn> columns, boolean includeLineForColumnNames, boolean includeLineForColumnTypes, boolean includeLineForColumnFormats) {
        HtmlHelper htmlHelper = (HtmlHelper)BEANS.get(HtmlHelper.class);
        int nr = rows.size();
        Object[][] a = new Object[nr + (includeLineForColumnNames ? 1 : 0) + (includeLineForColumnTypes ? 1 : 0) + (includeLineForColumnFormats ? 1 : 0)][columns.size()];
        int c = 0;
        while (c < columns.size()) {
            String format;
            boolean byValue;
            Class type;
            IColumn col = columns.get(c);
            if (col instanceof IDateColumn) {
                if (((IDateColumn)col).isHasTime()) {
                    type = Timestamp.class;
                    byValue = true;
                    format = ((IDateColumn)col).getFormat();
                } else {
                    type = Date.class;
                    byValue = true;
                    format = ((IDateColumn)col).getFormat();
                }
            } else if (col instanceof IIntegerColumn) {
                type = Integer.class;
                byValue = true;
                format = ((IIntegerColumn)col).getFormat().toPattern();
            } else if (col instanceof ILongColumn) {
                type = Long.class;
                byValue = true;
                format = ((ILongColumn)col).getFormat().toPattern();
            } else if (col instanceof IBigDecimalColumn) {
                type = Double.class;
                byValue = true;
                format = ((IBigDecimalColumn)col).getFormat().toPattern();
            } else if (col instanceof ISmartColumn) {
                type = String.class;
                byValue = false;
                format = null;
            } else if (col instanceof IBooleanColumn) {
                type = Boolean.class;
                byValue = false;
                format = null;
            } else {
                type = String.class;
                byValue = false;
                format = null;
            }
            int csvRowIndex = 0;
            if (includeLineForColumnNames) {
                IHeaderCell iHeaderCell = columns.get(c).getHeaderCell();
                a[csvRowIndex][c] = iHeaderCell.isHtmlEnabled() ? htmlHelper.toPlainText(iHeaderCell.getText()) : iHeaderCell.getText();
                ++csvRowIndex;
            }
            if (includeLineForColumnTypes) {
                a[csvRowIndex][c] = type;
                ++csvRowIndex;
            }
            if (includeLineForColumnFormats) {
                a[csvRowIndex][c] = format;
                ++csvRowIndex;
            }
            for (ITableRow iTableRow : rows) {
                if (byValue) {
                    a[csvRowIndex][c] = type == Timestamp.class ? TypeCastUtility.castValue(columns.get(c).getValue(iTableRow), Timestamp.class) : columns.get(c).getValue(iTableRow);
                } else {
                    Boolean b;
                    String text = columns.get(c).getDisplayText(iTableRow);
                    if (type == Boolean.class && (b = (Boolean)TypeCastUtility.castValue(columns.get(c).getValue(iTableRow), Boolean.class)) != null && b.booleanValue() && !StringUtility.hasText((CharSequence)text)) {
                        text = "X";
                    }
                    if (type == String.class && text != null && columns.get(c).isHtmlEnabled()) {
                        text = htmlHelper.toPlainText(text);
                    }
                    a[csvRowIndex][c] = text;
                }
                ++csvRowIndex;
            }
            ++c;
        }
        return a;
    }

    @FunctionalInterface
    public static interface ITableCellEditorFilter {
        public boolean accept(ITableRow var1, IColumn<?> var2);
    }
}

