/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.security.Permission;
import java.util.List;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.IShowInvisibleColumnsForm;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.ITableOrganizer;
import org.eclipse.scout.rt.client.ui.basic.table.organizer.ShowInvisibleColumnsForm;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.shared.security.CreateCustomColumnPermission;
import org.eclipse.scout.rt.shared.security.DeleteCustomColumnPermission;
import org.eclipse.scout.rt.shared.security.UpdateCustomColumnPermission;

public class TableOrganizer
implements ITableOrganizer {
    private final ITable m_table;

    public TableOrganizer(ITable table) {
        this.m_table = table;
    }

    @Override
    public boolean isColumnAddable() {
        return this.isCustomizable() && this.hasCreatePermission() || this.hasInvisibleColumns();
    }

    protected boolean hasInvisibleColumns() {
        ColumnSet columnSet = this.m_table.getColumnSet();
        return columnSet.getVisibleColumnCount() < columnSet.getDisplayableColumnCount();
    }

    @Override
    public boolean isColumnRemovable(IColumn column) {
        return true;
    }

    @Override
    public boolean isColumnModifiable(IColumn column) {
        return this.isCustomizable(column) && this.hasModifyPermission();
    }

    public void addColumn(IColumn insertAfterColumn) {
        if (this.isCustomizable() && this.hasCreatePermission()) {
            this.getCustomizer().addColumn(insertAfterColumn);
        } else if (this.hasInvisibleColumns()) {
            this.showInvisibleColumnsForm(insertAfterColumn);
        }
    }

    protected void showInvisibleColumnsForm(IColumn<?> insertAfterColumn) {
        IShowInvisibleColumnsForm form = new ShowInvisibleColumnsForm(this.m_table).withInsertAfterColumn(insertAfterColumn);
        form.startModify();
        form.waitFor();
    }

    @Override
    public void removeColumn(IColumn column) {
        if (this.isCustomizable(column)) {
            if (this.hasRemovePermission()) {
                this.getCustomizer().removeColumn(column);
            }
        } else if (column.isVisible()) {
            this.hideColumn(column);
        }
    }

    protected void hideColumn(IColumn column) {
        ColumnSet columnSet = this.m_table.getColumnSet();
        List<IColumn<?>> visibleColumns = columnSet.getVisibleColumns();
        visibleColumns.remove(column);
        columnSet.setVisibleColumns(visibleColumns);
        ClientUIPreferences.getInstance().setAllTableColumnPreferences(this.m_table);
    }

    @Override
    public void modifyColumn(IColumn column) {
        if (this.isColumnModifiable(column)) {
            this.getCustomizer().modifyColumn(column);
        }
    }

    protected boolean isCustomizable() {
        return this.m_table.isCustomizable();
    }

    protected boolean isCustomizable(IColumn<?> column) {
        return this.isCustomizable() && this.getCustomizer().isCustomizable(column);
    }

    protected ITableCustomizer getCustomizer() {
        return this.m_table.getTableCustomizer();
    }

    protected boolean hasCreatePermission() {
        return ACCESS.check((Permission)new CreateCustomColumnPermission());
    }

    protected boolean hasModifyPermission() {
        return ACCESS.check((Permission)new UpdateCustomColumnPermission());
    }

    protected boolean hasRemovePermission() {
        return ACCESS.check((Permission)new DeleteCustomColumnPermission());
    }

    protected ITable getTable() {
        return this.m_table;
    }
}

