/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ISummaryCellBuilder;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class SummaryCellBuilder
implements ISummaryCellBuilder {
    private ITable m_table;

    public SummaryCellBuilder(ITable table) {
        this.m_table = table;
    }

    public ITable getTable() {
        return this.m_table;
    }

    @Override
    public ICell build(ITableRow row) {
        IColumn col;
        ArrayList summaryColumns = this.getTable().getColumnSet().getSummaryColumns();
        if (summaryColumns.isEmpty() && (col = this.getTable().getColumnSet().getFirstDefinedVisibleColumn()) != null) {
            summaryColumns = CollectionUtility.arrayList((Object)col);
        }
        if (summaryColumns.isEmpty()) {
            return new Cell();
        }
        Cell cell = new Cell(this.getTable().getCell(row, (IColumn)summaryColumns.get(0)));
        if (cell.getIconId() == null) {
            cell.setIconId(row.getIconId());
        }
        if (summaryColumns.size() == 1) {
            return cell;
        }
        StringBuilder b = new StringBuilder();
        for (IColumn c : summaryColumns) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(this.getTable().getCell(row, c).toPlainText());
        }
        cell.setText(b.toString());
        return cell;
    }
}

