/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITileTableHeader;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractIconColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractSmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.fields.LogicalGridLayoutConfig;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.placeholder.AbstractPlaceholderField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

@ClassId(value="c6ee18fd-e630-4d92-81b1-cd0147c902d4")
public abstract class AbstractTileTableHeader
extends AbstractGroupBox
implements ITileTableHeader {
    private boolean m_isGrouping;
    private boolean m_isSorting;

    protected TableListener createTableListener() {
        return new TableAdapter(){

            @Override
            public void tableChanged(TableEvent e) {
                AbstractTileTableHeader.this.handleTableEvent(e);
            }
        };
    }

    protected void handleTableEvent(TableEvent e) {
        switch (e.getType()) {
            case 780: {
                this.syncSortingGroupingFields();
            }
        }
    }

    protected void syncSortingGroupingFields() {
        try {
            this.getSortByField().setValueChangeTriggerEnabled(false);
            this.getGroupByField().setValueChangeTriggerEnabled(false);
            if (!this.m_isSorting) {
                IColumn primarySortColumn = (IColumn)CollectionUtility.firstElement(this.getTable().getColumnSet().getSortColumns());
                if (primarySortColumn != null) {
                    this.getSortByField().setValue(new ImmutablePair((Object)primarySortColumn, (Object)primarySortColumn.isSortAscending()));
                } else {
                    this.getSortByField().setValue(null);
                }
            }
            if (!this.m_isGrouping) {
                IColumn primaryGroupColumn = (IColumn)CollectionUtility.firstElement(this.getTable().getColumnSet().getGroupedColumns());
                this.getGroupByField().setValue(primaryGroupColumn);
            }
        }
        finally {
            this.getSortByField().setValueChangeTriggerEnabled(true);
            this.getGroupByField().setValueChangeTriggerEnabled(true);
        }
    }

    protected ITable getTable() {
        if (this.getParent() instanceof ITable) {
            return (ITable)this.getParent();
        }
        return null;
    }

    @Override
    protected void execInitField() {
        super.execInitField();
        TableListener tableListener = this.createTableListener();
        this.getTable().addTableListener(tableListener, new Integer[0]);
        this.getGroupByField().setVisible(this.getTable().getColumnSet().isUserColumnGroupingAllowed());
        this.getSortByField().setVisible(this.getTable().isSortEnabled());
        this.syncSortingGroupingFields();
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 7;
    }

    @Override
    protected LogicalGridLayoutConfig getConfiguredBodyLayoutConfig() {
        return super.getConfiguredBodyLayoutConfig().withHGap(8);
    }

    public PlaceholderField getPlaceholderField() {
        return this.getFieldByClass(PlaceholderField.class);
    }

    public GroupByField getGroupByField() {
        return this.getFieldByClass(GroupByField.class);
    }

    public SortByField getSortByField() {
        return this.getFieldByClass(SortByField.class);
    }

    protected ILookupCall<IColumn> createGroupByLookupCall() {
        return new P_GroupByLookupCall();
    }

    protected ILookupCall<ImmutablePair<IColumn, Boolean>> createSortByLookupCall() {
        return new P_SortByLookupCall();
    }

    protected boolean isColumnTypeAllowedForGrouping(IColumn col) {
        return col instanceof AbstractSmartColumn || col instanceof AbstractDateColumn || col instanceof AbstractBooleanColumn;
    }

    protected boolean isColumnTypeAllowedForSorting(IColumn col) {
        return !(col instanceof AbstractIconColumn);
    }

    @Order(value=300.0)
    @ClassId(value="d2dd9b5a-5944-4a0d-afab-8bc89d31eed5")
    public class GroupByField
    extends AbstractSmartField<IColumn> {
        @Override
        protected String getConfiguredLabel() {
            return TEXTS.get((String)"GroupBy");
        }

        @Override
        protected boolean getConfiguredVisible() {
            return false;
        }

        @Override
        protected byte getConfiguredLabelPosition() {
            return 2;
        }

        @Override
        protected String getConfiguredClearable() {
            return "always";
        }

        @Override
        protected boolean getConfiguredStatusVisible() {
            return false;
        }

        @Override
        protected String getConfiguredDisplayStyle() {
            return "dropdown";
        }

        @Override
        protected void initConfig() {
            super.initConfig();
            this.setLookupCall(AbstractTileTableHeader.this.createGroupByLookupCall());
        }

        @Override
        protected void execChangedValue() {
            try {
                AbstractTileTableHeader.this.m_isGrouping = true;
                if (this.getValue() == null) {
                    AbstractTileTableHeader.this.getTable().getColumnSet().removeGroupColumn((IColumn)CollectionUtility.firstElement(AbstractTileTableHeader.this.getTable().getColumnSet().getGroupedColumns()));
                } else {
                    AbstractTileTableHeader.this.getTable().getColumnSet().handleGroupingEvent((IColumn)this.getValue(), false, true);
                }
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTileTableHeader.this.getTable());
                AbstractTileTableHeader.this.getTable().sort();
            }
            finally {
                AbstractTileTableHeader.this.m_isGrouping = false;
            }
        }
    }

    @ClassId(value="dbf260be-ee6c-4f6f-99c6-9b7bcbdf7d61")
    protected class P_GroupByLookupCall
    extends LocalLookupCall<IColumn> {
        private static final long serialVersionUID = 1L;

        protected P_GroupByLookupCall() {
        }

        protected List<? extends ILookupRow<IColumn>> execCreateLookupRows() {
            ArrayList<LookupRow> lookupRows = new ArrayList<LookupRow>();
            lookupRows.add(new LookupRow(null, TEXTS.get((String)"NoGrouping")).withFont(new FontSpec(null, 1, 0)));
            for (IColumn<?> col : AbstractTileTableHeader.this.getTable().getColumns()) {
                if ((!col.isVisible() || !AbstractTileTableHeader.this.isColumnTypeAllowedForGrouping(col)) && !col.isGroupingActive()) continue;
                String colLabel = (String)ObjectUtility.nvl((Object)col.getHeaderCell().getText(), (Object)col.getHeaderCell().getTooltipText());
                lookupRows.add(new LookupRow(col, colLabel));
            }
            return lookupRows;
        }
    }

    @ClassId(value="1f523a64-cfb9-434d-b47c-40cfc0aa6898")
    protected class P_SortByLookupCall
    extends LocalLookupCall<ImmutablePair<IColumn, Boolean>> {
        private static final long serialVersionUID = 1L;

        protected P_SortByLookupCall() {
        }

        protected List<? extends ILookupRow<ImmutablePair<IColumn, Boolean>>> execCreateLookupRows() {
            ArrayList<LookupRow> lookupRows = new ArrayList<LookupRow>();
            for (IColumn<?> col : AbstractTileTableHeader.this.getTable().getColumns()) {
                if (!col.isVisible() || !AbstractTileTableHeader.this.isColumnTypeAllowedForSorting(col)) continue;
                String colLabel = (String)ObjectUtility.nvl((Object)col.getHeaderCell().getText(), (Object)col.getHeaderCell().getTooltipText());
                lookupRows.add(new LookupRow((Object)new ImmutablePair(col, (Object)true), colLabel + " \u2191"));
                lookupRows.add(new LookupRow((Object)new ImmutablePair(col, (Object)false), colLabel + " \u2193"));
            }
            return lookupRows;
        }
    }

    @Order(value=200.0)
    @ClassId(value="30293777-ff47-4cef-a068-408524dcdf1a")
    public class PlaceholderField
    extends AbstractPlaceholderField {
        @Override
        protected int getConfiguredGridW() {
            return 5;
        }
    }

    @Order(value=400.0)
    @ClassId(value="7f20aa82-9059-4eaf-9e9d-fcb537114c63")
    public class SortByField
    extends AbstractSmartField<ImmutablePair<IColumn, Boolean>> {
        @Override
        protected String getConfiguredLabel() {
            return TEXTS.get((String)"SortBy");
        }

        @Override
        protected boolean getConfiguredVisible() {
            return false;
        }

        @Override
        protected byte getConfiguredLabelPosition() {
            return 2;
        }

        @Override
        protected String getConfiguredClearable() {
            return "always";
        }

        @Override
        protected boolean getConfiguredStatusVisible() {
            return false;
        }

        @Override
        protected String getConfiguredDisplayStyle() {
            return "dropdown";
        }

        @Override
        protected void initConfig() {
            super.initConfig();
            this.setLookupCall(AbstractTileTableHeader.this.createSortByLookupCall());
        }

        @Override
        protected void execChangedValue() {
            try {
                AbstractTileTableHeader.this.m_isSorting = true;
                if (this.getValue() == null) {
                    AbstractTileTableHeader.this.getTable().getColumnSet().removeSortColumn((IColumn)CollectionUtility.firstElement(AbstractTileTableHeader.this.getTable().getColumnSet().getSortColumns()));
                } else {
                    AbstractTileTableHeader.this.getTable().getColumnSet().handleSortEvent((IColumn)((ImmutablePair)this.getValue()).getLeft(), false, (Boolean)((ImmutablePair)this.getValue()).getRight());
                }
                ClientUIPreferences.getInstance().setAllTableColumnPreferences(AbstractTileTableHeader.this.getTable());
                AbstractTileTableHeader.this.getTable().sort();
            }
            finally {
                AbstractTileTableHeader.this.m_isSorting = false;
            }
        }
    }
}

